/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMArtifactReference;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.common.data.ArtifactReference;
import com.ibm.ram.common.data.URLArtifact;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.emf.ArtifactDetail;
import com.ibm.ram.common.util.ArtifactCacheUtil;
import com.ibm.ram.common.util.ManifestAccessor;
import com.ibm.ram.defaultprofile.Artifact;
import com.ibm.ram.defaultprofile.DefaultprofileFactory;
import com.ibm.ram.defaultprofile.Reference;
import com.ibm.ram.defaultprofile.ReferenceKind;
import com.ibm.ram.internal.client.IRAMArtifact;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import com.ibm.ram.internal.client.util.ClientArtifactAccessor;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;

public class RAMURLArtifact
extends URLArtifact
implements IRAMArtifact {
    private RAMAsset fAsset;
    private Artifact fArtifact;
    private ArtifactDetail fArtifactDetail;
    private ArtifactReference fArtifactReference;
    private ClientArtifactAccessor fClientArtifactAccessor;

    RAMURLArtifact(RAMAsset asset, String path, Artifact internalServiceArtifact) {
        this.fAsset = asset;
        this.setPath(path);
        this.fArtifact = internalServiceArtifact;
        if (asset != null) {
            this.fClientArtifactAccessor = new ClientArtifactAccessor(asset.getOriginalGUID(), asset.getOriginalVersion(), asset.getSession().getRAMClient());
        }
    }

    public RAMURLArtifact(String URL2) {
        this.createURLArtifact(URL2);
    }

    private void createURLArtifact(String url) {
        this.fArtifact = DefaultprofileFactory.eINSTANCE.createArtifact();
        Reference ref = this.createReference();
        ref.setValue(url);
        this.fArtifact.setReference(ref);
    }

    private Reference createReference() {
        Reference ref = DefaultprofileFactory.eINSTANCE.createReference();
        ReferenceKind refKind = DefaultprofileFactory.eINSTANCE.createReferenceKind();
        refKind.setName("url");
        ref.setReferenceKind(refKind);
        return ref;
    }

    @Override
    public String getName() {
        return this.fArtifact.getName();
    }

    @Override
    public void setName(String name) {
        this.fArtifact.setName(name);
    }

    @Override
    public String getURL() {
        String url = null;
        if (this.fArtifact != null && this.fArtifact.getReference() != null) {
            url = this.fArtifact.getReference().getValue();
        }
        return url;
    }

    @Override
    public String getPath() {
        if (super.getPath() == null) {
            EObject parent = this.fArtifact.eContainer();
            if (parent instanceof Artifact) {
                this.setPath(((Artifact)parent).computePathInSolution("/"));
            } else {
                this.setPath("");
            }
        }
        return super.getPath();
    }

    @Override
    public void setPath(String path) {
        if (path != null && path.startsWith("/")) {
            super.setPath(path.substring(1));
        } else {
            super.setPath(path);
        }
    }

    @Override
    public void setURL(String url) {
        if (this.fArtifact.getReference() == null) {
            Reference ref = this.createReference();
            this.fArtifact.setReference(ref);
        }
        this.fArtifact.getReference().setValue(url);
    }

    @Override
    public RAMAsset getAsset() {
        return this.fAsset;
    }

    Artifact getInternalArtifact() throws RAMRuntimeException {
        return this.fArtifact;
    }

    void setInternalArtifact(Artifact artifact) {
        this.fArtifact = artifact;
    }

    @Override
    public void setAsset(RAMAsset asset) {
        if (asset != this.fAsset) {
            this.fAsset = asset;
            this.fClientArtifactAccessor = asset != null ? new ClientArtifactAccessor(asset.getOriginalGUID(), asset.getOriginalVersion(), asset.getSession().getRAMClient()) : null;
        }
    }

    @Override
    public long getCreationDate() {
        if (this.fArtifactDetail == null) {
            this.fecthArtifactDetail();
        }
        long time = -1L;
        if (this.fArtifactDetail != null) {
            time = this.fArtifactDetail.getCreationDate().getTime();
        }
        return time;
    }

    @Override
    public String getType() {
        return "url";
    }

    public InputStream getCachedContent() {
        if (this.fClientArtifactAccessor == null || !this.hasCachedContent()) {
            return null;
        }
        String nameOfCahceArtifact = ArtifactCacheUtil.getCacheNameForURLArtifact(this.getInternalArtifact());
        String hack1028Path = "/" + this.getPath();
        Artifact cacheArtifact = this.getAsset().getManifestBuilder().getArtifact(hack1028Path, nameOfCahceArtifact);
        return this.fClientArtifactAccessor.getArtifactContent(cacheArtifact);
    }

    public boolean hasCachedContent() {
        return ManifestAccessor.isURLCacheArtifact(this.getInternalArtifact()) && ArtifactCacheUtil.getCacheDownloadableForURLArtifact(this.getInternalArtifact());
    }

    @Override
    public long getSize() {
        if (this.fArtifactDetail == null) {
            this.fecthArtifactDetail();
        }
        long size = -1L;
        if (this.fArtifactDetail != null) {
            size = this.fArtifactDetail.getSize();
        }
        return size;
    }

    private void fecthArtifactDetail() {
    }

    @Override
    public String getLabel() {
        if (this.fAsset != null) {
            try {
                return this.getAsset().getManifestBuilder().getLabel(this.fArtifact);
            }
            catch (RAMRuntimeException rAMRuntimeException) {
                throw new RAMRuntimeException(MessageFormat.format(ClientMessages.getString("RAMArtifact.NO_LABEL_FROM_NULL_ASSET"), this), true);
            }
        }
        return super.getLabel();
    }

    @Override
    public void setLabel(String label) {
        if (this.fAsset != null) {
            try {
                this.getAsset().getManifestBuilder().setLabel(label, this.fArtifact);
            }
            catch (RAMRuntimeException rAMRuntimeException) {
                throw new RAMRuntimeException(MessageFormat.format(ClientMessages.getString("RAMArtifact.NO_LABEL_TO_NULL_ASSET"), label, this), true);
            }
        } else {
            super.setLabel(label);
        }
    }

    @Override
    public ArtifactReference getReference() {
        if (this.fArtifactReference == null) {
            this.fArtifactReference = new RAMArtifactReference(this);
        }
        return this.fArtifactReference;
    }

    @Override
    public void setCreationDate(long creationDate) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMArtifact.METHOD_NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setReference(ArtifactReference reference) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMArtifact.METHOD_NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setSize(long size) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMArtifact.METHOD_NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setType(String type) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMArtifact.METHOD_NOT_IMPLEMENTED"), true);
    }
}

