/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.emf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class PackageType
extends AbstractEnumerator {
    public static final int NONE = 0;
    public static final int DOCUMENTATION = 1;
    public static final int BINARY = 2;
    public static final int INSTALLATION = 3;
    public static final PackageType NONE_LITERAL = new PackageType(0, "None", "None");
    public static final PackageType DOCUMENTATION_LITERAL = new PackageType(1, "Documentation", "Documentation");
    public static final PackageType BINARY_LITERAL = new PackageType(2, "Binary", "Binary");
    public static final PackageType INSTALLATION_LITERAL = new PackageType(3, "Installation", "Installation");
    private static final PackageType[] VALUES_ARRAY = new PackageType[]{NONE_LITERAL, DOCUMENTATION_LITERAL, BINARY_LITERAL, INSTALLATION_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static PackageType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PackageType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PackageType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PackageType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PackageType get(int value) {
        switch (value) {
            case 0: {
                return NONE_LITERAL;
            }
            case 1: {
                return DOCUMENTATION_LITERAL;
            }
            case 2: {
                return BINARY_LITERAL;
            }
            case 3: {
                return INSTALLATION_LITERAL;
            }
        }
        return null;
    }

    private PackageType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

