/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.emf.util;

import com.ibm.ram.common.emf.ArtifactDetail;
import com.ibm.ram.common.emf.ArtifactDetails;
import com.ibm.ram.common.emf.impl.ArtifactDetailImpl;
import com.ibm.ram.common.util.ManifestAccessor;
import com.ibm.ram.defaultprofile.Artifact;
import com.ibm.ram.defaultprofile.Asset;
import com.ibm.ram.defaultprofile.DefaultprofilePackage;
import com.ibm.ram.defaultprofile.Solution;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ArtifactAdapter
extends AdapterImpl {
    public static final String ROOT_FOLDER = "/";
    protected Map<String, FolderEntry> pathsToFolderEntries = new HashMap<String, FolderEntry>();
    protected ArtifactDetailsAdapter detailsAdapter;

    public static ArtifactAdapter getAdapter(Asset manifest) {
        ArtifactAdapter adapter = (ArtifactAdapter)EcoreUtil.getAdapter((List)manifest.eAdapters(), ArtifactAdapter.class);
        if (adapter == null) {
            adapter = new ArtifactAdapter();
            manifest.eAdapters().add((Object)adapter);
        }
        return adapter;
    }

    public static ArtifactAdapter getAdapter(Resource res) {
        return ArtifactAdapter.getAdapter((Asset)EcoreUtil.getObjectByType((Collection)res.getContents(), (EClassifier)DefaultprofilePackage.eINSTANCE.getAsset()));
    }

    protected static ArtifactDetailsAdapter getAdapter(ArtifactDetails details) {
        return (ArtifactDetailsAdapter)EcoreUtil.getAdapter((List)details.eAdapters(), ArtifactDetailsAdapter.class);
    }

    public static void setupArtifactDetails(ArtifactDetails details, Asset asset) {
        ArtifactAdapter manifestAdapter = ArtifactAdapter.getAdapter(asset);
        ArtifactDetailsAdapter oldDetailsAdapter = ArtifactAdapter.getAdapter(details);
        if (oldDetailsAdapter != null) {
            ArtifactAdapter oldManifestAdapter = oldDetailsAdapter.getArtifactAdapter();
            if (oldManifestAdapter != manifestAdapter) {
                details.eAdapters().remove((Object)oldDetailsAdapter);
            } else {
                return;
            }
        }
        EList eList = details.eAdapters();
        ArtifactAdapter artifactAdapter = manifestAdapter;
        ((Object)((Object)artifactAdapter)).getClass();
        eList.add((Object)artifactAdapter.new ArtifactDetailsAdapter());
    }

    public boolean isAdapterForType(Object type) {
        return ArtifactAdapter.class == type;
    }

    public Asset getManifest() {
        return (Asset)this.getTarget();
    }

    public String getFileName(Artifact artifact) {
        return artifact.getName() != null ? artifact.getName() : (artifact.getReference() != null ? artifact.getReference().getValue() : "unknown");
    }

    public Artifact getArtifact(String path, String name) {
        FolderEntry folderEntry = this.pathsToFolderEntries.get(path);
        return folderEntry != null ? folderEntry.getArtifact(name) : null;
    }

    public ArtifactDetail getArtifactDetail(Artifact artifact) {
        return this.detailsAdapter != null ? this.detailsAdapter.artifactToDetails.get(artifact) : null;
    }

    public Artifact getFolder(String path) {
        if (ROOT_FOLDER.equals(path)) {
            return null;
        }
        FolderEntry folderEntry = this.pathsToFolderEntries.get(path);
        return folderEntry != null ? (Artifact)folderEntry.getFolder() : null;
    }

    public void closeArtifactAdapter() {
        if (this.getTarget() != null) {
            this.getTarget().eAdapters().remove((Object)this);
        }
    }

    public void notifyChanged(Notification msg) {
        if (msg.getEventType() == 8) {
            this.close();
        } else if (msg.getFeatureID(Asset.class) == 8) {
            switch (msg.getEventType()) {
                case 1: {
                    this.removeOldSolution((Solution)msg.getOldValue());
                    this.addNewSolution((Solution)msg.getNewValue());
                    break;
                }
                case 2: {
                    this.removeOldSolution((Solution)msg.getOldValue());
                }
            }
        }
    }

    private void addNewSolution(Solution sol) {
        if (sol != null) {
            this.pathsToFolderEntries.put(ROOT_FOLDER, new FolderEntry(sol));
        }
    }

    private void removeOldSolution(Solution sol) {
        if (sol != null) {
            FolderEntry rootfe = this.pathsToFolderEntries.remove(ROOT_FOLDER);
            rootfe.close();
            if (this.detailsAdapter != null) {
                Iterator iter = sol.getArtifact().iterator();
                while (iter.hasNext()) {
                    this.detailsAdapter.removeArtifactDetails((Artifact)iter.next());
                }
            }
        }
    }

    private void close() {
        for (FolderEntry fe : this.pathsToFolderEntries.values()) {
            fe.closeFolderEntryAdapter();
        }
        this.pathsToFolderEntries.clear();
        if (this.detailsAdapter != null) {
            ArtifactDetails details = (ArtifactDetails)this.detailsAdapter.getTarget();
            details.eAdapters().remove((Object)this.detailsAdapter);
        }
        this.detailsAdapter = null;
    }

    public void setTarget(Notifier newTarget) {
        this.close();
        super.setTarget(newTarget);
        if (newTarget != null) {
            this.addNewSolution(((Asset)newTarget).getSolution());
        }
    }

    private class ArtifactDetailsAdapter
    extends AdapterImpl {
        protected Map<Artifact, ArtifactDetail> artifactToDetails = new HashMap<Artifact, ArtifactDetail>();

        private ArtifactDetailsAdapter() {
        }

        public ArtifactAdapter getArtifactAdapter() {
            return ArtifactAdapter.this;
        }

        public boolean isAdapterForType(Object type) {
            return ArtifactDetailsAdapter.class == type;
        }

        public ArtifactDetails getDetails() {
            return (ArtifactDetails)this.getTarget();
        }

        public void setTarget(Notifier newTarget) {
            this.artifactToDetails.clear();
            super.setTarget(newTarget);
            if (newTarget != null) {
                this.getDetails().setManifest(ArtifactAdapter.this.getManifest());
                Iterator iter = ((ArtifactDetails)newTarget).getArtifactDetails().iterator();
                while (iter.hasNext()) {
                    this.addNewContent((ArtifactDetail)iter.next());
                }
                ArtifactAdapter.this.detailsAdapter = this;
            } else {
                ArtifactAdapter.this.detailsAdapter = null;
            }
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeatureID(ArtifactDetails.class) == 0) {
                switch (msg.getEventType()) {
                    case 1: 
                    case 3: {
                        this.removeOldContent((ArtifactDetail)msg.getOldValue());
                        this.addNewContent((ArtifactDetail)msg.getNewValue());
                        break;
                    }
                    case 5: {
                        Iterator iter = ((List)msg.getNewValue()).iterator();
                        while (iter.hasNext()) {
                            this.addNewContent((ArtifactDetail)iter.next());
                        }
                        break;
                    }
                    case 4: {
                        this.removeOldContent((ArtifactDetail)msg.getOldValue());
                        break;
                    }
                    case 6: {
                        Iterator iter = ((List)msg.getOldValue()).iterator();
                        while (iter.hasNext()) {
                            this.removeOldContent((ArtifactDetail)iter.next());
                        }
                        break;
                    }
                }
            }
        }

        private void removeOldContent(ArtifactDetail detail) {
            if (detail != null) {
                Artifact artifact = detail.getArtifact();
                if (artifact != null) {
                    this.artifactToDetails.remove(artifact);
                } else {
                    this.artifactToDetails.values().remove(detail);
                }
            }
        }

        private void addNewContent(ArtifactDetail detail) {
            Artifact artifact;
            if (detail != null && (artifact = ArtifactAdapter.this.getArtifact(detail.getPath(), detail.getName())) != null) {
                this.artifactToDetails.put(artifact, detail);
                ((ArtifactDetailImpl)detail).setArtifact(artifact);
            }
        }

        private void removeArtifactDetails(Artifact artifact) {
            ArtifactDetail detail = this.artifactToDetails.remove(artifact);
            if (detail != null) {
                this.getDetails().getArtifactDetails().remove((Object)detail);
            }
            Iterator iter = artifact.getArtifact().iterator();
            while (iter.hasNext()) {
                this.removeArtifactDetails((Artifact)iter.next());
            }
        }
    }

    private class FolderEntry {
        private EObject folder;
        private Map<String, Artifact> nameToArtifact;
        private String pathName;

        public FolderEntry(Solution solution) {
            this.folder = solution;
            this.pathName = ArtifactAdapter.ROOT_FOLDER;
            this.nameToArtifact = new HashMap<String, Artifact>(solution.getArtifact().size());
            this.folder.eAdapters().add((Object)new FolderAdapter(Solution.class, 0, (List)solution.getArtifact()));
        }

        public FolderEntry(Artifact artifact, String folderPath) {
            this.folder = artifact;
            this.pathName = folderPath;
            this.nameToArtifact = new HashMap<String, Artifact>(artifact.getArtifact().size());
            this.folder.eAdapters().add((Object)new FolderAdapter(Artifact.class, 9, (List)artifact.getArtifact()));
        }

        public Artifact getArtifact(String name) {
            return this.nameToArtifact.get(name);
        }

        public void close() {
            this.closeFolderEntryAdapter();
            ArtifactAdapter.this.pathsToFolderEntries.remove(this.pathName);
            for (Artifact artifact : this.getFolder() instanceof Artifact ? ((Artifact)this.getFolder()).getArtifact() : ((Solution)this.getFolder()).getArtifact()) {
                FolderEntry fe;
                if (!ManifestAccessor.isFolder(artifact) || (fe = ArtifactAdapter.this.pathsToFolderEntries.remove(String.valueOf(this.pathName) + (ArtifactAdapter.ROOT_FOLDER.equals(this.pathName) ? "" : ArtifactAdapter.ROOT_FOLDER) + artifact.getName())) == null) continue;
                fe.close();
            }
        }

        void closeFolderEntryAdapter() {
            Adapter a = EcoreUtil.getAdapter((List)this.getFolder().eAdapters(), FolderEntry.class);
            if (a != null) {
                this.getFolder().eAdapters().remove((Object)a);
            }
        }

        public EObject getFolder() {
            return this.folder;
        }

        private class FolderAdapter
        extends AdapterImpl {
            private Class featureClass;
            private int featureID;
            private String folderPathForArtifact;

            public FolderAdapter(Class featureClass, int featureID, List artifacts) {
                this.folderPathForArtifact = FolderEntry.this.pathName.equals(ArtifactAdapter.ROOT_FOLDER) ? "" : FolderEntry.this.pathName;
                this.featureClass = featureClass;
                this.featureID = featureID;
                Iterator iter = artifacts.iterator();
                while (iter.hasNext()) {
                    this.addNewArtifact((Artifact)iter.next());
                }
            }

            public void notifyChanged(Notification msg) {
                if (msg.getFeatureID(this.featureClass) == this.featureID) {
                    switch (msg.getEventType()) {
                        case 1: 
                        case 3: {
                            this.removeOldArtifact((Artifact)msg.getOldValue());
                            this.addNewArtifact((Artifact)msg.getNewValue());
                            break;
                        }
                        case 5: {
                            Iterator iter = ((List)msg.getNewValue()).iterator();
                            while (iter.hasNext()) {
                                this.addNewArtifact((Artifact)iter.next());
                            }
                            break;
                        }
                        case 4: {
                            this.removeOldArtifact((Artifact)msg.getOldValue());
                            break;
                        }
                        case 6: {
                            Iterator iter = ((List)msg.getOldValue()).iterator();
                            while (iter.hasNext()) {
                                this.removeOldArtifact((Artifact)iter.next());
                            }
                            break;
                        }
                    }
                }
            }

            private void addNewArtifact(Artifact newart) {
                if (newart != null) {
                    FolderEntry.this.nameToArtifact.put(ArtifactAdapter.this.getFileName(newart), newart);
                    if (ManifestAccessor.isFolder(newart)) {
                        this.addNewFolder(newart);
                    }
                }
            }

            private void addNewFolder(Artifact newart) {
                String folderPath = String.valueOf(this.folderPathForArtifact) + '/' + newart.getName();
                ((FolderEntry)FolderEntry.this).ArtifactAdapter.this.pathsToFolderEntries.put(folderPath, new FolderEntry(newart, folderPath));
            }

            private void removeOldArtifact(Artifact oldart) {
                if (oldart != null) {
                    FolderEntry fe;
                    if (ManifestAccessor.isFolder(oldart) && (fe = ((FolderEntry)FolderEntry.this).ArtifactAdapter.this.pathsToFolderEntries.remove(String.valueOf(this.folderPathForArtifact) + '/' + oldart.getName())) != null) {
                        fe.close();
                    }
                    FolderEntry.this.nameToArtifact.remove(ArtifactAdapter.this.getFileName(oldart));
                    if (((FolderEntry)FolderEntry.this).ArtifactAdapter.this.detailsAdapter != null) {
                        ((FolderEntry)FolderEntry.this).ArtifactAdapter.this.detailsAdapter.removeArtifactDetails(oldart);
                    }
                }
            }

            public boolean isAdapterForType(Object type) {
                return type == FolderEntry.class;
            }
        }
    }
}

