/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;

public class SortedSizeSet<E>
extends TreeSet<E> {
    private static final long serialVersionUID = 1787312790089341198L;
    private int maxSize;

    public SortedSizeSet(int maxSize) {
        this.setMaxSize(maxSize);
    }

    public SortedSizeSet(int maxSize, Comparator<? super E> c) {
        super(c);
        this.setMaxSize(maxSize);
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        this.trimTo();
    }

    private void trimTo() {
        while (this.size() > this.maxSize) {
            this.remove(this.last());
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    private int compare(E e1, E e2) {
        Comparator comparator = this.comparator();
        return comparator == null ? ((Comparable)e1).compareTo(e2) : comparator.compare(e1, e2);
    }

    @Override
    public boolean add(E o) {
        this.trimTo();
        if (this.size() == this.maxSize) {
            if (this.compare(this.last(), o) <= 0) {
                return false;
            }
            this.remove(this.last());
        }
        return super.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E e : c) {
            changed |= this.add(e);
        }
        return changed;
    }

    public boolean isFull() {
        return this.size() >= this.maxSize;
    }
}

