/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.fix;

import com.ibm.ram.fix.Fixes;
import com.ibm.ram.fix.FolderFileAccess;
import com.ibm.ram.fix.ZipFileAccess;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public abstract class FileAccess
implements Closeable {
    private byte[] copybuffer;
    private File workDir;
    private FileAccess parentFA;
    private final String path;
    private boolean keepOpen;
    private Set<String> deletes = Collections.emptySet();
    private Map<String, Pattern> deletePatterns = Collections.emptyMap();
    private Map<String, FileAccess> nested = Collections.emptyMap();
    private Iterator<FileAccess> nestedItr;
    private FileAccess nestedNext;

    public static FileAccess createFileAccess(File file, byte[] copybuffer, File workdir) throws ZipException, IOException {
        if (file.exists()) {
            if (file.canRead()) {
                if (file.isDirectory()) {
                    return new FolderFileAccess(file, copybuffer, workdir);
                }
                return new ZipFileAccess(file, copybuffer, workdir);
            }
            throw new IOException("The file " + file + " cannot be read.");
        }
        throw new FileNotFoundException(file.toString());
    }

    protected FileAccess(byte[] copybuffer, File workDir) {
        this.copybuffer = copybuffer;
        this.workDir = workDir;
        this.path = "";
    }

    protected FileAccess(FileAccess parentFA, String path) {
        this.parentFA = parentFA;
        this.path = path;
        parentFA.addNested(this);
    }

    protected final byte[] getCopybuffer() {
        if (this.parentFA != null) {
            return this.parentFA.getCopybuffer();
        }
        return this.copybuffer != null ? this.copybuffer : (this.copybuffer = new byte[100000]);
    }

    protected final File getWorkDir() {
        if (this.parentFA != null) {
            return this.parentFA.getWorkDir();
        }
        return this.workDir;
    }

    public void setDeletes(Collection<String> deletes) {
        if (!deletes.isEmpty()) {
            for (String del : deletes) {
                if (del.startsWith("\\Q") && del.endsWith("\\E")) {
                    if (this.deletes.isEmpty()) {
                        this.deletes = new HashSet<String>(deletes.size());
                    }
                    this.deletes.add(del.substring("\\Q".length(), del.length() - "\\E".length()));
                    continue;
                }
                if (this.deletePatterns.isEmpty()) {
                    this.deletePatterns = new HashMap<String, Pattern>();
                }
                if (this.deletePatterns.containsKey(del)) continue;
                this.deletePatterns.put(del, Pattern.compile(del));
            }
        }
    }

    public final boolean isDeleted(String filename) {
        if (this.deletes.contains(filename)) {
            return true;
        }
        if (this.deletePatterns.isEmpty()) {
            return false;
        }
        for (Pattern pattern : this.deletePatterns.values()) {
            if (!pattern.matcher(filename).matches()) continue;
            return true;
        }
        return false;
    }

    public final void finish() throws IOException {
        if (this.isKeepOpen()) {
            return;
        }
        IOException io = null;
        try {
            for (FileAccess this.nestedNext : this.nested.values()) {
                try {
                    this.nestedNext.finish();
                }
                catch (IOException e) {
                    if (io != null) continue;
                    io = e;
                }
            }
        }
        finally {
            this.nestedItr = null;
            this.nestedNext = null;
        }
        this.doFinish();
        if (io != null) {
            throw io;
        }
    }

    protected abstract void doFinish() throws IOException;

    protected Set<String> getDeletes() {
        return this.deletes;
    }

    protected Collection<Pattern> getDeletePatterns() {
        return this.deletePatterns.values();
    }

    public abstract InputStream getIS(String var1) throws IOException, FileNotFoundException, Fixes.FileIsDirectory;

    public abstract OutputStream getOS(String var1) throws IOException, Fixes.FileIsDirectory;

    public abstract boolean touch(String var1);

    public abstract List<String> getFiles(NameFilter var1, boolean var2);

    public abstract String getFullname(String var1);

    public abstract FileAccess getNested(String var1) throws ZipException, IOException;

    public abstract FileType getFileType(String var1);

    public abstract void extractTo(String var1, ZipEntry var2, ZipFile var3) throws IOException;

    public abstract void addContents(String var1, String var2) throws IOException, Fixes.FileIsDirectory;

    private void addNested(FileAccess fa) {
        if (this.nestedItr != null) {
            throw new IllegalStateException("Cannot create a nested fileaccess while finishing or closing the parent");
        }
        if (this.nested.isEmpty()) {
            this.nested = new HashMap<String, FileAccess>();
        }
        this.nested.put(fa.path, fa);
    }

    protected FileAccess getNestedFA(String path) {
        return this.nested.get(path);
    }

    @Override
    public final void close() throws IOException {
        if (this.isKeepOpen()) {
            return;
        }
        IOException io = null;
        try {
            for (FileAccess this.nestedNext : this.nested.values()) {
                try {
                    this.nestedNext.close();
                }
                catch (IOException e) {
                    if (io != null) continue;
                    io = e;
                }
            }
            this.nested.clear();
        }
        finally {
            this.nestedItr = null;
            this.nestedNext = null;
        }
        try {
            this.doClose();
            if (io != null) {
                throw io;
            }
        }
        finally {
            if (this.parentFA != null) {
                this.parentFA.nestedClosed(this);
            }
        }
    }

    private void nestedClosed(FileAccess child) {
        if (this.nestedItr == null) {
            this.nested.remove(child.path);
        } else if (this.nestedNext == child) {
            this.nestedItr.remove();
        }
    }

    protected abstract void doClose() throws IOException;

    public boolean setKeepOpen(boolean keepOpen) {
        boolean old = this.keepOpen;
        this.keepOpen = keepOpen;
        return old;
    }

    public boolean isKeepOpen() {
        return this.keepOpen;
    }

    public abstract InputStream getNestedIS(String var1) throws FileNotFoundException, Fixes.FileIsDirectory, IOException;

    public abstract File extract(String var1) throws IOException, FileNotFoundException, Fixes.FileIsDirectory;

    public static enum FileType {
        file,
        directory,
        notExist;

    }

    public static interface NameFilter {
        public boolean acceptName(FileAccess var1, String var2);
    }
}

