/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.fix;

import com.ibm.ram.fix.FolderFileAccess;
import com.ibm.ram.fix.PatchControl;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;

public class TouchFiles {
    private final File base;
    private final Collection<PatchControl.Touch> touches;
    private final Map<String, String> moduleMap;

    public TouchFiles(File base, Collection<PatchControl.Touch> touches, Map<String, String> moduleMap) {
        this.base = base;
        this.touches = touches;
        this.moduleMap = moduleMap != null ? moduleMap : Collections.emptyMap();
    }

    public void touch() {
        for (PatchControl.Touch touch : this.touches) {
            if (touch.getFile() == null) {
                File totouch;
                Pattern include = Pattern.compile(touch.getInclude());
                Pattern exclude = touch.getExclude() != null ? Pattern.compile(touch.getExclude()) : null;
                String mapped = this.getMapped(touch.getBase());
                if (mapped == null || !(totouch = new File(this.base, mapped)).isDirectory()) continue;
                this.touch(totouch, include, exclude, touch.isRecurse());
                continue;
            }
            String mapped = this.getMapped(touch.getFile());
            if (mapped == null) continue;
            FolderFileAccess.touch(new File(this.base, touch.getFile()));
        }
    }

    private String getMapped(String file) {
        if (this.moduleMap.isEmpty()) {
            return file;
        }
        int ndx = file.length();
        while ((ndx = file.lastIndexOf(47, ndx - 1)) > -1) {
            String base = file.substring(0, ndx);
            if (!this.moduleMap.containsKey(base)) continue;
            String mapped = this.moduleMap.get(base);
            if (mapped == null) {
                return null;
            }
            return String.valueOf(mapped) + '/' + file.substring(ndx + 1);
        }
        return file;
    }

    private void touch(File file, final Pattern include, final Pattern exclude, final boolean recurse) {
        file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File subfile) {
                String fname = subfile.getName();
                if (!TouchFiles.this.exclude(fname, exclude)) {
                    if (subfile.isDirectory()) {
                        if (recurse) {
                            TouchFiles.this.touch(subfile, include, exclude, true);
                        }
                    } else if (include.matcher(fname).matches()) {
                        FolderFileAccess.touch(subfile);
                    }
                }
                return false;
            }
        });
    }

    private boolean exclude(String name, Pattern exclude) {
        if (exclude != null) {
            return exclude.matcher(name).matches();
        }
        return false;
    }
}

