/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.activities;

import com.ibm.ram.common.data.AssetActivity;
import com.ibm.ram.internal.activities.RAMActivityTeamInfo;
import com.ibm.ram.internal.common.util.Utilities;
import java.util.HashMap;
import java.util.Map;

public class AssetDevActivity
extends AssetActivity {
    public static final String ECLIPSE_PROJECT = "ECLIPSE_PROJECT";
    public static final int TYPEID = 620;
    private String artifact;
    private String eclipseProject;
    private RAMActivityTeamInfo teamInfo;
    private String teamInfoString;

    public AssetDevActivity(String artifact, String eclipseProject, RAMActivityTeamInfo teamInfo) {
        this.artifact = artifact;
        this.eclipseProject = eclipseProject;
        this.teamInfo = teamInfo;
        this.setTypeId(620);
        this.initTeamInfoPropertiesString();
    }

    public AssetDevActivity(String artifact, String eclipseProject, String teamInfoString) {
        this.artifact = artifact;
        this.eclipseProject = eclipseProject;
        this.teamInfoString = teamInfoString;
        this.setTypeId(620);
        this.initTeamInfoFromString();
    }

    public static String serializeLongData(String eclipseProject, RAMActivityTeamInfo teamInfo) {
        HashMap<? super String, String> map = new HashMap<String, String>();
        map.put(ECLIPSE_PROJECT, eclipseProject);
        if (teamInfo != null) {
            map.putAll(teamInfo.getProperties());
        }
        return Utilities.encodeToString(map);
    }

    private void initTeamInfoPropertiesString() {
        Map<? super String, String> propertiesMap;
        if (this.teamInfoString == null && this.teamInfo != null && (propertiesMap = this.teamInfo.getProperties()) != null) {
            this.teamInfoString = Utilities.encodeToString(propertiesMap);
        }
    }

    private void initTeamInfoFromString() {
        if (this.teamInfoString != null) {
            this.teamInfo = new RAMActivityTeamInfo();
            Map decodedObj = (Map)Utilities.decodeFromString(this.teamInfoString);
            if (decodedObj != null) {
                this.teamInfo.initialize(decodedObj);
            }
        }
    }

    public String serializeLongData() {
        return AssetDevActivity.serializeLongData(this.eclipseProject, this.teamInfo);
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getEclipseProject() {
        return this.eclipseProject;
    }

    public String getTeamInfo() {
        this.initTeamInfoPropertiesString();
        return this.teamInfoString;
    }

    public String getTeamServer() {
        String teamServer = "";
        if (this.teamInfo != null) {
            teamServer = this.teamInfo.getTeamServer();
        }
        return teamServer;
    }

    public String getTeamArea() {
        String teamArea = "";
        if (this.teamInfo != null) {
            teamArea = this.teamInfo.getTeamArea();
        }
        return teamArea;
    }

    public void setArtifact(String artifact) {
        this.artifact = artifact;
    }

    public void setEclipseProject(String eclipseProject) {
        this.eclipseProject = eclipseProject;
    }

    public void setTeamInfo(String teamInfoString) {
        this.teamInfoString = teamInfoString;
        this.initTeamInfoFromString();
    }
}

