/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.data;

import com.ibm.ram.common.data.Artifact;
import com.ibm.ram.common.data.Asset;
import com.ibm.ram.common.data.AssetInformation;
import com.ibm.ram.common.data.Category;
import com.ibm.ram.common.data.CategorySchema;
import com.ibm.ram.common.data.SubCategory;
import com.ibm.ram.internal.common.data.AssetActivitySO;
import com.ibm.ram.internal.common.data.AssetEventSO;
import com.ibm.ram.internal.common.data.AssetMetricsSO;
import com.ibm.ram.internal.common.data.AssetPermissionSO;
import com.ibm.ram.internal.common.data.CategorySO;
import com.ibm.ram.internal.common.data.PolicyResultSO;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="assetSO", namespace="http://jazz.net/xmlns/ecalm/ram/internal/v7.2")
public class AssetSO
extends Asset {
    private String manifest;
    private AssetPermissionSO permission;
    private AssetMetricsSO metrics;
    private Artifact[] artifacts;
    private AssetEventSO[] events;
    private AssetInformation[] assetVersions;
    private long expirationTime;
    private AssetActivitySO[] activities;
    private PolicyResultSO[] policyResults;
    private AssetInformation submissionPendingAsset;
    private AssetInformation submissionAsset;
    private String[] categoryIds;

    @XmlElement(name="manifest", namespace="http://jazz.net/xmlns/ecalm/ram/internal/v7.2")
    public String getManifest() {
        return this.manifest;
    }

    public void setManifest(String manifest) {
        this.manifest = manifest;
    }

    public AssetMetricsSO getMetrics() {
        return this.metrics;
    }

    public void setMetrics(AssetMetricsSO metrics) {
        this.metrics = metrics;
    }

    public AssetPermissionSO getPermission() {
        return this.permission;
    }

    public void setPermission(AssetPermissionSO permission) {
        this.permission = permission;
    }

    public Artifact[] getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(Artifact[] artifacts) {
        this.artifacts = artifacts;
    }

    public AssetEventSO[] getEvents() {
        return this.events;
    }

    public void setEvents(AssetEventSO[] events) {
        this.events = events;
    }

    public AssetInformation[] getAssetVersions() {
        return this.assetVersions;
    }

    public void setAssetVersions(AssetInformation[] assetVersions) {
        this.assetVersions = assetVersions;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public AssetActivitySO[] getActivities() {
        return this.activities;
    }

    public void setActivities(AssetActivitySO[] activities) {
        this.activities = activities;
    }

    public PolicyResultSO[] getPolicyResults() {
        return this.policyResults;
    }

    public void setPolicyResults(PolicyResultSO[] policyResults) {
        this.policyResults = policyResults;
    }

    public AssetInformation getSubmissionAsset() {
        return this.submissionAsset;
    }

    public void setSubmissionAsset(AssetInformation submissionAsset) {
        this.submissionAsset = submissionAsset;
    }

    public AssetInformation getSubmissionPendingAsset() {
        return this.submissionPendingAsset;
    }

    public void setSubmissionPendingAsset(AssetInformation submissionPendingAsset) {
        this.submissionPendingAsset = submissionPendingAsset;
    }

    @Override
    public void setCategorySchemas(CategorySchema[] schemas) {
        super.setCategorySchemas(schemas);
        ArrayList<String> ids = new ArrayList<String>();
        if (schemas != null) {
            CategorySchema[] categorySchemaArray = schemas;
            int n = schemas.length;
            int n2 = 0;
            while (n2 < n) {
                CategorySchema categorySchema = categorySchemaArray[n2];
                if (categorySchema.getCategories() != null) {
                    String schemaUri = categorySchema.getURI();
                    int index = schemaUri.indexOf("#");
                    if (index != -1) {
                        schemaUri = schemaUri.substring(0, index);
                    }
                    ids.add(schemaUri);
                    Category[] categoryArray = categorySchema.getCategories();
                    int n3 = categoryArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Category category = categoryArray[n4];
                        if (category instanceof CategorySO) {
                            String id = ((CategorySO)category).getId();
                            ids.add(String.valueOf(schemaUri) + "#" + id);
                        }
                        if (category.getSubCategories() != null) {
                            this.addSubCategories(ids, category.getSubCategories(), schemaUri);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        this.categoryIds = ids.toArray(new String[ids.size()]);
    }

    private void addSubCategories(List<String> ids, SubCategory[] subCategories, String schemaUri) {
        if (subCategories != null) {
            SubCategory[] subCategoryArray = subCategories;
            int n = subCategories.length;
            int n2 = 0;
            while (n2 < n) {
                SubCategory subCategory = subCategoryArray[n2];
                ids.add(String.valueOf(schemaUri) + "#" + subCategory.getId());
                this.addSubCategories(ids, subCategory.getSubCategories(), schemaUri);
                ++n2;
            }
        }
    }
}

