/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import com.ibm.ram.common.util.ManifestAccessor;
import com.ibm.ram.common.util.RAMURLEncoder;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.defaultprofile.Artifact;
import com.ibm.ram.defaultprofile.ReferenceKind;
import com.ibm.ram.defaultprofile.util.NullOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;

public class ArtifactUtilities {
    private static final Logger LOGGER = Logger.getLogger(ArtifactUtilities.class);
    public static final String PATH_SEPARATOR_PATTERN = "(\\\\|/)";
    public static final Pattern INVALID_ARTIFACT_PATH = Pattern.compile("(\\.\\.|^\\.\\.(\\\\|/).*|.*(\\\\|/)\\.\\.$|.*(\\\\|/)\\.\\.(\\\\|/).*|.*:.*)");

    public static List<Artifact> getChildArtifacts(Artifact artifact) {
        ArrayList<Artifact> children = new ArrayList<Artifact>();
        if (artifact != null) {
            EList childrenList = artifact.getArtifact();
            for (Artifact child : childrenList) {
                children.add(child);
                children.addAll(ArtifactUtilities.getChildArtifacts(child));
            }
        }
        return children;
    }

    public static String encodeArtifactPath(String path, String folderDelimiter) {
        String[] folders = path.split(folderDelimiter);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < folders.length) {
            String folder = folders[i];
            sb.append(RAMURLEncoder.encode(folder));
            if (i < folders.length - 1) {
                sb.append(folderDelimiter);
            }
            ++i;
        }
        if (path.endsWith(folderDelimiter)) {
            sb.append(folderDelimiter);
        }
        return sb.toString();
    }

    public static boolean isValidArtifactPath(String path) {
        boolean valid = true;
        if (path != null && path.length() > 0) {
            valid = !INVALID_ARTIFACT_PATH.matcher(path).matches();
        }
        return valid;
    }

    public static boolean isValidArtifactPath(File basePath, File file) {
        boolean valid = false;
        if (file != null && basePath != null) {
            try {
                valid = file.getCanonicalPath().startsWith(basePath.getCanonicalPath());
            }
            catch (IOException e) {
                LOGGER.error((Object)"Inavlid file path found when determining if artifact file path is valid", (Throwable)e);
                valid = false;
            }
        }
        return valid;
    }

    public static long calculateURLArtifactChecksum(Artifact artifact) {
        long checksum = -1L;
        if (ManifestAccessor.isURLArtifact(artifact) || ManifestAccessor.isURLCacheArtifact(artifact)) {
            String artifactLabel;
            String content = artifact.getName();
            if ("url_cache".equals(artifact.getType()) && artifact.getDescription() != null && artifact.getDescription().getValue() != null) {
                content = String.valueOf(content) + artifact.getDescription().getValue();
            }
            if (artifact.getReference() != null) {
                ReferenceKind referenceKind;
                if (artifact.getReference().getValue() != null) {
                    content = String.valueOf(content) + artifact.getReference().getValue();
                }
                if ((referenceKind = artifact.getReference().getReferenceKind()) != null && referenceKind.getName() != null) {
                    content = String.valueOf(content) + referenceKind.getName();
                }
            }
            if ((artifactLabel = ManifestAccessor.getArtifactLabel(artifact)) != null) {
                content = String.valueOf(content) + artifactLabel;
            }
            if (artifact.getType() != null) {
                content = String.valueOf(content) + artifact.getType();
            }
            try {
                Adler32 cs = new Adler32();
                UtilitiesCommon.copyStreams(new ByteArrayInputStream(content.getBytes("UTF-8")), new NullOutputStream(), null, true, true, cs);
                checksum = cs.getValue();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.warn((Object)("Unable to determine checksum for URL artifact: " + artifact.getName()));
            }
            catch (IOException iOException) {
                LOGGER.warn((Object)("Unable to determine checksum for URL artifact: " + artifact.getName()));
            }
        }
        return checksum;
    }
}

