/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.internal.common.util.BufferPipe;
import com.ibm.ram.internal.common.util.ByteBufferPipe;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;

public abstract class BaseParallelOutputStreamInputStream<T>
extends InputStream {
    private static Logger LOGGER = Logger.getLogger(BaseParallelOutputStreamInputStream.class);
    private ByteBufferPipe pipe = new ByteBufferPipe(1000, 2);
    private T saveThread;
    private long bytesWritten = -1L;
    private long bytesRead = -1L;
    private ByteBuffer readBuffer;
    private boolean eofRead;

    public BaseParallelOutputStreamInputStream(final Resource res) {
        this(new OutputRunnable(){

            @Override
            public void run(OutputStream os) throws IOException {
                res.save(os, Collections.EMPTY_MAP);
            }

            @Override
            public String getThreadName() {
                return "Save Resource \"" + res.getURI() + "\"";
            }
        });
    }

    public BaseParallelOutputStreamInputStream(final OutputRunnable runnable) {
        String tname = runnable.getThreadName();
        if (UtilitiesCommon.isEmptyString(tname)) {
            tname = "Parallel Output stream thread.";
        }
        this.saveThread = this.createThread(new Runnable(){
            final ByteBufferPipe outPipe;
            {
                this.outPipe = BaseParallelOutputStreamInputStream.this.pipe;
            }

            /*
             * Loose catch block
             */
            @Override
            public void run() {
                block39: {
                    OutputStream os = new OutputStream(){
                        private ByteBuffer writeBuffer;

                        private void getBuffer() throws IOException {
                            if (this.writeBuffer != null) {
                                return;
                            }
                            this.writeBuffer = (ByteBuffer)outPipe.getFree(-1L);
                            if (this.writeBuffer == null) {
                                if (outPipe.getGetStatus() == -24) {
                                    throw new BufferPipe.ReaderClosedException("Reader closed without error before reading all of the data.");
                                }
                                LOGGER.error((Object)("Read side of parallel output prematurely closed with status " + outPipe.getGetStatus()));
                                throw new IOException("Read side of parallel output prematurely closed with status " + outPipe.getGetStatus());
                            }
                        }

                        private void putBuffer() {
                            if (this.writeBuffer == null || this.writeBuffer.position() == 0) {
                                return;
                            }
                            if (outPipe.getGetStatus() == -1) {
                                this.writeBuffer.flip();
                                BaseParallelOutputStreamInputStream baseParallelOutputStreamInputStream = BaseParallelOutputStreamInputStream.this;
                                baseParallelOutputStreamInputStream.bytesWritten = baseParallelOutputStreamInputStream.bytesWritten + (long)this.writeBuffer.limit();
                                outPipe.putFull(this.writeBuffer);
                            } else {
                                outPipe.putFree(this.writeBuffer);
                            }
                            this.writeBuffer = null;
                        }

                        @Override
                        public void write(int b) throws IOException {
                            this.getBuffer();
                            this.writeBuffer.put((byte)b);
                            if (!this.writeBuffer.hasRemaining()) {
                                this.putBuffer();
                            }
                        }

                        @Override
                        public void write(byte[] b, int off, int len) throws IOException {
                            while (len > 0) {
                                this.getBuffer();
                                int copyAmount = Math.min(this.writeBuffer.remaining(), len);
                                this.writeBuffer.put(b, off, copyAmount);
                                off += copyAmount;
                                len -= copyAmount;
                                if (this.writeBuffer.hasRemaining()) continue;
                                this.putBuffer();
                            }
                        }

                        @Override
                        public void flush() throws IOException {
                            this.putBuffer();
                            super.flush();
                        }

                        @Override
                        public void close() throws IOException {
                            this.putBuffer();
                            super.close();
                        }
                    };
                    boolean finished = false;
                    try {
                        runnable.run(os);
                        finished = true;
                    }
                    catch (BufferPipe.ReaderClosedException e) {
                        LOGGER.info((Object)e.getMessage());
                        try {
                            os.close();
                        }
                        catch (BufferPipe.ReaderClosedException readerClosedException) {
                        }
                        catch (IOException e2) {
                            LOGGER.error((Object)"Error closing writing resource stream.", (Throwable)e2);
                            finished = false;
                        }
                        if (!finished) {
                            if (this.outPipe.getGetStatus() != -24) {
                                LOGGER.error((Object)("Put side closed with error " + this.outPipe.getGetStatus()));
                            }
                            this.outPipe.setPutStatus(-23);
                        } else {
                            this.outPipe.setPutStatus(0);
                        }
                        break block39;
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"Error writing resource.", (Throwable)e);
                        try {
                            os.close();
                        }
                        catch (BufferPipe.ReaderClosedException readerClosedException) {
                        }
                        catch (IOException e3) {
                            LOGGER.error((Object)"Error closing writing resource stream.", (Throwable)e3);
                            finished = false;
                        }
                        if (!finished) {
                            if (this.outPipe.getGetStatus() != -24) {
                                LOGGER.error((Object)("Put side closed with error " + this.outPipe.getGetStatus()));
                            }
                            this.outPipe.setPutStatus(-23);
                        } else {
                            this.outPipe.setPutStatus(0);
                        }
                        break block39;
                    }
                    catch (RuntimeException e) {
                        LOGGER.error((Object)"Error writing resource.", (Throwable)e);
                        {
                            catch (Throwable throwable) {
                                try {
                                    os.close();
                                }
                                catch (BufferPipe.ReaderClosedException readerClosedException) {
                                }
                                catch (IOException e4) {
                                    LOGGER.error((Object)"Error closing writing resource stream.", (Throwable)e4);
                                    finished = false;
                                }
                                if (!finished) {
                                    if (this.outPipe.getGetStatus() != -24) {
                                        LOGGER.error((Object)("Put side closed with error " + this.outPipe.getGetStatus()));
                                    }
                                    this.outPipe.setPutStatus(-23);
                                } else {
                                    this.outPipe.setPutStatus(0);
                                }
                                throw throwable;
                            }
                        }
                        try {
                            os.close();
                        }
                        catch (BufferPipe.ReaderClosedException readerClosedException) {
                        }
                        catch (IOException e5) {
                            LOGGER.error((Object)"Error closing writing resource stream.", (Throwable)e5);
                            finished = false;
                        }
                        if (!finished) {
                            if (this.outPipe.getGetStatus() != -24) {
                                LOGGER.error((Object)("Put side closed with error " + this.outPipe.getGetStatus()));
                            }
                            this.outPipe.setPutStatus(-23);
                        } else {
                            this.outPipe.setPutStatus(0);
                        }
                        break block39;
                    }
                    try {
                        os.close();
                    }
                    catch (BufferPipe.ReaderClosedException readerClosedException) {
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"Error closing writing resource stream.", (Throwable)e);
                        finished = false;
                    }
                    if (!finished) {
                        if (this.outPipe.getGetStatus() != -24) {
                            LOGGER.error((Object)("Put side closed with error " + this.outPipe.getGetStatus()));
                        }
                        this.outPipe.setPutStatus(-23);
                    } else {
                        this.outPipe.setPutStatus(0);
                    }
                }
            }
        }, tname);
    }

    protected abstract T createThread(Runnable var1, String var2);

    protected abstract boolean isAlive(T var1);

    protected abstract boolean join(T var1, int var2) throws InterruptedException;

    private boolean getBuffer() throws IOException {
        int pipeStatus;
        if (this.eofRead) {
            return true;
        }
        if (this.readBuffer != null && this.readBuffer.hasRemaining()) {
            return false;
        }
        if (this.readBuffer != null) {
            this.pipe.putFree(this.readBuffer);
            this.readBuffer = null;
        }
        block4: while (true) {
            pipeStatus = this.pipe.getPutStatus();
            switch (pipeStatus) {
                case -1: {
                    this.readBuffer = (ByteBuffer)this.pipe.getFull(-1L);
                    if (this.readBuffer == null) continue block4;
                    return false;
                }
                case 0: {
                    this.eofRead = true;
                    return true;
                }
            }
            break;
        }
        LOGGER.error((Object)("Save of resource terminated early with status " + pipeStatus));
        throw new IOException("Save of resource terminated early with status " + pipeStatus);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read() throws IOException {
        try {
            if (this.getBuffer()) {
                return -1;
            }
            try {
                ++this.bytesRead;
                byte by = this.readBuffer.get();
                return by;
            }
            finally {
                this.returnEmptyBuffer();
            }
        }
        catch (IOException e) {
            this.pipe.setGetStatus(-23);
            throw e;
        }
    }

    private void returnEmptyBuffer() {
        if (this.readBuffer != null && !this.readBuffer.hasRemaining()) {
            this.pipe.putFree(this.readBuffer);
            this.readBuffer = null;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        block4: {
            if (!this.getBuffer()) break block4;
            return -1;
        }
        try {
            int read = 0;
            while (len > 0) {
                if (this.getBuffer()) break;
                int copyAmount = Math.min(len, this.readBuffer.remaining());
                this.readBuffer.get(b, off, copyAmount);
                off += copyAmount;
                len -= copyAmount;
                read += copyAmount;
            }
            this.returnEmptyBuffer();
            this.bytesRead += (long)read;
            return read;
        }
        catch (IOException e) {
            this.pipe.setGetStatus(-23);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.pipe != null) {
            try {
                if (this.pipe.getGetStatus() == -1) {
                    if (!this.eofRead) {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info((Object)"Read side closed before reading all of the data.", (Throwable)new RuntimeException());
                        }
                        this.pipe.setGetStatus(-24);
                    } else if (this.pipe.getPutStatus() != 0) {
                        LOGGER.error((Object)("Read side closed with error due to put site closed with " + this.pipe.getPutStatus()));
                        this.pipe.setGetStatus(-23);
                    } else {
                        this.pipe.setGetStatus(0);
                    }
                    while (true) {
                        try {
                            this.join(this.saveThread, 60000);
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                    if (this.isAlive(this.saveThread)) {
                        LOGGER.warn((Object)"Save resource thread wouldn't finish in one minute time");
                    }
                    if (this.pipe.getGetStatus() != 0 && this.pipe.getGetStatus() != -24) {
                        LOGGER.error((Object)"Save resource Inputstream did not close successfully");
                        throw new IOException("Save resource Inputstream did not close successfully");
                    }
                    if (this.pipe.getGetStatus() != -24 && this.bytesWritten != this.bytesRead) {
                        LOGGER.error((Object)("Full amount not read: written=" + this.bytesWritten + " read=" + this.bytesRead));
                    }
                }
            }
            finally {
                this.saveThread = null;
                this.pipe = null;
                this.readBuffer = null;
            }
        }
    }

    public static interface OutputRunnable {
        public String getThreadName();

        public void run(OutputStream var1) throws IOException;
    }
}

