/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class JdkNeutralBase64Encoder {
    private static final String IBM_ENCODER = "com.ibm.misc.BASE64Encoder";
    private static final String SUN_ENCODER = "sun.misc.BASE64Encoder";

    public abstract String encode(byte[] var1) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    public String encode(String arg) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        try {
            return this.encode(arg.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return this.encode(arg.getBytes());
        }
    }

    public static JdkNeutralBase64Encoder newEncoder() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        try {
            Class<?> encoderClazz = Class.forName(IBM_ENCODER);
            Object ibmEncoder = encoderClazz.newInstance();
            return new EncoderProxy(ibmEncoder);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> encoderClazz = Class.forName(SUN_ENCODER);
            Object sunEncoder = encoderClazz.newInstance();
            return new EncoderProxy(sunEncoder);
        }
    }

    private static class EncoderProxy
    extends JdkNeutralBase64Encoder {
        private final Object ibmOrSunEncoder;
        private final Method encodeMethod;

        public EncoderProxy(Object encoder) throws SecurityException, NoSuchMethodException {
            this.ibmOrSunEncoder = encoder;
            this.encodeMethod = encoder.getClass().getMethod("encode", byte[].class);
        }

        @Override
        public String encode(byte[] arg) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return (String)this.encodeMethod.invoke(this.ibmOrSunEncoder, new Object[]{arg});
        }
    }
}

