/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.internal.jaxb.Action;
import com.ibm.ram.internal.jaxb.Asset;
import com.ibm.ram.internal.jaxb.Category;
import com.ibm.ram.internal.jaxb.ExitCondition;
import com.ibm.ram.internal.jaxb.Lifecycle;
import com.ibm.ram.internal.jaxb.Link;
import com.ibm.ram.internal.jaxb.PolicyConfiguration;
import com.ibm.ram.internal.jaxb.PolicyResult;
import com.ibm.ram.internal.jaxb.PolicyReturnCode;
import com.ibm.ram.internal.jaxb.Reviewer;
import com.ibm.ram.internal.jaxb.Rule;
import com.ibm.ram.internal.jaxb.RuleOperator;
import com.ibm.ram.internal.jaxb.RuleType;
import com.ibm.ram.internal.jaxb.State;
import com.ibm.ram.internal.jaxb.StateConfiguration;
import com.ibm.ram.internal.jaxb.StateHistory;
import com.ibm.ram.internal.jaxb.User;
import com.ibm.ram.internal.jaxb.UserGroup;
import com.ibm.ram.internal.jaxb.Vote;
import com.ibm.ram.internal.jaxb.VoteChoice;
import com.ibm.ram.internal.jaxb.Workflow;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import com.ibm.ram.internal.jaxb.util.JAXButil;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class LifecycleUtilities {
    public static final String RULE_IS_INVALID_MESSAGE = "Rule is invalid";
    public static final String RULE_OPERATOR_EACH_ASSIGNED_GROUP = "com.ibm.ram.eachAssignedGroup";

    public static State getState(Workflow workflow, Link<State> stateRef) {
        State ret = null;
        if (stateRef.getValue() != null) {
            ret = stateRef.getValue();
        } else {
            String identifier = JAXBLinksUtil.getStateIdentifier(stateRef);
            ret = LifecycleUtilities.getState(workflow, identifier);
            stateRef.setValue(ret);
        }
        return ret;
    }

    public static State getInitialState(Workflow workflow) {
        return LifecycleUtilities.getState(workflow, workflow.getInitialState());
    }

    public static State getState(Workflow workflow, String identifier) {
        State ret = null;
        int i = 0;
        while (i < workflow.getStates().size()) {
            if (workflow.getStates().get(i).getIdentifier().equals(identifier)) {
                ret = workflow.getStates().get(i);
                break;
            }
            ++i;
        }
        return ret;
    }

    public static State getStateByName(Workflow workflow, String name) {
        State ret = null;
        int i = 0;
        while (i < workflow.getStates().size()) {
            if (workflow.getStates().get(i).getName().equals(name)) {
                ret = workflow.getStates().get(i);
                break;
            }
            ++i;
        }
        return ret;
    }

    public static Action getAction(Workflow workflow, Link<Action> actionRef) {
        Action ret = null;
        if (actionRef.getValue() != null) {
            ret = actionRef.getValue();
        } else {
            String identifier = JAXBLinksUtil.getActionIdentifier(actionRef);
            ret = LifecycleUtilities.getAction(workflow, identifier);
            actionRef.setValue(ret);
        }
        return ret;
    }

    public static Action getAction(Workflow workflow, String identifier) {
        Action ret = null;
        int i = 0;
        while (i < workflow.getActions().size()) {
            if (workflow.getActions().get(i).getIdentifier().equals(identifier)) {
                ret = workflow.getActions().get(i);
                break;
            }
            ++i;
        }
        return ret;
    }

    public static Action getActionByName(Workflow workflow, String name) {
        Action ret = null;
        int i = 0;
        while (i < workflow.getActions().size()) {
            if (workflow.getActions().get(i).getName().equals(name)) {
                ret = workflow.getActions().get(i);
                break;
            }
            ++i;
        }
        return ret;
    }

    public static StateConfiguration getStateConfiguration(Lifecycle lifecycle, String stateIdentifier) {
        StateConfiguration ret = null;
        int i = 0;
        while (i < lifecycle.getStateConfigurations().size()) {
            String id = JAXBLinksUtil.getStateIdentifier(lifecycle.getStateConfigurations().get(i).getState().getHref());
            if (id.equals(stateIdentifier)) {
                ret = lifecycle.getStateConfigurations().get(i);
                break;
            }
            ++i;
        }
        return ret;
    }

    public static StateConfiguration getStateConfiguration(Lifecycle lifecycle, Link<State> state) {
        if (state == null || lifecycle == null || lifecycle.getStateConfigurations() == null) {
            return null;
        }
        StateConfiguration ret = null;
        int i = 0;
        while (i < lifecycle.getStateConfigurations().size()) {
            if (state.equals(lifecycle.getStateConfigurations().get(i).getState())) {
                ret = lifecycle.getStateConfigurations().get(i);
                break;
            }
            ++i;
        }
        return ret;
    }

    public static StateConfiguration getStateConfigurationByName(Lifecycle lifecycle, String stateName) {
        StateConfiguration ret = null;
        if (stateName != null && lifecycle.getStateConfigurations() != null) {
            int i = 0;
            while (i < lifecycle.getStateConfigurations().size()) {
                Link<State> stateRef = lifecycle.getStateConfigurations().get(i).getState();
                String name = JAXButil.toString(stateRef.getTitle());
                if (stateName.equals(name)) {
                    ret = lifecycle.getStateConfigurations().get(i);
                    break;
                }
                ++i;
            }
        }
        return ret;
    }

    public static Vote getUserVote(User user, UserGroup asUserGroup, StateHistory reviewHistory) {
        Vote ret = null;
        if (reviewHistory != null) {
            List<Vote> votes = reviewHistory.getVotes();
            int i = 0;
            while (i < votes.size()) {
                Vote vote = votes.get(i);
                Link<User> userRef = vote.getUser();
                String id = JAXBLinksUtil.getUserIdentifier(userRef.getHref());
                if (!vote.isWithdrawn() && id.equals(user.getIdentifier())) {
                    if (asUserGroup == null) {
                        if (vote.getUserGroup() == null) {
                            ret = vote;
                        }
                    } else if (vote.getUserGroup() != null) {
                        Link<UserGroup> userGroupRef = vote.getUserGroup();
                        Integer groupId = Integer.parseInt(JAXBLinksUtil.getUserGroupIdentifier(userGroupRef.getHref()));
                        if (userGroupRef != null && groupId.equals(asUserGroup.getDbid())) {
                            ret = vote;
                        }
                    }
                    if (ret != null) break;
                }
                ++i;
            }
        }
        return ret;
    }

    public static boolean checkRule(Asset asset, Rule rule, Map<Integer, Integer> reviwerGroupCounts) {
        if (rule == null) {
            return true;
        }
        boolean ret = false;
        if (RuleType.ASSET_TYPE.equals((Object)rule.getType())) {
            ret = LifecycleUtilities.checkAssetTypeRule(asset, rule);
        } else if (RuleType.CATEGORIZATION.equals((Object)rule.getType())) {
            ret = LifecycleUtilities.checkCategorizationRule(asset, rule);
        } else if (RuleType.COMPOUND.equals((Object)rule.getType())) {
            ret = LifecycleUtilities.checkCompoundRule(asset, rule, reviwerGroupCounts);
        } else if (RuleType.MANUAL_ACTION.equals((Object)rule.getType())) {
            ret = LifecycleUtilities.checkManualActionRule(asset, rule);
        } else if (RuleType.POLICY_RESULT.equals((Object)rule.getType())) {
            ret = LifecycleUtilities.checkPolicyRule(asset, rule);
        } else if (RuleType.VOTE_RESULT.equals((Object)rule.getType())) {
            ret = LifecycleUtilities.checkVoteResultRule(asset, rule, reviwerGroupCounts);
        } else if (RuleType.INDIVIDUAL_VOTES.equals((Object)rule.getType())) {
            ret = LifecycleUtilities.checkIndividualVoteRule(asset, rule);
        } else if (RuleType.GROUP_VOTES.equals((Object)rule.getType())) {
            if (RULE_OPERATOR_EACH_ASSIGNED_GROUP.equals(rule.getStringValue())) {
                ret = true;
                StateConfiguration stateConfig = LifecycleUtilities.getStateConfiguration(asset.getLifecycle().getValue(), asset.getState());
                for (Reviewer reviewer : stateConfig.getReviewers()) {
                    if (!reviewer.isVoteAllowed() || reviewer.getUserGroup() == null) continue;
                    rule.setStringValue(JAXBLinksUtil.getUserGroupIdentifier(reviewer.getUserGroup().getHref()));
                    ret = LifecycleUtilities.checkGroupVotesRule(asset, rule, reviwerGroupCounts, stateConfig);
                    if (!ret) break;
                }
                rule.setStringValue(RULE_OPERATOR_EACH_ASSIGNED_GROUP);
            } else {
                ret = LifecycleUtilities.checkGroupVotesRule(asset, rule, reviwerGroupCounts, null);
            }
        }
        return ret;
    }

    public static String createRuleDisplayString(Rule rule) {
        String ret = null;
        if (RuleType.ASSET_TYPE.equals((Object)rule.getType())) {
            ret = LifecycleUtilities.createAssetTypeRuleDisplay(rule);
        } else if (RuleType.CATEGORIZATION.equals((Object)rule.getType())) {
            ret = LifecycleUtilities.createCategorizationRuleDisplay(rule);
        } else if (RuleType.COMPOUND.equals((Object)rule.getType())) {
            ret = LifecycleUtilities.createCompoundRuleDisplay(rule);
        } else if (RuleType.MANUAL_ACTION.equals((Object)rule.getType())) {
            LifecycleUtilities.createManualActionRuleDisplay(rule);
        } else if (RuleType.POLICY_RESULT.equals((Object)rule.getType())) {
            ret = LifecycleUtilities.createPolicyRuleDisplay(rule);
        } else if (RuleType.INDIVIDUAL_VOTES.equals((Object)rule.getType())) {
            LifecycleUtilities.createIndividualVoteRuleDisplay(rule);
        } else if (RuleType.GROUP_VOTES.equals((Object)rule.getType())) {
            LifecycleUtilities.createGroupVotesRuleDisplay(rule);
        }
        if (ret == null) {
            ret = RULE_IS_INVALID_MESSAGE;
        }
        return ret;
    }

    private static String createPolicyRuleDisplay(Rule rule) {
        String ret = null;
        if (RuleOperator.EQUALS.equals((Object)rule.getOperator()) && rule.isSetIntegerValue()) {
            int level = rule.getIntegerValue();
            String levelString = null;
            switch (level) {
                case 2: {
                    levelString = "Error";
                    break;
                }
                case 3: {
                    levelString = "Pending";
                    break;
                }
                case 0: {
                    levelString = "Success";
                    break;
                }
                case -1: {
                    levelString = "Success force approve";
                    break;
                }
                case 1: {
                    levelString = "Warning";
                }
            }
            ret = "Policy " + rule.getTarget() + " must result in " + levelString;
        }
        return ret;
    }

    private static boolean checkPolicyRule(Asset asset, Rule rule) {
        boolean ret = false;
        List<Link<StateHistory>> histories = asset.getStateHistories();
        if (histories == null || histories.size() == 0) {
            return false;
        }
        StateHistory history = histories.get(0).getValue();
        List<PolicyResult> policyResults = history.getPolicyResults();
        if (policyResults == null || policyResults.size() == 0) {
            return false;
        }
        if (rule.isSetStringValue() && !UtilitiesCommon.isEmptyStringTrimmed(rule.getTarget())) {
            boolean customCode = false;
            int returnCodeInt = -1;
            String customReturnCode = "";
            String policyConfigId = null;
            String policyId = null;
            if (rule.getTarget().indexOf("/policies/") != -1) {
                policyId = rule.getTarget().substring(rule.getTarget().indexOf("/policies/") + 10);
            } else {
                policyConfigId = rule.getTarget();
            }
            try {
                returnCodeInt = Integer.parseInt(rule.getStringValue());
            }
            catch (NumberFormatException numberFormatException) {
                customCode = true;
                customReturnCode = rule.getStringValue();
            }
            for (PolicyResult result : policyResults) {
                if (result.isObsolete() || result.getPolicyConfiguration() == null || result.getPolicyConfiguration().getPolicy() == null) continue;
                boolean resultMatchesRule = false;
                if (policyId != null && policyId.equals(JAXBLinksUtil.getPolicyIdentifier(result.getPolicyConfiguration().getPolicy().getHref()))) {
                    resultMatchesRule = true;
                } else if (policyConfigId != null && policyConfigId.equals(result.getPolicyConfiguration().getIdentifier())) {
                    resultMatchesRule = true;
                }
                if (!resultMatchesRule) continue;
                if (!customCode) {
                    PolicyReturnCode returnCode = null;
                    switch (returnCodeInt) {
                        case 2: {
                            returnCode = PolicyReturnCode.ERROR;
                            break;
                        }
                        case 3: {
                            returnCode = PolicyReturnCode.PENDING;
                            break;
                        }
                        case 1: {
                            returnCode = PolicyReturnCode.WARNING;
                            break;
                        }
                        default: {
                            returnCode = PolicyReturnCode.SUCCESS;
                        }
                    }
                    if (RuleOperator.EQUALS.equals((Object)rule.getOperator())) {
                        ret = result != null && result.getReturnCode() == PolicyReturnCode.INFO && returnCode == PolicyReturnCode.SUCCESS ? true : result != null && result.getReturnCode() == returnCode;
                    } else if (RuleOperator.NOT_EQUALS.equals((Object)rule.getOperator())) {
                        ret = result != null && result.getReturnCode() == PolicyReturnCode.INFO && returnCode != PolicyReturnCode.SUCCESS ? true : result != null && result.getReturnCode() != returnCode;
                    }
                } else if (RuleOperator.EQUALS.equals((Object)rule.getOperator())) {
                    ret = result != null && result.getCustomReturnCode() != null ? result.getCustomReturnCode().getIdentifier().equals(customReturnCode) : false;
                } else if (RuleOperator.NOT_EQUALS.equals((Object)rule.getOperator())) {
                    ret = result != null && result.getCustomReturnCode() != null ? !result.getCustomReturnCode().getIdentifier().equals(customReturnCode) : result.getCustomReturnCode() == null;
                }
                if (ret) break;
                break;
            }
        }
        return ret;
    }

    public static boolean checkDelete(Asset asset, StateConfiguration stateConfig) {
        boolean ret = true;
        if (stateConfig == null) {
            return true;
        }
        for (PolicyConfiguration policyConfig : stateConfig.getPolicyConfigurations()) {
            if (policyConfig.getDeleteEventConfig() == null) continue;
            List<Link<StateHistory>> histories = asset.getStateHistories();
            if (histories == null || histories.size() == 0) {
                return false;
            }
            StateHistory history = histories.get(0).getValue();
            List<PolicyResult> policyResults = history.getPolicyResults();
            if (policyResults == null || policyResults.size() == 0) {
                return false;
            }
            String policyId = JAXBLinksUtil.getPolicyIdentifier(policyConfig.getPolicy().getHref());
            if (policyId != null) {
                for (PolicyResult result : policyResults) {
                    if (!result.isObsolete() && result.getPolicyConfiguration() != null && result.getPolicyConfiguration().getPolicy() != null && policyId.equals(JAXBLinksUtil.getPolicyIdentifier(result.getPolicyConfiguration().getPolicy().getHref()))) {
                        switch (result.getReturnCode()) {
                            case PENDING: 
                            case ERROR: {
                                ret = false;
                                break;
                            }
                            default: {
                                ret = true;
                            }
                        }
                    }
                    if (!ret) break;
                }
            }
            if (!ret) break;
        }
        return ret;
    }

    private static boolean checkAssetTypeRule(Asset asset, Rule rule) {
        boolean ret = false;
        if (asset.getType() == null || asset.getType().getHref() == null) {
            ret = RuleOperator.NOT_EQUALS.equals((Object)rule.getOperator());
        } else {
            String id = JAXBLinksUtil.getAssetTypeIdentifier(asset.getType().getHref());
            if (RuleOperator.ANY.equals((Object)rule.getOperator())) {
                ret = true;
            } else if (RuleOperator.EQUALS.equals((Object)rule.getOperator())) {
                ret = asset.getType().getHref().equals(rule.getStringValue()) || id.equals(rule.getStringValue());
            } else if (RuleOperator.NOT_EQUALS.equals((Object)rule.getOperator())) {
                ret = !asset.getType().getHref().equals(rule.getStringValue()) && !id.equals(rule.getStringValue());
            }
        }
        return ret;
    }

    private static String createAssetTypeRuleDisplay(Rule rule) {
        String ret = null;
        if (RuleOperator.ANY.equals((Object)rule.getOperator())) {
            ret = "Any asset type is valid";
        } else if (RuleOperator.EQUALS.equals((Object)rule.getOperator())) {
            ret = "Asset type equals " + rule.getStringValue();
        } else if (RuleOperator.NOT_EQUALS.equals((Object)rule.getOperator())) {
            ret = "Asset type does not equal " + rule.getStringValue();
        }
        return ret;
    }

    private static boolean checkCategorizationRule(Asset asset, Rule rule) {
        String uri;
        boolean ret = false;
        if (rule.getStringValue() == null || !rule.getStringValue().contains("#")) {
            ret = false;
        }
        String ruleRoot = null;
        if (rule.getValueDisplayName() != null) {
            StringTokenizer toker = new StringTokenizer(rule.getValueDisplayName(), "\t\n\r\f>:");
            StringBuffer buff = new StringBuffer();
            while (toker.hasMoreTokens()) {
                buff.append(toker.nextToken().trim());
                if (!toker.hasMoreTokens()) continue;
                buff.append("/");
            }
            ruleRoot = buff.toString();
        }
        if (RuleOperator.EQUALS.equals((Object)rule.getOperator())) {
            if (asset.getCategories() == null || asset.getCategories().size() == 0) {
                ret = false;
            } else {
                uri = rule.getStringValue();
                List<Link<Category>> categories = asset.getCategories();
                if (categories != null) {
                    int i = 0;
                    while (i < categories.size()) {
                        Link<Category> catLink = categories.get(i);
                        String id = JAXBLinksUtil.getCategoryIdentifier(catLink.getHref());
                        String displayName = JAXButil.toString(catLink.getTitle());
                        if (id.equals(uri)) {
                            ret = true;
                        } else if (ruleRoot != null && displayName != null && displayName.startsWith(ruleRoot)) {
                            ret = true;
                        }
                        ++i;
                    }
                }
            }
        } else if (RuleOperator.NOT_EQUALS.equals((Object)rule.getOperator())) {
            if (asset.getCategories() == null || asset.getCategories().size() == 0) {
                ret = true;
            } else {
                uri = rule.getStringValue();
                boolean found = false;
                List<Link<Category>> categories = asset.getCategories();
                if (categories != null) {
                    int i = 0;
                    while (i < categories.size()) {
                        Link<Category> catLink = categories.get(i);
                        String id = JAXBLinksUtil.getCategoryIdentifier(catLink.getHref());
                        String displayName = JAXButil.toString(catLink.getTitle());
                        if (id.equals(uri)) {
                            found = true;
                            break;
                        }
                        if (ruleRoot != null && displayName != null && displayName.startsWith(ruleRoot)) {
                            found = true;
                        }
                        ++i;
                    }
                }
                ret = !found;
            }
        }
        return ret;
    }

    private static boolean checkManualActionRule(Asset asset, Rule rule) {
        boolean ret = false;
        if (RuleOperator.ANY.equals((Object)rule.getOperator())) {
            ret = asset.getAction() != null;
        } else if (RuleOperator.EQUALS.equals((Object)rule.getOperator())) {
            String actionId = JAXBLinksUtil.getActionIdentifier(asset.getAction());
            ret = asset.getAction() != null && actionId != null && actionId.equals(rule.getStringValue());
        } else if (RuleOperator.NOT_EQUALS.equals((Object)rule.getOperator())) {
            String actionId = JAXBLinksUtil.getActionIdentifier(asset.getAction());
            ret = asset.getAction() == null || actionId != null && !actionId.equals(rule.getStringValue());
        }
        return ret;
    }

    private static String createManualActionRuleDisplay(Rule rule) {
        String ret = null;
        if (RuleOperator.ANY.equals((Object)rule.getOperator())) {
            ret = "Asset action is not null";
        } else if (RuleOperator.EQUALS.equals((Object)rule.getOperator())) {
            ret = "Asset action equals " + rule.getStringValue();
        } else if (RuleOperator.NOT_EQUALS.equals((Object)rule.getOperator())) {
            ret = "Asset action does not equal " + rule.getStringValue();
        }
        return ret;
    }

    private static boolean checkCompoundRule(Asset asset, Rule rule, Map<Integer, Integer> reviwerGroupCounts) {
        boolean ret;
        block6: {
            block9: {
                block8: {
                    block7: {
                        ret = false;
                        if (rule.getChildRules() != null && rule.getChildRules().size() != 0) break block7;
                        ret = false;
                        break block6;
                    }
                    if (!RuleOperator.AND.equals((Object)rule.getOperator())) break block8;
                    ret = true;
                    List<Rule> childRules = rule.getChildRules();
                    int i = 0;
                    while (i < childRules.size()) {
                        boolean test = LifecycleUtilities.checkRule(asset, childRules.get(i), reviwerGroupCounts);
                        if (!test) {
                            ret = false;
                            break block6;
                        }
                        ++i;
                    }
                    break block6;
                }
                if (!RuleOperator.OR.equals((Object)rule.getOperator())) break block9;
                ret = false;
                List<Rule> childRules = rule.getChildRules();
                int i = 0;
                while (i < childRules.size()) {
                    boolean test = LifecycleUtilities.checkRule(asset, childRules.get(i), reviwerGroupCounts);
                    if (test) {
                        ret = true;
                        break block6;
                    }
                    ++i;
                }
                break block6;
            }
            if (!RuleOperator.NOT.equals((Object)rule.getOperator())) break block6;
            ret = false;
            List<Rule> childRules = rule.getChildRules();
            int i = 0;
            while (i < childRules.size()) {
                boolean test = LifecycleUtilities.checkRule(asset, childRules.get(i), reviwerGroupCounts);
                if (test) {
                    ret = false;
                    break;
                }
                ++i;
            }
        }
        return ret;
    }

    private static String createCompoundRuleDisplay(Rule rule) {
        String ret = null;
        if (RuleOperator.AND.equals((Object)rule.getOperator())) {
            ret = "All child rules are true";
        } else if (RuleOperator.OR.equals((Object)rule.getOperator())) {
            ret = "Any child rule is true";
        } else if (RuleOperator.NOT.equals((Object)rule.getOperator())) {
            ret = "All child rules are false";
        }
        return ret;
    }

    private static boolean checkVoteResultRule(Asset asset, Rule rule, Map<Integer, Integer> reviwerGroupCounts) {
        boolean isPercentage;
        boolean ret = false;
        List<Link<StateHistory>> votingHistory = asset.getStateHistories();
        if (votingHistory == null || votingHistory.size() == 0 || !votingHistory.get(0).getValue().isActive()) {
            return false;
        }
        StateHistory history = votingHistory.get(0).getValue();
        int acceptVotes = 0;
        int rejectVotes = 0;
        int i = 0;
        while (i < history.getVotes().size()) {
            Vote vote = history.getVotes().get(i);
            if (!vote.isWithdrawn() && VoteChoice.APPROVE.equals(vote.getChoice().getValue())) {
                ++acceptVotes;
            } else if (!vote.isWithdrawn() && VoteChoice.REJECT.equals(vote.getChoice().getValue())) {
                ++rejectVotes;
            }
            ++i;
        }
        int approvePercentage = 0;
        int rejectPercentage = 0;
        int numberValue = rule.getIntegerValue();
        boolean bl = isPercentage = rule.getValueDisplayName() != null && rule.getValueDisplayName().indexOf("%") > 0;
        if (isPercentage) {
            int totalVotes = 0;
            StateConfiguration stateConfig = LifecycleUtilities.getStateConfiguration(asset.getLifecycle().getValue(), asset.getState());
            for (Reviewer reviewer : stateConfig.getReviewers()) {
                if (!reviewer.isVoteAllowed()) continue;
                if (reviewer.getUserGroup() == null) {
                    ++totalVotes;
                    continue;
                }
                try {
                    Integer size = reviwerGroupCounts.get(new Integer(JAXBLinksUtil.getUserGroupIdentifier(reviewer.getUserGroup().getHref())));
                    if (size == null) continue;
                    totalVotes += size.intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Unable to parse group ID from " + reviewer.getUserGroup().getHref());
                }
            }
            if (totalVotes == 0) {
                approvePercentage = 100;
                rejectPercentage = 100;
            } else {
                approvePercentage = acceptVotes == 0 ? 0 : (int)((double)acceptVotes * 1.0 / (double)totalVotes * 100.0);
                int n = rejectPercentage = rejectVotes == 0 ? 0 : (int)((double)rejectVotes * 1.0 / (double)totalVotes * 100.0);
            }
        }
        if (VoteChoice.REJECT.equals(rule.getTarget())) {
            if (RuleOperator.GREATER_THAN_OR_EQUALS.equals((Object)rule.getOperator())) {
                ret = isPercentage ? rejectPercentage >= numberValue : rejectVotes >= numberValue;
            } else if (RuleOperator.GREATER_THAN.equals((Object)rule.getOperator())) {
                ret = isPercentage ? rejectPercentage > numberValue : rejectVotes > numberValue;
            } else if (RuleOperator.LESS_THAN.equals((Object)rule.getOperator())) {
                ret = isPercentage ? rejectPercentage < numberValue : rejectVotes < numberValue;
            } else if (RuleOperator.LESS_THAN_OR_EQUALS.equals((Object)rule.getOperator())) {
                ret = isPercentage ? rejectPercentage <= numberValue : rejectVotes <= numberValue;
            } else if (RuleOperator.EQUALS.equals((Object)rule.getOperator())) {
                ret = isPercentage ? rejectPercentage == numberValue : rejectVotes == numberValue;
            } else if (RuleOperator.NOT_EQUALS.equals((Object)rule.getOperator())) {
                ret = isPercentage ? rejectPercentage != numberValue : rejectVotes != numberValue;
            }
        } else if (RuleOperator.GREATER_THAN_OR_EQUALS.equals((Object)rule.getOperator())) {
            ret = isPercentage ? approvePercentage >= numberValue : acceptVotes >= numberValue;
        } else if (RuleOperator.GREATER_THAN.equals((Object)rule.getOperator())) {
            ret = isPercentage ? approvePercentage > numberValue : acceptVotes > numberValue;
        } else if (RuleOperator.LESS_THAN.equals((Object)rule.getOperator())) {
            ret = isPercentage ? approvePercentage < numberValue : acceptVotes < numberValue;
        } else if (RuleOperator.LESS_THAN_OR_EQUALS.equals((Object)rule.getOperator())) {
            ret = isPercentage ? approvePercentage <= numberValue : acceptVotes <= numberValue;
        } else if (RuleOperator.EQUALS.equals((Object)rule.getOperator())) {
            ret = isPercentage ? approvePercentage == numberValue : acceptVotes == numberValue;
        } else if (RuleOperator.NOT_EQUALS.equals((Object)rule.getOperator())) {
            ret = isPercentage ? approvePercentage != numberValue : acceptVotes != numberValue;
        }
        return ret;
    }

    private static String createIndividualVoteRuleDisplay(Rule rule) {
        String ret = null;
        if (rule.getTarget() == null) {
            if (RuleOperator.LESS_THAN.equals((Object)rule.getOperator())) {
                ret = "Less than " + rule.getIntegerValue() + " voters have voted";
            } else if (RuleOperator.GREATER_THAN.equals((Object)rule.getOperator())) {
                ret = "More than " + rule.getIntegerValue() + " voters have voted";
            } else if (RuleOperator.EQUALS.equals((Object)rule.getOperator())) {
                ret = String.valueOf(rule.getIntegerValue()) + " voters have voted";
            }
        } else {
            String userid = rule.getTarget();
            if (RuleOperator.EQUALS.equals((Object)rule.getOperator())) {
                if (rule.isSetBooleanValue()) {
                    ret = "User " + userid + " has not voted";
                } else {
                    String vote = rule.isBooleanValue() ? "approval" : "rejection";
                    ret = "User " + userid + " voted " + vote;
                }
            }
        }
        return ret;
    }

    private static boolean checkIndividualVoteRule(Asset asset, Rule rule) {
        String target;
        boolean ret = false;
        List<Link<StateHistory>> votingHistory = asset.getStateHistories();
        if (votingHistory == null || votingHistory.size() == 0 || !votingHistory.get(0).getValue().isActive()) {
            return false;
        }
        StateHistory history = votingHistory.get(0).getValue();
        String string = target = rule.getTarget() != null && rule.getTarget().length() > 0 ? rule.getTarget() : VoteChoice.APPROVE;
        if (RuleOperator.EQUALS.equals((Object)rule.getOperator())) {
            for (Vote vote : history.getVotes()) {
                if (vote.isWithdrawn() || !vote.getChoice().getValue().equals(target) || !JAXBLinksUtil.getUserIdentifier(vote.getUser().getHref()).equals(rule.getStringValue())) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean checkGroupVotesRule(Asset asset, Rule rule, Map<Integer, Integer> reviwerGroupCounts, StateConfiguration stateConfig) {
        ret = false;
        votingHistory = asset.getStateHistories();
        if (votingHistory == null || votingHistory.size() == 0 || !votingHistory.get(0).getValue().isActive()) {
            return false;
        }
        history = votingHistory.get(0).getValue();
        groupid = rule.getStringValue();
        numberValue = rule.getIntegerValue();
        groupVotes = 0;
        if (groupid == null || groupid.length() == 0) {
            for (Vote vote : history.getVotes()) {
                if (vote.isWithdrawn() || vote.isSetUserGroup()) continue;
                if (rule.getTarget() != null && rule.getTarget().equals(vote.getChoice().getValue())) {
                    ++groupVotes;
                    continue;
                }
                if (rule.getTarget() != null) continue;
                ++groupVotes;
            }
        } else {
            for (Vote vote : history.getVotes()) {
                if (vote.isWithdrawn() || !vote.isSetUserGroup() || !groupid.equals(String.valueOf(id = JAXBLinksUtil.getUserGroupIdentifier(vote.getUserGroup().getHref())))) continue;
                if (rule.getTarget() != null && rule.getTarget().equals(vote.getChoice().getValue())) {
                    ++groupVotes;
                    continue;
                }
                if (rule.getTarget() != null) continue;
                ++groupVotes;
            }
        }
        percentage = 0;
        v0 = isPercentage = rule.getValueDisplayName() != null && rule.getValueDisplayName().indexOf("%") > 0;
        if (isPercentage) {
            totalVotes = 0;
            if (groupid == null || groupid.length() == 0) {
                if (stateConfig == null) {
                    stateConfig = LifecycleUtilities.getStateConfiguration(asset.getLifecycle().getValue(), asset.getState());
                }
                for (Reviewer reviewer : stateConfig.getReviewers()) {
                    if (!reviewer.isVoteAllowed() || reviewer.getUserGroup() != null) continue;
                    ++totalVotes;
                }
            } else {
                try {
                    groupSize = reviwerGroupCounts.get(new Integer(groupid));
                    if (groupSize == null) ** GOTO lbl46
                    totalVotes = groupSize;
                }
                catch (NumberFormatException v1) {
                    System.err.println("Unable to parse group ID from " + groupid);
                }
            }
lbl46:
            // 4 sources

            if (totalVotes == 0) {
                percentage = 100;
            } else {
                v2 = percentage = groupVotes == 0 ? 0 : (int)((double)groupVotes * 1.0 / (double)totalVotes * 100.0);
            }
        }
        if (RuleOperator.GREATER_THAN_OR_EQUALS.equals((Object)rule.getOperator())) {
            ret = isPercentage ? percentage >= numberValue : groupVotes >= numberValue;
        } else if (RuleOperator.LESS_THAN.equals((Object)rule.getOperator())) {
            ret = isPercentage ? percentage < numberValue : groupVotes < numberValue;
        } else if (RuleOperator.GREATER_THAN.equals((Object)rule.getOperator())) {
            ret = isPercentage ? percentage > numberValue : groupVotes > numberValue;
        } else if (RuleOperator.EQUALS.equals((Object)rule.getOperator())) {
            ret = isPercentage ? percentage == numberValue : groupVotes == numberValue;
        }
        return ret;
    }

    private static String createGroupVotesRuleDisplay(Rule rule) {
        String ret = null;
        String groupid = rule.getTarget();
        if (RuleOperator.LESS_THAN.equals((Object)rule.getOperator())) {
            ret = "Less than " + rule.getIntegerValue() + " voters in " + groupid + " have voted";
        } else if (RuleOperator.GREATER_THAN.equals((Object)rule.getOperator())) {
            ret = "More than " + rule.getIntegerValue() + " voters in " + groupid + " have voted";
        } else if (RuleOperator.EQUALS.equals((Object)rule.getOperator())) {
            ret = String.valueOf(rule.getIntegerValue()) + " voters in " + groupid + " have voted";
        }
        return ret;
    }

    private static String createCategorizationRuleDisplay(Rule rule) {
        String ret = null;
        if (RuleOperator.CONTAINS.equals((Object)rule.getOperator())) {
            ret = "Asset is categorized as " + rule.getStringValue();
        } else if (RuleOperator.DOES_NOT_CONTAIN.equals((Object)rule.getOperator())) {
            ret = "Asset is not categorized as " + rule.getStringValue();
        }
        return ret;
    }

    public static String[] getWorkflowAndStateId(String datatebaseStateWFId) {
        String[] retVal = new String[]{JAXBLinksUtil.LEGACY_WORKFLOW_ID, ""};
        if (datatebaseStateWFId != null) {
            String[] stateWorkflowJazzId = datatebaseStateWFId.split("/");
            if (stateWorkflowJazzId.length == 2) {
                if (stateWorkflowJazzId[0].length() > 0) {
                    retVal[0] = stateWorkflowJazzId[0];
                }
                retVal[1] = stateWorkflowJazzId[1];
            } else {
                retVal[1] = "";
            }
        }
        return retVal;
    }

    public static String getLegacyStateIcon(String legacyStateName) {
        String iconUrl = "";
        iconUrl = legacyStateName.equals("Draft") ? "/theme/images/icons/obj16/draft_state.gif" : (legacyStateName.equals("Plan review") ? "/theme/images/icons/obj16/in_review_state.gif" : (legacyStateName.equals("Review") ? "/theme/images/icons/obj16/review_state.gif" : (legacyStateName.equals("Evaluate review") ? "/theme/images/icons/obj16/evaluate_state.gif" : (legacyStateName.equals("Approved") ? "/theme/images/icons/obj16/approve_state.gif" : (legacyStateName.equals("Retired") ? "/theme/images/icons/obj16/retired_state.gif" : (legacyStateName.equals("As is") ? "/theme/images/icons/obj16/asis_state.gif" : (legacyStateName.equals("Archived") ? "/theme/images/icons/obj16/archive_state.gif" : "/theme/images/icons/obj16/cq_review_state.gif")))))));
        return iconUrl;
    }

    public static ExitCondition getExitCondition(StateConfiguration stateConfig, String actionId) {
        ExitCondition ret = null;
        int i = 0;
        while (i < stateConfig.getExitConditions().size()) {
            String id = JAXBLinksUtil.getActionIdentifier(stateConfig.getExitConditions().get(i).getAction().getHref());
            if (id.equals(actionId)) {
                ret = stateConfig.getExitConditions().get(i);
                break;
            }
            ++i;
        }
        return ret;
    }

    public static ExitCondition getExitCondition(StateConfiguration stateConfig, Link<Action> action) {
        String id = JAXBLinksUtil.getActionIdentifier(action);
        return LifecycleUtilities.getExitCondition(stateConfig, id);
    }
}

