/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.jaxb;

import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.util.UniqueIDGenerator;
import com.ibm.ram.internal.jaxb.Action;
import com.ibm.ram.internal.jaxb.Artifact;
import com.ibm.ram.internal.jaxb.ArtifactType;
import com.ibm.ram.internal.jaxb.AssetID;
import com.ibm.ram.internal.jaxb.AssetType;
import com.ibm.ram.internal.jaxb.AttributeValue;
import com.ibm.ram.internal.jaxb.Category;
import com.ibm.ram.internal.jaxb.Community;
import com.ibm.ram.internal.jaxb.Lifecycle;
import com.ibm.ram.internal.jaxb.Link;
import com.ibm.ram.internal.jaxb.RelatedAsset;
import com.ibm.ram.internal.jaxb.RelationshipLink;
import com.ibm.ram.internal.jaxb.SimpleLiteral;
import com.ibm.ram.internal.jaxb.State;
import com.ibm.ram.internal.jaxb.StateHistory;
import com.ibm.ram.internal.jaxb.User;
import com.ibm.ram.internal.jaxb.util.AssetPropOptions;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import com.ibm.ram.internal.jaxb.util.JAXButil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.datatype.XMLGregorianCalendar;
import org.oslc.asset.internal.Relation;
import org.oslc.asset.internal.ResourceRef;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Asset", propOrder={"id", "title", "type", "state", "action", "owners", "community", "subject", "description", "avgRating", "ratings", "relationships", "artifacts", "forums", "categories", "tags", "htmlRef", "stateHistories", "lifecycle", "content", "attributeValues", "lastModified"})
public class Asset {
    @XmlElement(namespace="http://www.omg.org/ras/v2.2", required=true, type=AssetID.class)
    protected AssetID id;
    @XmlElement(namespace="http://purl.org/dc/elements/1.1/", required=true)
    protected SimpleLiteral title;
    @XmlElement(required=true, type=Link.class)
    protected Link<AssetType> type;
    @XmlElement(required=true, type=Link.class)
    protected Link<State> state;
    @XmlElement(type=Link.class)
    protected Link<Action> action;
    @XmlElement(name="owner", required=true, type=Link.class)
    protected List<Link<User>> owners;
    @XmlElement(required=true, type=Link.class)
    protected Link<Community> community;
    @XmlElement(namespace="http://purl.org/dc/elements/1.1/", required=true)
    protected SimpleLiteral subject;
    @XmlElement(namespace="http://purl.org/dc/elements/1.1/")
    protected SimpleLiteral description;
    @XmlElement(defaultValue="-1")
    protected Double avgRating;
    protected Link ratings;
    @XmlElement(name="relationship", required=true)
    protected List<RelationshipLink> relationships;
    @XmlElement(name="artifact", required=true, type=Link.class)
    protected List<Link<Artifact>> artifacts;
    protected Link forums;
    @XmlElement(name="category", required=true, type=Link.class)
    protected List<Link<Category>> categories;
    @XmlElement(name="tag", required=true)
    protected List<Link> tags;
    protected String htmlRef;
    @XmlElement(name="stateHistory", required=true, type=Link.class)
    protected List<Link<StateHistory>> stateHistories;
    @XmlElement(type=Link.class)
    protected Link<Lifecycle> lifecycle;
    @XmlAttribute(namespace="http://jazz.net/xmlns/ecalm/ram/internal/v7.2")
    protected String lifecycleId;
    @XmlElement(required=true)
    protected String content;
    @XmlElement(name="attributeValue", required=true)
    protected List<AttributeValue> attributeValues;
    @XmlElement(required=true)
    protected XMLGregorianCalendar lastModified;
    @XmlAttribute
    protected Integer dbid;
    @XmlAttribute
    protected Integer managementStyle;
    @XmlAttribute
    protected Integer revisionCount;
    @XmlAttribute
    protected String etag;
    @XmlAttribute
    protected String href;
    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    protected String base;
    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String lang;
    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String space;

    public Asset() {
    }

    public Asset(org.oslc.asset.internal.Asset oslcAsset) {
        if (oslcAsset.getId() == null) {
            throw new RAMRuntimeException("Could not copy the asset pojo : ID is null");
        }
        String guid = oslcAsset.getId().getGUID();
        if (guid == null) {
            oslcAsset.getId().setGUID(UniqueIDGenerator.getUniqueID());
        }
        this.setId(new AssetID(oslcAsset.getId()));
        this.setBase(oslcAsset.getBase());
        this.setEtag(oslcAsset.getEtag());
        this.setCommunity(JAXBLinksUtil.getLink(oslcAsset.getRAMCommunity()));
        this.setDescription(JAXButil.getSimpleLiteral(oslcAsset.getDescription()));
        this.setLastModified(JAXButil.getXMLCalendar(oslcAsset.getModified()));
        this.setState(JAXBLinksUtil.getLink(oslcAsset.getState()));
        this.setSubject(JAXButil.getSimpleLiteral(oslcAsset.getSubject()));
        this.setTitle(JAXButil.getSimpleLiteral(oslcAsset.getTitle()));
        this.setType(JAXBLinksUtil.getLink(oslcAsset.getType()));
        this.setHref(JAXBLinksUtil.getAssetHref(this));
        this.setEtag(oslcAsset.getEtag());
        if (oslcAsset.getEtag() != null) {
            try {
                this.setRevisionCount(Integer.parseInt(oslcAsset.getEtag()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (oslcAsset.getHtmlRef() != null) {
            this.setHtmlRef(oslcAsset.getHtmlRef().getResource());
        }
        for (org.oslc.asset.internal.Artifact oslcArtifact : oslcAsset.getArtifacts()) {
            if (oslcArtifact.getAbout() == null) {
                oslcArtifact.setAbout(String.valueOf(oslcAsset.getAbout()) + "/" + "artifacts" + "/" + oslcArtifact.getTitle());
            }
            Artifact artifact = new Artifact(oslcArtifact);
            Link<Artifact> artifactRef = JAXBLinksUtil.getLink(artifact.getName(), artifact.getHref(), artifact);
            this.getArtifacts().add(artifactRef);
        }
        for (ResourceRef ownerRef : oslcAsset.getContributors()) {
            Link toOwner = JAXBLinksUtil.getLink(ownerRef);
            this.getOwners().add(toOwner);
        }
        for (ResourceRef categoryRef : oslcAsset.getRAMCategories()) {
            Link toCategory = JAXBLinksUtil.getLink(categoryRef);
            this.getCategories().add(toCategory);
        }
        for (AttributeValue attributeValue : oslcAsset.getRAMAttributeValues()) {
            this.getAttributeValues().add(attributeValue);
        }
        for (Relation rel : oslcAsset.getRelationships()) {
            RelationshipLink relLink = new RelationshipLink();
            relLink.setTitle(JAXButil.getSimpleLiteral(JAXBLinksUtil.getRelationshipTypeId(rel)));
            relLink.setRelationship(new RelatedAsset());
            relLink.getRelationship().setAssetId(JAXBLinksUtil.getAssetID(rel.getResource()));
            relLink.getRelationship().setAssetName(rel.getTitle());
            relLink.getRelationship().setDescription(rel.getDescription());
            this.getRelationships().add(relLink);
        }
        for (String tag : oslcAsset.getTagsList()) {
            this.getTags().add(JAXBLinksUtil.getLink(tag, null));
        }
    }

    public AssetID getId() {
        return this.id;
    }

    public void setId(AssetID value) {
        this.id = value;
    }

    public SimpleLiteral getTitle() {
        return this.title;
    }

    public void setTitle(SimpleLiteral value) {
        this.title = value;
    }

    public Link<AssetType> getType() {
        return this.type;
    }

    public void setType(Link<AssetType> value) {
        this.type = value;
    }

    public Link<State> getState() {
        return this.state;
    }

    public void setState(Link<State> value) {
        this.state = value;
    }

    public Link<Action> getAction() {
        return this.action;
    }

    public void setAction(Link<Action> value) {
        this.action = value;
    }

    public List<Link<User>> getOwners() {
        if (this.owners == null) {
            this.owners = new ArrayList<Link<User>>();
        }
        return this.owners;
    }

    public Link<Community> getCommunity() {
        return this.community;
    }

    public void setCommunity(Link<Community> value) {
        this.community = value;
    }

    public SimpleLiteral getSubject() {
        return this.subject;
    }

    public void setSubject(SimpleLiteral value) {
        this.subject = value;
    }

    public SimpleLiteral getDescription() {
        return this.description;
    }

    public void setDescription(SimpleLiteral value) {
        this.description = value;
    }

    public Double getAvgRating() {
        return this.avgRating;
    }

    public void setAvgRating(Double value) {
        this.avgRating = value;
    }

    public Link getRatings() {
        return this.ratings;
    }

    public void setRatings(Link value) {
        this.ratings = value;
    }

    public List<RelationshipLink> getRelationships() {
        if (this.relationships == null) {
            this.relationships = new ArrayList<RelationshipLink>();
        }
        return this.relationships;
    }

    public List<Link<Artifact>> getArtifacts() {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList<Link<Artifact>>();
        }
        return this.artifacts;
    }

    public Link getForums() {
        return this.forums;
    }

    public void setForums(Link value) {
        this.forums = value;
    }

    public List<Link<Category>> getCategories() {
        if (this.categories == null) {
            this.categories = new ArrayList<Link<Category>>();
        }
        return this.categories;
    }

    public List<Link> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<Link>();
        }
        return this.tags;
    }

    public String getHtmlRef() {
        return this.htmlRef;
    }

    public void setHtmlRef(String value) {
        this.htmlRef = value;
    }

    public List<Link<StateHistory>> getStateHistories() {
        if (this.stateHistories == null) {
            this.stateHistories = new ArrayList<Link<StateHistory>>();
        }
        return this.stateHistories;
    }

    public String getLifecycleId() {
        return this.lifecycleId;
    }

    public void setLifecycleId(String lifecycleId) {
        this.lifecycleId = lifecycleId;
    }

    public Link<Lifecycle> getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(Link<Lifecycle> value) {
        this.lifecycle = value;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String value) {
        this.content = value;
    }

    public List<AttributeValue> getAttributeValues() {
        if (this.attributeValues == null) {
            this.attributeValues = new ArrayList<AttributeValue>();
        }
        return this.attributeValues;
    }

    public XMLGregorianCalendar getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(XMLGregorianCalendar value) {
        this.lastModified = value;
    }

    public Integer getDbid() {
        if (this.dbid == null) {
            return -1;
        }
        return this.dbid;
    }

    public void setDbid(Integer value) {
        this.dbid = value;
    }

    public int getManagementStyle() {
        if (this.managementStyle == null) {
            return 0;
        }
        return this.managementStyle;
    }

    public void setManagementStyle(Integer value) {
        this.managementStyle = value;
    }

    public int getRevisionCount() {
        if (this.revisionCount == null) {
            return 0;
        }
        return this.revisionCount;
    }

    public void setRevisionCount(Integer value) {
        this.revisionCount = value;
    }

    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String value) {
        this.etag = value;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String value) {
        this.href = value;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String value) {
        this.base = value;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String value) {
        this.lang = value;
    }

    public String getSpace() {
        if (this.space == null) {
            return "preserve";
        }
        return this.space;
    }

    public void setSpace(String value) {
        this.space = value;
    }

    public String toString() {
        return this.title == null ? this.href : String.valueOf(JAXButil.toString(this.title)) + "[" + this.href + "]";
    }

    public org.oslc.asset.internal.Asset toOSLCAsset(AssetPropOptions props) {
        org.oslc.asset.internal.Asset to = new org.oslc.asset.internal.Asset();
        if (this.getId() == null) {
            throw new RAMRuntimeException("Could not copy the asset pojo : ID is null");
        }
        to.setId(this.getId().toOSLCAssetId());
        to.setDbid(this.getDbid());
        to.setBase(this.getBase());
        to.setEtag(this.getEtag());
        to.setAbout(JAXBLinksUtil.getURL(to));
        if (props.shouldLoadCommunity()) {
            to.setRAMCommunity(JAXBLinksUtil.getResourceRef(this.getCommunity()));
        }
        if (props.shouldLoadDescription() && this.getDescription() != null) {
            to.setDescription(JAXButil.toString(this.getDescription()));
        }
        if (props.shouldLoadModified()) {
            to.setModified(JAXButil.getDate(this.getLastModified()));
        }
        if (props.shouldLoadState()) {
            to.setState(JAXBLinksUtil.getResourceRef(this.getState()));
        }
        if (props.shouldLoadSubject() && this.getSubject() != null) {
            to.setSubject(JAXButil.toString(this.getSubject()));
        }
        to.setTitle(JAXButil.toString(this.getTitle()));
        if (props.shouldLoadType()) {
            to.setType(JAXBLinksUtil.getResourceRef(this.getType()));
        }
        String internalURL = JAXBLinksUtil.removeExtension(this.getHref());
        if (props.shouldLoadArtifactContentFactory()) {
            ResourceRef resourceRef = new ResourceRef();
            resourceRef.setResource(String.valueOf(to.getAbout()) + "/" + "artifacts");
            resourceRef.setValue("Artifact creation factory URL");
            to.setArtifactFactory(resourceRef);
        }
        if (props.shouldLoadHtmlRef() && this.getHtmlRef() != null) {
            to.setHtmlRef(new ResourceRef(this.getHtmlRef()));
        }
        if (props.shouldLoadAvailableActions()) {
            ResourceRef resourceRef = new ResourceRef();
            resourceRef.setResource(String.valueOf(internalURL) + "/" + "availableActions");
            resourceRef.setValue("Available Actions");
            to.setRAMAvailableActions(resourceRef);
        }
        if (props.shouldLoadCurrentStateHistory()) {
            ResourceRef resourceRef = new ResourceRef();
            resourceRef.setResource(String.valueOf(internalURL) + "/" + "stateHistories" + "/" + "current");
            resourceRef.setValue("Current State History");
            to.setCurrentStateHistory(resourceRef);
        }
        if (props.shouldLoadArtifacts()) {
            for (Link<Object> link : this.getArtifacts()) {
                if (link.isValueSet()) {
                    Artifact internalArt = (Artifact)link.getValue();
                    if (internalArt.getType() == null || ArtifactType.FOLDER == internalArt.getType()) continue;
                    org.oslc.asset.internal.Artifact toArtifact = internalArt.toOSLCArtifact();
                    to.getArtifacts().add(toArtifact);
                    continue;
                }
                org.oslc.asset.internal.Artifact toArtifact = new org.oslc.asset.internal.Artifact();
                toArtifact.setTitle(JAXButil.toString(link.getTitle()));
                toArtifact.setAbout(String.valueOf(to.getAbout()) + "/" + "artifacts" + "/" + toArtifact.getTitle());
                to.getArtifacts().add(toArtifact);
            }
        }
        if (props.shouldLoadOwners()) {
            for (Link<Object> link : this.getOwners()) {
                ResourceRef toOwner = JAXBLinksUtil.getResourceRef(link);
                to.getContributors().add(toOwner);
            }
        }
        if (props.shouldLoadCategories()) {
            for (Link link : this.getCategories()) {
                ResourceRef toCategory = JAXBLinksUtil.getResourceRef(link);
                to.getRAMCategories().add(toCategory);
            }
        }
        if (props.shouldLoadAttributes()) {
            for (AttributeValue attributeValue : this.getAttributeValues()) {
                to.getRAMAttributeValues().add(attributeValue);
            }
        }
        if (props.shouldLoadRelationships()) {
            for (RelationshipLink relationshipLink : this.getRelationships()) {
                Relation newRel = new Relation();
                newRel.setResource(JAXBLinksUtil.getOSLCAssetURL(relationshipLink.getRelationship().getAssetId()));
                newRel.setTitle(relationshipLink.getRelationship().getAssetName());
                newRel.setDescription(relationshipLink.getRelationship().getDescription());
                ResourceRef typeRes = new ResourceRef();
                typeRes.setResource(JAXBLinksUtil.getRelationshipTypesURL(relationshipLink));
                typeRes.setValue(JAXButil.toString(relationshipLink.getTitle()));
                newRel.setType(typeRes);
                to.getRelationships().add(newRel);
            }
        }
        if (props.shouldLoadTags() && this.getTags() != null && !this.getTags().isEmpty()) {
            for (Link link : this.getTags()) {
                to.getTagsList().add(link.getTitle().toString());
            }
        }
        return to;
    }
}

