/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.jaxb.util;

import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.jaxb.atom.FeedType;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.bind.JAXBElement;

public class FeedIterator<T>
implements Iterator<T>,
Iterable<T> {
    private FeedType fFeed;
    private int fEntyPointer = 0;

    public FeedIterator(FeedType feed) {
        this.fFeed = feed;
    }

    public int getSize() {
        return this.fFeed == null || this.fFeed.getEntry() == null ? 0 : this.fFeed.getEntry().size();
    }

    @Override
    public boolean hasNext() {
        return this.fFeed != null && this.fFeed.getEntry() != null && this.fFeed.getEntry().size() > this.fEntyPointer;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Reached the end of the feed");
        }
        JAXBElement element = this.getFirstJAXBElement(this.fFeed.getEntry().get(this.fEntyPointer++).getContent().getContent());
        if (element == null) {
            throw new RAMRuntimeException("Feed did not contain a JAXBElement as expected");
        }
        return (T)element.getValue();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unmodifiable Collection");
    }

    public FeedType getFeed() {
        return this.fFeed;
    }

    public void reset() {
        this.fEntyPointer = 0;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    private JAXBElement getFirstJAXBElement(List content) {
        JAXBElement ret = null;
        if (content != null) {
            for (Object object : content) {
                if (!(object instanceof JAXBElement)) continue;
                ret = (JAXBElement)object;
                break;
            }
        }
        return ret;
    }
}

