/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.ibm.ram.internal.jaxb.Link;
import com.ibm.ram.internal.json.JsonTransientLinkValue;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

public class JaxbSerializer
implements JsonSerializer<Object> {
    @Override
    public JsonElement serialize(Object src, Type typeOfSrc, JsonSerializationContext context) {
        JsonElement jsonElement = null;
        Class<?> clazz = src.getClass();
        if (clazz.isAnnotationPresent(XmlAccessorType.class)) {
            JsonObject jsonObject = new JsonObject();
            while (clazz != null) {
                Field[] fields;
                Field[] fieldArray = fields = clazz.getDeclaredFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    field.setAccessible(true);
                    if (!Modifier.isTransient(field.getModifiers())) {
                        Object fieldValue = null;
                        try {
                            String prefix;
                            fieldValue = field.get(src);
                            String name = null;
                            String namespace = null;
                            if (field.isAnnotationPresent(XmlElement.class)) {
                                XmlElement xmlElement = field.getAnnotation(XmlElement.class);
                                name = xmlElement.name();
                                namespace = xmlElement.namespace();
                            } else if (field.isAnnotationPresent(XmlAttribute.class)) {
                                XmlAttribute xmlAttribute = field.getAnnotation(XmlAttribute.class);
                                name = xmlAttribute.name();
                                namespace = xmlAttribute.namespace();
                            }
                            if (name == null || name.length() == 0 || "##default".equals(name)) {
                                name = field.getName();
                            }
                            if (context.getPrefixMapper() != null && namespace != null && (prefix = context.getPrefixMapper().getPreferredPrefix(namespace, null, false)) != null && prefix.length() > 0) {
                                StringBuilder builder = new StringBuilder();
                                builder.append(prefix);
                                builder.append(":");
                                builder.append(name);
                                name = builder.toString();
                            }
                            if (fieldValue == null) {
                                jsonObject.add(name, new JsonNull());
                            } else if (fieldValue instanceof String) {
                                jsonObject.addProperty(name, (String)fieldValue);
                            } else if (fieldValue instanceof Character) {
                                jsonObject.addProperty(name, (Character)fieldValue);
                            } else if (fieldValue instanceof Boolean) {
                                jsonObject.addProperty(name, (Boolean)fieldValue);
                            } else if (fieldValue instanceof Number) {
                                jsonObject.addProperty(name, (Number)fieldValue);
                            } else {
                                if (field.isAnnotationPresent(JsonTransientLinkValue.class) || this.isTransientField(clazz.getName(), field.getName())) {
                                    if (fieldValue instanceof Link) {
                                        ((Link)fieldValue).setValue(null);
                                    } else if (fieldValue instanceof Collection) {
                                        Collection collection = (Collection)fieldValue;
                                        for (Object o : collection) {
                                            if (!(o instanceof Link)) continue;
                                            ((Link)o).setValue(null);
                                        }
                                    }
                                }
                                jsonObject.add(name, context.serialize(fieldValue));
                            }
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
                clazz = clazz.getSuperclass();
            }
            jsonElement = jsonObject;
        } else {
            jsonElement = context.serialize(src, src.getClass());
        }
        return jsonElement;
    }

    private boolean isTransientField(String className, String fieldName) {
        boolean transientField = false;
        if (className != null && fieldName != null) {
            transientField = "com.ibm.ram.internal.jaxb.State".equals(className) && "actions".equals(fieldName);
        }
        return transientField;
    }
}

