/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase;

import com.ibm.ram.defaultprofile.DefaultprofileFactory;
import com.ibm.ram.defaultprofile.Reference;
import com.ibm.ram.defaultprofile.ReferenceKind;
import com.ibm.ram.internal.common.bundles.CommonMessages;
import com.ibm.ram.internal.scm.SCMReference;
import com.ibm.ram.internal.scm.Utilities;
import com.ibm.ram.internal.scm.clearcase.ClearCaseReference;
import com.ibm.ram.internal.scm.clearcase.ClearcaseManager;
import com.ibm.ram.internal.scm.clearcase.VOB;
import com.ibm.ram.internal.scm.clearcase.ucm.ClearcaseUCMReference;
import com.ibm.ram.scm.SCMException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class BaseClearCaseReference
extends SCMReference {
    protected static Logger logger = Logger.getLogger((String)BaseClearCaseReference.class.getName());
    public static final String REFERENCE_KIND_NAME = "clearcase";
    public static final String KEY_VERSION_UNIVERSAL_SELECTOR = "VERSION_UNIV_SEL";
    public static final String KEY_ELEMENT_UNIVERSAL_SELECTOR = "ELEMENT_UNIV_SEL";
    public static final String KEY_LABEL = "LABEL";
    public static final String KEY_BRANCH_NAME = "BRANCH_NAME";
    public static final String KEY_REGION_HOST = "REGION_HOST";
    public static final String KEY_VOB_TAG = "VOB_TAG";
    public static final String KEY_VOB_FAMILY_UUID = "VOB_FAMILY_UUID";
    public static final String KEY_REGION = "REGION";
    public static final String KEY_VOB_SERVER_HOST = "VOB_SERVER_HOST";
    private String versionUniversalSelector;
    private String elementUniversalSelector;
    private String lastBranch;
    private String label;
    private VOB vob;
    private String registryHost;

    public BaseClearCaseReference(String versionUniversalSelector, String elementUniversalSelector, String label, String lastBranch, VOB vob, String registryHost, boolean isFolder, String artifactFileRelativePath) {
        super(isFolder, artifactFileRelativePath);
        this.setVersionUniversalSelector(versionUniversalSelector);
        this.setElementUniversalSelector(elementUniversalSelector);
        this.setLabel(label);
        this.setLastBranch(lastBranch);
        this.setVob(vob);
        this.setRegistryHost(registryHost);
    }

    public static String createReferenceValue(String versionUniversalSelector, String elementUniversalSelector, String label, String branchName, String regionHost) {
        String referenceString = String.valueOf(versionUniversalSelector) + " " + elementUniversalSelector + " " + label + " " + branchName + " " + regionHost;
        return referenceString;
    }

    public static BaseClearCaseReference parseReferenceValue(Reference reference, boolean resolveVOB) throws SCMException {
        try {
            String VOBSEP;
            int vobIndex;
            Properties coreProperties = Utilities.deSerializeProperties(Utilities.processCRLF(reference.getValue()));
            Properties descriptiveProperties = Utilities.deSerializeProperties(Utilities.processCRLF(reference.getDescription().getValue()));
            String versionUS = coreProperties.getProperty(KEY_VERSION_UNIVERSAL_SELECTOR);
            String elementUS = coreProperties.getProperty(KEY_ELEMENT_UNIVERSAL_SELECTOR);
            String label = coreProperties.getProperty(KEY_LABEL);
            String branchName = coreProperties.getProperty(KEY_BRANCH_NAME);
            String regionHost = coreProperties.getProperty(KEY_REGION_HOST);
            String versionPath = descriptiveProperties == null ? null : descriptiveProperties.getProperty("VERSION_PATH");
            String baselineUUIDs = descriptiveProperties == null ? null : descriptiveProperties.getProperty("BASELINE_NAME");
            boolean isFolder = Boolean.valueOf(coreProperties.getProperty("IS_FOLDER"));
            String artifactFileRelativePath = coreProperties.getProperty("ARTIFACT_FILE_RELATIVE_PATH");
            VOB vob = null;
            if (resolveVOB && (vobIndex = elementUS.lastIndexOf(VOBSEP = "@vobuuid:")) > -1) {
                String vobUUID = elementUS.substring(vobIndex + VOBSEP.length());
                ClearcaseManager manager = ClearcaseManager.getInstance();
                if (manager != null) {
                    try {
                        vob = manager.getVOB(vobUUID);
                    }
                    catch (Throwable e) {
                        logger.log((Priority)Level.ERROR, (Object)("Unable to determine VOB: " + vobUUID), e);
                    }
                }
            }
            if (versionPath == null) {
                return new BaseClearCaseReference(versionUS, elementUS, label, branchName, vob, regionHost, isFolder, artifactFileRelativePath);
            }
            if (baselineUUIDs == null) {
                return new ClearCaseReference(versionUS, elementUS, label, versionPath, branchName, vob, regionHost, isFolder, artifactFileRelativePath);
            }
            return new ClearcaseUCMReference(baselineUUIDs, versionUS, elementUS, label, versionPath, branchName, vob, regionHost, isFolder, artifactFileRelativePath);
        }
        catch (IOException e) {
            throw new SCMException(MessageFormat.format(CommonMessages.getString("BaseClearCaseReference_UnableToReconstructCCRefernece"), reference.getValue()), e);
        }
    }

    public VOB getVob() {
        return this.vob;
    }

    public void setVob(VOB vob) {
        this.vob = vob;
    }

    @Override
    public Properties getDisplayProperties() {
        Properties props = super.getDisplayProperties();
        props.setProperty(CommonMessages.getString("BaseClearCaseReference_DisplayVersion"), this.getVersionUniversalSelector());
        props.setProperty(CommonMessages.getString("BaseClearCaseReference_DisplayElement"), this.getElementUniversalSelector());
        props.setProperty(CommonMessages.getString("BaseClearCaseReference_DisplayLabel"), this.getLabel());
        props.setProperty(CommonMessages.getString("BaseClearCaseReference_DisplayBranch"), this.getLastBranch());
        VOB v = this.getVob();
        if (v != null) {
            props.setProperty(CommonMessages.getString("BaseClearCaseReference_DisplayVOBTag"), v.getTag());
            props.setProperty(CommonMessages.getString("BaseClearCaseReference_DisplayVOBFamilyUUID"), v.getFamilyUUID());
            props.setProperty(CommonMessages.getString("BaseClearCaseReference_DisplayRegion"), v.getRegion());
            props.setProperty(CommonMessages.getString("BaseClearCaseReference_DisplayVOBServer"), v.getServerHost());
        }
        if (this.getRegistryHost() != null) {
            props.setProperty(CommonMessages.getString("BaseClearCaseReference_DisplayRegistry"), this.getRegistryHost());
        }
        return props;
    }

    @Override
    public Properties getCoreProperties() {
        Properties props = super.getCoreProperties();
        props.setProperty(KEY_VERSION_UNIVERSAL_SELECTOR, this.getVersionUniversalSelector());
        props.setProperty(KEY_ELEMENT_UNIVERSAL_SELECTOR, this.getElementUniversalSelector());
        props.setProperty(KEY_LABEL, this.getLabel());
        props.setProperty(KEY_BRANCH_NAME, this.getLastBranch());
        if (this.getRegistryHost() != null) {
            props.setProperty(KEY_REGION_HOST, this.getRegistryHost());
        }
        return props;
    }

    @Override
    public Properties getDescriptiveProperties() {
        Properties props = super.getDescriptiveProperties();
        VOB v = this.getVob();
        if (v != null) {
            props.setProperty(KEY_VOB_TAG, v.getTag());
            props.setProperty(KEY_VOB_FAMILY_UUID, v.getFamilyUUID());
            props.setProperty(KEY_REGION, v.getRegion());
            props.setProperty(KEY_VOB_SERVER_HOST, v.getServerHost());
        }
        props.setProperty(KEY_VERSION_UNIVERSAL_SELECTOR, this.getVersionUniversalSelector());
        props.setProperty(KEY_ELEMENT_UNIVERSAL_SELECTOR, this.getElementUniversalSelector());
        props.setProperty(KEY_LABEL, this.getLabel());
        props.setProperty(KEY_BRANCH_NAME, this.getLastBranch());
        if (this.getRegistryHost() != null) {
            props.setProperty(KEY_REGION_HOST, this.getRegistryHost());
        }
        return props;
    }

    public String getElementUniversalSelector() {
        return this.elementUniversalSelector;
    }

    public void setElementUniversalSelector(String elementUniversalSelector) {
        this.elementUniversalSelector = elementUniversalSelector;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getVersionUniversalSelector() {
        return this.versionUniversalSelector;
    }

    public void setVersionUniversalSelector(String versionUniversalSelector) {
        this.versionUniversalSelector = versionUniversalSelector;
    }

    @Override
    protected ReferenceKind getReferenceKind() {
        ReferenceKind refKind = DefaultprofileFactory.eINSTANCE.createReferenceKind();
        refKind.setName(REFERENCE_KIND_NAME);
        return refKind;
    }

    public static String getReferenceKindName() {
        return REFERENCE_KIND_NAME;
    }

    public String getLastBranch() {
        return this.lastBranch;
    }

    public void setLastBranch(String lastBranch) {
        this.lastBranch = lastBranch;
    }

    public String getRegistryHost() {
        return this.registryHost;
    }

    public void setRegistryHost(String registryHost) {
        this.registryHost = registryHost;
    }
}

