/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase;

import com.ibm.ram.defaultprofile.Asset;
import com.ibm.ram.internal.common.bundles.CommonMessages;
import com.ibm.ram.internal.scm.Utilities;
import com.ibm.ram.internal.scm.clearcase.AbstractView;
import com.ibm.ram.internal.scm.clearcase.ClearCaseException;
import com.ibm.ram.internal.scm.clearcase.ClearCaseReference;
import com.ibm.ram.internal.scm.clearcase.DynamicView;
import com.ibm.ram.internal.scm.clearcase.FileInfo;
import com.ibm.ram.internal.scm.clearcase.RegistryInformation;
import com.ibm.ram.internal.scm.clearcase.SnapshotView;
import com.ibm.ram.internal.scm.clearcase.VOB;
import com.ibm.ram.internal.scm.clearcase.VersionFileInfo;
import com.ibm.ram.internal.scm.clearcase.ViewPrivateFileInfo;
import com.ibm.ram.internal.scm.clearcase.commands.AbstractListElementTypesCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CreateLabelCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CreateLabelTypeCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CreateSnapshotViewCommand;
import com.ibm.ram.internal.scm.clearcase.commands.FileCheckinCommand;
import com.ibm.ram.internal.scm.clearcase.commands.FileCheckoutCommand;
import com.ibm.ram.internal.scm.clearcase.commands.FilePathToVersionCommand;
import com.ibm.ram.internal.scm.clearcase.commands.GetAttributesCommand;
import com.ibm.ram.internal.scm.clearcase.commands.GetClearToolVersionCommand;
import com.ibm.ram.internal.scm.clearcase.commands.GetFileInfoCommand;
import com.ibm.ram.internal.scm.clearcase.commands.GetRegistryInformationCommand;
import com.ibm.ram.internal.scm.clearcase.commands.GetUniversalSelectorCommand;
import com.ibm.ram.internal.scm.clearcase.commands.GetViewConfigSpecCommand;
import com.ibm.ram.internal.scm.clearcase.commands.GetViewInfoCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ListAttributeTypesCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ListBranchTypesCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ListLabelTypesCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ListVOBCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ListVersionTreeCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ListViewsCommand;
import com.ibm.ram.internal.scm.clearcase.commands.MakeAttributeTypeCommand;
import com.ibm.ram.internal.scm.clearcase.commands.MakeBranchTypeCommand;
import com.ibm.ram.internal.scm.clearcase.commands.MakeElementCommand;
import com.ibm.ram.internal.scm.clearcase.commands.MountVOBCommand;
import com.ibm.ram.internal.scm.clearcase.commands.RemoveViewCommand;
import com.ibm.ram.internal.scm.clearcase.commands.SetAttributeCommand;
import com.ibm.ram.internal.scm.clearcase.commands.SetConfigSpecCommand;
import com.ibm.ram.internal.scm.clearcase.commands.StartDynamicViewCommand;
import com.ibm.ram.internal.scm.clearcase.commands.UniversalSelectorToPathCommand;
import com.ibm.ram.internal.scm.clearcase.commands.UpdateSnapshotViewCommand;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ClearcaseManager {
    protected static Logger logger = Logger.getLogger(ClearcaseManager.class);
    protected static String installLocation = null;
    protected static Properties configProperties = null;
    protected static ClearcaseManager manager = null;
    protected static long commandTimeout = 0L;
    protected static boolean ccInstalled = false;
    protected static boolean ccInstalledDetermined = false;
    private static final String KEY_CC_INSTALL_LOCATION = "CC_INSTALL_LOCATION";
    private static final String BRANCH_ATTRIBUTE_NAME = "RAM_ASSETS";

    private static String getInstallLocation() {
        if (installLocation == null) {
            installLocation = ClearcaseManager.getConfigProperties().getProperty(KEY_CC_INSTALL_LOCATION);
        }
        return installLocation;
    }

    private static Properties getConfigProperties() {
        if (configProperties == null) {
            configProperties = new Properties();
            try {
                configProperties.load(ClearcaseManager.class.getResourceAsStream("config.properties"));
            }
            catch (IOException e) {
                logger.error((Object)"Error reading configuration", (Throwable)e);
            }
        }
        return configProperties;
    }

    public static String getCLIPath() {
        if (ClearcaseManager.getInstallLocation() != null) {
            return String.valueOf(ClearcaseManager.getInstallLocation()) + "ClearCase/bin/cleartool";
        }
        return "cleartool";
    }

    public static ClearcaseManager getInstance() {
        if (ClearcaseManager.isCleartoolInstalled() && manager == null) {
            manager = new ClearcaseManager();
        }
        return manager;
    }

    public AbstractView[] getViews(String viewTag) throws ClearCaseException {
        try {
            ListViewsCommand command = new ListViewsCommand(viewTag);
            ListViewsCommand.ListViewsOutput viewsOutput = (ListViewsCommand.ListViewsOutput)command.run(ClearcaseManager.getCLIPath());
            return viewsOutput.getViews();
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.views"), viewTag), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.views"), viewTag), e);
        }
    }

    public VOB[] getVOBs(String hostName) throws ClearCaseException {
        try {
            ListVOBCommand command = new ListVOBCommand(hostName, true, false);
            ListVOBCommand.ListVOBOutput viewsOutput = (ListVOBCommand.ListVOBOutput)command.run(ClearcaseManager.getCLIPath());
            return viewsOutput.getVOBs();
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.vobs"), hostName), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.vobs"), hostName), e);
        }
    }

    public VOB getVOB(String familyUUID) throws ClearCaseException {
        try {
            ListVOBCommand command = new ListVOBCommand(familyUUID, false, true);
            ListVOBCommand.ListVOBOutput viewsOutput = (ListVOBCommand.ListVOBOutput)command.run(ClearcaseManager.getCLIPath());
            VOB[] vobs = viewsOutput.getVOBs();
            if (vobs != null && vobs.length > 0) {
                return vobs[0];
            }
            return null;
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.vob.with.uuid"), familyUUID), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.vob.with.uuid"), familyUUID), e);
        }
    }

    public String resolveUniversalSelectorToPath(String universalSelector, File viewLocation) throws ClearCaseException {
        try {
            UniversalSelectorToPathCommand c = new UniversalSelectorToPathCommand(universalSelector, viewLocation);
            String path = ((UniversalSelectorToPathCommand.ReferenceToPathOutput)c.run(ClearcaseManager.getCLIPath())).getPath();
            String viewPath = viewLocation.getAbsolutePath();
            if (viewPath.length() > 2 && Character.isLetter(viewPath.charAt(0)) && ':' == viewPath.charAt(1) && path != null && path.length() > 1 && ':' != path.charAt(1)) {
                String prefix = new String(new char[]{viewPath.charAt(0), ':'});
                path = String.valueOf(prefix) + path;
            }
            return path;
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.resolve.universal.selector"), universalSelector), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.resolve.universal.selector"), universalSelector), e);
        }
    }

    public String[] resolveFilePathToVersion(String[] filePaths) throws ClearCaseException {
        try {
            FilePathToVersionCommand c = new FilePathToVersionCommand(filePaths);
            return ((FilePathToVersionCommand.FilePathToVersionOutput)c.run(ClearcaseManager.getCLIPath())).getVersion();
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.file.version"), new Object[]{filePaths}), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.file.version"), new Object[]{filePaths}), e);
        }
    }

    public ClearCaseReference getReference(File viewFile, String pathInContainer) throws ClearCaseException {
        return this.createReferences(new File[]{viewFile}, null, new String[]{pathInContainer})[0];
    }

    private boolean setLabel(File[] viewFiles, String label, boolean isRecursive) throws ClearCaseException {
        boolean set = false;
        try {
            CreateLabelCommand c2 = new CreateLabelCommand(viewFiles, label, isRecursive);
            CreateLabelCommand.CreateLabelOutput out2 = (CreateLabelCommand.CreateLabelOutput)c2.run(ClearcaseManager.getCLIPath());
            set = out2.isCreated();
        }
        catch (IOException e) {
            throw new ClearCaseException(CommonMessages.getString("ccManager.unable.to.set.label"), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(CommonMessages.getString("ccManager.unable.to.set.label"), e);
        }
        return set;
    }

    public boolean isSharedWithClearCase(File viewFile) throws ClearCaseException {
        boolean managed = false;
        ClearcaseManager manager = ClearcaseManager.getInstance();
        if (manager != null) {
            AbstractView view = manager.getViewAtLocation(viewFile);
            if (view != null && view.isUCM()) {
                return false;
            }
            FileInfo fi = manager.getFileInfo(viewFile);
            if (fi != null) {
                if (fi instanceof ViewPrivateFileInfo) {
                    managed = false;
                } else if (fi instanceof VersionFileInfo) {
                    managed = true;
                }
            }
        }
        return managed;
    }

    public boolean isCheckedOut(File viewFile) throws ClearCaseException {
        FileInfo fi;
        boolean checkedOut = false;
        ClearcaseManager manager = ClearcaseManager.getInstance();
        if (manager != null && (fi = manager.getFileInfo(viewFile)) != null) {
            if (fi instanceof ViewPrivateFileInfo) {
                checkedOut = false;
            } else if (fi instanceof VersionFileInfo) {
                checkedOut = ((VersionFileInfo)fi).isCheckedOut();
            }
        }
        return checkedOut;
    }

    public boolean startDynamicView(DynamicView dynamicView) throws ClearCaseException {
        boolean started = false;
        try {
            StartDynamicViewCommand c = new StartDynamicViewCommand(dynamicView);
            StartDynamicViewCommand.StartDynamicViewOutput out = (StartDynamicViewCommand.StartDynamicViewOutput)c.run(ClearcaseManager.getCLIPath());
            started = out.isStarted();
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.start.dynamic.view"), dynamicView.getTag()), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.start.dynamic.view"), dynamicView.getTag()), e);
        }
        return started;
    }

    public FileInfo getFileInfo(File viewFile) throws ClearCaseException {
        FileInfo file = null;
        try {
            GetFileInfoCommand c = new GetFileInfoCommand(new String[]{viewFile.getAbsolutePath()});
            GetFileInfoCommand.IFileInfoCommandOutput out = (GetFileInfoCommand.IFileInfoCommandOutput)c.run(ClearcaseManager.getCLIPath());
            file = out.getFileInfo()[0];
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.get.file.info"), viewFile.getAbsolutePath()), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.get.file.info"), viewFile.getAbsolutePath()), e);
        }
        return file;
    }

    public FileInfo[] getFileInfos(File[] viewFiles) throws ClearCaseException {
        FileInfo[] file = null;
        try {
            String[] paths = new String[viewFiles.length];
            int c = 0;
            while (c < viewFiles.length) {
                paths[c] = viewFiles[c] == null || !viewFiles[c].exists() || !viewFiles[c].canRead() ? "/" : viewFiles[c].getAbsolutePath();
                ++c;
            }
            GetFileInfoCommand c2 = new GetFileInfoCommand(paths);
            GetFileInfoCommand.IFileInfoCommandOutput out = (GetFileInfoCommand.IFileInfoCommandOutput)c2.run(ClearcaseManager.getCLIPath());
            file = out.getFileInfo();
        }
        catch (IOException e) {
            throw new ClearCaseException(CommonMessages.getString("ccManager.unable.to.get.view.file.info"), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(CommonMessages.getString("ccManager.unable.to.get.view.file.info"), e);
        }
        return file;
    }

    public DynamicView createDynamicView() {
        return null;
    }

    public SnapshotView createSnapshotView(String viewTag, String destinationPath) throws ClearCaseException {
        SnapshotView snapshotView;
        block17: {
            AbstractView[] views;
            block16: {
                snapshotView = null;
                try {
                    ListViewsCommand c1 = new ListViewsCommand(viewTag);
                    ListViewsCommand.ListViewsOutput out1 = (ListViewsCommand.ListViewsOutput)c1.run(ClearcaseManager.getCLIPath());
                    views = out1.getViews();
                    if (views == null) break block16;
                    int vc = 0;
                    while (vc < views.length) {
                        SnapshotView sv;
                        if (views[vc] instanceof SnapshotView && viewTag.equals((sv = (SnapshotView)views[vc]).getTag())) {
                            snapshotView = sv;
                            break;
                        }
                        ++vc;
                    }
                }
                catch (IOException e) {
                    throw new ClearCaseException(CommonMessages.getString("ccManager.unable.to.determine.existing.views"), e);
                }
                catch (InterruptedException e) {
                    throw new ClearCaseException(CommonMessages.getString("ccManager.unable.to.determine.existing.views"), e);
                }
            }
            if (snapshotView == null) {
                CreateSnapshotViewCommand.ICreateSnapshotViewCommandOutput out;
                try {
                    CreateSnapshotViewCommand c = new CreateSnapshotViewCommand(viewTag, destinationPath);
                    out = (CreateSnapshotViewCommand.ICreateSnapshotViewCommandOutput)c.run(ClearcaseManager.getCLIPath());
                    if (out == null || !out.isCreated()) {
                        throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.create.view"), c.getErrorStreamContent()));
                    }
                }
                catch (IOException e) {
                    throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.create.snapshot.view"), viewTag), e);
                }
                catch (InterruptedException e) {
                    throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.create.snapshot.view"), viewTag), e);
                }
                if (out.isCreated()) {
                    try {
                        ListViewsCommand c2 = new ListViewsCommand(viewTag);
                        ListViewsCommand.ListViewsOutput out2 = (ListViewsCommand.ListViewsOutput)c2.run(ClearcaseManager.getCLIPath());
                        views = out2.getViews();
                        if (views == null) break block17;
                        int vc = 0;
                        while (vc < views.length) {
                            SnapshotView sv;
                            if (views[vc] instanceof SnapshotView && viewTag.equals((sv = (SnapshotView)views[vc]).getTag())) {
                                snapshotView = sv;
                                break;
                            }
                            ++vc;
                        }
                    }
                    catch (IOException e) {
                        throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.newly.created.view"), viewTag), e);
                    }
                    catch (InterruptedException e) {
                        throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.newly.created.view"), viewTag), e);
                    }
                }
            }
        }
        return snapshotView;
    }

    public static boolean isCleartoolInstalled() {
        if (!ccInstalledDetermined) {
            ccInstalled = false;
            ccInstalledDetermined = true;
            try {
                GetClearToolVersionCommand c = new GetClearToolVersionCommand();
                GetClearToolVersionCommand.ClearToolVersionOutput out = (GetClearToolVersionCommand.ClearToolVersionOutput)c.run(ClearcaseManager.getCLIPath());
                ccInstalled = out != null && out.getVersion() != null && out.getVersion().trim().length() > 0;
            }
            catch (IOException e) {
                logger.info((Object)("Unable to determine if ClearCase is installed: " + e.getLocalizedMessage()));
            }
            catch (InterruptedException e) {
                logger.info((Object)("Unable to determine if ClearCase is installed: " + e.getLocalizedMessage()));
            }
        }
        return ccInstalled;
    }

    public boolean setConfigSpec(AbstractView view, File configSpecFile, File viewLocation) throws ClearCaseException {
        boolean set = false;
        try {
            SetConfigSpecCommand c = new SetConfigSpecCommand(view, configSpecFile, viewLocation);
            SetConfigSpecCommand.SetConfigSpecCommandOutput out = (SetConfigSpecCommand.SetConfigSpecCommandOutput)c.run(ClearcaseManager.getCLIPath());
            set = out.isSet();
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.set.config.spec.for.view"), view.getTag()), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.set.config.spec.for.view"), view.getTag()), e);
        }
        return set;
    }

    public void updateSnapshotView(SnapshotView sv) throws ClearCaseException {
        try {
            UpdateSnapshotViewCommand c = new UpdateSnapshotViewCommand(sv);
            c.run(ClearcaseManager.getCLIPath());
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.update.snapshot.view"), sv.getTag()), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.update.snapshot.view"), sv.getTag()), e);
        }
    }

    public boolean makeBranchType(String branchType, VOB vob) throws ClearCaseException {
        boolean created = this.isBranchTypePresent(branchType, vob);
        if (!created) {
            try {
                MakeBranchTypeCommand c1 = new MakeBranchTypeCommand(branchType, vob);
                MakeBranchTypeCommand.MakeBranchTypeCommandOutput out1 = (MakeBranchTypeCommand.MakeBranchTypeCommandOutput)c1.run(ClearcaseManager.getCLIPath());
                created = out1.isCreated();
            }
            catch (IOException e) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.create.branch"), branchType), e);
            }
            catch (InterruptedException e) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.create.branch"), branchType), e);
            }
            created = this.isBranchTypePresent(branchType, vob);
        }
        return created;
    }

    private boolean isBranchTypePresent(String branchType, VOB vob) throws ClearCaseException {
        boolean created;
        block5: {
            created = false;
            ListBranchTypesCommand c = new ListBranchTypesCommand(vob);
            try {
                AbstractListElementTypesCommand.ListTypesOutput out = (AbstractListElementTypesCommand.ListTypesOutput)c.run(ClearcaseManager.getCLIPath());
                String[] existingTypes = out.getTypes();
                if (existingTypes == null) break block5;
                int ltc = 0;
                while (ltc < existingTypes.length) {
                    if (branchType.equals(existingTypes[ltc])) {
                        created = true;
                        break;
                    }
                    ++ltc;
                }
            }
            catch (IOException e) {
                throw new ClearCaseException(CommonMessages.getString("ccManager.unable.to.determine.branch.type.list"), e);
            }
            catch (InterruptedException e) {
                throw new ClearCaseException(CommonMessages.getString("ccManager.unable.to.determine.branch.type.list"), e);
            }
        }
        return created;
    }

    public AbstractView getViewAtLocation(File viewLocation) throws ClearCaseException {
        AbstractView view = null;
        try {
            GetViewInfoCommand c = new GetViewInfoCommand(viewLocation);
            GetViewInfoCommand.ViewInfoOutput out = (GetViewInfoCommand.ViewInfoOutput)c.run(ClearcaseManager.getCLIPath());
            if (out != null) {
                view = out.getView();
            }
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.view.at.location"), viewLocation.getAbsolutePath()), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.view.at.location"), viewLocation.getAbsolutePath()), e);
        }
        return view;
    }

    public void makeEditableInDynamicView(File file, boolean isFolder) throws ClearCaseException {
        FileInfo fileInfo = this.getFileInfo(file);
        if (fileInfo != null) {
            VersionFileInfo versionFileInfo;
            if (fileInfo instanceof ViewPrivateFileInfo) {
                this.addToSourceControl(new File[]{file});
                this.checkout(file);
            } else if (fileInfo instanceof VersionFileInfo && !(versionFileInfo = (VersionFileInfo)fileInfo).isCheckedOut()) {
                this.checkout(file);
            }
        } else {
            this.makeEditableInDynamicView(file.getParentFile(), true);
            this.createElement(new File[]{file}, isFolder);
            this.checkout(file);
        }
    }

    private File[] createElement(File[] files, boolean areFolders) throws ClearCaseException {
        try {
            MakeElementCommand coCommand = new MakeElementCommand(2, files, areFolders, "RAM Create Element");
            MakeElementCommand.MakeElementCommandOutput co = (MakeElementCommand.MakeElementCommandOutput)coCommand.run(ClearcaseManager.getCLIPath());
            if (co.areElementsMade()) {
                return files;
            }
            return null;
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.create.elements"), new Integer(files.length)), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.create.elements"), new Integer(files.length)), e);
        }
    }

    public boolean checkout(File file) throws ClearCaseException {
        boolean checkedOut = false;
        FileInfo fi = this.getFileInfo(file);
        if (fi instanceof VersionFileInfo) {
            VersionFileInfo vfi = (VersionFileInfo)fi;
            checkedOut = vfi.isCheckedOut() ? true : this.primtCheckout(file);
        } else {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.file.not.checkedin.to.checkout"), file.getAbsolutePath()));
        }
        return checkedOut;
    }

    public boolean createFolder(File folder) throws ClearCaseException {
        boolean created = false;
        if (folder != null) {
            if (folder.exists()) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.cc.cannot.create.already.existing.folder"), folder.getAbsolutePath()));
            }
            File parentFolder = folder.getParentFile();
            if (!parentFolder.exists()) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.locate.parent.folder"), parentFolder.getAbsolutePath()));
            }
            FileInfo parentFileInfo = this.getFileInfo(parentFolder);
            if (parentFileInfo instanceof VersionFileInfo) {
                VersionFileInfo version = (VersionFileInfo)parentFileInfo;
                if (!version.isCheckedOut() && !this.primtCheckout(parentFolder)) {
                    throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.checkout.parent.folder"), parentFolder.getAbsolutePath()));
                }
                try {
                    if (this.createElement(new File[]{folder}, true) == null) {
                        throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.create.folder.element"), folder.getAbsolutePath()));
                    }
                    created = true;
                }
                catch (Throwable throwable) {
                    this.primCheckin(new File[]{parentFolder});
                    throw throwable;
                }
                this.primCheckin(new File[]{parentFolder});
            } else {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.parent.folder.not.in.scm"), parentFolder.getAbsolutePath()));
            }
        }
        return created;
    }

    public boolean createFile(File file) throws ClearCaseException {
        boolean created = false;
        if (file != null) {
            File parentFolder = file.getParentFile();
            if (!parentFolder.exists()) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.locate.parent.folder"), parentFolder.getAbsolutePath()));
            }
            FileInfo parentFileInfo = this.getFileInfo(parentFolder);
            if (parentFileInfo instanceof VersionFileInfo) {
                VersionFileInfo version = (VersionFileInfo)parentFileInfo;
                if (!version.isCheckedOut() && !this.primtCheckout(parentFolder)) {
                    throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.checkout.parent.folder"), parentFolder.getAbsolutePath()));
                }
                try {
                    if (this.createElement(new File[]{file}, false) == null) {
                        throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.create.folder.element"), file.getAbsolutePath()));
                    }
                }
                catch (Throwable throwable) {
                    this.primCheckin(new File[]{parentFolder});
                    throw throwable;
                }
                this.primCheckin(new File[]{parentFolder});
            } else {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.parent.folder.not.in.scm"), parentFolder.getAbsolutePath()));
            }
        }
        return created;
    }

    public boolean updateFile(File file, IFileUpdateCallback callback) throws ClearCaseException {
        boolean created = false;
        if (file != null) {
            File parentFolder = file.getParentFile();
            if (!parentFolder.exists()) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.locate.parent.folder"), parentFolder.getAbsolutePath()));
            }
            FileInfo parentFileInfo = this.getFileInfo(parentFolder);
            if (parentFileInfo instanceof VersionFileInfo) {
                VersionFileInfo version = (VersionFileInfo)parentFileInfo;
                if (!version.isCheckedOut() && !this.primtCheckout(parentFolder)) {
                    throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.checkout.parent.folder"), parentFolder.getAbsolutePath()));
                }
                try {
                    callback.performUpdate(file);
                }
                catch (Throwable throwable) {
                    this.primCheckin(new File[]{parentFolder});
                    throw throwable;
                }
                this.primCheckin(new File[]{parentFolder});
            } else {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.parent.folder.not.in.scm"), parentFolder.getAbsolutePath()));
            }
        }
        return created;
    }

    public String[] checkin(File[] file) throws ClearCaseException {
        String[] checkIn = null;
        FileInfo[] fi = this.getFileInfos(file);
        LinkedHashMap<File, Integer> fileToIndexMap = new LinkedHashMap<File, Integer>();
        int fc = 0;
        while (fc < fi.length) {
            if (fi[fc] instanceof VersionFileInfo) {
                VersionFileInfo vfi = (VersionFileInfo)fi[fc];
                if (vfi.isCheckedOut()) {
                    fileToIndexMap.put(file[fc], new Integer(fc));
                } else {
                    if (checkIn == null) {
                        checkIn = new String[file.length];
                    }
                    checkIn[fc] = vfi.getVersion();
                }
            } else {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.file.not.element.to.checkin"), file[fc].getAbsolutePath()));
            }
            ++fc;
        }
        if (fileToIndexMap.size() > 0) {
            String[] checkedIn = this.primCheckin(fileToIndexMap.keySet().toArray(new File[fileToIndexMap.size()]));
            if (checkedIn.length == file.length) {
                checkIn = checkedIn;
            } else {
                int i = 0;
                for (Integer ndx : fileToIndexMap.values()) {
                    checkIn[ndx.intValue()] = checkedIn[i++];
                }
            }
        }
        return checkIn;
    }

    public String getVersion(File f) throws ClearCaseException {
        FileInfo fi = this.getFileInfo(f);
        if (fi instanceof VersionFileInfo) {
            VersionFileInfo vfi = (VersionFileInfo)fi;
            return vfi.getVersion();
        }
        throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.file.not.element.that.can.have.version"), f.getAbsolutePath()));
    }

    private boolean primtCheckout(File file) throws ClearCaseException {
        try {
            FileCheckoutCommand coCommand = new FileCheckoutCommand(file, "RAM Checkout");
            FileCheckoutCommand.CheckoutCommandOutput co = (FileCheckoutCommand.CheckoutCommandOutput)coCommand.run(ClearcaseManager.getCLIPath());
            return co.isCheckedOut();
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.checkout.file"), file.getAbsolutePath()), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.checkout.file"), file.getAbsolutePath()), e);
        }
    }

    private String[] primCheckin(File[] files) throws ClearCaseException {
        try {
            FileCheckinCommand coCommand = new FileCheckinCommand(files, "RAM Checkin");
            FileCheckinCommand.CheckinCommandOutput co = (FileCheckinCommand.CheckinCommandOutput)coCommand.run(ClearcaseManager.getCLIPath());
            return co.getVersions();
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.checkin.files"), new Object[]{files}), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.checkin.files"), new Object[]{files}), e);
        }
    }

    public String[] getBranches(File file) throws ClearCaseException {
        try {
            ListVersionTreeCommand coCommand = new ListVersionTreeCommand(file);
            ListVersionTreeCommand.ListVersionTreeOutput co = (ListVersionTreeCommand.ListVersionTreeOutput)coCommand.run(ClearcaseManager.getCLIPath());
            return co.getBranches();
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.file.branches"), file.getAbsolutePath()), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.file.branches"), file.getAbsolutePath()), e);
        }
    }

    public String[] getBranches(VOB vob) throws ClearCaseException {
        try {
            ListBranchTypesCommand coCommand = new ListBranchTypesCommand(vob);
            AbstractListElementTypesCommand.ListTypesOutput co = (AbstractListElementTypesCommand.ListTypesOutput)coCommand.run(ClearcaseManager.getCLIPath());
            return co.getTypes();
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.all.vob.branches"), vob.getTag()), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.all.vob.branches"), vob.getTag()), e);
        }
    }

    public boolean removeSnapshotView(String viewTag, File viewFolder) throws ClearCaseException {
        boolean removed = false;
        try {
            RemoveViewCommand coCommand = new RemoveViewCommand(viewFolder, true);
            coCommand.run(ClearcaseManager.getCLIPath());
            boolean found = false;
            AbstractView[] views = this.getViews(viewTag);
            if (views != null) {
                int vc = 0;
                while (vc < views.length) {
                    if (viewTag.equals(views[vc].getTag())) {
                        found = true;
                        break;
                    }
                    ++vc;
                }
            }
            if (!found) {
                removed = true;
            }
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.remove.snapshot.view.at"), viewFolder.getAbsolutePath()), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.remove.snapshot.view.at"), viewFolder.getAbsolutePath()), e);
        }
        return removed;
    }

    public static long getCommandTimeout() {
        return commandTimeout;
    }

    public static void setCommandTimeout(long commandTimeout) {
        ClearcaseManager.commandTimeout = commandTimeout;
    }

    public RegistryInformation getRegistryInformation() throws ClearCaseException {
        try {
            GetRegistryInformationCommand coCommand = new GetRegistryInformationCommand();
            GetRegistryInformationCommand.RegistryInformationCommandOutput co = (GetRegistryInformationCommand.RegistryInformationCommandOutput)coCommand.run(ClearcaseManager.getCLIPath());
            return co.getRegistryInformation();
        }
        catch (IOException e) {
            throw new ClearCaseException(CommonMessages.getString("ccManager.unable.to.determine.registry.info"), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(CommonMessages.getString("ccManager.unable.to.determine.registry.info"), e);
        }
    }

    private boolean isAttributeTypePresent(String attributeName, VOB inVob) throws ClearCaseException {
        boolean attributeTypeExists;
        block5: {
            attributeTypeExists = false;
            try {
                ListAttributeTypesCommand atTypeCommand = new ListAttributeTypesCommand(inVob);
                AbstractListElementTypesCommand.ListTypesOutput atts = (AbstractListElementTypesCommand.ListTypesOutput)atTypeCommand.run(ClearcaseManager.getCLIPath());
                if (atts == null || atts.getTypes() == null) break block5;
                int ac = 0;
                while (ac < atts.getTypes().length) {
                    if (atts.getTypes()[ac].equals(attributeName)) {
                        attributeTypeExists = true;
                        break;
                    }
                    ++ac;
                }
            }
            catch (IOException iOException) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.attribute.in.vob"), attributeName, inVob.getTag()));
            }
            catch (InterruptedException interruptedException) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.attribute.in.vob"), attributeName, inVob.getTag()));
            }
        }
        return attributeTypeExists;
    }

    private boolean makeAttributeType(String attributeType, String comment, VOB vob) throws ClearCaseException {
        boolean created = this.isAttributeTypePresent(attributeType, vob);
        if (!created) {
            try {
                MakeAttributeTypeCommand c1 = new MakeAttributeTypeCommand(attributeType, comment, vob);
                MakeAttributeTypeCommand.MakeAttributeTypeCommandOutput out1 = (MakeAttributeTypeCommand.MakeAttributeTypeCommandOutput)c1.run(ClearcaseManager.getCLIPath());
                created = out1.isCreated();
            }
            catch (IOException e) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.create.attribute.type"), attributeType), e);
            }
            catch (InterruptedException e) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.create.attribute.type"), attributeType), e);
            }
            created = this.isAttributeTypePresent(attributeType, vob);
        }
        return created;
    }

    public boolean addToSourceControl(File[] files) throws ClearCaseException {
        boolean added = true;
        try {
            Arrays.sort(files, new Comparator(){

                public int compare(Object o1, Object o2) {
                    File file1 = (File)o1;
                    File file2 = (File)o2;
                    String path1 = file1.getAbsolutePath();
                    String path2 = file2.getAbsolutePath();
                    if (path1.length() < path2.length()) {
                        return -1;
                    }
                    if (path1.length() > path2.length()) {
                        return 1;
                    }
                    return 0;
                }
            });
            ArrayList<File> directoryList = new ArrayList<File>();
            ArrayList<File> fileList = new ArrayList<File>();
            int c = 0;
            while (c < files.length) {
                if (files[c].isDirectory()) {
                    directoryList.add(files[c]);
                } else {
                    fileList.add(files[c]);
                }
                ++c;
            }
            if (directoryList.size() > 0) {
                boolean[] parentFoldersCheckedout = new boolean[directoryList.size()];
                File[] parentFolders = new File[directoryList.size()];
                int pc = 0;
                while (pc < parentFoldersCheckedout.length) {
                    parentFolders[pc] = ((File)directoryList.get(pc)).getParentFile();
                    ++pc;
                }
                FileInfo[] beforeMakeElementFileInfos = this.getFileInfos(parentFolders);
                File[] dirs = directoryList.toArray(new File[directoryList.size()]);
                MakeElementCommand coCommand = new MakeElementCommand(4, dirs, true, "RAM Create Element");
                MakeElementCommand.MakeElementCommandOutput co = (MakeElementCommand.MakeElementCommandOutput)coCommand.run(ClearcaseManager.getCLIPath());
                added = co.areElementsMade();
                if (!added) {
                    FileInfo[] afterMakeElementFileInfos = this.getFileInfos(parentFolders);
                    ArrayList<File> parentsToCheckinList = new ArrayList<File>();
                    int fic = 0;
                    while (fic < afterMakeElementFileInfos.length) {
                        if (beforeMakeElementFileInfos[fic] instanceof VersionFileInfo && afterMakeElementFileInfos[fic] instanceof VersionFileInfo) {
                            VersionFileInfo beforeFileInfo = (VersionFileInfo)beforeMakeElementFileInfos[fic];
                            VersionFileInfo afterFileInfo = (VersionFileInfo)afterMakeElementFileInfos[fic];
                            if (!beforeFileInfo.isCheckedOut() && afterFileInfo.isCheckedOut()) {
                                parentsToCheckinList.add(parentFolders[fic]);
                            }
                        }
                        ++fic;
                    }
                    if (parentsToCheckinList.size() > 0) {
                        this.checkin(parentsToCheckinList.toArray(new File[parentsToCheckinList.size()]));
                        added = true;
                    }
                    logger.warn((Object)("addToSourceControl: " + coCommand.getErrorStreamContent()));
                }
            }
            if (fileList.size() > 0) {
                File[] fs = fileList.toArray(new File[fileList.size()]);
                MakeElementCommand coCommand = new MakeElementCommand(4, fs, false, "RAM Create Element");
                MakeElementCommand.MakeElementCommandOutput co = (MakeElementCommand.MakeElementCommandOutput)coCommand.run(ClearcaseManager.getCLIPath());
                boolean areElementsMade = co.areElementsMade();
                if (!areElementsMade) {
                    logger.warn((Object)("addToSourceControl-mkelement: " + coCommand.getErrorStreamContent()));
                }
                added = added && areElementsMade;
            }
        }
        catch (IOException e) {
            throw new ClearCaseException(CommonMessages.getString("ccManager.unable.to.add.to.source.control"), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(CommonMessages.getString("ccManager.unable.to.add.to.source.control"), e);
        }
        return added;
    }

    public boolean associateAssetWithBranch(Asset asset, String branchName, VOB vob) throws ClearCaseException {
        boolean associated;
        block6: {
            associated = false;
            String assetLabel = Utilities.getAssetLabel(asset);
            try {
                if (!this.makeAttributeType(BRANCH_ATTRIBUTE_NAME, "Attribute listing all RAMs assets in branch", vob)) break block6;
                String currentValue = this.getBranchAssetsAttributeValue(branchName, vob);
                if (currentValue != null) {
                    StringTokenizer colonSeparator = new StringTokenizer(currentValue, ":", false);
                    while (colonSeparator.hasMoreTokens()) {
                        String label = colonSeparator.nextToken();
                        if (!label.equals(assetLabel)) continue;
                        associated = true;
                        break;
                    }
                }
                if (associated) break block6;
                String newValue = currentValue == null ? assetLabel : String.valueOf(currentValue) + ":" + assetLabel;
                SetAttributeCommand sac = new SetAttributeCommand(BRANCH_ATTRIBUTE_NAME, newValue, branchName, vob, "RAM Assets in branch");
                sac.run(ClearcaseManager.getCLIPath());
                currentValue = this.getBranchAssetsAttributeValue(branchName, vob);
                if (currentValue == null) break block6;
                StringTokenizer colonSeparator = new StringTokenizer(currentValue, ":", false);
                while (colonSeparator.hasMoreTokens()) {
                    String label = colonSeparator.nextToken();
                    if (!label.equals(assetLabel)) continue;
                    associated = true;
                    break;
                }
            }
            catch (IOException iOException) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.associate.branch.with.asset"), branchName, asset.getName()));
            }
            catch (InterruptedException interruptedException) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.associate.branch.with.asset"), branchName, asset.getName()));
            }
        }
        return associated;
    }

    private String getBranchAssetsAttributeValue(String branchName, VOB vob) throws ClearCaseException {
        String currentValue = null;
        try {
            GetAttributesCommand gac = new GetAttributesCommand(branchName, vob);
            GetAttributesCommand.GetAttributesOutput out = (GetAttributesCommand.GetAttributesOutput)gac.run(ClearcaseManager.getCLIPath());
            Properties attributes = out.getAttributes();
            if (attributes != null && attributes.containsKey(BRANCH_ATTRIBUTE_NAME) && (currentValue = attributes.getProperty(BRANCH_ATTRIBUTE_NAME)).charAt(0) == '\"' && currentValue.endsWith("\"")) {
                currentValue = currentValue.substring(1, currentValue.length() - 1);
            }
        }
        catch (IOException iOException) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.assets.attribute.on.branch"), branchName));
        }
        catch (InterruptedException interruptedException) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.assets.attribute.on.branch"), branchName));
        }
        return currentValue;
    }

    public String[] getAssetAssociatedBranches(Asset asset, VOB vob) throws ClearCaseException {
        ArrayList<String> branchesList = new ArrayList<String>();
        String[] allBranches = this.getBranches(vob);
        if (allBranches != null) {
            int bc = 0;
            while (bc < allBranches.length) {
                block5: {
                    try {
                        String attributeValue = this.getBranchAssetsAttributeValue(allBranches[bc], vob);
                        if (attributeValue == null) break block5;
                        String assetLabel = Utilities.getAssetLabel(asset);
                        StringTokenizer colonSeparator = new StringTokenizer(attributeValue, ":", false);
                        while (colonSeparator.hasMoreTokens()) {
                            String label = colonSeparator.nextToken();
                            if (!label.equals(assetLabel)) continue;
                            branchesList.add(allBranches[bc]);
                            break;
                        }
                    }
                    catch (ClearCaseException clearCaseException) {}
                }
                ++bc;
            }
        }
        return branchesList.toArray(new String[branchesList.size()]);
    }

    public boolean mountVOB(VOB vob) throws ClearCaseException {
        boolean added = false;
        try {
            MountVOBCommand coCommand = new MountVOBCommand(vob);
            MountVOBCommand.MountVOBOutput co = (MountVOBCommand.MountVOBOutput)coCommand.run(ClearcaseManager.getCLIPath());
            added = co.isMounted();
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.mount.vob"), vob.getTag()), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.mount.vob"), vob.getTag()), e);
        }
        return added;
    }

    public ClearCaseReference[] createReferences(File[] viewFiles, String label, String[] pathInContainers) throws ClearCaseException {
        ClearCaseReference[] references = null;
        if (viewFiles != null && viewFiles.length > 0) {
            List<File> viewFilesList = Arrays.asList(viewFiles);
            references = new ClearCaseReference[viewFiles.length];
            ClearcaseManager manager = ClearcaseManager.getInstance();
            ArrayList<File> inSCMFileList = new ArrayList<File>();
            FileInfo[] viewFileInfos = manager.getFileInfos(viewFiles);
            int vfc = 0;
            while (vfc < viewFileInfos.length) {
                if (viewFileInfos[vfc] instanceof VersionFileInfo) {
                    inSCMFileList.add(viewFiles[vfc]);
                }
                ++vfc;
            }
            if (inSCMFileList.size() > 0) {
                String registryHost;
                String[] univSelectorPaths = new String[inSCMFileList.size() * 2];
                String[] filePaths = new String[inSCMFileList.size()];
                String[] branches = new String[inSCMFileList.size()];
                int fc = 0;
                while (fc < inSCMFileList.size()) {
                    File file = (File)inSCMFileList.get(fc);
                    filePaths[fc] = file.getAbsolutePath();
                    String versionFilePath = filePaths[fc];
                    String elementFilePath = String.valueOf(filePaths[fc]) + "@@";
                    univSelectorPaths[2 * fc] = versionFilePath;
                    univSelectorPaths[2 * fc + 1] = elementFilePath;
                    branches[fc] = this.determineRAMBranch(file);
                    ++fc;
                }
                String[] univSelectors = null;
                try {
                    GetUniversalSelectorCommand guc = new GetUniversalSelectorCommand(univSelectorPaths);
                    GetUniversalSelectorCommand.ReferenceOutput out = (GetUniversalSelectorCommand.ReferenceOutput)guc.run(ClearcaseManager.getCLIPath());
                    univSelectors = out.getUniversalSelector();
                }
                catch (InterruptedException e) {
                    throw new ClearCaseException(CommonMessages.getString("ccManager.unable.to.resolve.univ.selectors"), e);
                }
                catch (IOException e) {
                    throw new ClearCaseException(CommonMessages.getString("ccManager.unable.to.resolve.univ.selectors"), e);
                }
                String[] versionPaths = this.resolveFilePathToVersion(filePaths);
                HashMap<String, VOB> uuidToVOBMap = new HashMap<String, VOB>();
                VOB[] vobs = new VOB[inSCMFileList.size()];
                int vc = 0;
                while (vc < vobs.length) {
                    String versionUniversalSelector = univSelectors[2 * vc];
                    String VOBSEP = "@vobuuid:";
                    int vobIndex = versionUniversalSelector.indexOf(VOBSEP);
                    if (vobIndex > -1) {
                        String vobUID = versionUniversalSelector.substring(vobIndex + VOBSEP.length());
                        if (uuidToVOBMap.containsKey(vobUID)) {
                            vobs[vc] = (VOB)uuidToVOBMap.get(vobUID);
                        } else {
                            VOB vob = this.getVOB(vobUID);
                            uuidToVOBMap.put(vobUID, vob);
                            vobs[vc] = vob;
                        }
                    }
                    ++vc;
                }
                RegistryInformation regInfo = this.getRegistryInformation();
                String string = registryHost = regInfo != null ? regInfo.getRegistryHost() : null;
                if (label == null) {
                    label = "";
                }
                int rc = 0;
                while (rc < inSCMFileList.size()) {
                    File file = (File)inSCMFileList.get(rc);
                    int viewFileIndex = viewFilesList.indexOf(file);
                    String versionUniversalSelector = univSelectors[2 * rc];
                    String elementUniversalSelector = univSelectors[2 * rc + 1];
                    String fileLabel = label;
                    String versionPath = versionPaths[rc];
                    VOB vob = vobs[rc];
                    if (versionPath == null) {
                        versionPath = "";
                    }
                    references[viewFileIndex] = new ClearCaseReference(versionUniversalSelector, elementUniversalSelector, fileLabel, versionPath, branches[rc], vob, registryHost, file.isDirectory(), pathInContainers[viewFileIndex]);
                    ++rc;
                }
            }
        }
        return references;
    }

    private String determineRAMBranch(File viewFile) {
        String branchName = null;
        try {
            String MAKEBRANCH_PARAM;
            String ramConfig;
            int indexOfMakeBranch;
            int indexRAMConfigEnd;
            int indexRAMConfigStart;
            String configSpec = this.getViewConfigSpec(viewFile);
            if (configSpec != null && configSpec.length() > 0 && (indexRAMConfigStart = configSpec.indexOf("# RAM Rich Client configuration start")) > -1 && (indexRAMConfigEnd = configSpec.indexOf("# RAM Rich Client configuration end", indexRAMConfigStart)) > -1 && indexRAMConfigEnd > indexRAMConfigStart && (indexOfMakeBranch = (ramConfig = configSpec.substring(indexRAMConfigStart, indexRAMConfigEnd)).indexOf(MAKEBRANCH_PARAM = " -mkbranch ")) > -1) {
                int eol = ramConfig.indexOf("\n", indexOfMakeBranch);
                branchName = ramConfig.substring(indexOfMakeBranch + MAKEBRANCH_PARAM.length(), eol).trim();
            }
        }
        catch (ClearCaseException e) {
            logger.warn((Object)("Unable to determine branch name for view file:" + viewFile.getAbsolutePath()), (Throwable)e);
        }
        return branchName;
    }

    private String getViewConfigSpec(File viewFile) throws ClearCaseException {
        String configSpec = null;
        try {
            GetViewConfigSpecCommand c = new GetViewConfigSpecCommand(viewFile);
            GetViewConfigSpecCommand.ViewConfigSpecOutput out = (GetViewConfigSpecCommand.ViewConfigSpecOutput)c.run(ClearcaseManager.getCLIPath());
            configSpec = out.getViewConfigSpec();
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.get.file.info"), viewFile.getAbsolutePath()), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.get.file.info"), viewFile.getAbsolutePath()), e);
        }
        return configSpec;
    }

    private boolean createLabelInVOB(VOB vob, String label) throws ClearCaseException {
        boolean labelTypeExists;
        block10: {
            labelTypeExists = false;
            try {
                ListLabelTypesCommand c = new ListLabelTypesCommand(vob);
                AbstractListElementTypesCommand.ListTypesOutput out = (AbstractListElementTypesCommand.ListTypesOutput)c.run(ClearcaseManager.getCLIPath());
                String[] exisitingTypes = out.getTypes();
                if (exisitingTypes == null) break block10;
                int ltc = 0;
                while (ltc < exisitingTypes.length) {
                    if (label.equals(exisitingTypes[ltc])) {
                        labelTypeExists = true;
                        break;
                    }
                    ++ltc;
                }
            }
            catch (IOException e) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.existing.labels"), vob.getTag()), e);
            }
            catch (InterruptedException e) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.determine.existing.labels"), vob.getTag()), e);
            }
        }
        if (!labelTypeExists) {
            try {
                CreateLabelTypeCommand c1 = new CreateLabelTypeCommand(label, vob);
                CreateLabelTypeCommand.CreateLabelTypeOutput out1 = (CreateLabelTypeCommand.CreateLabelTypeOutput)c1.run(ClearcaseManager.getCLIPath());
                if (!out1.isCreated()) {
                    throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.create.label.type"), label));
                }
                labelTypeExists = true;
            }
            catch (IOException e) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.create.label.type"), label), e);
            }
            catch (InterruptedException e) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccManager.unable.to.create.label.type"), label), e);
            }
        }
        return labelTypeExists;
    }

    public void applyLabel(File[] viewFiles, String label, boolean isRecursive) throws ClearCaseException {
        if (viewFiles != null && viewFiles.length > 0) {
            List<File> viewFilesList = Arrays.asList(viewFiles);
            ArrayList<File> validViewFileList = new ArrayList<File>();
            ArrayList<String> filePaths = new ArrayList<String>();
            for (File file : viewFilesList) {
                if (file == null || !file.exists() || !file.canRead()) continue;
                validViewFileList.add(file);
                filePaths.add(file.getAbsolutePath());
            }
            if (validViewFileList.size() > 0) {
                String[] universalSelectors = null;
                try {
                    GetUniversalSelectorCommand getUSCommand = new GetUniversalSelectorCommand(filePaths.toArray(new String[filePaths.size()]));
                    GetUniversalSelectorCommand.ReferenceOutput out = (GetUniversalSelectorCommand.ReferenceOutput)getUSCommand.run(ClearcaseManager.getCLIPath());
                    universalSelectors = out.getUniversalSelector();
                }
                catch (IOException e) {
                    throw new ClearCaseException(CommonMessages.getString("ccManager.unable.to.determine.uuids"), e);
                }
                catch (InterruptedException e) {
                    throw new ClearCaseException(CommonMessages.getString("ccManager.unable.to.determine.uuids"), e);
                }
                if (universalSelectors != null && universalSelectors.length > 0) {
                    ArrayList<String> vobUUIDs = new ArrayList<String>();
                    ArrayList filesWithUnivSelectorList = new ArrayList();
                    int sc = 0;
                    while (sc < universalSelectors.length) {
                        if (universalSelectors[sc] != null && universalSelectors[sc].trim().length() > 0) {
                            String vobUID;
                            filesWithUnivSelectorList.add(validViewFileList.get(sc));
                            String VOBSEP = "@vobuuid:";
                            int vobIndex = universalSelectors[sc].indexOf(VOBSEP);
                            if (vobIndex > -1 && !vobUUIDs.contains(vobUID = universalSelectors[sc].substring(vobIndex + VOBSEP.length()))) {
                                vobUUIDs.add(vobUID);
                                VOB vob = this.getVOB(vobUID);
                                this.createLabelInVOB(vob, label);
                            }
                        }
                        ++sc;
                    }
                    if (!this.setLabel(filesWithUnivSelectorList.toArray(new File[filesWithUnivSelectorList.size()]), label, isRecursive)) {
                        throw new ClearCaseException(CommonMessages.getString("ccManager.unable.to.set.labels.on.cc.files"));
                    }
                }
            }
        }
    }

    public static interface IFileUpdateCallback {
        public void performUpdate(File var1);
    }
}

