/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.io.File;

public class AddLoadRuleToViewCommand
extends OutputCleartoolCommand {
    private String loadRule;
    private File viewLocation;

    public AddLoadRuleToViewCommand(String loadRule, File viewLocation) {
        this.loadRule = loadRule;
        this.viewLocation = viewLocation;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(final String output, String error) {
        return new AddLoadRuleToViewCommandOutput(){

            @Override
            public boolean loadSuccessful() {
                boolean foundDoneLoad = false;
                if (output != null && output.length() > 0) {
                    String[] lines = output.split("\r\n");
                    int i = 0;
                    while (i < lines.length) {
                        if (lines[i].startsWith("Done loading")) {
                            foundDoneLoad = true;
                        }
                        ++i;
                    }
                }
                return foundDoneLoad;
            }
        };
    }

    @Override
    protected String[] getArguments() {
        return new String[]{"update", "-add_loadrules", this.loadRule};
    }

    @Override
    protected File getFolderToRunIn() {
        return this.viewLocation;
    }

    public static interface AddLoadRuleToViewCommandOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public boolean loadSuccessful();
    }
}

