/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands.ucm;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CleartoolCommandConstants;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.ucm.Project;
import java.util.ArrayList;

public class ListProjectCommand
extends OutputCleartoolCommand {
    public static final int VIEW = 0;
    public static final int PROJECT_SELECTOR = 1;
    private int TYPE = -1;
    private static String KEY_PROJECT = CleartoolCommandConstants.LSPROJECT_PROJECT;
    private static String KEY_INTEGRATION_STREAM = CleartoolCommandConstants.LSPROJECT_INTEGRATION_STREAM;
    private static String KEY_MODIFIABLE_COMPONENTS = CleartoolCommandConstants.LSPROJECT_MODIFIABLE_COMPONENTS;
    private static String KEY_RECOMMENDED_BASELINES = CleartoolCommandConstants.LSPROJECT_RECOMMENDED_BASELINES;
    private static String KEY_POLICIES = CleartoolCommandConstants.LSPROJECT_POLICIES;
    private int lastProcessedOffset;
    private String arg = null;

    public ListProjectCommand(String arg, int cmdType) {
        this.arg = arg;
        this.TYPE = cmdType;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String output, String error) {
        final ArrayList<Project> projectsList = new ArrayList<Project>();
        if (output != null && output.length() > 0) {
            String[] projectStrings = output.split("\r\n");
            int pc = 0;
            while (pc < projectStrings.length) {
                if (projectStrings[pc].trim().length() > 0 && !Character.isWhitespace(projectStrings[pc].charAt(0))) {
                    String firstLine;
                    String projectName = firstLine = projectStrings[pc].substring(KEY_PROJECT.length());
                    projectName = this.stripQuotes(projectName);
                    String integrationStream = null;
                    String[] modifiableComponents = null;
                    String[] recommendedBaselines = null;
                    String[] policies = null;
                    ++pc;
                    while (pc < projectStrings.length && Character.isWhitespace(projectStrings[pc].charAt(0))) {
                        String line = projectStrings[pc].trim();
                        if (line.startsWith(KEY_INTEGRATION_STREAM)) {
                            integrationStream = line.substring(KEY_INTEGRATION_STREAM.length()).trim();
                        } else if (line.startsWith(KEY_RECOMMENDED_BASELINES)) {
                            recommendedBaselines = this.processBaselines(projectStrings, ++pc);
                            pc = this.lastProcessedOffset - 1;
                        } else if (line.startsWith(KEY_MODIFIABLE_COMPONENTS)) {
                            modifiableComponents = this.processComponents(projectStrings, ++pc);
                            pc = this.lastProcessedOffset - 1;
                        } else if (line.startsWith(KEY_POLICIES)) {
                            policies = this.processPolicies(projectStrings, ++pc);
                            pc = this.lastProcessedOffset - 1;
                        }
                        ++pc;
                    }
                    Project project = new Project();
                    project.setProjectName(projectName);
                    project.setIntegrationStream(integrationStream);
                    project.setModifiableComponents(modifiableComponents);
                    project.setRecommendedBaselines(recommendedBaselines);
                    project.setPolicies(policies);
                    projectsList.add(project);
                }
                ++pc;
            }
        }
        return new ListProjectOutput(){

            @Override
            public Project[] getProjects() {
                return projectsList.toArray(new Project[projectsList.size()]);
            }
        };
    }

    private String[] processComponents(String[] lines, int offset) {
        ArrayList<String> componentList = new ArrayList<String>();
        String currentToken = lines[offset].trim();
        while (offset < lines.length && !currentToken.startsWith(CleartoolCommandConstants.LSPROJECT_DEFAULT_PROMO_LEVEL)) {
            componentList.add(currentToken);
            currentToken = lines[++offset].trim();
        }
        this.lastProcessedOffset = offset;
        return componentList.toArray(new String[componentList.size()]);
    }

    private String[] processBaselines(String[] lines, int offset) {
        ArrayList<String> baselineList = new ArrayList<String>();
        String currentToken = lines[offset].trim();
        while (offset < lines.length && !currentToken.startsWith(CleartoolCommandConstants.LSPROJECT_MODEL)) {
            baselineList.add(currentToken);
            currentToken = lines[++offset].trim();
        }
        this.lastProcessedOffset = offset;
        return baselineList.toArray(new String[baselineList.size()]);
    }

    private String[] processPolicies(String[] lines, int offset) {
        ArrayList<String> policyList = new ArrayList<String>();
        String currentToken = lines[offset].trim();
        while (offset < lines.length && !currentToken.startsWith(CleartoolCommandConstants.LSPROJECT_NAMING_TEMPLATE)) {
            policyList.add(currentToken);
            currentToken = lines[++offset].trim();
        }
        this.lastProcessedOffset = offset;
        return policyList.toArray(new String[policyList.size()]);
    }

    @Override
    protected String[] getArguments() {
        if (this.TYPE == 0) {
            return new String[]{"lsproject", "-long", "-view", this.arg};
        }
        return new String[]{"lsproject", "-long", this.arg};
    }

    private String stripQuotes(String str) {
        String stripped = str.replace('\"', ' ');
        return stripped.trim();
    }

    public static interface ListProjectOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public Project[] getProjects();
    }
}

