/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands.ucm;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CleartoolCommandConstants;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;

public class RemoveStreamCommand
extends OutputCleartoolCommand {
    private String streamSelector;

    public RemoveStreamCommand(String streamSelector) {
        this.streamSelector = streamSelector;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String outputStream, String errorStream) {
        boolean removedStream = false;
        if (outputStream != null && outputStream.length() > 0) {
            String[] lines = outputStream.split("\r\n");
            int i = 0;
            while (i < lines.length) {
                if (lines[i].indexOf(CleartoolCommandConstants.REMOVED) != -1) {
                    removedStream = true;
                }
                ++i;
            }
        }
        final boolean finalState = removedStream;
        return new RemoveStreamCommandOuptut(){

            @Override
            public boolean streamRemoved() {
                return finalState;
            }
        };
    }

    @Override
    protected String[] getArguments() {
        return new String[]{"rmstream", "-nc", "-f", this.streamSelector};
    }

    public static interface RemoveStreamCommandOuptut
    extends AbstractCleartoolCommand.ICommandOutput {
        public boolean streamRemoved();
    }
}

