/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.io.util;

import java.io.IOException;
import java.io.InputStream;

public class SynchronizedInputStream
extends InputStream {
    protected final Object lock;
    protected InputStream in;

    public SynchronizedInputStream(InputStream in) {
        this(in, null);
    }

    public SynchronizedInputStream(InputStream in, Object lock) {
        this.in = in;
        this.lock = lock != null ? lock : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.in.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.read(b, 0, b.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.in.read(b, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.in.skip(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.in.available();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.doClose();
        }
    }

    protected void doClose() throws IOException {
        this.in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readlimit) {
        Object object = this.lock;
        synchronized (object) {
            this.in.mark(readlimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.in.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markSupported() {
        Object object = this.lock;
        synchronized (object) {
            return this.in.markSupported();
        }
    }
}

