/*
 * Decompiled with CFR 0.152.
 */
package org.oslc.asset.internal.query.ast;

import java.util.ArrayList;
import java.util.List;
import org.oslc.asset.internal.query.ast.Node;
import org.oslc.asset.internal.query.ast.OperatorKind;
import org.oslc.asset.internal.query.ast.Optional;
import org.oslc.asset.internal.query.ast.Term;
import org.oslc.asset.internal.query.ast.Union;

public class Query
extends ArrayList<Node> {
    private static final long serialVersionUID = 8567507489838703748L;
    public static final String SORT_ORDER_UNSPECIFIED = null;
    public static final int LIMIT_UNLIMITED = 0;
    private String sortProperty = SORT_ORDER_UNSPECIFIED;
    private SortOrder sortOrder = SortOrder.ASC;
    private int limit = 0;
    private int offset = 0;

    public String getSortProperty() {
        return this.sortProperty;
    }

    public void setSortProperty(String sortProperty) {
        this.sortProperty = sortProperty;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    private List<String> distinctNames(Node node) {
        ArrayList<String> names = new ArrayList<String>();
        if (node instanceof Term) {
            names.add(((Term)node).getPropertyName());
        } else if (node instanceof Optional) {
            Optional list = (Optional)node;
            for (Term term : list) {
                names.add(term.getPropertyName());
            }
        }
        return names;
    }

    public List<String> getDistinctPropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Node node : this) {
            names.addAll(this.distinctNames(node));
        }
        return names;
    }

    public boolean hasUnion() {
        for (Node node : this) {
            if (!(node instanceof Union)) continue;
            return true;
        }
        return false;
    }

    public void optimize() {
        ArrayList<Object> results = null;
        if (this.hasUnion()) {
            results = new ArrayList(this.size());
            int from = 0;
            int i = 0;
            while (i < this.size()) {
                if (this.get(i) instanceof Union) {
                    ArrayList<Node> slice = this.optimizeSlice(from, i);
                    results.addAll(slice);
                    results.add((Node)this.get(i));
                    from = i + 1;
                }
                ++i;
            }
            ArrayList<Node> slice = this.optimizeSlice(from, this.size());
            results.addAll(slice);
        } else {
            results = this.optimizeSlice(0, this.size());
        }
        this.clear();
        this.addAll(results);
    }

    /*
     * Unable to fully structure code
     */
    public ArrayList<Node> optimizeSlice(int from, int to) {
        results = new ArrayList<Node>(to - from);
        first = 0;
        i = from;
        while (i < to) {
            block3: {
                node = (Node)this.get(i);
                if (!(node instanceof Optional)) break block3;
                ((Optional)node).optimize();
                ** GOTO lbl-1000
            }
            if (node instanceof Term && ((Term)node).getOperatorKind() == OperatorKind.Equal && !((Term)node).getValue().endsWith("*\"")) {
                results.add(first++, node);
            } else lbl-1000:
            // 2 sources

            {
                results.add(node);
            }
            ++i;
        }
        return results;
    }

    @Override
    public String toString() {
        String list = super.toString();
        return String.format("%s /sort=%s /limit=%d /hasUnion=%s", list, this.sortProperty, this.limit, this.hasUnion());
    }

    public static enum SortOrder {
        ASC,
        DESC;

    }
}

