/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.cli.command;

import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAssetType;
import com.ibm.ram.client.RAMCategorySchema;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.client.RCAssetNotFoundException;
import com.ibm.ram.client.status.RAMStatus;
import com.ibm.ram.common.data.Asset;
import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.common.data.AssetType;
import com.ibm.ram.common.data.Category;
import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.data.Relationship;
import com.ibm.ram.common.data.RelationshipType;
import com.ibm.ram.internal.cli.bundles.Messages;
import com.ibm.ram.internal.cli.command.Command;
import com.ibm.ram.internal.cli.command.SearchCommand;
import com.ibm.ram.internal.cli.commandline.CommandLine;
import com.ibm.ram.internal.cli.commandline.Option;
import com.ibm.ram.internal.cli.commandline.ParseException;
import com.ibm.ram.internal.cli.configuration.BuildEnvironment;
import com.ibm.ram.internal.cli.rampackage.Dependency;
import com.ibm.ram.internal.cli.rampackage.DescriptorParser;
import com.ibm.ram.internal.cli.rampackage.Package;
import com.ibm.ram.internal.cli.rampackage.PackageListDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class GetCommand
extends Command {
    public static final String NAME = "get";
    public static final String OPTION_NOT_RECURSIVE = "-n";
    public static final String OPTION_DIRECTORY = "-d";
    public static final String OPTION_SNAPSHOT = "-s";
    public static final String OPTION_ID = "-id";
    public static final String OPTION_LIST = "-l";
    private static final String ASSET_MANIFEST = "manifest.rmd";
    private static final String ASSET_INTERNAL_DIR = ".com.ibm.ram.data";
    private static final String ENVIRONMENT_TYPE = "Environment";
    private static final String COMPONENT_TYPE = "Component";
    private static final String PACKAGE_SCHEMA = "Continuous Delivery";
    private static final String PACKAGE_CATEGORY = "Package Type";
    protected File fLocation;
    protected boolean recursive = true;
    private String snapshotId = null;
    private String snapshotVersion = null;
    protected Map<String, RAMAsset> assets = new HashMap<String, RAMAsset>();
    private String listDescriptorName;
    protected static List<String> dependentTypes;

    static {
        ArrayList<String> ln = new ArrayList<String>();
        ln.add("dependency");
        dependentTypes = Collections.unmodifiableList(ln);
    }

    public GetCommand(String[] args) {
        super(args);
    }

    @Override
    public IStatus execute() {
        MultiStatus mStatus;
        block31: {
            RAMAsset asset;
            String message;
            mStatus = new MultiStatus(this.getClass().getName(), 0, "", null);
            List<Object> packageList = null;
            if (this.packageId != null) {
                packageList = new ArrayList<Dependency>();
                packageList.add(new Dependency(this.packageId, this.packageVersion, this.queryString));
            } else {
                PackageListDescriptor listDescriptor = new PackageListDescriptor(this.listDescriptorName);
                IStatus status = listDescriptor.read();
                if (status.isOK()) {
                    packageList = listDescriptor.getPackages();
                } else {
                    return status;
                }
            }
            Status status = this.getRAMSession();
            if (!status.isOK()) {
                return status;
            }
            boolean snapshotExists = false;
            RAMAsset snapshotAsset = null;
            if (this.snapshotId != null) {
                RAMAssetType environmentType = this.ramSession.getAssetType(ENVIRONMENT_TYPE);
                if (environmentType != null) {
                    try {
                        AssetIdentification assetIdentification = new AssetIdentification(this.snapshotId, this.snapshotVersion);
                        snapshotAsset = this.ramSession.getAsset(assetIdentification);
                        snapshotExists = true;
                    }
                    catch (Exception exception) {}
                    if (snapshotAsset == null) {
                        snapshotAsset = this.ramSession.createAsset(this.snapshotId, this.snapshotVersion);
                        snapshotAsset.setAssetType((AssetType)environmentType);
                        snapshotAsset.setName(this.snapshotId);
                        snapshotAsset.setCommunity((CommunityInformation)Package.getCommunity(this.ramSession, this.config.getCommunity(), ""));
                        snapshotAsset.setShortDescription(this.snapshotId);
                    }
                } else {
                    String string = MessageFormat.format(Messages.getString("GetCommand.11"), ENVIRONMENT_TYPE);
                    mStatus.add((IStatus)new Status(4, this.getClass().getName(), string));
                }
            }
            ArrayList<AssetIdentification> assetIdList = null;
            if (mStatus.isOK() && packageList.size() > 0) {
                assetIdList = new ArrayList<AssetIdentification>();
                for (Dependency dependency : packageList) {
                    AssetIdentification assetId = SearchCommand.getAssetIdentification(this.ramSession, dependency.getId(), dependency.getVersion(), dependency.getQueryString());
                    if (assetId != null) {
                        assetIdList.add(assetId);
                        continue;
                    }
                    String searchVersion = dependency.getVersion();
                    message = searchVersion != null && !searchVersion.isEmpty() ? MessageFormat.format(Messages.getString("GetCommand.3"), dependency.getId(), searchVersion) : MessageFormat.format(Messages.getString("GetCommand.9"), dependency.getId());
                    mStatus.add((IStatus)new Status(4, this.getClass().getName(), message));
                    break;
                }
            }
            if (mStatus.isOK() && assetIdList != null && assetIdList.size() > 0) {
                for (AssetIdentification assetIdentification : assetIdList) {
                    try {
                        String assetTypeName;
                        asset = this.ramSession.getAsset(assetIdentification);
                        if (snapshotAsset != null) {
                            snapshotAsset.addRelatedAsset((Asset)asset, (RelationshipType)this.ramSession.getRelationshipType("Depends on"));
                        }
                        if (this.recursive) {
                            this.visit(asset);
                            continue;
                        }
                        if (!this.assets.containsKey(assetIdentification.getGUID())) {
                            this.assets.put(assetIdentification.getGUID(), asset);
                        }
                        if ((assetTypeName = asset.getTypeName()).equalsIgnoreCase(COMPONENT_TYPE)) {
                            this.addComponentPackages(this.ramSession, asset);
                            continue;
                        }
                        if (!assetTypeName.equalsIgnoreCase(ENVIRONMENT_TYPE)) continue;
                        this.addEnvironmentPackages(this.ramSession, asset);
                    }
                    catch (RCAssetNotFoundException nfe) {
                        mStatus.add((IStatus)new Status(4, this.getClass().getName(), nfe.getLocalizedMessage()));
                        break;
                    }
                    catch (Exception e) {
                        message = MessageFormat.format(Messages.getString("GetCommand.4"), assetIdentification.getGUID(), assetIdentification.getVersion());
                        mStatus.add((IStatus)new Status(4, this.getClass().getName(), message));
                        message = e.getLocalizedMessage();
                        if (message == null) break;
                        mStatus.add((IStatus)new Status(4, this.getClass().getName(), message));
                        break;
                    }
                }
            }
            if (mStatus.isOK() && this.assets.size() > 0) {
                String string = this.fLocation.getAbsolutePath();
                Iterator<Map.Entry<String, RAMAsset>> assetIterator = this.assets.entrySet().iterator();
                while (mStatus.isOK() && assetIterator.hasNext()) {
                    asset = assetIterator.next().getValue();
                    mStatus.add(this.getArtifacts(asset, string));
                }
            }
            if (mStatus.isOK() && snapshotAsset != null) {
                try {
                    RAMStatus rAMStatus = this.ramSession.put((IRAMSessionObject)snapshotAsset, (IProgressMonitor)new NullProgressMonitor());
                    if (rAMStatus.isOK() || rAMStatus.matches(1)) {
                        String messageId = "GetCommand.12";
                        if (snapshotExists) {
                            messageId = "GetCommand.13";
                        }
                        String message3 = MessageFormat.format(Messages.getString(messageId), snapshotAsset.getName(), snapshotAsset.getIdentification().getVersion());
                        mStatus.add((IStatus)new Status(0, this.getClass().getName(), message3));
                    } else {
                        mStatus.add((IStatus)rAMStatus);
                    }
                }
                catch (Exception exception) {
                    if (exception.getLocalizedMessage() == null) break block31;
                    mStatus.add((IStatus)new Status(4, this.getClass().getName(), exception.getLocalizedMessage()));
                }
            }
        }
        this.ramSession.release();
        return mStatus;
    }

    private void visit(RAMAsset anAsset) {
        AssetIdentification assetId = anAsset.getIdentification();
        String assetKey = assetId.getGUID();
        if (this.assets.containsKey(assetKey)) {
            return;
        }
        this.assets.put(assetKey, anAsset);
        Relationship[] relationships = anAsset.getRelationships();
        int i = 0;
        while (i < relationships.length) {
            AssetIdentification childAssetId;
            String childKey;
            String relationshipType = relationships[i].getRelationshipTypeName();
            if (dependentTypes.contains(relationshipType) && !this.assets.containsKey(childKey = (childAssetId = new AssetIdentification(relationships[i].getChildAssetGUID(), relationships[i].getChildAssetVersion())).getGUID())) {
                RAMAsset asset = this.ramSession.getAsset(childAssetId);
                this.visit(asset);
            }
            ++i;
        }
    }

    private void addComponentPackages(RAMSession session, RAMAsset anAsset) {
        Relationship[] relationships;
        Category category = null;
        RAMCategorySchema schema = session.getCategorySchema(PACKAGE_SCHEMA);
        if (schema != null) {
            category = schema.getCategory(PACKAGE_CATEGORY);
        }
        if (category == null) {
            return;
        }
        Relationship[] relationshipArray = relationships = anAsset.getRelationships();
        int n = relationships.length;
        int n2 = 0;
        while (n2 < n) {
            Relationship relationship = relationshipArray[n2];
            String relationshipType = relationship.getRelationshipTypeName();
            if (dependentTypes.contains(relationshipType)) {
                AssetIdentification childAssetId = new AssetIdentification(relationship.getChildAssetGUID(), relationship.getChildAssetVersion());
                try {
                    String childKey;
                    RAMAsset relatedAsset = session.getAsset(childAssetId);
                    String[] packageTypes = relatedAsset.getCategorizations(category);
                    if (packageTypes != null && packageTypes.length > 0 && !this.assets.containsKey(childKey = childAssetId.getGUID())) {
                        this.assets.put(childKey, relatedAsset);
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }

    private void addEnvironmentPackages(RAMSession session, RAMAsset anAsset) {
        Relationship[] relationships;
        Category category = null;
        RAMCategorySchema schema = session.getCategorySchema(PACKAGE_SCHEMA);
        if (schema != null) {
            category = schema.getCategory(PACKAGE_CATEGORY);
        }
        Relationship[] relationshipArray = relationships = anAsset.getRelationships();
        int n = relationships.length;
        int n2 = 0;
        while (n2 < n) {
            Relationship relationship = relationshipArray[n2];
            String relationshipType = relationship.getRelationshipTypeName();
            if (dependentTypes.contains(relationshipType)) {
                AssetIdentification childAssetId = new AssetIdentification(relationship.getChildAssetGUID(), relationship.getChildAssetVersion());
                try {
                    String childKey;
                    String[] packageTypes;
                    RAMAsset relatedAsset = session.getAsset(childAssetId);
                    if (category != null && (packageTypes = relatedAsset.getCategorizations(category)) != null && packageTypes.length > 0 && !this.assets.containsKey(childKey = childAssetId.getGUID())) {
                        this.assets.put(childKey, relatedAsset);
                    }
                    if (relatedAsset.getTypeName().equalsIgnoreCase(COMPONENT_TYPE)) {
                        if (!this.assets.containsKey(childAssetId.getGUID())) {
                            this.assets.put(childAssetId.getGUID(), relatedAsset);
                        }
                        this.addComponentPackages(session, relatedAsset);
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }

    @Override
    public IStatus validate() {
        String id;
        CommandLine commandLine = new CommandLine(this.cmdArgs);
        commandLine.addOption(new Option(OPTION_DIRECTORY, true));
        commandLine.addOption(new Option("-config", true));
        commandLine.addOption(new Option("-q", true));
        commandLine.addOption(new Option(OPTION_NOT_RECURSIVE));
        commandLine.addOption(new Option(OPTION_SNAPSHOT, true));
        commandLine.addOption(new Option(OPTION_ID, true));
        commandLine.addOption(new Option(OPTION_LIST, true));
        try {
            commandLine.parse();
        }
        catch (ParseException pe) {
            return new Status(4, this.getClass().getName(), pe.getMessage());
        }
        List<String> values = commandLine.getValues();
        if (values.size() > 2) {
            String message = MessageFormat.format(Messages.getString("CommandLine.5"), values.get(2));
            return new Status(4, this.getClass().getName(), message);
        }
        this.packageId = null;
        if (!values.isEmpty()) {
            this.packageId = values.get(0).trim();
        }
        this.packageVersion = null;
        if (values.size() > 1) {
            this.packageVersion = values.get(1).trim();
        }
        if ((id = commandLine.getOption(OPTION_ID).getValue()) != null && !id.isEmpty()) {
            BuildEnvironment.getInstance().setSnapshotID(id);
        }
        this.listDescriptorName = commandLine.getOption(OPTION_LIST).getValue();
        if (this.packageId == null && this.listDescriptorName == null) {
            return new Status(4, this.getClass().getName(), Messages.getString("GetCommand.7"));
        }
        if (this.packageId != null && this.listDescriptorName != null) {
            return new Status(4, this.getClass().getName(), Messages.getString("GetCommand.8"));
        }
        this.recursive = !commandLine.getOption(OPTION_NOT_RECURSIVE).isSet();
        this.queryString = commandLine.getOption("-q").getValue();
        Status status = null;
        String snapshotValue = commandLine.getOption(OPTION_SNAPSHOT).getValue();
        if (snapshotValue != null) {
            int separator = snapshotValue.indexOf(":");
            if (separator == -1) {
                String message = MessageFormat.format(Messages.getString("PublishCommand.7"), OPTION_SNAPSHOT);
                status = new Status(4, this.getClass().getName(), message);
            } else {
                this.snapshotId = snapshotValue.substring(0, separator).trim();
                this.snapshotVersion = snapshotValue.substring(separator + 1).trim();
                if (this.snapshotId.isEmpty() || this.snapshotVersion.isEmpty()) {
                    String message = MessageFormat.format(Messages.getString("PublishCommand.7"), OPTION_SNAPSHOT);
                    status = new Status(4, this.getClass().getName(), message);
                }
                this.snapshotVersion = DescriptorParser.resolveVersion(this.snapshotVersion);
            }
        }
        if (status != null && !status.isOK()) {
            return status;
        }
        this.createConfiguration(commandLine.getOption("-config").getValue());
        status = this.config.validate();
        if (!status.isOK()) {
            return status;
        }
        if (this.snapshotId != null && this.config.getCommunity() == null) {
            return new Status(4, this.getClass().getName(), Messages.getString("GetCommand.10"));
        }
        String location = commandLine.getOption(OPTION_DIRECTORY).getValue();
        this.fLocation = location != null ? new File(location) : new File(".");
        return this.validateLocation(this.fLocation);
    }

    private IStatus validateLocation(File aLocation) {
        Status status = null;
        if (aLocation.exists()) {
            if (!aLocation.isDirectory() || !aLocation.canWrite()) {
                String message = MessageFormat.format(Messages.getString("GetCommand.2"), aLocation.getAbsolutePath());
                status = new Status(4, this.getClass().getName(), message);
            }
        } else {
            boolean locationCreated = aLocation.mkdirs();
            if (!(locationCreated && aLocation.exists() && aLocation.isDirectory() && aLocation.canWrite())) {
                String message = MessageFormat.format(Messages.getString("GetCommand.2"), aLocation.getAbsolutePath());
                status = new Status(4, this.getClass().getName(), message);
            }
        }
        if (status == null) {
            status = new Status(0, this.getClass().getName(), null);
        }
        return status;
    }

    protected IStatus getArtifacts(RAMAsset asset, String baseLocation) {
        String target = baseLocation;
        File fTarget = new File(target);
        IStatus status = this.validateLocation(fTarget);
        if (status.isOK()) {
            try {
                ZipInputStream zis = new ZipInputStream(asset.getContents());
                ZipEntry ze = zis.getNextEntry();
                while (status.isOK() && ze != null) {
                    String fileName = ze.getName();
                    if (!fileName.equals(ASSET_MANIFEST) && !fileName.startsWith(ASSET_INTERNAL_DIR)) {
                        File newFile = new File(String.valueOf(target) + File.separator + fileName);
                        new File(newFile.getParent()).mkdirs();
                        if (!ze.isDirectory()) {
                            int len;
                            FileOutputStream fos = new FileOutputStream(newFile);
                            byte[] buffer = new byte[1024];
                            while ((len = zis.read(buffer)) > 0) {
                                fos.write(buffer, 0, len);
                            }
                            fos.close();
                        }
                    }
                    zis.closeEntry();
                    ze = zis.getNextEntry();
                }
                zis.close();
            }
            catch (IOException ex) {
                status = new MultiStatus(this.getClass().getName(), 4, null, (Throwable)ex);
                ((MultiStatus)status).add((IStatus)new Status(4, this.getClass().getName(), ex.getLocalizedMessage()));
                String message = MessageFormat.format(Messages.getString("GetCommand.5"), asset.getName());
                ((MultiStatus)status).add((IStatus)new Status(4, this.getClass().getName(), message));
            }
        }
        if (status.isOK()) {
            String message = MessageFormat.format(Messages.getString("GetCommand.6"), asset.getName(), asset.getIdentification().getVersion(), target);
            status = new Status(0, this.getClass().getName(), message);
        }
        return status;
    }

    public Map getDownloadedAssets() {
        return this.assets;
    }

    public String toString() {
        return "package id=" + this.packageId + "\npackage version=" + this.packageVersion + "\nrecursive=" + this.recursive;
    }
}

