/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.cli.configuration;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;

public class BuildEnvironment {
    public static final String BUILD_ID = "BUILD_ID";
    public static final String SNAPSHOT_ID = "SNAPSHOT";
    public static final String RTC_BUILD_ID = "buildLabel";
    public static final String BUILD_RESULT_UUID = "buildResultUUID";
    public static final String BUILD_URL = "BUILD_URL";
    public static final String PERSONAL_BUILD = "personalBuild";
    public static final String BUILD_REQUESTER_USERID = "buildRequesterUserId";
    public static final String BUILD_TYPE = "BuildType";
    public static final String BUILD_TYPE_PERSONAL = "Personal";
    public static final String BUILD_TYPE_INTEGRATION = "Integration";
    private HashMap<String, String[]> assetAttributes = null;
    private Properties buildProperties;
    private static BuildEnvironment instance = null;

    protected BuildEnvironment() {
        String personalBuild;
        boolean fromBuild = true;
        this.buildProperties = new Properties();
        String value = this.get(BUILD_ID);
        if (value == null) {
            value = this.get(RTC_BUILD_ID);
        }
        if (value == null) {
            fromBuild = false;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
            Date date = new Date();
            value = dateFormat.format(date);
        }
        this.buildProperties.setProperty(SNAPSHOT_ID, value);
        value = this.get(BUILD_RESULT_UUID);
        if (value != null) {
            this.buildProperties.setProperty(BUILD_RESULT_UUID, value);
        }
        if ((value = this.get(BUILD_URL)) != null) {
            this.buildProperties.setProperty(BUILD_URL, value);
        }
        if ((value = this.get(BUILD_REQUESTER_USERID)) != null) {
            this.buildProperties.setProperty(BUILD_REQUESTER_USERID, value);
        }
        if ((personalBuild = this.get(PERSONAL_BUILD)) != null) {
            this.buildProperties.setProperty(PERSONAL_BUILD, personalBuild);
        }
        if (fromBuild) {
            this.buildProperties.setProperty(BUILD_TYPE, personalBuild != null ? BUILD_TYPE_PERSONAL : BUILD_TYPE_INTEGRATION);
        }
    }

    public static BuildEnvironment getInstance() {
        if (instance == null) {
            instance = new BuildEnvironment();
        }
        return instance;
    }

    public String get(String name) {
        return System.getenv(name);
    }

    public String getBuildUrl() {
        return this.buildProperties.getProperty(BUILD_URL);
    }

    public String getBuildId() {
        return this.buildProperties.getProperty(BUILD_ID);
    }

    public String getSnapshotID() {
        return this.buildProperties.getProperty(SNAPSHOT_ID);
    }

    public void setSnapshotID(String id) {
        this.buildProperties.setProperty(SNAPSHOT_ID, id);
    }

    public String getBuildResultId() {
        return this.buildProperties.getProperty(BUILD_RESULT_UUID);
    }

    public String getBuildRequester() {
        return this.buildProperties.getProperty(BUILD_REQUESTER_USERID);
    }

    public boolean isPersonalBuild() {
        return this.buildProperties.getProperty(PERSONAL_BUILD) != null;
    }

    public String getBuildType() {
        return this.buildProperties.getProperty(BUILD_TYPE);
    }

    public HashMap<String, String[]> getAssetAttributes() {
        if (this.assetAttributes == null) {
            this.assetAttributes = new HashMap();
            if (this.getBuildId() != null) {
                this.assetAttributes.put("Build Label", new String[]{this.getBuildId()});
            }
            if (this.getBuildResultId() != null) {
                this.assetAttributes.put("Build ID", new String[]{this.getBuildResultId()});
            }
            if (this.getBuildType() != null) {
                this.assetAttributes.put("Build Type", new String[]{this.getBuildType()});
            }
            if (this.getBuildUrl() != null) {
                this.assetAttributes.put("Build URL", new String[]{"<a href=" + this.getBuildUrl() + " target='_blank'>Build Project URL</a>"});
            }
            if (this.getBuildRequester() != null) {
                this.assetAttributes.put("Build Requested By", new String[]{this.getBuildRequester()});
            }
        }
        return this.assetAttributes;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Build Environment\n");
        sbuf.append("build id:         " + this.getBuildId() + "\n");
        sbuf.append("build result id:  " + this.getBuildResultId() + "\n");
        sbuf.append("build url:        " + this.getBuildUrl() + "\n");
        sbuf.append("build requester:  " + this.getBuildRequester() + "\n");
        sbuf.append("build type:       " + this.getBuildType() + "\n");
        return sbuf.toString();
    }

    public static void main(String[] args) {
        BuildEnvironment env = BuildEnvironment.getInstance();
        System.out.println(env.toString());
    }
}

