/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.tasks;

import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.RAMArtifact;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMFolderArtifact;
import com.ibm.ram.client.RAMURLArtifact;
import com.ibm.ram.common.data.Artifact;
import com.ibm.ram.common.data.AssetActivity;
import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.internal.activities.AssetBuildActivity;
import com.ibm.ram.internal.client.IRAMArtifact;
import com.ibm.ram.internal.client.ant.ArtifactEntry;
import com.ibm.ram.internal.client.ant.DownloadUtil;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.tasks.RAMTask;
import com.ibm.ram.internal.client.ant.types.Asset;
import com.ibm.ram.internal.client.ant.types.AssetList;
import com.ibm.ram.internal.client.ant.types.BuildInfo;
import com.ibm.ram.internal.client.ant.types.Search;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class DownloadTask
extends RAMTask {
    public static final String DOWNLOAD_LIST_ASSET_SEPARATOR = ";";
    public static final String DOWNLOAD_LIST_GUIDVER_SEPARATOR = "/";
    private List assets = new ArrayList();
    private List assetLists = new ArrayList();
    private List artifacts = new ArrayList();
    private List searches = new ArrayList();
    private Map<String, HashSet<String>> downloadList = null;
    private BuildInfo buildInfo;
    private File destdir;
    private File eclipseproject;
    private boolean overwrite = false;
    private boolean extract = false;
    private boolean preservePath = false;
    private String relativePath = "";
    private String downloadlist;
    boolean downloadedSomething = false;

    public void add(Search search) {
        if (this.getSession() != null) {
            search.setSession(this.getSession());
        }
        search.setTask(this);
        this.searches.add(search);
    }

    public void add(Asset asset) {
        if (this.getSession() != null) {
            asset.setSession(this.getSession());
        }
        asset.setTask(this);
        this.assets.add(asset);
    }

    public void add(com.ibm.ram.internal.client.ant.types.Artifact artifact) {
        if (this.getSession() != null) {
            artifact.setSession(this.getSession());
        }
        artifact.setTask(this);
        this.artifacts.add(artifact);
    }

    public void add(AssetList assetList) {
        if (this.getSession() != null) {
            assetList.setSession(this.getSession());
        }
        assetList.setTask(this);
        this.assetLists.add(assetList);
    }

    public void add(BuildInfo buildInfo) {
        if (this.buildInfo != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)buildInfo);
        } else {
            buildInfo.setTask(this);
            this.buildInfo = buildInfo;
        }
    }

    protected void close(ZipFile zip) {
        if (zip != null) {
            try {
                zip.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void extractZip(File file) {
        ZipFile zip = null;
        try {
            zip = new ZipFile(file);
            Enumeration entries = zip.getEntries();
            byte[] buffer = new byte[4096];
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)entries.nextElement();
                InputStream in = zip.getInputStream(entry);
                File f = FileUtils.getFileUtils().resolveFile(this.getDestdir(), entry.getName());
                if (!this.isOverwrite() && f.exists()) {
                    LoggingUtil.warn((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ArtifactExists"), entry.getName(), f.getAbsolutePath()));
                    return;
                }
                try {
                    try {
                        LoggingUtil.verbose((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.Extracting"), entry.getName(), f.getAbsolutePath()));
                        File dir = f.getParentFile();
                        if (dir != null) {
                            dir.mkdirs();
                        }
                        if (entry.isDirectory()) {
                            f.mkdirs();
                        } else {
                            UtilitiesCommon.copyStreams((InputStream)in, (OutputStream)new FileOutputStream(f), (byte[])buffer, (boolean)true, (boolean)true);
                        }
                        FileUtils.getFileUtils().setFileLastModified(f, entry.getTime());
                    }
                    catch (FileNotFoundException e) {
                        LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.Error.Extracting"), f.getAbsolutePath()), (Throwable)e);
                    }
                    continue;
                }
                catch (IOException e) {
                    LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.Error.Extracting"), file.getAbsolutePath()), (Throwable)e);
                }
                break;
            }
        }
        finally {
            this.close(zip);
        }
    }

    protected void downloadAsset(RAMAsset asset) {
        if (asset == null) {
            return;
        }
        File file = null;
        String filename = String.valueOf(asset.getName()) + " [" + asset.getIdentification().getVersion() + "]";
        if (this.isExtract()) {
            try {
                file = File.createTempFile(filename, null);
            }
            catch (IOException e) {
                LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.Error.CreatingTempFile"), filename), (Throwable)e);
            }
        } else {
            file = new File(this.getDestdir(), String.valueOf(filename) + ".ras");
            file.getParentFile().mkdirs();
        }
        LoggingUtil.verbose((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.DownloadingAsset"), String.valueOf(asset.getName()) + " [" + asset.getIdentification().getVersion() + "]", file.getAbsolutePath()));
        if (!this.isExtract() && file.exists() && !this.isOverwrite()) {
            LoggingUtil.warn((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.AssetExists"), String.valueOf(asset.getName()) + " [" + asset.getIdentification().getVersion() + "]", file.getAbsolutePath()));
            return;
        }
        try {
            UtilitiesCommon.copyStreams((InputStream)asset.getContents(), (OutputStream)new FileOutputStream(file), null, (boolean)true, (boolean)true);
            this.downloadedSomething = true;
            if (this.buildInfo != null) {
                AssetBuildActivity buildActivity = this.buildInfo.getActivity();
                buildActivity.setAssetGUID(asset.getIdentification().getGUID());
                buildActivity.setAssetName(asset.getName());
                buildActivity.setAssetVersion(asset.getIdentification().getVersion());
                asset.recordActivity((AssetActivity)buildActivity);
                this.getSession().put((IRAMSessionObject)asset, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (RAMRuntimeException e) {
            LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.Error.DownloadingAsset"), String.valueOf(asset.getName()) + " [" + asset.getIdentification().getVersion() + "]"), (Throwable)e);
        }
        catch (IOException e) {
            LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.Error.DownloadingAsset"), String.valueOf(asset.getName()) + " [" + asset.getIdentification().getVersion() + "]"), (Throwable)e);
        }
        LoggingUtil.verbose((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.DownloadSuccessful"), String.valueOf(asset.getName()) + " [" + asset.getIdentification().getVersion() + "]"));
        if (this.isExtract()) {
            LoggingUtil.verbose((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ExtractingAsset"), String.valueOf(asset.getName()) + " [" + asset.getIdentification().getVersion() + "]", this.getDestdir().getAbsolutePath()));
            this.extractZip(file);
            file.delete();
        }
        this.appendDownloadList(asset.getIdentification().getGUID(), asset.getIdentification().getVersion(), null);
    }

    protected void downloadFromControlFile() {
        if (this.eclipseproject != null) {
            if (!this.eclipseproject.exists()) {
                LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.FileDoesNotExist"), this.eclipseproject));
                return;
            }
            if (!this.eclipseproject.isDirectory()) {
                LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.FileIsNotADirectory"), this.eclipseproject));
                return;
            }
            File controlFile = new File(this.eclipseproject, ".settings/rambuildercontrol.xml");
            if (!controlFile.exists()) {
                LoggingUtil.warn((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ControlFileDoesNotExist"), this.eclipseproject));
                return;
            }
            List<ArtifactEntry> entries = DownloadUtil.getArtifactsFromControlFile(controlFile);
            for (ArtifactEntry entry : entries) {
                if (!this.isSameRepository(entry.getRepositoryId(), entry.getHost())) {
                    LoggingUtil.warn((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.WrongRepository"), entry.getKey(), entry.getHost(), this.getSession().getIdentification().getServerURL()));
                    continue;
                }
                RAMAsset asset = null;
                try {
                    asset = this.getSession().getAsset(new AssetIdentification(entry.getGuid(), entry.getVersion()));
                }
                catch (RAMRuntimeException e) {
                    e.printStackTrace();
                }
                if (asset == null) {
                    LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.DownloadTask.AssetDoesNotExist"), entry.getGuid(), entry.getVersion()));
                    continue;
                }
                File tempDestdir = this.destdir;
                if (entry.getDestination() != null) {
                    this.setDestdir(new File(this.eclipseproject, entry.getDestination()));
                } else {
                    this.setDestdir(this.eclipseproject);
                }
                boolean tempPreservePath = this.isPreservePath();
                this.setPreservePath(entry.isPreservePath());
                if (!entry.getArtifactPaths().isEmpty()) {
                    RAMFolderArtifact root = (RAMFolderArtifact)asset.getArtifactsRoot();
                    List<String> paths = entry.getArtifactPaths();
                    for (String path : paths) {
                        Artifact artifact = root.getChild(path);
                        if (artifact == null) {
                            LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.Error.DownloadingArtifact"), path));
                            continue;
                        }
                        this.downloadArtifact(artifact);
                        this.appendDownloadList(asset.getIdentification().getGUID(), asset.getIdentification().getVersion(), String.valueOf(artifact.getPath()) + '/' + artifact.getName());
                        this.setRelativePath("");
                        this.createBuildActivity(artifact);
                    }
                }
                this.setDestdir(tempDestdir);
                this.setPreservePath(tempPreservePath);
            }
        }
    }

    protected boolean isSameRepository(String repositoryID, String hostName) {
        String thisID = this.getSession().getIdentification().getId();
        if (repositoryID != null && thisID != null && thisID.equals(repositoryID)) {
            return true;
        }
        String thisHost = this.getSession().getIdentification().getServerURL();
        try {
            URL url = new URL(thisHost);
            thisHost = url.getHost();
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        boolean same = thisHost.equals(hostName);
        if (same) {
            return true;
        }
        thisHost = thisHost.split("\\.")[0];
        hostName = hostName.split("\\.")[0];
        return thisHost.equals(hostName);
    }

    protected void downloadAssets() {
        int i;
        RAMAsset[] assetArray;
        for (Asset asset : this.assets) {
            RAMAsset ramAsset = asset.getAsset();
            if (ramAsset == null) {
                LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.DownloadTask.AssetDoesNotExist"), asset.getGuid(), asset.getVersion()));
                return;
            }
            this.downloadAsset(ramAsset);
        }
        for (AssetList list : this.assetLists) {
            assetArray = list.getAssets();
            i = 0;
            while (i < assetArray.length) {
                this.downloadAsset(assetArray[i]);
                ++i;
            }
        }
        for (Search search : this.searches) {
            assetArray = search.getAssets();
            i = 0;
            while (i < assetArray.length) {
                this.downloadAsset(assetArray[i]);
                ++i;
            }
        }
    }

    protected void downloadArtifacts() {
        for (com.ibm.ram.internal.client.ant.types.Artifact artifact : this.artifacts) {
            Artifact model = (Artifact)artifact.getModel();
            this.downloadArtifact(model);
            this.appendDownloadList(artifact.getAsset().getIdentification().getGUID(), artifact.getAsset().getIdentification().getVersion(), String.valueOf(artifact.getPath()) + artifact.getName());
            this.setRelativePath("");
            this.createBuildActivity(model);
        }
    }

    protected String getRelativePath() {
        if (this.relativePath == null) {
            this.relativePath = "";
        }
        return this.relativePath;
    }

    protected void setRelativePath(String path) {
        this.relativePath = path;
    }

    protected void downloadArtifact(Artifact artifact) {
        try {
            String path;
            if (artifact == null || artifact.getName() == null) {
                LoggingUtil.warn((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.Error.DownloadingArtifact"), "NULL"));
                return;
            }
            String filename = artifact.getName();
            String filepath = this.getRelativePath();
            if (this.isPreservePath() && (path = artifact.getPath()) != null && path.length() > 0) {
                if (!path.endsWith(DOWNLOAD_LIST_GUIDVER_SEPARATOR)) {
                    path = String.valueOf(path) + DOWNLOAD_LIST_GUIDVER_SEPARATOR;
                }
                if (path.startsWith(DOWNLOAD_LIST_GUIDVER_SEPARATOR)) {
                    path = path.substring(1);
                }
                filepath = path;
            }
            if ("file".equals(artifact.getType()) && artifact instanceof RAMArtifact) {
                RAMArtifact ramArtifact = (RAMArtifact)artifact;
                File file = new File(this.getDestdir(), String.valueOf(filepath) + filename);
                file.getParentFile().mkdirs();
                LoggingUtil.verbose((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.DownloadingArtifact"), artifact.getName(), file.getAbsolutePath()));
                if (file.exists() && !this.isOverwrite()) {
                    LoggingUtil.warn((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ArtifactExists"), artifact.getName(), file.getAbsolutePath()));
                    return;
                }
                UtilitiesCommon.copyStreams((InputStream)ramArtifact.downloadContents(), (OutputStream)new FileOutputStream(file), null, (boolean)true, (boolean)true);
                long creationDate = ramArtifact.getCreationDate();
                if (creationDate > -1L) {
                    file.setLastModified(creationDate);
                }
                this.downloadedSomething = true;
            } else if ("url".equals(artifact.getType()) && artifact instanceof RAMURLArtifact) {
                RAMURLArtifact urlArtifact = (RAMURLArtifact)artifact;
                String url = urlArtifact.getURL();
                if (url.equals(filename)) {
                    int i;
                    if (url.endsWith(DOWNLOAD_LIST_GUIDVER_SEPARATOR)) {
                        url = url.substring(0, url.length() - 1);
                    }
                    if ((i = url.lastIndexOf(47)) > -1 && i < url.length() - 2) {
                        filename = url.substring(i + 1);
                    }
                }
                File file = new File(this.getDestdir(), String.valueOf(filepath) + filename);
                file.getParentFile().mkdirs();
                LoggingUtil.verbose((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.DownloadingArtifact"), artifact.getName(), file.getAbsolutePath()));
                if (file.exists() && !this.isOverwrite()) {
                    LoggingUtil.warn((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ArtifactExists"), artifact.getName(), file.getAbsolutePath()));
                    return;
                }
                URLConnection conn = new URL(url).openConnection();
                UtilitiesCommon.copyStreams((InputStream)conn.getInputStream(), (OutputStream)new FileOutputStream(file), null, (boolean)true, (boolean)true);
                this.downloadedSomething = true;
            } else if ("folder".equals(artifact.getType()) && artifact instanceof RAMFolderArtifact) {
                RAMFolderArtifact folderArtifact = (RAMFolderArtifact)artifact;
                Artifact[] artifacts = folderArtifact.getChildren();
                String oldRel = this.getRelativePath();
                if (!this.isPreservePath()) {
                    this.setRelativePath(String.valueOf(filepath) + folderArtifact.getName() + DOWNLOAD_LIST_GUIDVER_SEPARATOR);
                }
                Artifact[] artifactArray = artifacts;
                int n = artifacts.length;
                int n2 = 0;
                while (n2 < n) {
                    Artifact a = artifactArray[n2];
                    this.downloadArtifact(a);
                    ++n2;
                }
                if (!this.isPreservePath()) {
                    this.setRelativePath(oldRel);
                }
            }
        }
        catch (RAMRuntimeException e) {
            LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.Error.DownloadingAsset"), artifact.getName()), (Throwable)e);
        }
        catch (IOException e) {
            LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.Error.DownloadingAsset"), artifact.getName()), (Throwable)e);
        }
        LoggingUtil.verbose((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.DownloadSuccessful"), artifact.getName()));
    }

    protected void createBuildActivity(Artifact artifact) {
        if (this.buildInfo != null && artifact instanceof IRAMArtifact) {
            AssetBuildActivity buildActivity = this.buildInfo.getActivity();
            RAMAsset asset = ((IRAMArtifact)artifact).getAsset();
            buildActivity.setAssetGUID(asset.getIdentification().getGUID());
            buildActivity.setAssetName(asset.getName());
            buildActivity.setAssetVersion(asset.getIdentification().getVersion());
            buildActivity.setArtifact(String.valueOf(artifact.getPath()) + '/' + artifact.getName());
            asset.recordActivity((AssetActivity)buildActivity);
            this.getSession().put((IRAMSessionObject)asset, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Override
    public void execute() throws BuildException {
        try {
            super.execute();
            if (this.getSession() == null) {
                LoggingUtil.error((ProjectComponent)this, ClientMessages.getString((String)"Ant.ServerNotSpecified"));
                return;
            }
            this.downloadFromControlFile();
            this.downloadAssets();
            this.downloadArtifacts();
            if (!this.downloadedSomething) {
                LoggingUtil.warn((ProjectComponent)this, ClientMessages.getString((String)"Ant.NothingToDownload"));
            }
            this.updateDownloadedListProperty();
        }
        catch (Exception e) {
            LoggingUtil.error((ProjectComponent)this, (Throwable)e);
        }
    }

    @Override
    public List getChildren() {
        ArrayList children = new ArrayList();
        children.addAll(this.artifacts);
        children.addAll(this.assetLists);
        children.addAll(this.assets);
        children.addAll(this.searches);
        return children;
    }

    protected File getDestdir() {
        if (this.destdir == null) {
            this.destdir = this.getProject().getBaseDir();
        }
        return this.destdir;
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    protected boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    protected boolean isPreservePath() {
        return this.preservePath;
    }

    public void setPreservePath(boolean preservePath) {
        this.preservePath = preservePath;
    }

    protected boolean isExtract() {
        return this.extract;
    }

    public void setExtract(boolean extract) {
        this.extract = extract;
    }

    public File getEclipseproject() {
        return this.eclipseproject;
    }

    public void setEclipseproject(File eclipseproject) {
        this.eclipseproject = eclipseproject;
    }

    public String getDownloadlist() {
        return this.downloadlist;
    }

    public void setDownloadlist(String val) {
        this.downloadlist = val;
    }

    protected void appendDownloadList(String guid, String ver, String artifactPath) {
        String a = String.valueOf(guid) + DOWNLOAD_LIST_GUIDVER_SEPARATOR + ver;
        HashSet<String> aSet = this.getDownloadList().get(a);
        if (aSet == null) {
            aSet = new HashSet();
            this.getDownloadList().put(a, aSet);
        }
        if (artifactPath != null) {
            aSet.add(artifactPath);
        }
    }

    protected void updateDownloadedListProperty() {
        if (this.getDownloadlist() != null && this.downloadList != null) {
            StringBuffer prop = new StringBuffer();
            for (String asset : this.downloadList.keySet()) {
                if (prop.length() > 0) {
                    prop.append(DOWNLOAD_LIST_ASSET_SEPARATOR);
                }
                prop.append(asset);
            }
            this.getProject().setProperty(this.getDownloadlist(), prop.toString());
        }
    }

    protected Map<String, HashSet<String>> getDownloadList() {
        if (this.downloadList == null) {
            this.downloadList = new HashMap<String, HashSet<String>>();
        }
        return this.downloadList;
    }
}

