/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.tasks;

import com.ibm.ram.client.RAMSession;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.types.RAMDataType;
import com.ibm.ram.internal.client.ant.types.Server;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.text.MessageFormat;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;

public abstract class RAMTask
extends Task {
    private RAMSession session;
    private boolean failOnError = true;
    private boolean clearCache = false;
    private String serverId;
    private Server server;

    public static void checkAntVersion(String versionPrefix, ProjectComponent projectComponent) {
        String antVersion = projectComponent.getProject().getProperty("ant.version");
        if (antVersion.indexOf(versionPrefix) == -1) {
            LoggingUtil.error(projectComponent, MessageFormat.format(ClientMessages.getString((String)"Ant.UnsupportedAntVersion"), antVersion));
        }
    }

    public void execute() throws BuildException {
    }

    public RAMSession getSession() {
        if (this.session == null) {
            Object ref = null;
            if (this.server != null) {
                ref = this.server;
            } else if (this.serverId != null) {
                ref = this.getProject().getReference(this.serverId);
            }
            if (ref == null || !(ref instanceof Server)) {
                LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ServerNotDefined"), this.serverId));
            }
            this.setSession(((Server)((Object)ref)).getSession());
        }
        return this.session;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public boolean isClearCache() {
        return this.clearCache;
    }

    public void setSession(RAMSession session) {
        List children;
        this.session = session;
        if (this.clearCache) {
            session.clear();
        }
        if ((children = this.getChildren()) != null) {
            for (Object child : children) {
                if (!(child instanceof RAMDataType)) continue;
                ((RAMDataType)((Object)child)).setSession(this.getSession());
            }
        }
    }

    public void setFailOnError(boolean value) {
        this.failOnError = value;
    }

    public void setClearCache(boolean value) {
        this.clearCache = value;
        if (this.clearCache && this.session != null) {
            this.session.clear();
        }
    }

    public abstract List getChildren();

    public final void setServer(String server) {
        this.serverId = server;
    }

    public String getServer() {
        return this.serverId;
    }

    public void addConfigured(Server server) {
        if (this.server != null) {
            LoggingUtil.error((ProjectComponent)this, "Only one Server element allowed.");
        }
        if (this.serverId != null) {
            LoggingUtil.error((ProjectComponent)this, "Both server attribute and server element may not be set. They are mutually exclusive.");
        }
        this.server = server;
    }
}

