/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.tasks;

import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMCommunity;
import com.ibm.ram.client.RAMFolderArtifact;
import com.ibm.ram.client.RAMHomepageViewlet;
import com.ibm.ram.client.RAMURLArtifact;
import com.ibm.ram.common.data.Artifact;
import com.ibm.ram.common.data.Asset;
import com.ibm.ram.common.data.AssetAttribute;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.tasks.RAMTask;
import com.ibm.ram.internal.client.ant.types.Search;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class UpdateViewletTask
extends RAMTask {
    private static final String DEFAULT_TEMPLATE = "<td><a href=\"@asset.url@\">@asset.name@ [@asset.version@]</a></td>";
    private Search search;
    private String id;
    private String title;
    private int column = 2;
    private String template = "<td><a href=\"@asset.url@\">@asset.name@ [@asset.version@]</a></td>";
    private String header;
    private String footer;
    private String remove = Boolean.FALSE.toString();
    private String tableClass;
    private String[] rowClasses;
    private String community;
    private String colspan;

    public void add(Search search) {
        if (this.getSession() != null) {
            search.setSession(this.getSession());
        }
        search.setTask(this);
        this.search = search;
    }

    @Override
    public List getChildren() {
        ArrayList<Search> children = new ArrayList<Search>();
        children.add(this.search);
        return children;
    }

    public String getCommunity() {
        return this.community;
    }

    public void setCommunity(String community) {
        this.community = community;
    }

    private RAMHomepageViewlet getHomepageViewlet() {
        RAMCommunity community = this.getSession().getCommunity(this.getCommunity());
        return community.getHomepageViewlet(this.getId());
    }

    @Override
    public void execute() throws BuildException {
        try {
            super.execute();
            RAMHomepageViewlet viewlet = this.getHomepageViewlet();
            if (viewlet == null) {
                LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.WidgetTask.WidgetIdNotFound"), this.getId()));
            }
            if (this.getTitle() != null) {
                viewlet.setTitle(this.getTitle());
            }
            viewlet.setColumn(this.getColumn());
            viewlet.setContent(this.getViewletContent());
            if (this.getColspan() != null) {
                viewlet.setColspan(this.getColspan());
            }
            RAMCommunity community = this.getSession().getCommunity(this.getCommunity());
            this.getSession().put((IRAMSessionObject)community, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            LoggingUtil.error((ProjectComponent)this, (Throwable)e);
        }
    }

    public boolean isRemove() {
        return Boolean.valueOf(this.remove);
    }

    private String getRowClass(int index) {
        if (this.rowClasses == null) {
            return null;
        }
        return this.rowClasses[index %= this.rowClasses.length].trim();
    }

    protected String getViewletContent() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<table width=\"100%\"");
        if (this.tableClass != null) {
            buffer.append(" class=\"" + this.tableClass + "\"");
        }
        buffer.append(">");
        if (this.header != null) {
            buffer.append("<thead>");
            buffer.append(this.header);
            buffer.append("</thead>");
        }
        buffer.append("<tbody>");
        RAMAsset[] assets = this.search.getAssets();
        int i = 0;
        while (i < assets.length) {
            buffer.append("<tr");
            String rowClass = this.getRowClass(i);
            if (rowClass != null) {
                buffer.append(" class=\"" + rowClass + "\"");
            }
            buffer.append(">");
            String tpl = this.getTempate();
            if (tpl == null || tpl.length() == 0) {
                tpl = DEFAULT_TEMPLATE;
            }
            tpl = tpl.replaceAll("@asset.name@", assets[i].getName());
            tpl = tpl.replaceAll("@asset.version@", assets[i].getIdentification().getVersion());
            tpl = tpl.replaceAll("@asset.url@", "../assetDetail/generalDetails.faces?guid=" + assets[i].getIdentification().getGUID() + "&amp;v=" + assets[i].getIdentification().getVersion());
            tpl = tpl.replaceAll("@asset.artifacts@", "../artifact/" + assets[i].getIdentification().getGUID() + "/" + assets[i].getIdentification().getVersion());
            tpl = this.replaceAttributes((Asset)assets[i], tpl);
            tpl = this.replaceUrlArtifacts((Asset)assets[i], tpl);
            buffer.append(tpl);
            buffer.append("</td></tr>");
            ++i;
        }
        if (this.footer != null) {
            buffer.append("<tfoot>");
            buffer.append(this.footer);
            buffer.append("</tfoot>");
        }
        buffer.append("</tbody></table>");
        return buffer.toString();
    }

    private String replaceUrlArtifacts(Asset asset, String template) {
        String key = "@asset.urlartifact.";
        int start = template.indexOf(key);
        while (start != -1) {
            int end = template.indexOf("@", start + 1);
            if (end != -1) {
                RAMAsset ramAsset;
                RAMFolderArtifact root;
                Artifact artifact;
                String path = template.substring(start + key.length(), end);
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if ((artifact = (root = (RAMFolderArtifact)(ramAsset = (RAMAsset)asset).getArtifactsRoot()).getChild(path)) != null && artifact instanceof RAMURLArtifact) {
                    RAMURLArtifact urlArtifact = (RAMURLArtifact)artifact;
                    String url = urlArtifact.getURL();
                    if (url == null) {
                        url = "";
                    }
                    template = template.replaceAll(String.valueOf(key) + path + '@', url);
                }
            }
            start = template.indexOf(key, start + 1);
        }
        return template;
    }

    private String replaceAttributes(Asset asset, String template) {
        String key = "@asset.attribute.";
        int start = template.indexOf(key);
        while (start != -1) {
            int end = template.indexOf("@", start + 1);
            if (end != -1) {
                String name = template.substring(start + key.length(), end);
                AssetAttribute attribute = ((RAMAsset)asset).getAssetAttribute(name);
                String[] values = null;
                values = attribute == null ? new String[]{} : attribute.getValues();
                StringBuffer value = new StringBuffer();
                if (values != null) {
                    int i = 0;
                    while (i < values.length) {
                        value.append(values[i]);
                        if (i < values.length - 1) {
                            value.append(", ");
                        }
                        ++i;
                    }
                }
                template = template.replaceAll(String.valueOf(key) + name + '@', value.toString());
            }
            start = template.indexOf(key, start + 1);
        }
        return template;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public int getColumn() {
        return this.column;
    }

    public String getTempate() {
        return this.template;
    }

    public String getHeader() {
        return this.header;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public void setRowClasses(String rowClasses) {
        this.rowClasses = rowClasses.split(",");
    }

    public void setTableClass(String tableClass) {
        this.tableClass = tableClass;
    }

    public void setRemove(String remove) {
        this.remove = remove;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public String getColspan() {
        return this.colspan;
    }

    public void setColspan(String colspan) {
        this.colspan = colspan;
    }
}

