/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.tasks;

import com.ibm.ram.cli.Ram;
import com.ibm.ram.client.RAMAction;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.cli.command.RetireCommand;
import com.ibm.ram.internal.client.ant.AntLogger;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.tasks.RAMTask;
import com.ibm.ram.internal.client.ant.types.Asset;
import com.ibm.ram.internal.client.ant.types.Search;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class RetireTask
extends RAMTask {
    private List assets = new ArrayList();
    private List searches = new ArrayList();
    private String id;
    private String version;
    private String query;
    private File config;

    public void add(Asset asset) {
        if (this.getSession() != null) {
            asset.setSession(this.getSession());
        }
        asset.setTask(this);
        this.assets.add(asset);
    }

    public void add(Search search) {
        if (this.getSession() != null) {
            search.setSession(this.getSession());
        }
        search.setTask(this);
        this.searches.add(search);
    }

    @Override
    public void execute() throws BuildException {
        try {
            super.execute();
            if (this.id != null || this.version != null || this.query != null || this.config != null) {
                ArrayList<String> args = new ArrayList<String>();
                args.add("retire");
                if (this.id != null) {
                    args.add(this.id);
                }
                if (this.version != null) {
                    args.add(this.version);
                }
                if (this.query != null) {
                    args.add("-q");
                    args.add(this.query);
                }
                if (this.config != null) {
                    args.add("-config");
                    args.add(this.config.getAbsolutePath());
                }
                RetireCommand retire = new RetireCommand(args.toArray(new String[args.size()]));
                Ram.execute(retire, new AntLogger(this));
            }
            for (Search search : this.searches) {
                RAMAsset[] assets = search.getAssets();
                int i = 0;
                while (i < assets.length) {
                    assets[i].setAction(RAMAction.RETIRE);
                    this.getSession().queueAssetForPut(assets[i]);
                    ++i;
                }
            }
            for (Asset asset : this.assets) {
                LoggingUtil.verbose((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.RetireTask.RetiringAsset"), String.valueOf(asset.getName()) + " [" + asset.getVersion() + "]"));
                RAMAsset ramAsset = asset.getAsset();
                ramAsset.setAction(RAMAction.RETIRE);
                this.getSession().queueAssetForPut(ramAsset);
            }
            if (!this.assets.isEmpty() || !this.searches.isEmpty()) {
                try {
                    this.getSession().putAssets((IProgressMonitor)new NullProgressMonitor());
                }
                catch (RAMRuntimeException e) {
                    LoggingUtil.error((ProjectComponent)this, (Throwable)e);
                }
                catch (IOException e) {
                    LoggingUtil.error((ProjectComponent)this, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LoggingUtil.error((ProjectComponent)this, (Throwable)e);
        }
    }

    @Override
    public List getChildren() {
        ArrayList children = new ArrayList();
        children.addAll(this.assets);
        return children;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setConfig(File config) {
        this.config = config;
    }
}

