/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.udeploy.repo.integration;

import com.ibm.ram.cli.Ram;
import com.ibm.ram.client.RAMAssetQueryBuilder;
import com.ibm.ram.client.RAMAssetSearchResult;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.common.data.SearchQuery;
import com.ibm.ram.common.data.SearchResult;
import com.ibm.ram.internal.cli.command.Command;
import com.ibm.ram.internal.cli.command.ConfigCommand;
import com.ibm.ram.internal.cli.command.GetCommand;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAMHelper {
    final String repo;
    final String user;
    final String password;
    final String uniqueId;
    final String versionPattern;
    final String query;
    final String state;
    private Map<String, File> tempDirs = new HashMap<String, File>();
    private RAMSession ramSession;

    public RAMHelper(String repo, String user, String password, String uniqueId, String versionPattern, String query, String state) throws IOException {
        if (repo.endsWith("/")) {
            repo = repo.substring(0, repo.length() - 1);
        }
        this.repo = repo;
        this.user = user;
        this.password = password;
        this.uniqueId = uniqueId;
        this.versionPattern = versionPattern;
        this.query = query;
        this.state = state;
    }

    public String getVersion(String revision) throws IOException {
        RAMAssetSearchResult[] assets;
        String result = null;
        revision = revision == null || revision.trim().length() == 0 ? ".*" : revision.replace("*", ".*");
        Pattern regex = Pattern.compile(revision);
        System.out.println(String.format("Searching for version like %s", revision));
        SearchResult searchResult = this.search(this.uniqueId, this.versionPattern, this.query, this.state, -1);
        if (searchResult != null && (assets = (RAMAssetSearchResult[])searchResult.getAssetSearchResults()) != null) {
            for (RAMAssetSearchResult r : assets) {
                AssetIdentification assetId = r.getAsset().getIdentification();
                Matcher matcher = regex.matcher(assetId.getVersion());
                if (!matcher.matches()) continue;
                result = assetId.getVersion();
                break;
            }
        }
        return result;
    }

    public List<String> getLatestVersions(int count) throws IOException {
        RAMAssetSearchResult[] assets;
        System.out.println(String.format("Searching for %d most recent version(s)", count));
        ArrayList<String> versions = new ArrayList<String>();
        SearchResult searchResult = this.search(this.uniqueId, this.versionPattern, this.query, this.state, count);
        if (searchResult != null && (assets = (RAMAssetSearchResult[])searchResult.getAssetSearchResults()) != null) {
            for (RAMAssetSearchResult result : assets) {
                AssetIdentification assetId = result.getAsset().getIdentification();
                versions.add(assetId.getVersion());
            }
        }
        return versions;
    }

    SearchResult search(String id, String version, String queryString, String state, int count) {
        SearchResult searchResult;
        RAMAssetQueryBuilder queryBuilder = new RAMAssetQueryBuilder(this.getRAMSession());
        String queryId = null;
        if (id != null && id.length() > 0) {
            id = id.replaceAll(" ", "\\\\ ");
            queryId = new String(" id:(" + id + ") ");
        }
        String queryVersion = null;
        if (version != null && version.length() > 0) {
            queryVersion = new String(" version:(" + version + ") ");
        }
        String queryState = null;
        if (state != null && state.length() > 0) {
            queryState = new String(" state:(" + state + ") ");
        }
        if (queryString == null || !queryString.startsWith("ramSearch:(")) {
            System.out.println("Attempting text search for versions since a query string was not provided...");
            StringBuilder queryStringBuilder = new StringBuilder();
            if (queryString != null) {
                queryStringBuilder.append(queryString);
            }
            if (queryId != null) {
                queryStringBuilder.append(queryId);
            }
            if (queryVersion != null) {
                queryStringBuilder.append(queryVersion);
            }
            if (queryState != null) {
                queryStringBuilder.append(queryState);
            }
            queryBuilder.addQueryTextField(queryStringBuilder.toString());
            queryBuilder.setSortAscending(false);
            queryBuilder.setSortByField(queryBuilder.SORT_BY_FIELD_VERSION);
            if (count != -1) {
                queryBuilder.setMaxResults(count);
            }
            searchResult = this.getRAMSession().getAssets((SearchQuery)queryBuilder);
        } else {
            System.out.println("Performing RAM search for versions");
            if (queryId != null || queryVersion != null) {
                StringBuilder sb = new StringBuilder("$txt,");
                if (queryId != null) {
                    sb.append(queryId);
                }
                if (queryVersion != null) {
                    sb.append(queryVersion);
                }
                StringBuilder queryStringBuilder = new StringBuilder(queryString);
                int insertIndex = queryString.lastIndexOf(")");
                if (insertIndex > -1) {
                    queryStringBuilder.insert(insertIndex, sb);
                } else {
                    queryStringBuilder.append((CharSequence)sb);
                }
                queryString = queryStringBuilder.toString();
            }
            SearchQuery searchQuery = new SearchQuery();
            searchQuery.setQueryString(queryString);
            searchQuery.setSortAscending(false);
            queryBuilder.setSortByField(queryBuilder.SORT_BY_FIELD_VERSION);
            if (count != -1) {
                searchQuery.setMaxResults(count);
            }
            searchResult = this.getRAMSession().getAssets(searchQuery);
        }
        return searchResult;
    }

    private File getTempDir(String version) throws IOException {
        File result = this.tempDirs.get(version);
        if (result == null) {
            result = new File(UUID.randomUUID().toString());
            IO.mkdirs(result);
            this.tempDirs.put(version, result);
        }
        return result;
    }

    public File downloadFiles(String version, boolean includeDependent) throws Exception {
        String[] getArgs;
        File tempDir = this.getTempDir(version);
        String[] arguments = new String[]{"config", "-url", this.repo, "-u", this.user, "-p", this.password};
        System.out.println("Configuring RAM command");
        if (Ram.execute((Command)new ConfigCommand(arguments)) != 0) {
            throw new RuntimeException("Error configuring RAM command");
        }
        if (includeDependent) {
            System.out.println("Downloading files, incuding dependent...");
            getArgs = new String[]{"get", this.uniqueId, version, "-d", tempDir.getPath()};
        } else {
            System.out.println("Downloading files...");
            getArgs = new String[]{"get", "-n", this.uniqueId, version, "-d", tempDir.getPath()};
        }
        if (Ram.execute((Command)new GetCommand(getArgs)) != 0) {
            throw new RuntimeException("Error downloading files");
        }
        System.out.println(String.format("Files downloaded to %s", tempDir.getName()));
        return tempDir;
    }

    private RAMSession getRAMSession() {
        if (this.ramSession == null) {
            this.ramSession = new RAMSession(this.repo, this.user, this.password);
        }
        return this.ramSession;
    }

    public void release() {
        if (this.ramSession != null) {
            this.ramSession.release();
        }
    }

    public String getState(String version) {
        RAMAssetSearchResult[] assets;
        String result = null;
        SearchResult searchResult = this.search(this.uniqueId, version, null, null, 1);
        if (searchResult != null && (assets = (RAMAssetSearchResult[])searchResult.getAssetSearchResults()) != null && assets.length > 0) {
            result = assets[0].getAsset().getStateName();
        }
        return result;
    }

    public String getWebURL() {
        return this.getRAMSession().getWebServerURL();
    }
}

