/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client;

import com.ibm.ram.internal.client.AbstractRAMClient;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.multipart.FilePart;

public class FilePartWithProgress
extends FilePart {
    private AbstractRAMClient.IUploadProgress progress = null;
    private long total;

    public FilePartWithProgress(String name, File file, AbstractRAMClient.IUploadProgress progress) throws FileNotFoundException {
        super(name, file);
        this.total = file.length();
        this.progress = progress;
    }

    protected void sendData(OutputStream out) throws IOException {
        OutputStreamWrapper outW = new OutputStreamWrapper(out);
        try {
            super.sendData((OutputStream)outW);
        }
        finally {
            this.progress.setProgress(100);
        }
    }

    class OutputStreamWrapper
    extends OutputStream {
        private final OutputStream ostream;
        long written = 0L;
        long reported = 0L;

        public OutputStreamWrapper(OutputStream ostream) {
            this.ostream = ostream;
        }

        @Override
        public void write(int b) throws IOException {
            this.ostream.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (FilePartWithProgress.this.progress != null && FilePartWithProgress.this.progress.isCanceled() || Thread.interrupted()) {
                throw new IOException(ClientMessages.getString((String)"FilePartWithProgress.UPLOAD_CANCELLED"));
            }
            this.ostream.write(b, off, len);
            this.written += (long)len;
            int percentDone = (int)(100.0 * (double)this.written / (double)FilePartWithProgress.this.total);
            if (this.reported < (long)percentDone) {
                FilePartWithProgress.this.progress.setProgress(percentDone);
                this.reported = percentDone;
            }
        }

        @Override
        public void flush() throws IOException {
            this.ostream.flush();
        }

        @Override
        public void close() throws IOException {
            this.ostream.close();
        }
    }
}

