/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client;

import com.ibm.ram.common.util.CachedRAMURIConverter;
import com.ibm.ram.common.util.ManifestAccessor;
import com.ibm.ram.common.util.ManifestBuilder;
import com.ibm.ram.common.util.RAMURIConverter;
import com.ibm.ram.common.util.RAMURLEncoder;
import com.ibm.ram.internal.client.AbstractRAMClient;
import com.ibm.ram.internal.client.ClientCachedRAMUriConverter;
import com.ibm.ram.internal.client.HttpclientSecureProtocolSocketFactory;
import com.ibm.ram.internal.client.RAMClient;
import com.ibm.ram.internal.client.RAMServiceException;
import com.ibm.ram.internal.client.util.StringUtils;
import com.ibm.ram.repository.web.ws.core.AcceptAllCertsTrustManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;

public class RAMClientUtilities {
    public static final String DEFAULT_AUTO_ACCEPT_SSL_PROTOCOLS_LIST = "SSL, TLS, SSLv2, SSLv3, TLSv1";
    public static final int WEB_SERVICE_TIMEOUT = 60000;
    public static final String DEFAULT_HTTP_ERROR_MESSAGE = "Error in transport medium trying to communicate with server";
    public static final String LOGGED_OUT_ERROR_MESSAGE = "The repository connection is currently logged out";
    public static final String IS_LOGGED_OUT_KEY = "com.ibm.ram.rich.client.isLoggedOut";
    private static final Logger logger = Logger.getLogger((String)RAMClientUtilities.class.getName());
    public static String AUTO_ACCES_SSL_PROTOCOLS_LIST = "SSL, TLS, SSLv2, SSLv3, TLSv1";
    public static boolean IS_SSL_AUTO_APPROVE_ALLOWED = true;
    private static boolean isHTTPClientSSLInitialized = false;
    private static boolean isWebServicesSSLInitialized = false;
    public static char[] HTTPS_SCHEME = HttpsURL.DEFAULT_SCHEME;
    public static int HTTP_STATUS_CODE_CONFLICT = 409;
    private static String KEY_URLTIMEOUT = "com.ibm.ram.rich.client.urlTimeout";
    private static Map<String, Integer> urlDownloadTimeouts = new HashMap<String, Integer>();

    public static List getSSLContexts() {
        ArrayList contextOrder = new ArrayList();
        ArrayList<SSLContext> realSSLContexts = new ArrayList<SSLContext>();
        ArrayList<SSLContext> fakeSSLContexts = new ArrayList<SSLContext>();
        String sslProtocols = AUTO_ACCES_SSL_PROTOCOLS_LIST;
        StringTokenizer commaTokenizer = new StringTokenizer(sslProtocols, ",", false);
        while (commaTokenizer.hasMoreTokens()) {
            String sslProtocolName = commaTokenizer.nextToken().trim();
            SSLContext s = RAMClientUtilities.getRealContext(sslProtocolName);
            if (s != null) {
                realSSLContexts.add(s);
            }
            if ((s = RAMClientUtilities.getFakeContext(sslProtocolName)) == null) continue;
            fakeSSLContexts.add(s);
        }
        contextOrder.addAll(realSSLContexts);
        contextOrder.addAll(fakeSSLContexts);
        return contextOrder;
    }

    private static SSLContext getFakeContext(String sslProtocolName) {
        SSLContext fakeContext = null;
        try {
            fakeContext = SSLContext.getInstance(sslProtocolName);
            fakeContext.init(new KeyManager[0], new TrustManager[]{new AcceptAllCertsTrustManager()}, new SecureRandom());
        }
        catch (KeyManagementException e) {
            logger.log((Priority)Level.DEBUG, (Object)("Unable to instantiate fake SSL context for " + sslProtocolName + " protocol"), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.log((Priority)Level.DEBUG, (Object)("Unable to instantiate fake SSL context for " + sslProtocolName + " protocol"), (Throwable)e);
        }
        return fakeContext;
    }

    private static SSLContext getRealContext(String sslProtocolName) {
        SSLContext realContext = null;
        if (realContext == null) {
            try {
                realContext = SSLContext.getInstance(sslProtocolName);
                realContext.init(null, null, null);
            }
            catch (NoSuchAlgorithmException e) {
                logger.log((Priority)Level.DEBUG, (Object)("Unable to instantiate real SSL context for " + sslProtocolName + " protocol"), (Throwable)e);
            }
            catch (KeyManagementException e) {
                logger.log((Priority)Level.DEBUG, (Object)("Unable to instantiate real  SSL context for " + sslProtocolName + " protocol"), (Throwable)e);
            }
        }
        return realContext;
    }

    public static SSLContext getNextAvailableContext(SSLContext current, SSLContext firstContext, List contextOrder) {
        SSLContext nextContext = null;
        if (contextOrder != null && contextOrder.size() > 0) {
            if (current == null) {
                nextContext = (SSLContext)contextOrder.get(0);
            } else {
                int currentIndex = contextOrder.indexOf(current);
                int nextIndex = currentIndex + 1;
                if (nextIndex >= contextOrder.size() && firstContext != null) {
                    nextIndex = 0;
                }
                if (nextIndex > -1 && nextIndex < contextOrder.size()) {
                    if (firstContext != null) {
                        if (contextOrder.get(nextIndex) != firstContext) {
                            nextContext = (SSLContext)contextOrder.get(nextIndex);
                        }
                    } else {
                        nextContext = (SSLContext)contextOrder.get(nextIndex);
                    }
                }
            }
        }
        return nextContext;
    }

    public static void updateWebServicesSSLProperties() {
        if (RAMClientUtilities.isSSLAutoApproveAllowed() && !isWebServicesSSLInitialized) {
            String axisSecureSocketFactory = "axis.socketSecureFactory";
            String socketFactoryClassName = "com.ibm.ram.repository.web.ws.core.AcceptAllSSLCertsSocketFactory";
            System.setProperty(axisSecureSocketFactory, socketFactoryClassName);
            isWebServicesSSLInitialized = true;
        }
    }

    public static void updateHTTPClientSSLProperties() {
        if (RAMClientUtilities.isSSLAutoApproveAllowed() && !isHTTPClientSSLInitialized) {
            Protocol.registerProtocol((String)new String(HttpsURL.DEFAULT_SCHEME), (Protocol)new Protocol(new String(HttpsURL.DEFAULT_SCHEME), (ProtocolSocketFactory)new HttpclientSecureProtocolSocketFactory(), 443));
            logger.log((Priority)Level.DEBUG, (Object)"Updated the HTTPCLIENT protocol handler for HTTPS protocol to use 'HttpclientSecureProtocolSocketFactory'");
            isHTTPClientSSLInitialized = true;
        }
    }

    private static boolean isSSLAutoApproveAllowed() {
        return IS_SSL_AUTO_APPROVE_ALLOWED;
    }

    public static ResourceSet createResourceSet(String serverPath, RAMClient client, Map serverURIToLocalFileURIMap, boolean recordExceptions) {
        ClientCachedRAMUriConverter c = new ClientCachedRAMUriConverter(serverPath, client, recordExceptions);
        ResourceSet rset = ManifestBuilder.createResourceSet((RAMURIConverter)c);
        RAMClientUtilities.initializeResourceSet(rset, serverPath, serverURIToLocalFileURIMap);
        return rset;
    }

    public static void initializeResourceSet(ResourceSet resourceSet, String serverPath, Map serverURIToLocalFileURIMap) {
        URIConverter converter;
        if (serverPath != null) {
            ManifestAccessor.setServerPath((ResourceSet)resourceSet, (String)serverPath);
        }
        if ((converter = resourceSet.getURIConverter()) instanceof CachedRAMURIConverter) {
            CachedRAMURIConverter cachedConverter = (CachedRAMURIConverter)converter;
            if (serverURIToLocalFileURIMap != null && serverURIToLocalFileURIMap.size() > 0) {
                for (URI serverURI : serverURIToLocalFileURIMap.keySet()) {
                    URI localFileURI = (URI)serverURIToLocalFileURIMap.get(serverURI);
                    if (serverURI == null || localFileURI == null) continue;
                    cachedConverter.addCacheMapping(serverURI, localFileURI);
                }
            }
        }
    }

    public static String[] saveServerCategorySchemaFiles(String repositoryName, String[] serverURIs, AbstractRAMClient client, File saveInFolder, IProgressMonitor monitor) throws IOException {
        ArrayList<String> localURIList = new ArrayList<String>();
        String repositoryFileName = RAMURLEncoder.encode((String)repositoryName);
        String repositoryDirectoryPath = String.valueOf(saveInFolder.getAbsolutePath()) + "/" + repositoryFileName;
        File repositoryDirectory = new File(repositoryDirectoryPath);
        if (!repositoryDirectory.exists()) {
            repositoryDirectory.mkdir();
        }
        IOException firstException = null;
        if (serverURIs != null) {
            int uc = 0;
            while (uc < serverURIs.length) {
                String localFileName;
                block17: {
                    String remoteFileName = serverURIs[uc];
                    if (remoteFileName.endsWith("#/")) {
                        remoteFileName = remoteFileName.substring(0, remoteFileName.lastIndexOf("#/"));
                    }
                    localFileName = String.valueOf(repositoryDirectoryPath) + "/" + remoteFileName.substring(remoteFileName.lastIndexOf("/") + 1);
                    if (!StringUtils.isBlank((String)remoteFileName) && !StringUtils.isBlank((String)localFileName)) {
                        try {
                            File localFile = new File(localFileName);
                            if (!localFile.exists()) {
                                localFile.getParentFile().mkdirs();
                                localFile.createNewFile();
                            }
                            FileOutputStream outputstream = new FileOutputStream(localFile);
                            try {
                                try {
                                    InputStream is = client.getInputStream(new URL(remoteFileName));
                                    if (is == null) {
                                        logger.error((Object)("Faild to load server category schema " + remoteFileName));
                                    } else {
                                        byte[] data = new byte[8192];
                                        int read = is.read(data);
                                        while (read > -1) {
                                            outputstream.write(data, 0, read);
                                            read = is.read(data);
                                        }
                                    }
                                }
                                catch (RAMServiceException e) {
                                    logger.log((Priority)Level.WARN, (Object)"Unable to download classification schema from server", (Throwable)e);
                                    throw new IOException(e.getMessage());
                                }
                            }
                            finally {
                                outputstream.close();
                            }
                        }
                        catch (IOException e) {
                            logger.log((Priority)Level.WARN, (Object)"Unable to download classification schema from server", (Throwable)e);
                            if (firstException != null) break block17;
                            firstException = e;
                        }
                    }
                }
                localURIList.add(localFileName);
                ++uc;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
        return localURIList.toArray(new String[localURIList.size()]);
    }

    public static int getURLDownloadTimeout(String urlPath) {
        Integer value;
        if (urlDownloadTimeouts != null && urlPath != null && urlDownloadTimeouts.containsKey(urlPath) && (value = urlDownloadTimeouts.get(urlPath)) != null) {
            return value;
        }
        return -1;
    }

    public static void setURLDownloadTimeout(String urlPath, int timeout) {
        if (urlPath != null) {
            if (timeout < 1) {
                urlDownloadTimeouts.remove(urlPath);
            } else {
                urlDownloadTimeouts.put(urlPath, new Integer(timeout));
            }
        }
    }

    public static int getDefaultURLDownloadTimeout() {
        int timeout = 120000;
        try {
            String property = System.getProperty(KEY_URLTIMEOUT);
            if (property != null) {
                timeout = Integer.parseInt(property);
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"Unable to determine URL timeout", e);
        }
        return timeout;
    }
}

