/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.batch;

import com.ibm.ram.client.batch.BatchDataSource;
import com.ibm.ram.internal.client.batch.BatchTarget;
import com.ibm.ram.internal.common.util.Utilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BatchSourcesRoot {
    protected static final String SOURCE_CONNECTIONS = "SOURCE_CONNECTIONS";
    protected static final String SOURCE_TYPE_ID = "SOURCE_TYPE_ID";
    protected static final String SOURCE_TYPE_CONFIG = "SOURCE_CONFIG";
    protected static final String EXTENSION_POINT_BATCH_DATA_SOURCE = "batchDataSource";
    public static String ATTRIBUTE_CLASS_NAME = "class";
    public static String ATTRIBUTE_ID_NAME = "id";
    Logger logger = Logger.getLogger((String)BatchSourcesRoot.class.getName());
    private BatchTarget fBatchTarget;
    private List fBatchDataSources = new ArrayList();

    public BatchSourcesRoot() {
    }

    protected BatchSourcesRoot(BatchTarget target, Map initMap) {
    }

    public BatchDataSource[] getBatchDataSources() {
        return this.fBatchDataSources.toArray(new BatchDataSource[this.fBatchDataSources.size()]);
    }

    public void addBatchDataSource(BatchDataSource dataSource) {
        if (!this.fBatchDataSources.contains(dataSource)) {
            this.fBatchDataSources.add(dataSource);
            if (this.getBatchTarget() != null) {
                dataSource.setTargetSession(this.getBatchTarget().getTargetSession());
            }
        }
    }

    public void removeBatchDataSource(BatchDataSource dataSource) {
        this.fBatchDataSources.remove(dataSource);
    }

    public String save(HashMap map) {
        HashMap[] sources = new HashMap[this.getBatchDataSources().length];
        int i = 0;
        while (i < sources.length) {
            String xml = this.getBatchDataSources()[i].save();
            sources[i] = new HashMap();
            sources[i].put(SOURCE_TYPE_ID, this.getBatchDataSources()[i].getTypeId());
            sources[i].put(SOURCE_TYPE_CONFIG, xml);
            ++i;
        }
        map.put(SOURCE_CONNECTIONS, sources);
        return Utilities.encodeToXML((Map)map);
    }

    public BatchTarget getBatchTarget() {
        return this.fBatchTarget;
    }

    public void setBatchTarget(BatchTarget batchTarget) {
        if (batchTarget != this.fBatchTarget) {
            this.fBatchTarget = batchTarget;
        }
        if (batchTarget != null && batchTarget.getTargetSession() != null) {
            BatchDataSource[] sources = this.getBatchDataSources();
            int i = 0;
            while (i < sources.length) {
                sources[i].setTargetSession(batchTarget.getTargetSession());
                ++i;
            }
        }
    }
}

