/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.batch;

import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.RAMAction;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAssetAttribute;
import com.ibm.ram.client.RAMAssetType;
import com.ibm.ram.client.RAMAssetValidation;
import com.ibm.ram.client.RAMCommunity;
import com.ibm.ram.client.RAMForum;
import com.ibm.ram.client.RAMRelationship;
import com.ibm.ram.client.RAMRelationshipType;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.client.RAMSubCategory;
import com.ibm.ram.client.RAMUser;
import com.ibm.ram.client.status.RAMStatusMonitor;
import com.ibm.ram.common.data.Asset;
import com.ibm.ram.common.data.AssetAttribute;
import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.common.data.AssetType;
import com.ibm.ram.common.data.Category;
import com.ibm.ram.common.data.CategorySchema;
import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.data.Forum;
import com.ibm.ram.common.data.Post;
import com.ibm.ram.common.data.Relationship;
import com.ibm.ram.common.data.RelationshipType;
import com.ibm.ram.common.data.SubCategory;
import com.ibm.ram.common.data.Topic;
import com.ibm.ram.common.data.UserInformation;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.util.UniqueIDGenerator;
import com.ibm.ram.internal.client.RAMMappings;
import com.ibm.ram.internal.client.batch.BatchTargetModifiedListener;
import com.ibm.ram.internal.client.batch.Utilities;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import com.ibm.ram.internal.client.util.AssetUtil;
import com.ibm.ram.internal.client.util.BatchTargetModifiedEvent;
import com.ibm.ram.internal.client.util.SessionManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class BatchTarget {
    private static String className = BatchTarget.class.getName();
    private static final Logger logger = Logger.getLogger((String)className);
    private List fBatchTargetModifiedListeners = new ArrayList();
    protected RAMSession fTaregtSession;
    protected RAMMappings fMappings;
    protected AssetContainer fAssetContainer = new AssetContainer();
    protected CommunityContainer fCommunityContainer;
    protected AssetTypesContainer fAssetTypesContainer;
    protected RelationshipTypesContainer fRelationshipTypesContainer = null;
    protected UserContainer fUserContainer = new UserContainer();
    protected CategorizationContainer fCategorizationContainer = new CategorizationContainer();
    protected AttributesContainer fAttributesContainer = new AttributesContainer();

    public BatchTarget(RAMSession targetSession) {
        this.fTaregtSession = targetSession;
        if (this.getTargetSession() != null) {
            this.fMappings = SessionManager.getSessionManager().getSessionStore(this.getTargetSession()).getMappings();
        }
    }

    public BatchTarget(HashMap initMap) {
    }

    private void initContainers() {
        if (this.fCommunityContainer == null) {
            this.fCommunityContainer = new CommunityContainer();
        }
        if (this.fAssetTypesContainer == null) {
            this.fAssetTypesContainer = new AssetTypesContainer();
        }
        if (this.fRelationshipTypesContainer == null) {
            this.fRelationshipTypesContainer = new RelationshipTypesContainer();
        }
    }

    public RAMSession getTargetSession() {
        return this.fTaregtSession;
    }

    public RAMMappings getMappings() {
        if (this.fMappings == null && this.getTargetSession() != null) {
            this.fMappings = SessionManager.getSessionManager().getSessionStore(this.getTargetSession()).getMappings();
        }
        return this.fMappings;
    }

    public void clear() {
        RAMAsset[] modifiedAssets = this.getTargetSession().getModifiedAssets();
        int i = 0;
        while (i < modifiedAssets.length) {
            this.getTargetSession().remove((IRAMSessionObject)modifiedAssets[i]);
            ++i;
        }
        BatchTargetModifiedEvent event = new BatchTargetModifiedEvent(this);
        if (this.fAssetContainer != null && this.fAssetContainer.getAssetCount() > 0) {
            this.fAssetContainer.clear();
            event.setAssetsModified(true);
        }
        if (this.fAssetTypesContainer != null && this.fAssetTypesContainer.getAssetTypesCount() > 0) {
            this.fAssetTypesContainer.clear();
            event.setAssetTypesModified(true);
        }
        if (this.fAttributesContainer != null && this.fAttributesContainer.getAttributesCount() > 0) {
            this.fAttributesContainer.clear();
            event.setAttributesModified(true);
        }
        if (this.fCategorizationContainer != null && this.fCategorizationContainer.getCategoriesCount() > 0) {
            this.fCategorizationContainer.clear();
            event.setCategorizationsModified(true);
        }
        if (this.fCommunityContainer != null && this.fCommunityContainer.getCommunityCount() > 0) {
            this.fCommunityContainer.clear();
            event.setCommunitiesModified(true);
        }
        if (this.fRelationshipTypesContainer != null && this.fRelationshipTypesContainer.getRelationshipTypesCount() > 0) {
            this.fRelationshipTypesContainer.clear();
            event.setRelationshipTypesModified(true);
        }
        if (this.fUserContainer != null && this.fUserContainer.getUserCount() > 0) {
            this.fUserContainer.clear();
            event.setUsersModified(true);
        }
        this.fireModificationEvents(event);
    }

    private void fireModificationEvents(BatchTargetModifiedEvent event) {
        int i = 0;
        while (i < this.fBatchTargetModifiedListeners.size()) {
            BatchTargetModifiedListener listener = (BatchTargetModifiedListener)this.fBatchTargetModifiedListeners.get(i);
            listener.handleEvent(event);
            ++i;
        }
    }

    public void addModifiedListener(BatchTargetModifiedListener listener) {
        if (!this.fBatchTargetModifiedListeners.contains(listener)) {
            this.fBatchTargetModifiedListeners.add(listener);
        }
    }

    public void addAsset(Asset asset, RAMStatusMonitor monitor) {
        int i;
        BatchTargetModifiedEvent modificationEvent = new BatchTargetModifiedEvent(this);
        BatchAsset batchAsset = null;
        int TOTAL_WORK = 100;
        int workDone = 0;
        if (!monitor.isCanceled()) {
            this.initContainers();
            monitor.beginTask(ClientMessages.getString((String)"BatchTarget.0"), TOTAL_WORK);
            monitor.subTask("Add Asset " + asset);
            AssetIdentification assetId = asset.getIdentification();
            workDone += 5;
            try {
                batchAsset = this.fAssetContainer.addAsset(asset, (IProgressMonitor)new RAMStatusMonitor((IProgressMonitor)monitor, 5));
            }
            catch (Exception e) {
                monitor.appendStatus((Object)asset, 4, 1017, e.getLocalizedMessage(), (Throwable)e);
            }
            if (batchAsset == null) {
                monitor.worked(TOTAL_WORK - workDone);
                return;
            }
            String message = MessageFormat.format(ClientMessages.getString((String)"BatchTarget_Validating_asset"), asset);
            monitor.appendStatus((Object)asset, 1, 19, message, null);
            modificationEvent.setAssetsModified(batchAsset != null);
            this.getMappings().setAssetIsInvalid(assetId.getGUID(), assetId.getVersion(), false);
            monitor.subTask(MessageFormat.format(ClientMessages.getString((String)"BatchTarget.FETCH_COMMUNITY"), asset.getCommunityName(), asset));
            modificationEvent.setCommunitiesModified(this.fCommunityContainer.addCommunity(asset.getCommunity()));
            workDone += 5;
            monitor.worked(5);
        }
        if (!monitor.isCanceled()) {
            monitor.subTask(MessageFormat.format(ClientMessages.getString((String)"BatchTarget.FETCH_ASSET_TYPE"), asset));
            if (asset.getAssetType() != null) {
                modificationEvent.setAssetTypesModified(this.fAssetTypesContainer.addAssetType(asset.getAssetType()));
            }
            workDone += 5;
            monitor.worked(5);
        }
        if (!monitor.isCanceled()) {
            monitor.subTask(MessageFormat.format(ClientMessages.getString((String)"BatchTarget.FETCH_OWNERS"), asset));
            UserInformation[] users = asset.getOwners();
            if (users != null) {
                int i2 = 0;
                while (i2 < users.length) {
                    boolean newUser = this.fUserContainer.addUser(users[i2]);
                    if (newUser) {
                        modificationEvent.setUsersModified(true);
                    }
                    ++i2;
                }
            }
            workDone += 5;
            monitor.worked(5);
        }
        if (!monitor.isCanceled()) {
            monitor.subTask(MessageFormat.format(ClientMessages.getString((String)"BatchTarget.FETCH_CATEGORIES"), asset));
            CategorySchema[] schemas = asset.getCategorySchemas();
            if (schemas != null) {
                ArrayList categorizationsList = new ArrayList();
                i = 0;
                while (i < schemas.length) {
                    Category[] categories = schemas[i].getCategories();
                    int j = 0;
                    while (j < categories.length) {
                        BatchTarget.findSetSubCategories(categories[j].getSubCategories(), categorizationsList);
                        ++j;
                    }
                    ++i;
                }
                SubCategory[] subcategories = categorizationsList.toArray(new SubCategory[categorizationsList.size()]);
                int i3 = 0;
                while (i3 < subcategories.length) {
                    try {
                        boolean newCategorization = this.fCategorizationContainer.addCategorization(subcategories[i3]);
                        if (newCategorization) {
                            modificationEvent.setCategorizationsModified(true);
                        }
                    }
                    catch (Exception e) {
                        String message = MessageFormat.format(ClientMessages.getString((String)"BatchTarget.COULD_NOT_FIND_CAT"), subcategories[i3]);
                        logger.warn((Object)message, (Throwable)e);
                    }
                    ++i3;
                }
            }
            workDone += 5;
            monitor.worked(5);
        }
        if (!monitor.isCanceled()) {
            monitor.subTask(MessageFormat.format(ClientMessages.getString((String)"BatchTarget.FETCH_ATTRIBUTES"), asset));
            AssetAttribute[] customAttributes = asset.getAssetAttributes();
            if (customAttributes != null) {
                int i4 = 0;
                while (!monitor.isCanceled() && i4 < customAttributes.length) {
                    block53: {
                        try {
                            String[] values;
                            boolean newAttribute = this.fAttributesContainer.addAttribute(customAttributes[i4]);
                            if (newAttribute) {
                                modificationEvent.setAttributesModified(true);
                            }
                            if ((values = customAttributes[i4].getValues()) == null) break block53;
                            BatchAttribute attribute = this.fAttributesContainer.getBatchAttribute(customAttributes[i4].getName());
                            int j = 0;
                            while (j < values.length) {
                                try {
                                    attribute.addAttributeValue(values[j]);
                                }
                                catch (Exception ex) {
                                    monitor.appendStatus((Object)asset, 2, 1000, "Fialed to add attribute " + customAttributes[i4].getName() + " value " + values[j] + " to asset " + asset, (Throwable)ex);
                                }
                                ++j;
                            }
                        }
                        catch (Exception e) {
                            monitor.appendStatus((Object)asset, 2, 1000, "Fialed to add attribute " + customAttributes[i4].getName() + " to asset " + asset, (Throwable)e);
                        }
                    }
                    ++i4;
                }
            }
            workDone += 5;
            monitor.worked(5);
        }
        if (!monitor.isCanceled()) {
            if (batchAsset != null && asset.getForums() != null && asset.getForums().length > 0) {
                monitor.subTask(MessageFormat.format(ClientMessages.getString((String)"BatchTarget.FETCH_FORUMS"), asset));
                Forum[] ramForums = batchAsset.getTargetAsset().getForums();
                Forum[] sourceForums = asset.getForums();
                i = 0;
                while (i < sourceForums.length) {
                    Forum sourceForum = sourceForums[i];
                    RAMForum targetForum = null;
                    int j = 0;
                    while (j < ramForums.length) {
                        if (ramForums[j].getTitle().equals(sourceForum.getTitle())) {
                            targetForum = (RAMForum)ramForums[j];
                        }
                        ++j;
                    }
                    BatchForum forum = new BatchForum(batchAsset, sourceForum, targetForum);
                    batchAsset.addForum(forum);
                    boolean newUser = this.fUserContainer.addUser(sourceForum.getSubmitter());
                    if (newUser) {
                        modificationEvent.setUsersModified(true);
                    }
                    Topic[] topics = sourceForum.getTopics();
                    int j2 = 0;
                    while (j2 < topics.length) {
                        Topic sourceTopic = topics[j2];
                        newUser = this.fUserContainer.addUser(sourceTopic.getSubmitter());
                        if (newUser) {
                            modificationEvent.setUsersModified(true);
                        }
                        Post[] posts = sourceTopic.getPosts();
                        int k = 0;
                        while (k < posts.length) {
                            Post sourcePost = posts[k];
                            newUser = this.fUserContainer.addUser(sourcePost.getSubmitter());
                            if (newUser) {
                                modificationEvent.setUsersModified(true);
                            }
                            ++k;
                        }
                        ++j2;
                    }
                    ++i;
                }
            }
            workDone += 10;
            monitor.worked(10);
        }
        if (!monitor.isCanceled()) {
            monitor.subTask(MessageFormat.format(ClientMessages.getString((String)"BatchTarget.FETCH_RELATIONSHIPS"), asset));
            Relationship[] rels = asset.getRelationships();
            if (rels instanceof RAMRelationship[]) {
                RAMRelationship[] relationships = (RAMRelationship[])rels;
                ArrayList<RAMAsset> children = new ArrayList<RAMAsset>();
                if (!monitor.isCanceled() && relationships.length > 0) {
                    RAMStatusMonitor relationshipsMon = new RAMStatusMonitor((IProgressMonitor)monitor, 60);
                    relationshipsMon.beginTask(ClientMessages.getString((String)"BatchTarget.ADD_RELATED"), relationships.length * 10);
                    int i5 = 0;
                    while (!monitor.isCanceled() && i5 < relationships.length) {
                        RAMAsset childAsset = null;
                        String GUID = relationships[i5].getChildAssetGUID();
                        String version = relationships[i5].getChildAssetVersion();
                        try {
                            monitor.subTask(MessageFormat.format(ClientMessages.getString((String)"BatchTarget.FETCH_RELATED"), asset, GUID, version));
                            if (relationships[i5].getRelationshipType() == null) {
                                logger.warn((Object)MessageFormat.format(ClientMessages.getString((String)"BatchTarget.MISSING_RELATIONSHIP"), relationships[i5].getParentAsset(), relationships[i5].getChildAsset()));
                            } else {
                                this.fRelationshipTypesContainer.addSourceRelationshipType(relationships[i5].getRelationshipType());
                                modificationEvent.setRelationshipTypesModified(true);
                                if (this.getMappings().isFollowRelatedAssets() && !this.getMappings().isInvalidAsset(GUID, version)) {
                                    childAsset = (RAMAsset)relationships[i5].getChildAsset();
                                    if (childAsset != null) {
                                        if (!this.fAssetContainer.containsAsset(childAsset)) {
                                            children.add(childAsset);
                                        } else {
                                            relationshipsMon.worked(10);
                                        }
                                    } else {
                                        relationshipsMon.worked(10);
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            logger.warn((Object)MessageFormat.format(ClientMessages.getString((String)"BatchTarget.FAILED_FETCH_RELATED"), GUID, version, asset), (Throwable)e);
                            this.getMappings().setAssetIsInvalid(GUID, version, true);
                        }
                        ++i5;
                    }
                    workDone += 60;
                    this.updateUI(modificationEvent, batchAsset);
                    i5 = 0;
                    while (i5 < children.size()) {
                        monitor.appendStatus((Object)asset, 1, 1, "Add related asset to batch target session - " + children.get(i5), null);
                        this.addAsset((Asset)children.get(i5), new RAMStatusMonitor((IProgressMonitor)relationshipsMon, 10));
                        ++i5;
                    }
                } else {
                    this.updateUI(modificationEvent, batchAsset);
                    workDone += 60;
                    monitor.worked(60);
                }
            } else {
                this.updateUI(modificationEvent, batchAsset);
                workDone += 60;
                monitor.worked(60);
            }
        }
        monitor.worked(TOTAL_WORK - workDone);
        monitor.done();
    }

    private void updateUI(BatchTargetModifiedEvent modificationEvent, BatchAsset batchAsset) {
        if (batchAsset != null) {
            batchAsset.validate();
        }
        this.fireModificationEvents(modificationEvent);
    }

    private static void findSetSubCategories(SubCategory[] children, List setList) {
        int i = 0;
        while (i < children.length) {
            SubCategory[] grandChildren;
            if (children[i].isSet()) {
                setList.add(children[i]);
            }
            if ((grandChildren = children[i].getSubCategories()) != null && grandChildren.length > 0) {
                BatchTarget.findSetSubCategories(grandChildren, setList);
            }
            ++i;
        }
    }

    public AssetContainer getAssets() {
        return this.fAssetContainer;
    }

    public CommunityContainer getCommunities() {
        this.initContainers();
        return this.fCommunityContainer;
    }

    public AssetTypesContainer getAssetTypes() {
        this.initContainers();
        return this.fAssetTypesContainer;
    }

    public RelationshipTypesContainer getRelationshipTypes() {
        this.initContainers();
        return this.fRelationshipTypesContainer;
    }

    public UserContainer getUser() {
        return this.fUserContainer;
    }

    public CategorizationContainer getCategorizations() {
        return this.fCategorizationContainer;
    }

    public AttributesContainer getAttributes() {
        return this.fAttributesContainer;
    }

    public boolean isFollowRelatedAssets() {
        return this.getMappings().isFollowRelatedAssets();
    }

    public void setFollowRelatedAssets(boolean followRelatedAssets) {
        this.getMappings().setFollowRelatedAssets(followRelatedAssets);
    }

    public boolean isFilterOutExistingAssets() {
        return this.getMappings().isFilterOutExistingAssets();
    }

    public void setFilterOutExistingAssets(boolean followRelatedAssets) {
        this.getMappings().setFilterOutExistingAssets(followRelatedAssets);
    }

    public class AssetContainer {
        private Map fAssets = new HashMap();
        private boolean fHasError = false;
        private boolean fHashConflict = false;
        private volatile BatchAsset[] fAssetsCache;

        public int getAssetCount() {
            return this.fAssets.size();
        }

        public BatchAsset[] getAssets() {
            if (this.fAssetsCache == null) {
                Collection values = this.fAssets.values();
                BatchAsset[] tmpCache = values.toArray(new BatchAsset[values.size()]);
                Utilities.sort(tmpCache);
                this.fAssetsCache = tmpCache;
            }
            return this.fAssetsCache;
        }

        public BatchAsset getBatchAsset(Asset asset) {
            String key = this.createKey(asset);
            return (BatchAsset)this.fAssets.get(key);
        }

        public void validate() {
            BatchAsset[] assets = this.getAssets();
            boolean error = false;
            boolean conflict = false;
            int i = 0;
            while (i < assets.length) {
                if (assets[i].isInError()) {
                    error = true;
                }
                if (assets[i].isInConflict()) {
                    conflict = true;
                }
                if (conflict && error) break;
                ++i;
            }
            this.fHasError = error;
            this.fHashConflict = conflict;
        }

        public boolean isInError() {
            return this.fHasError;
        }

        public boolean isInConflict() {
            return this.fHashConflict;
        }

        public void setInError(boolean error) {
            this.fHasError = error;
        }

        public void setInConflict(boolean conlict) {
            this.fHashConflict = conlict;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public BatchAsset addAsset(Asset asset, IProgressMonitor monitor) {
            BatchAsset batchAsset;
            int workRemaining;
            block23: {
                RAMAsset remoteAsset;
                String key = this.createKey(asset);
                RAMStatusMonitor ramStatusMonitor = null;
                ramStatusMonitor = monitor instanceof RAMStatusMonitor ? (RAMStatusMonitor)monitor : new RAMStatusMonitor();
                monitor.beginTask(ClientMessages.getString((String)"RAMDataSource.5"), 200);
                workRemaining = 200;
                boolean clearCache = !this.fAssets.containsKey(key);
                batchAsset = null;
                if (BatchTarget.this.getMappings().isFilterOutExistingAssets()) {
                    if (BatchTarget.this.getMappings().isInvalidAsset(asset.getGUID(), asset.getVersion())) {
                        ramStatusMonitor.appendStatus((Object)asset, 1, 1, "Filtered out exitsing due to invalid - " + asset, null);
                        return null;
                    }
                    remoteAsset = null;
                    try {
                        remoteAsset = BatchTarget.this.fTaregtSession.getAsset(asset.getGUID(), asset.getVersion());
                    }
                    catch (RAMRuntimeException rAMRuntimeException) {
                        ramStatusMonitor.appendStatus((Object)asset, 1, 1, "Filtered out exitsing failed to find remote - " + asset, null);
                    }
                    if (remoteAsset != null && remoteAsset.isUpdate()) {
                        BatchTarget.this.getMappings().isInvalidAsset(asset.getGUID(), asset.getVersion());
                        ramStatusMonitor.appendStatus((Object)asset, 1, 1, "Filtered out exitsing add invalid - " + asset, null);
                        if (clearCache) return null;
                        ramStatusMonitor.appendStatus((Object)asset, 1, 1, "Filtered out remove from assets list - " + asset, null);
                        this.fAssets.remove(key);
                        return null;
                    }
                }
                if (clearCache) {
                    remoteAsset = null;
                    try {
                        ramStatusMonitor.appendStatus((Object)asset, 1, 1, "Download Source Asset - " + asset, null);
                        RAMStatusMonitor cloneMonitor = new RAMStatusMonitor((IProgressMonitor)ramStatusMonitor, 100);
                        remoteAsset = BatchTarget.this.fTaregtSession.createAsset(asset, asset.getIdentification().getGUID(), asset.getIdentification().getVersion(), cloneMonitor);
                        workRemaining -= 100;
                        batchAsset = new BatchAsset(BatchTarget.this.fAssetContainer, asset, remoteAsset);
                        this.fAssets.put(this.createKey(asset), batchAsset);
                        BatchAsset[] tmpCache = null;
                        if (this.fAssetsCache == null) {
                            Collection values = this.fAssets.values();
                            tmpCache = values.toArray(new BatchAsset[values.size()]);
                            Utilities.sort(tmpCache);
                            this.fAssetsCache = tmpCache;
                            break block23;
                        }
                        tmpCache = new BatchAsset[this.fAssetsCache.length + 1];
                        if (this.fAssetsCache.length == 0) {
                            tmpCache[0] = batchAsset;
                        } else {
                            int cur = 0;
                            String newAssetName = asset.getName();
                            String newAssetVersion = asset.getVersion();
                            int i = 0;
                            while (true) {
                                if (i >= this.fAssetsCache.length) {
                                    if (cur != this.fAssetsCache.length) break;
                                    tmpCache[cur] = batchAsset;
                                    break;
                                }
                                if (cur > i) {
                                    tmpCache[cur] = this.fAssetsCache[i];
                                } else {
                                    String oldAssetName = this.fAssetsCache[i].getSourceAsset().getName();
                                    String oldAssetVersion = this.fAssetsCache[i].getSourceAsset().getVersion();
                                    if (oldAssetName != null && oldAssetName.compareTo(newAssetName) < 0) {
                                        tmpCache[cur] = this.fAssetsCache[i];
                                    } else if (oldAssetName != null && oldAssetName.equals(newAssetName) && oldAssetVersion != null && oldAssetVersion.compareTo(newAssetVersion) < 0) {
                                        tmpCache[cur] = this.fAssetsCache[i];
                                    } else {
                                        tmpCache[cur++] = batchAsset;
                                        tmpCache[cur] = this.fAssetsCache[i];
                                    }
                                }
                                ++i;
                                ++cur;
                            }
                        }
                        BatchAsset[] batchAssetArray = this.fAssetsCache;
                        // MONITORENTER : this.fAssetsCache
                        this.fAssetsCache = tmpCache;
                        // MONITOREXIT : batchAssetArray
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            if (workRemaining > 0) {
                monitor.worked(workRemaining);
            }
            monitor.done();
            return batchAsset;
        }

        private String createKey(Asset asset) throws RAMRuntimeException {
            if (asset.getGUID() == null) {
                asset.setGUID(UniqueIDGenerator.getUniqueID());
            }
            return String.valueOf(asset.getGUID()) + ":" + asset.getVersion();
        }

        public boolean containsAsset(RAMAsset asset) {
            return this.fAssets.containsKey(this.createKey((Asset)asset));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void clear() {
            if (this.fAssetsCache == null) return;
            BatchAsset[] batchAssetArray = this.fAssetsCache;
            synchronized (this.fAssetsCache) {
                this.fAssets.clear();
                this.fAssetsCache = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    public class AssetTypesContainer {
        private boolean fHasError = false;
        private volatile BatchAssetType[] fBatchAssetTypes;
        private Map fSourceAssetTypes = new HashMap();
        private Map fTargetAssetTypes = new HashMap();

        public AssetTypesContainer() {
            this.refreshTargetAssetTypes();
        }

        private void refreshTargetAssetTypes() throws RAMRuntimeException {
            RAMAssetType[] allAssetTypes = BatchTarget.this.fTaregtSession.getAllAssetTypes();
            int i = 0;
            while (i < allAssetTypes.length) {
                this.fTargetAssetTypes.put(allAssetTypes[i].getName(), allAssetTypes[i]);
                ++i;
            }
        }

        public void clear() {
            this.fHasError = false;
            this.fSourceAssetTypes.clear();
            this.fBatchAssetTypes = null;
        }

        public int getAssetTypesCount() {
            return this.fSourceAssetTypes.size();
        }

        public void inValidate() {
            this.fHasError = false;
            this.refreshTargetAssetTypes();
            this.refreshBatchAssetTypes();
        }

        public BatchAssetType[] getAssetTypes() {
            if (this.fBatchAssetTypes == null) {
                this.refreshBatchAssetTypes();
            }
            return this.fBatchAssetTypes;
        }

        private void refreshBatchAssetTypes() {
            Collection values = this.fSourceAssetTypes.values();
            BatchAssetType[] tmpCache = new BatchAssetType[values.size()];
            int i = 0;
            for (AssetType sourceAssetType : values) {
                tmpCache[i] = new BatchAssetType(this, sourceAssetType, this.getTargetAssetType(sourceAssetType.getName()));
                if (tmpCache[i].isInError()) {
                    this.fHasError = true;
                }
                ++i;
            }
            Utilities.sort(tmpCache);
            this.fBatchAssetTypes = tmpCache;
        }

        public boolean addAssetType(AssetType assetType) {
            boolean clearCache = !this.fSourceAssetTypes.containsKey(assetType.getName());
            this.fSourceAssetTypes.put(assetType.getName(), assetType);
            if (clearCache) {
                this.inValidate();
            }
            return clearCache;
        }

        public RAMAssetType getTargetAssetType(String name) {
            String typeName = name;
            if (BatchTarget.this.getMappings().getAssetTypeNameMappings().containsKey(name)) {
                typeName = (String)BatchTarget.this.getMappings().getAssetTypeNameMappings().get(name);
            }
            return (RAMAssetType)this.fTargetAssetTypes.get(typeName);
        }

        public boolean isInError() {
            if (this.fBatchAssetTypes == null) {
                this.getAssetTypes();
            }
            return this.fHasError;
        }
    }

    public class AttributesContainer {
        private boolean fHasError = false;
        private volatile BatchAttribute[] fBatchAttributes;
        private Map fSourceAttributes = new HashMap();

        public void clear() {
            this.fHasError = false;
            this.fSourceAttributes.clear();
            this.fBatchAttributes = null;
        }

        public int getAttributesCount() {
            return this.fSourceAttributes.size();
        }

        public void inValidate() {
            this.fHasError = false;
            this.refreshAttributes();
        }

        public BatchAttribute[] getAttributes() {
            if (this.fBatchAttributes == null) {
                this.refreshAttributes();
            }
            return this.fBatchAttributes;
        }

        private void refreshAttributes() {
            Collection values = this.fSourceAttributes.values();
            BatchAttribute[] tmpCache = new BatchAttribute[values.size()];
            int i = 0;
            for (AssetAttribute sourceAttribute : values) {
                tmpCache[i] = new BatchAttribute(this, sourceAttribute, this.getTargetAttribute(sourceAttribute.getName()));
                if (tmpCache[i].isInError()) {
                    this.fHasError = true;
                }
                ++i;
            }
            this.fBatchAttributes = tmpCache;
        }

        public BatchAttribute getBatchAttribute(String name) {
            BatchAttribute[] attributes = this.getAttributes();
            BatchAttribute ret = null;
            int i = 0;
            while (i < attributes.length) {
                if (name.equals(attributes[i].getSourceAttribute().getName())) {
                    ret = attributes[i];
                    break;
                }
                ++i;
            }
            return ret;
        }

        public boolean addAttribute(AssetAttribute attribute) {
            boolean clearCache;
            boolean bl = clearCache = !this.fSourceAttributes.containsKey(attribute.getName());
            if (clearCache) {
                this.fSourceAttributes.put(attribute.getName(), attribute);
                this.inValidate();
            }
            return clearCache;
        }

        public RAMAssetAttribute getTargetAttribute(String name) {
            if (BatchTarget.this.getMappings().getAssetAttributeNameMappings().containsKey(name)) {
                name = (String)BatchTarget.this.getMappings().getAssetAttributeNameMappings().get(name);
            }
            return BatchTarget.this.fTaregtSession.getAssetAttribute(name);
        }

        public boolean isInError() {
            if (this.fBatchAttributes == null) {
                this.getAttributes();
            }
            return this.fHasError;
        }
    }

    public class BatchAsset {
        private AssetContainer fContainer;
        private boolean fHasError = false;
        private boolean fHasConflict = false;
        private Asset fSourceAsset;
        private RAMAsset fTargetAsset;
        private boolean fSelected;
        private List fForums = new ArrayList();
        private BatchForum[] fForumCache;
        private RAMAssetValidation[] fValidationMessages;

        public BatchAsset(AssetContainer container, Asset sourceAsset, RAMAsset taregtAsset) {
            this.fSourceAsset = sourceAsset;
            this.fTargetAsset = taregtAsset;
            this.fContainer = container;
            if (this.fHasError) {
                this.fContainer.setInError(true);
            }
            if (this.fHasConflict) {
                this.fContainer.setInConflict(true);
            }
        }

        public boolean isSelected() {
            return this.fSelected;
        }

        public void setSelected(boolean selected) {
            this.fSelected = selected;
        }

        public void validate() {
            this.validate(true);
        }

        private void validate(boolean invalidateContainer) {
            boolean oldVal = this.fHasError;
            if (this.fTargetAsset != null) {
                RAMAssetValidation[] messages = this.fTargetAsset.validate();
                this.fHasError = messages.length > 0;
                this.fValidationMessages = messages;
            } else {
                this.fValidationMessages = new RAMAssetValidation[0];
                this.fHasError = false;
            }
            if (invalidateContainer && this.fHasError != oldVal) {
                this.fContainer.validate();
            }
            if (this.fTargetAsset.isUpdate()) {
                this.fHasConflict = true;
            }
        }

        public RAMAssetValidation[] getValidationMessages() {
            return this.fValidationMessages;
        }

        public BatchForum[] getForums() {
            if (this.fForumCache == null) {
                BatchForum[] forums = this.fForums.toArray(new BatchForum[this.fForums.size()]);
                Utilities.sort(forums);
                this.fForumCache = forums;
            }
            return this.fForumCache;
        }

        public boolean addForum(BatchForum forum) {
            boolean clearCache;
            boolean bl = clearCache = !this.fForums.contains(forum);
            if (clearCache) {
                this.fForums.add(forum);
                BatchForum[] forums = this.fForums.toArray(new BatchForum[this.fForums.size()]);
                Utilities.sort(forums);
                this.fForumCache = forums;
            }
            return clearCache;
        }

        public Asset getSourceAsset() {
            return this.fSourceAsset;
        }

        public RAMAsset getTargetAsset() {
            return this.fTargetAsset;
        }

        public void setTargetAsset(RAMAsset newTarget) {
            this.fTargetAsset = newTarget;
        }

        public boolean isInError() {
            return this.fHasError;
        }

        public boolean isInConflict() {
            return this.fHasConflict;
        }

        public String toString() {
            return this.fTargetAsset != null ? this.fTargetAsset.toString() : "<no target set>";
        }
    }

    public class BatchAssetType {
        private AssetTypesContainer fContainer;
        private boolean fHasError = false;
        private AssetType fSourceAssetType;
        private RAMAssetType fTargetAssetType;

        public BatchAssetType(AssetTypesContainer container, AssetType sourceAssetType, RAMAssetType taregtAssetType) {
            this.fSourceAssetType = sourceAssetType;
            this.fTargetAssetType = taregtAssetType;
            this.fContainer = container;
            this.validate(false);
        }

        private void validate(boolean invalidateConatiner) {
            boolean oldVal = this.fHasError;
            boolean bl = this.fHasError = this.fTargetAssetType == null;
            if (invalidateConatiner && this.fHasError != oldVal) {
                this.fContainer.inValidate();
            }
        }

        public AssetType getSourceAssetType() {
            return this.fSourceAssetType;
        }

        public RAMAssetType getTargetAssetType() {
            return this.fTargetAssetType;
        }

        public void setTargetAssetType(RAMAssetType ramAssetType) {
            this.fTargetAssetType = ramAssetType;
            Map mapping = BatchTarget.this.getMappings().getAssetTypeNameMappings();
            if (ramAssetType == null || ramAssetType.getName().equals(this.fSourceAssetType.getName())) {
                mapping.remove(this.fSourceAssetType.getName());
            } else {
                mapping.put(this.fSourceAssetType.getName(), ramAssetType.getName());
            }
            this.validate(true);
        }

        public boolean isInError() {
            return this.fHasError;
        }

        public boolean isCreate() {
            return this.fTargetAssetType != null && this.fTargetAssetType.getAction() != RAMAction.UPDATE;
        }
    }

    public class BatchAttribute {
        private AttributesContainer fContainer;
        private boolean fHasError = false;
        private AssetAttribute fSourceAttribute;
        private RAMAssetAttribute fTargetAttribute;
        private BatchAttributeValue[] fBatchAttributesValues;
        private List fSourceAttributeValues = new ArrayList();

        public BatchAttribute(AttributesContainer container, AssetAttribute sourceAttribute, RAMAssetAttribute taregtAttribute) {
            this.fSourceAttribute = sourceAttribute;
            this.fTargetAttribute = taregtAttribute;
            this.fContainer = container;
            String[] values = sourceAttribute.getValues();
            if (values != null) {
                int i = 0;
                while (i < values.length) {
                    this.fSourceAttributeValues.add(values[i]);
                    ++i;
                }
            }
            this.validate(false);
        }

        public void clear() {
            this.fBatchAttributesValues = null;
        }

        public int getAttributeValuesCount() {
            return this.fSourceAttributeValues.size();
        }

        public void inValidate() {
            this.fBatchAttributesValues = null;
        }

        public BatchAttributeValue[] getAttributeValues() {
            if (this.fBatchAttributesValues == null) {
                this.fBatchAttributesValues = new BatchAttributeValue[this.fSourceAttributeValues.size()];
                String attributeName = this.getSourceAttribute().getName();
                int i = 0;
                for (String sourceAttributeValue : this.fSourceAttributeValues) {
                    String key = AssetUtil.createAssetAttributeValueKey((String)attributeName, (String)sourceAttributeValue);
                    String targetAttributeValue = (String)BatchTarget.this.getMappings().getAssetAttributeValueMappings().get(key);
                    this.fBatchAttributesValues[i] = new BatchAttributeValue(this, sourceAttributeValue, targetAttributeValue);
                    if (this.fBatchAttributesValues[i].isInError()) {
                        this.fHasError = true;
                    }
                    ++i;
                }
            }
            return this.fBatchAttributesValues;
        }

        public boolean addAttributeValue(String attributeValue) {
            boolean clearCache;
            boolean bl = clearCache = !this.fSourceAttributeValues.contains(attributeValue);
            if (clearCache) {
                this.fSourceAttributeValues.add(attributeValue);
                String[] oldValues = this.fSourceAttribute.getValues();
                if (oldValues == null) {
                    oldValues = new String[]{};
                }
                String[] newValues = new String[oldValues.length + 1];
                System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
                newValues[newValues.length - 1] = attributeValue;
                this.fSourceAttribute.setValues(newValues);
                this.inValidate();
            }
            return clearCache;
        }

        private void validate(boolean invalidateConatiner) {
            boolean oldVal = this.fHasError;
            boolean bl = this.fHasError = this.fTargetAttribute == null;
            if (invalidateConatiner && this.fHasError != oldVal) {
                this.fContainer.inValidate();
            }
        }

        public AssetAttribute getSourceAttribute() {
            return this.fSourceAttribute;
        }

        public RAMAssetAttribute getTargetAttribute() {
            return this.fTargetAttribute;
        }

        public void setTargetAttribute(RAMAssetAttribute ramAttribute) {
            this.fTargetAttribute = ramAttribute;
            Map mapping = BatchTarget.this.getMappings().getAssetAttributeNameMappings();
            if (ramAttribute == null || ramAttribute.getName().equals(this.fSourceAttribute.getName())) {
                mapping.remove(this.fSourceAttribute.getName());
            } else {
                mapping.put(this.fSourceAttribute.getName(), ramAttribute.getName());
            }
            this.validate(true);
        }

        public boolean isInError() {
            return this.fHasError;
        }
    }

    public class BatchAttributeValue {
        private BatchAttribute fBatchAttribute;
        private boolean fHasError = false;
        private String fSourceAttributeValue;
        private String fTargetAttributeValue;

        public BatchAttributeValue(BatchAttribute attribute, String sourceAttributeValue, String taregtAttributeValue) {
            this.fSourceAttributeValue = sourceAttributeValue;
            this.fTargetAttributeValue = taregtAttributeValue;
            this.fBatchAttribute = attribute;
            this.validate(false);
        }

        private void validate(boolean invalidateConatiner) {
            String[] values;
            boolean oldVal = this.fHasError;
            this.fHasError = false;
            if (this.fBatchAttribute.getTargetAttribute() != null && this.fBatchAttribute.getTargetAttribute().isRestrictedSetting() && (values = this.fBatchAttribute.getTargetAttribute().getValidValues()) != null) {
                boolean match = false;
                int i = 0;
                while (i < values.length) {
                    if (values[i].equals(this.fTargetAttributeValue)) {
                        match = true;
                        break;
                    }
                    ++i;
                }
                this.fHasError = match;
            }
            if (invalidateConatiner && this.fHasError != oldVal) {
                this.fBatchAttribute.inValidate();
            }
        }

        public String getSourceAttributeValue() {
            return this.fSourceAttributeValue;
        }

        public String getTargetAttributeValue() {
            return this.fTargetAttributeValue;
        }

        public void setTargetAttributeValue(String ramAttributeValue) {
            this.fTargetAttributeValue = ramAttributeValue;
            Map mapping = BatchTarget.this.getMappings().getAssetAttributeValueMappings();
            String key = AssetUtil.createAssetAttributeValueKey((String)this.fBatchAttribute.getSourceAttribute().getName(), (String)this.fSourceAttributeValue);
            if (ramAttributeValue == null || ramAttributeValue.equals(this.fSourceAttributeValue)) {
                mapping.remove(key);
            } else {
                mapping.put(key, ramAttributeValue);
            }
            this.validate(true);
        }

        public boolean isInError() {
            return this.fHasError;
        }
    }

    public class BatchCommunity {
        private CommunityContainer fContainer;
        private boolean fHasError = false;
        private CommunityInformation fSourceCommunity;
        private RAMCommunity fTargetCommunity;

        public BatchCommunity(CommunityContainer container, CommunityInformation sourceCommunity, RAMCommunity taregtCommunity) {
            this.fSourceCommunity = sourceCommunity;
            this.fTargetCommunity = taregtCommunity;
            this.fContainer = container;
            this.validate(false);
        }

        private void validate(boolean invalidateConatiner) {
            boolean oldVal = this.fHasError;
            boolean bl = this.fHasError = this.fTargetCommunity == null;
            if (invalidateConatiner && this.fHasError != oldVal) {
                this.fContainer.inValidate();
            }
        }

        public CommunityInformation getSourceCommunity() {
            return this.fSourceCommunity;
        }

        public RAMCommunity getTargetCommunity() {
            return this.fTargetCommunity;
        }

        public void setTargetCommunity(RAMCommunity ramCommunity) {
            this.fTargetCommunity = ramCommunity;
            Map mapping = BatchTarget.this.getMappings().getCommunityNameMappings();
            if (ramCommunity == null || this.fSourceCommunity.getName().equals(ramCommunity.getName())) {
                mapping.remove(this.fSourceCommunity.getName());
            } else {
                mapping.put(this.fSourceCommunity.getName(), ramCommunity.getName());
            }
            this.validate(true);
        }

        public boolean isInError() {
            return this.fHasError;
        }

        public boolean isCreate() {
            return this.fTargetCommunity != null && this.fTargetCommunity.getAction() != RAMAction.UPDATE;
        }
    }

    public class BatchForum {
        private boolean fHasError = false;
        private Forum fSourceForum;
        private RAMForum fTargetForum;

        public BatchForum(BatchAsset container, Forum sourceForum, RAMForum taregtForum) {
            this.fSourceForum = sourceForum;
            this.fTargetForum = taregtForum;
            this.validate(false);
        }

        private void validate(boolean invalidateConatiner) {
            this.fHasError = false;
        }

        public Forum getSourceForum() {
            return this.fSourceForum;
        }

        public RAMForum getTargetForum() {
            return this.fTargetForum;
        }

        public boolean isInError() {
            return this.fHasError;
        }
    }

    public class BatchRelationshipType {
        private RelationshipTypesContainer fContainer;
        private boolean fHasError = false;
        private RelationshipType fSourceRelationshipType;
        private RAMRelationshipType fTargetRelationshipType;
        private BatchRelationshipType fReverseRelationshipType;

        public BatchRelationshipType(RelationshipTypesContainer container, RelationshipType sourceRelationshipType, RAMRelationshipType taregtRelationshipType) {
            this.fSourceRelationshipType = sourceRelationshipType;
            this.fTargetRelationshipType = taregtRelationshipType;
            this.fContainer = container;
            this.validate(false);
        }

        private void validate(boolean invalidateConatiner) {
            boolean oldVal = this.fHasError;
            boolean bl = this.fHasError = this.fTargetRelationshipType == null;
            if (invalidateConatiner && this.fHasError != oldVal) {
                this.fContainer.inValidate();
            }
        }

        public RelationshipType getSourceRelationshipType() {
            return this.fSourceRelationshipType;
        }

        public RAMRelationshipType getTargetRelationshipType() {
            return this.fTargetRelationshipType;
        }

        public void setTargetRelationshipType(RAMRelationshipType taregtRelationshipType) {
            this.fTargetRelationshipType = taregtRelationshipType;
            Map mapping = BatchTarget.this.getMappings().getRelationshipTypeNameMappings();
            if (taregtRelationshipType == null || this.fSourceRelationshipType.getName().equals(taregtRelationshipType.getName())) {
                mapping.remove(this.fSourceRelationshipType.getName());
            } else {
                mapping.put(this.fSourceRelationshipType.getName(), taregtRelationshipType.getName());
            }
            BatchRelationshipType reverse = this.getReverseType();
            if (reverse != null) {
                if (taregtRelationshipType == null || this.fSourceRelationshipType.getReverseName().equals(taregtRelationshipType.getReverseName())) {
                    mapping.remove(this.fSourceRelationshipType.getReverseName());
                } else {
                    mapping.put(this.fSourceRelationshipType.getReverseName(), taregtRelationshipType.getReverseName());
                }
            }
            this.validate(true);
        }

        public boolean isInError() {
            return this.fHasError;
        }

        public boolean isCreate() {
            return this.fTargetRelationshipType != null && this.fTargetRelationshipType.getAction() != RAMAction.UPDATE;
        }

        public void setReverseType(BatchRelationshipType reverseType) {
            this.fReverseRelationshipType = reverseType;
        }

        public BatchRelationshipType getReverseType() {
            return this.fReverseRelationshipType;
        }

        public String toString() {
            if (this.fTargetRelationshipType != null) {
                return this.fTargetRelationshipType.toString();
            }
            if (this.fSourceRelationshipType != null) {
                return this.fSourceRelationshipType.toString();
            }
            return super.toString();
        }
    }

    public class BatchSubCategory {
        private CategorizationContainer fContainer;
        private boolean fHasError = false;
        private SubCategory fSourceSubCategory;
        private RAMSubCategory fTargetSubCategory;

        public BatchSubCategory(CategorizationContainer container, SubCategory sourceSubCategory, RAMSubCategory taregtSubCategory) {
            this.fSourceSubCategory = sourceSubCategory;
            this.fTargetSubCategory = taregtSubCategory;
            this.fContainer = container;
            this.validate(false);
        }

        private void validate(boolean invalidateConatiner) {
            boolean oldVal = this.fHasError;
            boolean bl = this.fHasError = this.fTargetSubCategory == null;
            if (invalidateConatiner && this.fHasError != oldVal) {
                this.fContainer.inValidate();
            }
        }

        public SubCategory getSourceSubCategory() {
            return this.fSourceSubCategory;
        }

        public RAMSubCategory getTargetSubCategory() {
            return this.fTargetSubCategory;
        }

        public void setTargetSubCategory(RAMSubCategory ramSubCategory) {
            this.fTargetSubCategory = ramSubCategory;
            Map mapping = BatchTarget.this.getMappings().getCategorizationMappings();
            if (ramSubCategory == null || ramSubCategory.getFullPath().equals(this.fSourceSubCategory.getFullPath())) {
                mapping.remove(this.fSourceSubCategory.getFullPath());
            } else {
                mapping.put(this.fSourceSubCategory.getFullPath(), ramSubCategory.getFullPath());
            }
            this.validate(true);
        }

        public boolean isInError() {
            return this.fHasError;
        }
    }

    public class BatchUser {
        private UserContainer fContainer;
        private boolean fHasError = false;
        private UserInformation fSourceUser;
        private RAMUser fTargetUser;

        public BatchUser(UserContainer container, UserInformation sourceUser, RAMUser taregtUser) {
            this.fSourceUser = sourceUser;
            this.fTargetUser = taregtUser;
            this.fContainer = container;
            this.validate(false);
        }

        private void validate(boolean invalidateConatiner) {
            boolean oldVal = this.fHasError;
            boolean bl = this.fHasError = this.fTargetUser == null || !this.fTargetUser.isRegistered();
            if (invalidateConatiner && this.fHasError != oldVal) {
                this.fContainer.inValidate();
            }
        }

        public UserInformation getSourceUser() {
            return this.fSourceUser;
        }

        public RAMUser getTargetUser() {
            return this.fTargetUser;
        }

        public void setTargetUser(RAMUser ramUser) {
            this.fTargetUser = ramUser;
            Map mapping = BatchTarget.this.getMappings().getUserIdMappings();
            if (ramUser == null || this.fSourceUser.getUid().equals(ramUser.getUid())) {
                mapping.remove(this.fSourceUser.getUid());
            } else {
                mapping.put(this.fSourceUser.getUid(), ramUser.getName());
            }
            this.validate(true);
        }

        public boolean isInError() {
            return this.fHasError;
        }
    }

    public class CategorizationContainer {
        private boolean fHasError = false;
        private volatile BatchSubCategory[] fBatchCategorizations;
        private Map fSourceCategorizations = new HashMap();

        public void clear() {
            this.fHasError = false;
            this.fSourceCategorizations.clear();
            this.fBatchCategorizations = null;
        }

        public int getCategoriesCount() {
            return this.fSourceCategorizations.size();
        }

        public void inValidate() {
            this.fHasError = false;
            this.refreshCategorizations();
        }

        public BatchSubCategory[] getCategorizations() {
            if (this.fBatchCategorizations == null) {
                this.refreshCategorizations();
            }
            return this.fBatchCategorizations;
        }

        private void refreshCategorizations() {
            Collection values = this.fSourceCategorizations.values();
            BatchSubCategory[] tmpCache = new BatchSubCategory[values.size()];
            int i = 0;
            for (SubCategory sourceSubCategory : values) {
                tmpCache[i] = new BatchSubCategory(this, sourceSubCategory, this.getTargetSubCategory(sourceSubCategory.getFullPath()));
                if (tmpCache[i].isInError()) {
                    this.fHasError = true;
                }
                ++i;
            }
            Utilities.sort(tmpCache);
            this.fBatchCategorizations = tmpCache;
        }

        public BatchSubCategory getBatchSubCategory(String sourceFullPath) {
            BatchSubCategory[] cats = this.getCategorizations();
            BatchSubCategory ret = null;
            int i = 0;
            while (i < cats.length) {
                if (sourceFullPath != null && sourceFullPath.equals(cats[i].getSourceSubCategory().getFullPath())) {
                    ret = cats[i];
                    break;
                }
                ++i;
            }
            return ret;
        }

        public boolean addCategorization(SubCategory subCategory) {
            boolean clearCache = !this.fSourceCategorizations.containsKey(subCategory.getFullPath());
            this.fSourceCategorizations.put(subCategory.getFullPath(), subCategory);
            if (clearCache) {
                this.inValidate();
            }
            return clearCache;
        }

        public RAMSubCategory getTargetSubCategory(String fullpath) {
            String catgeoryFullPath = fullpath;
            if (BatchTarget.this.getMappings().getCategorizationMappings().containsKey(catgeoryFullPath)) {
                catgeoryFullPath = (String)BatchTarget.this.getMappings().getCategorizationMappings().get(fullpath);
            }
            return (RAMSubCategory)AssetUtil.fetchSubCategory((RAMSession)BatchTarget.this.fTaregtSession, (String)catgeoryFullPath);
        }

        public boolean isInError() {
            if (this.fBatchCategorizations == null) {
                BatchTarget.this.getCommunities();
            }
            return this.fHasError;
        }
    }

    public class CommunityContainer {
        private boolean fHasError = false;
        private volatile BatchCommunity[] fBatchCommunities;
        private Map fSourceCommunities = new HashMap();
        private Map fTargetCommunities = new HashMap();

        public CommunityContainer() {
            this.refreshTargetCommunties();
        }

        private void refreshTargetCommunties() throws RAMRuntimeException {
            RAMCommunity[] allCommunities = BatchTarget.this.fTaregtSession.getAllCommunities();
            int i = 0;
            while (i < allCommunities.length) {
                this.fTargetCommunities.put(allCommunities[i].getName(), allCommunities[i]);
                ++i;
            }
        }

        public void clear() {
            this.fHasError = false;
            this.fSourceCommunities.clear();
            this.fBatchCommunities = null;
        }

        public int getCommunityCount() {
            return this.fSourceCommunities.size();
        }

        public void inValidate() {
            this.fHasError = false;
            this.refreshTargetCommunties();
            this.refreshBatchCommunityList();
        }

        public BatchCommunity[] getCommunities() {
            if (this.fBatchCommunities == null) {
                this.refreshBatchCommunityList();
            }
            return this.fBatchCommunities;
        }

        private void refreshBatchCommunityList() {
            Collection values = this.fSourceCommunities.values();
            BatchCommunity[] tmpCache = new BatchCommunity[values.size()];
            int i = 0;
            for (CommunityInformation sourceCommunity : values) {
                tmpCache[i] = new BatchCommunity(this, sourceCommunity, this.getTargetCommunity(sourceCommunity.getName()));
                if (tmpCache[i].isInError()) {
                    this.fHasError = true;
                }
                ++i;
            }
            Utilities.sort(tmpCache);
            this.fBatchCommunities = tmpCache;
        }

        public boolean addCommunity(CommunityInformation community) {
            if (community == null) {
                return false;
            }
            boolean clearCache = !this.fSourceCommunities.containsKey(community.getName());
            this.fSourceCommunities.put(community.getName(), community);
            if (clearCache) {
                this.inValidate();
            }
            return clearCache;
        }

        public RAMCommunity getTargetCommunity(String name) {
            String communityName = name;
            if (BatchTarget.this.getMappings().getCommunityNameMappings().containsKey(name)) {
                communityName = (String)BatchTarget.this.getMappings().getCommunityNameMappings().get(name);
            }
            return (RAMCommunity)this.fTargetCommunities.get(communityName);
        }

        public boolean isInError() {
            if (this.fBatchCommunities == null) {
                this.getCommunities();
            }
            return this.fHasError;
        }
    }

    public class RelationshipTypesContainer {
        private boolean fHasError = false;
        private Map fRawRelationshipTypes = new HashMap();
        private volatile BatchRelationshipType[] fRelationshipTypes;
        private Map fTargetRelationshipTypes = new HashMap();

        public RelationshipTypesContainer() {
            this.refreshTargetRelationshipTypes();
        }

        private void refreshTargetRelationshipTypes() throws RAMRuntimeException {
            RAMRelationshipType[] allRelationshipTypes = BatchTarget.this.fTaregtSession.getAllRelationshipTypes();
            int i = 0;
            while (i < allRelationshipTypes.length) {
                this.fTargetRelationshipTypes.put(allRelationshipTypes[i].getName(), allRelationshipTypes[i]);
                ++i;
            }
        }

        public void clear() {
            this.fHasError = false;
            this.fRawRelationshipTypes.clear();
            this.fRelationshipTypes = null;
        }

        public int getRelationshipTypesCount() {
            return this.fRawRelationshipTypes.size();
        }

        public void inValidate() {
            this.fHasError = false;
            this.refreshTargetRelationshipTypes();
            this.refreshRelationshipTypes();
        }

        public BatchRelationshipType[] getRelationshipTypes() {
            if (this.fRelationshipTypes == null) {
                this.refreshRelationshipTypes();
            }
            return this.fRelationshipTypes;
        }

        private void refreshRelationshipTypes() {
            Collection values = this.fRawRelationshipTypes.values();
            HashMap<String, BatchRelationshipType> reverseLookupMap = new HashMap<String, BatchRelationshipType>();
            BatchRelationshipType[] tmpCache = new BatchRelationshipType[values.size()];
            int i = 0;
            for (RelationshipType sourceRelationshipType : values) {
                tmpCache[i] = new BatchRelationshipType(this, sourceRelationshipType, this.getTargetRelationshipType(sourceRelationshipType.getName()));
                reverseLookupMap.put(sourceRelationshipType.getName(), tmpCache[i]);
                if (tmpCache[i].isInError()) {
                    this.fHasError = true;
                }
                ++i;
            }
            i = 0;
            while (i < tmpCache.length) {
                String sourceReverseName = tmpCache[i].getSourceRelationshipType().getReverseName();
                BatchRelationshipType reverse = (BatchRelationshipType)reverseLookupMap.get(sourceReverseName);
                if (reverse != null) {
                    tmpCache[i].setReverseType(reverse);
                    reverse.setReverseType(tmpCache[i]);
                }
                ++i;
            }
            Utilities.sort(tmpCache);
            this.fRelationshipTypes = tmpCache;
        }

        public boolean addSourceRelationshipType(RelationshipType relationshipType) {
            boolean clearCache;
            boolean bl = clearCache = !this.fRawRelationshipTypes.containsKey(relationshipType.getName());
            if (clearCache) {
                this.fRawRelationshipTypes.put(relationshipType.getName(), relationshipType);
                this.inValidate();
            }
            return clearCache;
        }

        public RAMRelationshipType getTargetRelationshipType(String name) {
            String typeName = name;
            if (BatchTarget.this.getMappings().getRelationshipTypeNameMappings().containsKey(name)) {
                typeName = (String)BatchTarget.this.getMappings().getRelationshipTypeNameMappings().get(name);
            }
            return (RAMRelationshipType)this.fTargetRelationshipTypes.get(typeName);
        }

        public boolean isInError() {
            if (this.fRelationshipTypes == null) {
                this.getRelationshipTypes();
            }
            return this.fHasError;
        }
    }

    public class UserContainer {
        private boolean fHasError = false;
        private volatile BatchUser[] fBatchUsers;
        private Map fSourceUsers = new HashMap();
        private Map fTargetUsers = new HashMap();

        public void clear() {
            this.fHasError = false;
            this.fSourceUsers.clear();
            this.fBatchUsers = null;
        }

        public int getUserCount() {
            return this.fSourceUsers.size();
        }

        public void inValidate() {
            this.fHasError = false;
            this.fBatchUsers = null;
        }

        public BatchUser[] getUsers() {
            if (this.fBatchUsers == null) {
                Collection values = this.fSourceUsers.values();
                BatchUser[] users = new BatchUser[values.size()];
                int i = 0;
                for (UserInformation sourceUser : values) {
                    users[i] = new BatchUser(this, sourceUser, this.getTargetUser(sourceUser.getUid()));
                    if (users[i].isInError()) {
                        this.fHasError = true;
                    }
                    ++i;
                }
                Utilities.sort(users);
                this.fBatchUsers = users;
            }
            return this.fBatchUsers;
        }

        public boolean addUser(UserInformation user) {
            boolean isNew = false;
            if (!"ram.repositoryprocess".equals(user.getUid()) && !this.fSourceUsers.containsKey(user.getUid())) {
                isNew = true;
                this.fSourceUsers.put(user.getUid(), user);
                this.inValidate();
            }
            return isNew;
        }

        public RAMUser getTargetUser(String userid) {
            RAMUser ret;
            if (BatchTarget.this.getMappings().getUserIdMappings().containsKey(userid)) {
                userid = (String)BatchTarget.this.getMappings().getUserIdMappings().get(userid);
            }
            if ((ret = (RAMUser)this.fTargetUsers.get(userid)) == null) {
                RAMUser targetUser;
                try {
                    ret = BatchTarget.this.fTaregtSession.getUser(userid);
                }
                catch (RAMRuntimeException rAMRuntimeException) {}
                if (!(ret != null && ret.isRegistered() || (targetUser = BatchTarget.this.fTaregtSession.getUser()).isRepositoryAdministrator())) {
                    ret = targetUser;
                    BatchTarget.this.getMappings().getUserIdMappings().put(userid, ret.getUid());
                }
                this.fTargetUsers.put(userid, ret);
            }
            return ret;
        }

        public boolean isInError() {
            if (this.fBatchUsers == null) {
                this.getUsers();
            }
            return this.fHasError;
        }
    }

    public class ValidationStatus {
        private boolean fRunning;

        public ValidationStatus(boolean running) {
            this.fRunning = running;
        }

        public boolean isRunning() {
            return this.fRunning;
        }

        public void setRunning(boolean running) {
            this.fRunning = running;
        }
    }
}

