/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMArtifactReference;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.common.data.Artifact;
import com.ibm.ram.common.data.ArtifactReference;
import com.ibm.ram.common.data.FolderArtifact;
import com.ibm.ram.common.data.URLArtifact;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.emf.ArtifactDetail;
import com.ibm.ram.common.emf.EMFFactory;
import com.ibm.ram.common.util.InputStreamInformation;
import com.ibm.ram.defaultprofile.DefaultprofileFactory;
import com.ibm.ram.internal.client.IRAMArtifact;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import com.ibm.ram.internal.client.util.ClientArtifactAccessor;
import com.ibm.ram.internal.common.data.AssetSO;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;

public class RAMArtifact
extends Artifact
implements IRAMArtifact {
    private RAMAsset fAsset;
    private com.ibm.ram.defaultprofile.Artifact fArtifact;
    private ArtifactDetail fArtifactDetail;
    private ArtifactReference fArtifactReference;
    private ClientArtifactAccessor fClientArtifactAccessor;

    private ClientArtifactAccessor getClientArtifactAccessor() {
        if (this.fClientArtifactAccessor == null && this.fAsset != null) {
            this.fClientArtifactAccessor = new ClientArtifactAccessor(this.fAsset.getOriginalGUID(), this.fAsset.getOriginalVersion(), this.fAsset.getSession().getRAMClient());
        }
        return this.fClientArtifactAccessor;
    }

    RAMArtifact(RAMAsset asset, String path, com.ibm.ram.defaultprofile.Artifact internalServiceArtifact) {
        this.fAsset = asset;
        this.setPath(path);
        this.fArtifact = internalServiceArtifact;
        if (asset != null) {
            AssetSO assetSO = asset.getInternalAsset();
            Artifact artifactFromSO = this.findArtifact(this.fArtifact.getName(), path, "", assetSO.getArtifacts());
            if (artifactFromSO != null) {
                this.fArtifactDetail = EMFFactory.eINSTANCE.createArtifactDetail();
                this.fArtifactDetail.setCreationDate(new Timestamp(artifactFromSO.getCreationDate()));
                this.fArtifactDetail.setSize(artifactFromSO.getSize());
                this.fArtifactDetail.setAdler32CRC(artifactFromSO.getChecksum());
            }
        }
    }

    private Artifact findArtifact(String name, String path, String currentPath, Artifact[] artifacts) {
        Artifact foundArtifact = null;
        Artifact[] children = artifacts;
        if (children != null && children.length > 0) {
            int i = 0;
            while (i < children.length) {
                Artifact currentChild = children[i];
                if (currentChild instanceof FolderArtifact) {
                    String folPath = currentPath;
                    folPath = currentPath == null || currentPath.equals("") ? currentChild.getName() : String.valueOf(folPath) + "/" + currentChild.getName();
                    foundArtifact = this.findArtifact(name, path, folPath, ((FolderArtifact)currentChild).getChildren());
                    if (foundArtifact != null) {
                        break;
                    }
                } else if (!(currentChild instanceof URLArtifact)) {
                    if (currentPath == null) {
                        currentPath = "";
                    }
                    if (path.equalsIgnoreCase(currentPath) && name.equalsIgnoreCase(currentChild.getName())) {
                        foundArtifact = currentChild;
                        break;
                    }
                }
                ++i;
            }
        }
        return foundArtifact;
    }

    RAMArtifact(RAMAsset asset) {
        this(asset, null, DefaultprofileFactory.eINSTANCE.createArtifact());
    }

    protected RAMArtifact() {
        this(null);
    }

    @Override
    public RAMAsset getAsset() {
        return this.fAsset;
    }

    @Override
    public void setAsset(RAMAsset asset) {
        if (asset != this.fAsset) {
            this.fAsset = asset;
            this.fClientArtifactAccessor = null;
        }
    }

    @Override
    public String getName() {
        return this.fArtifact.getName();
    }

    @Override
    public void setName(String name) {
        this.fArtifact.setName(name);
    }

    @Override
    public String getPath() {
        if (super.getPath() == null) {
            EObject parent = this.fArtifact.eContainer();
            if (parent instanceof com.ibm.ram.defaultprofile.Artifact) {
                this.setPath(((com.ibm.ram.defaultprofile.Artifact)parent).computePathInSolution("/"));
            } else {
                this.setPath("");
            }
        }
        return super.getPath();
    }

    @Override
    public void setPath(String path) {
        if (path != null && path.startsWith("/")) {
            super.setPath(path.substring(1));
        } else {
            super.setPath(path);
        }
    }

    public InputStream downloadContents() throws RAMRuntimeException, IOException {
        InputStreamInformation artifactContent = this.downloadContentInformation();
        return artifactContent != null ? artifactContent.getIs() : null;
    }

    public InputStreamInformation downloadContentInformation() {
        ClientArtifactAccessor ca = this.getClientArtifactAccessor();
        if (ca == null) {
            return null;
        }
        return ca.getArtifactContentInformation(this.getInternalArtifact());
    }

    com.ibm.ram.defaultprofile.Artifact getInternalArtifact() throws RAMRuntimeException {
        return this.fArtifact;
    }

    void setInternalArtifact(com.ibm.ram.defaultprofile.Artifact artifact) {
        this.fArtifact = artifact;
    }

    @Override
    public long getCreationDate() {
        if (this.fArtifactDetail == null) {
            this.fecthArtifactDetail();
        }
        long time = -1L;
        if (this.fArtifactDetail != null) {
            time = this.fArtifactDetail.getCreationDate().getTime();
        }
        return time;
    }

    @Override
    public String getType() {
        return "file";
    }

    @Override
    public long getSize() {
        this.getAsset().getInternalAsset().getArtifacts();
        if (this.fArtifactDetail == null) {
            this.fecthArtifactDetail();
        }
        long size = -1L;
        if (this.fArtifactDetail != null) {
            size = this.fArtifactDetail.getSize();
        }
        return size;
    }

    private void fecthArtifactDetail() {
    }

    @Override
    public String getLabel() {
        if (this.fAsset != null) {
            try {
                return this.getAsset().getManifestBuilder().getLabel(this.fArtifact);
            }
            catch (RAMRuntimeException rAMRuntimeException) {
                throw new RAMRuntimeException(MessageFormat.format(ClientMessages.getString("RAMArtifact.NO_LABEL_FROM_NULL_ASSET"), this), true);
            }
        }
        return super.getLabel();
    }

    @Override
    public void setLabel(String label) {
        if (this.fAsset != null) {
            try {
                this.getAsset().getManifestBuilder().setLabel(label, this.fArtifact);
            }
            catch (RAMRuntimeException rAMRuntimeException) {
                throw new RAMRuntimeException(MessageFormat.format(ClientMessages.getString("RAMArtifact.NO_LABEL_TO_NULL_ASSET"), label, this), true);
            }
        } else {
            super.setLabel(label);
        }
    }

    @Override
    public String getMimeType() {
        String mimeType = null;
        if (this.fAsset != null) {
            try {
                mimeType = this.getAsset().getManifestBuilder().getFormat(this.fArtifact);
            }
            catch (RAMRuntimeException rAMRuntimeException) {
                throw new RAMRuntimeException(MessageFormat.format(ClientMessages.getString("RAMArtifact.NO_LABEL_FROM_NULL_ASSET"), this), true);
            }
        } else {
            mimeType = super.getMimeType();
        }
        return mimeType;
    }

    @Override
    public void setMimeType(String mimeType) {
        if (this.fAsset != null) {
            try {
                this.getAsset().getManifestBuilder().setFormat(mimeType, this.fArtifact);
            }
            catch (RAMRuntimeException e) {
                throw new RAMRuntimeException("Unexpected exception setting a mime type", e);
            }
        } else {
            super.setMimeType(mimeType);
        }
    }

    @Override
    public ArtifactReference getReference() {
        if (this.fArtifactReference == null) {
            this.fArtifactReference = new RAMArtifactReference(this);
        }
        return this.fArtifactReference;
    }

    @Override
    public void setCreationDate(long creationDate) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMArtifact.METHOD_NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setReference(ArtifactReference reference) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMArtifact.METHOD_NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setSize(long size) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMArtifact.METHOD_NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setType(String type) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMArtifact.TYPE_CANNOT_BE_CAHNGED"), true);
    }
}

