/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMD;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

public class RAMPassword {
    private static final String PWKEY = "ramPassword";
    private String password;

    public RAMPassword(File passwordFile) {
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(passwordFile);
                Properties props = new Properties();
                props.loadFromXML(is);
                String pw = props.getProperty(PWKEY);
                if (pw == null) {
                    throw new RAMRuntimeException("Password file doesn't contain a password.", true);
                }
                this.password = RAMD.getDC(pw);
            }
            catch (InvalidPropertiesFormatException e) {
                throw new RAMRuntimeException(e, true);
            }
            catch (IOException e) {
                throw new RAMRuntimeException(e, true);
            }
        }
        catch (Throwable throwable) {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (is != null) {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
    }

    public RAMPassword(String encryptedPW) {
        this.password = RAMD.getDC(encryptedPW);
    }

    public static String getEncryptedPassword(String password) {
        return RAMD.getEC(password);
    }

    public static void createPasswordFile(String password, File passwordFile) throws RAMRuntimeException {
        OutputStream fs = null;
        try {
            try {
                Properties props = new Properties();
                props.put(PWKEY, RAMPassword.getEncryptedPassword(password));
                fs = new FileOutputStream(passwordFile);
                props.storeToXML(fs, "RAM");
            }
            catch (IOException e) {
                throw new RAMRuntimeException(e, true);
            }
        }
        catch (Throwable throwable) {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (fs != null) {
            try {
                fs.close();
            }
            catch (IOException iOException) {}
        }
    }

    String getPassword() {
        StackTraceElement caller = new RuntimeException().getStackTrace()[1];
        if (!RAMSession.class.getName().equals(caller.getClassName())) {
            throw new IllegalAccessError();
        }
        return this.password;
    }
}

