/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMAction;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.client.RAMUser;
import com.ibm.ram.internal.jaxb.Subscription;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import org.oslc.asset.internal.ResourceRef;

public class RAMSubscription {
    private Subscription fSubscription;
    private RAMAsset fAsset;
    private RAMSession fSession;
    private RAMUser fUser;
    private RAMAction fAction;

    RAMSubscription(RAMAsset asset, Subscription subscription) {
        this.fAsset = asset;
        this.fSubscription = subscription;
    }

    public RAMSubscription(String subscriptionName, RAMUser user) {
        this.fSubscription = new Subscription();
        this.setUser(user);
        this.fSubscription.setTitle(subscriptionName);
        this.fSubscription.setFrequency(Subscription.Frequency.DEFAULT);
        this.markDirty();
    }

    public RAMUser getUser() {
        if (this.fUser == null && this.fSubscription.getUser() != null && this.fSubscription.getUser().getResource() != null && this.getSession() != null) {
            String id = JAXBLinksUtil.getUserIdentifier(this.fSubscription.getUser().getResource());
            this.fUser = this.getSession().getUser(id);
        }
        return this.fUser;
    }

    void setUser(RAMUser user) {
        if (user != null) {
            this.fUser = user;
            String userResource = JAXBLinksUtil.getUserIdentifier(user.getUid());
            ResourceRef ref = new ResourceRef(userResource);
            ref.setValue(user.getName());
            this.fSubscription.setUser(ref);
        }
    }

    public Frequency getFrequency() {
        if (this.fSubscription == null || this.fSubscription.getFrequency() == null) {
            return Frequency.DEFAULT;
        }
        switch (this.fSubscription.getFrequency()) {
            case DAILY: {
                return Frequency.DAILY;
            }
            case IMMEDIATE: {
                return Frequency.IMMEDIATE;
            }
            case MONTHLY: {
                return Frequency.MONTHLY;
            }
            case WEEKLY: {
                return Frequency.WEEKLY;
            }
        }
        return Frequency.DEFAULT;
    }

    public void setFrequency(Frequency frequency) {
        if (frequency == null) {
            this.fSubscription.setFrequency(Subscription.Frequency.DEFAULT);
        } else {
            switch (frequency) {
                case DAILY: {
                    this.fSubscription.setFrequency(Subscription.Frequency.DAILY);
                    break;
                }
                case IMMEDIATE: {
                    this.fSubscription.setFrequency(Subscription.Frequency.IMMEDIATE);
                    break;
                }
                case MONTHLY: {
                    this.fSubscription.setFrequency(Subscription.Frequency.MONTHLY);
                    break;
                }
                case WEEKLY: {
                    this.fSubscription.setFrequency(Subscription.Frequency.WEEKLY);
                    break;
                }
                default: {
                    this.fSubscription.setFrequency(Subscription.Frequency.DEFAULT);
                }
            }
        }
        this.markDirty();
    }

    public String getName() {
        return this.fSubscription.getTitle();
    }

    public void setName(String name) {
        this.fSubscription.setTitle(name);
        this.markDirty();
    }

    public String getIdentifier() {
        return this.fSubscription.getIdentifier();
    }

    void setIdentifier(String id) {
        this.fSubscription.setIdentifier(id);
    }

    Subscription getInternalSubscription() {
        return this.fSubscription;
    }

    void setInternalSubscription(Subscription subscription) {
        this.fSubscription = subscription;
    }

    RAMAsset getAsset() {
        return this.fAsset;
    }

    RAMSession getSession() {
        if (this.fSession == null && this.fAsset != null) {
            this.fSession = this.fAsset.getSession();
        }
        return this.fSession;
    }

    void setAsset(RAMAsset asset) {
        this.fAsset = asset;
    }

    boolean isDity() {
        return this.fAction == null;
    }

    void markDirty() {
        if (this.fAction == null && this.getIdentifier() != null) {
            this.fAction = RAMAction.UPDATE;
        } else if (this.fAction == null) {
            this.fAction = RAMAction.CREATE;
        }
        if (this.fAsset != null) {
            this.fAsset.setSubscriptionsDirty(true);
        }
    }

    public RAMAction getAction() {
        return this.fAction;
    }

    public void setAction(RAMAction action) {
        this.fAction = action;
        this.markDirty();
    }

    public String getResourceURI() {
        return this.fSubscription.getAbout();
    }

    public static enum Frequency {
        IMMEDIATE,
        DAILY,
        WEEKLY,
        MONTHLY,
        DEFAULT;

    }
}

