/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import com.ibm.ram.common.emf.ArtifactConstraintType;
import com.ibm.ram.common.emf.ArtifactMatch;
import com.ibm.ram.common.emf.EMFFactory;
import com.ibm.ram.common.emf.NamespaceMapping;
import com.ibm.ram.common.emf.XMLArtifactCategoryConstraint;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.defaultprofile.Artifact;
import com.ibm.ram.internal.common.data.XMLArtifactAttributeConstraint;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;

public class XMLUtility {
    private static final String ELEMENT_REG_EX = "(.+)\\[(.*)\\]";
    private static final Pattern ELEMENT_PATTERN = Pattern.compile("(.+)\\[(.*)\\]");
    private static final char[] RESERVED_CHARS = new char[]{'[', ']', '\''};
    private static final Pattern NAME_SPACE_PATTERN = Pattern.compile("xmlns:?(\\S*)?=\"(\\S*)\"");

    public static NamespaceMapping[] getNamespaceMappings(CharSequence content) {
        ArrayList<NamespaceMapping> ret = new ArrayList<NamespaceMapping>();
        Matcher m = NAME_SPACE_PATTERN.matcher(content);
        while (m.find()) {
            String prefix = m.group(1);
            String uri = m.group(2);
            if (prefix == null || "".equals(prefix)) {
                prefix = "default";
            }
            NamespaceMapping mapping = EMFFactory.eINSTANCE.createNamespaceMapping();
            mapping.setPrefix(prefix);
            mapping.setURI(uri);
            ret.add(mapping);
        }
        return ret.toArray(new NamespaceMapping[ret.size()]);
    }

    public static String getFileExtension(String filename) {
        String extension = "";
        if (filename.indexOf(".") != -1 && (extension = filename.substring(filename.lastIndexOf(".") + 1)).endsWith("\"")) {
            extension = extension.substring(0, extension.length() - 1);
        }
        return extension;
    }

    public static Object evaluateXPathExpression(InputStream xmlContent, String XPathExpression, NamespaceMapping[] namespaces) throws Exception {
        SAXBuilder builder = new SAXBuilder(false);
        Document document = builder.build(xmlContent);
        JDOMXPath xpath = new JDOMXPath(XPathExpression);
        NamespaceMapping[] namespaceMappings = namespaces;
        if (namespaceMappings != null && namespaceMappings.length > 0) {
            SimpleNamespaceContext context = new SimpleNamespaceContext();
            int j = 0;
            while (j < namespaceMappings.length) {
                NamespaceMapping mapping = namespaceMappings[j];
                context.addNamespace(mapping.getPrefix(), mapping.getURI());
                ++j;
            }
            xpath.setNamespaceContext((NamespaceContext)context);
        }
        return xpath.evaluate((Object)document);
    }

    public static boolean matchesFileTypes(XMLArtifactCategoryConstraint constaint, Artifact artifact) {
        String fileName = artifact.getName();
        return XMLUtility.match(constaint, fileName);
    }

    private static boolean match(XMLArtifactCategoryConstraint constaint, String fileName) {
        boolean match = false;
        EList matches = constaint.getArtifactMatches();
        int i = 0;
        while (i < matches.size()) {
            ArtifactMatch aMatch = (ArtifactMatch)matches.get(i);
            if (aMatch.getMatchType() == ArtifactConstraintType.FILE_EXTENSION_LITERAL && fileName.endsWith(aMatch.getMatchPattern())) {
                match = true;
                break;
            }
            ++i;
        }
        return match;
    }

    public static boolean matchesFileTypes(XMLArtifactCategoryConstraint constaint, File file) {
        String fileName = file.getName();
        return XMLUtility.match(constaint, fileName);
    }

    public static boolean matchesFileTypes(XMLArtifactAttributeConstraint constaint, Artifact artifact) {
        String fileName = artifact.getName();
        return XMLUtility.match(constaint, fileName);
    }

    public static boolean matchesFileTypes(XMLArtifactAttributeConstraint constaint, File file) {
        String fileName = file.getName();
        return XMLUtility.match(constaint, fileName);
    }

    private static boolean match(XMLArtifactAttributeConstraint constaint, String fileName) {
        boolean match = false;
        String[] matches = constaint.getFileTypesArray();
        int i = 0;
        while (i < matches.length) {
            if (fileName.endsWith(matches[i])) {
                match = true;
                break;
            }
            ++i;
        }
        return match;
    }

    public static String getStringValue(Object xpathResult) {
        ArrayList<Object> results;
        StringBuilder value = new StringBuilder();
        if (xpathResult instanceof List) {
            results = (ArrayList<Object>)xpathResult;
        } else {
            results = new ArrayList<Object>();
            results.add(xpathResult);
        }
        int i = 0;
        while (i < results.size()) {
            String val;
            boolean skipResult = false;
            Object curResult = results.get(i);
            if (curResult instanceof Attribute) {
                value.append(XMLUtility.cleanResult(((Attribute)curResult).getName()));
                value.append("=");
                value.append("'" + XMLUtility.cleanResult(((Attribute)curResult).getValue()) + "'");
            } else if (curResult instanceof Element) {
                Element el = (Element)curResult;
                value.append(XMLUtility.cleanResult(el.getName()));
                List atts = el.getAttributes();
                value.append("[");
                if (atts != null) {
                    int j = 0;
                    while (j < atts.size()) {
                        value.append(XMLUtility.cleanResult(((Attribute)atts.get(j)).getName()));
                        value.append("=");
                        value.append("'" + XMLUtility.cleanResult(((Attribute)atts.get(j)).getValue()) + "'");
                        if (j < atts.size() - 1) {
                            value.append(" and ");
                        }
                        ++j;
                    }
                }
                value.append("]");
            } else if (curResult instanceof org.w3c.dom.Text) {
                val = XMLUtility.cleanResult(((org.w3c.dom.Text)curResult).getNodeValue());
                if (!UtilitiesCommon.isEmptyString(val)) {
                    value.append("'" + val + "'");
                } else {
                    skipResult = true;
                }
            } else if (curResult instanceof Text) {
                val = XMLUtility.cleanResult(((Text)curResult).getTextTrim());
                if (!UtilitiesCommon.isEmptyString(val)) {
                    value.append("'" + val + "'");
                } else {
                    skipResult = true;
                }
            } else if (curResult != null) {
                val = XMLUtility.cleanResult(curResult);
                if (!UtilitiesCommon.isEmptyString(val)) {
                    value.append("'" + val + "'");
                } else {
                    skipResult = true;
                }
            } else {
                value.append("null");
            }
            if (!skipResult && i < results.size() - 1) {
                value.append(";");
            }
            ++i;
        }
        return value.toString();
    }

    private static String cleanResult(Object curResult) {
        if (curResult == null) {
            curResult = "";
        }
        String ret = curResult.toString().trim();
        int i = 0;
        while (i < RESERVED_CHARS.length) {
            if (ret.indexOf(RESERVED_CHARS[i]) != -1) {
                ret = ret.replace(RESERVED_CHARS[i], ' ');
            }
            ++i;
        }
        return ret;
    }

    public static XMLResult hydrateResult(String val) {
        Matcher m = ELEMENT_PATTERN.matcher(val);
        boolean match = false;
        XMLResult ret = new XMLResult();
        while (m.find()) {
            match = true;
            if (m.groupCount() != 2) continue;
            String element = m.group(1);
            ret.setElement(element);
            String[] attributes = m.group(2).split(" and ");
            ArrayList<String[]> attributePairs = new ArrayList<String[]>();
            int j = 0;
            while (j < attributes.length) {
                String[] nameValue = attributes[j].split("=");
                if (nameValue != null && nameValue.length == 2) {
                    String[] pair = new String[]{nameValue[0].trim(), XMLUtility.removeQuotes(nameValue[1])};
                    attributePairs.add(pair);
                }
                ++j;
            }
            String[][] retPairs = (String[][])attributePairs.toArray((T[])new String[attributePairs.size()][]);
            ret.setAttributes(retPairs);
        }
        if (!match && val.indexOf("=") != -1) {
            String[] attributes = val.split("=");
            ret.setAttributes(new String[1][2]);
            ret.getAttributes()[0][0] = attributes[0].trim();
            ret.getAttributes()[0][1] = XMLUtility.removeQuotes(attributes[1]);
        } else if (!match) {
            ret.setStringValue(XMLUtility.removeQuotes(val));
        }
        return ret;
    }

    private static String removeQuotes(String toTrim) {
        if ((toTrim = toTrim.trim()).startsWith("'")) {
            toTrim = toTrim.substring(1);
        }
        if (toTrim.endsWith("'")) {
            toTrim = toTrim.substring(0, toTrim.length() - 1);
        }
        return toTrim;
    }

    public static class XMLResult {
        public String fElement;
        public String[][] fAttributes;
        public String fStringValue;

        public String getElement() {
            return this.fElement;
        }

        public void setElement(String element) {
            this.fElement = element;
        }

        public String[][] getAttributes() {
            return this.fAttributes;
        }

        public void setAttributes(String[][] attributes) {
            this.fAttributes = attributes;
        }

        public String getStringValue() {
            return this.fStringValue;
        }

        public void setStringValue(String stringValue) {
            this.fStringValue = stringValue;
        }
    }
}

