/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.rest;

import com.ibm.ram.internal.common.bundles.CommonMessages;
import com.ibm.ram.internal.rest.NotModifiedException;
import com.ibm.ram.internal.rest.PreconditionFailedException;
import com.ibm.ram.internal.rest.ResourceCollisionException;
import java.sql.Timestamp;
import java.text.MessageFormat;

public interface RequestStatus {
    public static final RequestStatus ALWAYS_RETURN_STATUS = new RequestStatus(){

        @Override
        public boolean shouldReturnContent(Timestamp lastmodified, String etag) {
            return true;
        }

        @Override
        public boolean shouldUpdateContent(Timestamp lastmodified, String etag) {
            return true;
        }

        @Override
        public void setContentStatus(ContentStatus contentStatus) {
        }

        @Override
        public ContentStatus getContentStatus() {
            return ContentStatus.matched;
        }

        @Override
        public HTTPMethod getMethod() {
            return HTTPMethod.GET;
        }

        @Override
        public boolean isHead() {
            return false;
        }

        @Override
        public boolean isGetOrHead() {
            return true;
        }

        @Override
        public boolean isInfoOnly() {
            return false;
        }

        @Override
        public void throwStatus(String contentIdentification) throws ResourceCollisionException, NotModifiedException, PreconditionFailedException {
        }
    };
    public static final long NO_MODIFIED_SINCE_TAG = -1L;
    public static final Timestamp NO_MODIFIED_SINCE_TIMESTAMP = null;
    public static final String IF_MODIFIED_SINCE_HEADER = "If-Modified-Since";
    public static final String IF_NONE_MATCH_HEADER = "If-None-Match";
    public static final String IF_UNMODIFIED_SINCE_HEADER = "If-Unmodified-Since";
    public static final String IF_MATCH_HEADER = "If-Match";

    public boolean shouldReturnContent(Timestamp var1, String var2);

    public boolean shouldUpdateContent(Timestamp var1, String var2);

    public ContentStatus getContentStatus();

    public void setContentStatus(ContentStatus var1);

    public void throwStatus(String var1) throws ResourceCollisionException, NotModifiedException, PreconditionFailedException;

    public HTTPMethod getMethod();

    public boolean isHead();

    public boolean isGetOrHead();

    public boolean isInfoOnly();

    public static abstract class BasicRequestStatus
    implements RequestStatus {
        private ContentStatus contentStatus = ContentStatus.matched;
        private boolean infoOnly;

        @Override
        public ContentStatus getContentStatus() {
            return this.contentStatus;
        }

        @Override
        public void setContentStatus(ContentStatus contentStatus) {
            this.contentStatus = contentStatus;
        }

        protected abstract long getIfModifiedSince();

        protected abstract long getIfUnmodifiedSince();

        protected abstract String[] getIfNoneMatch();

        protected abstract String[] getIfMatch();

        public static String[] parseIfETAG(String ifetags) {
            if (ifetags != null) {
                return ifetags.trim().split("(\\s)+");
            }
            return null;
        }

        @Override
        public boolean shouldReturnContent(Timestamp lastmodified, String etag) {
            this.setContentStatus(this.isMatch(lastmodified, etag));
            if (this.isHead()) {
                this.infoOnly = true;
                return false;
            }
            return this.getContentStatus() == ContentStatus.matched;
        }

        @Override
        public boolean shouldUpdateContent(Timestamp lastmodified, String etag) {
            this.setContentStatus(this.isMatch(lastmodified, etag));
            return this.getContentStatus() == ContentStatus.matched;
        }

        protected ContentStatus isMatch(Timestamp lastmodified, String etag) {
            if (this.getIfModifiedSince() != -1L || this.getIfNoneMatch() != null) {
                Match modsince = Match.notInHeader;
                if (lastmodified != NO_MODIFIED_SINCE_TIMESTAMP && this.getIfModifiedSince() != -1L) {
                    long lastmod;
                    long ifmodsince = this.getIfModifiedSince() / 1000L;
                    modsince = ifmodsince < (lastmod = lastmodified.getTime() / 1000L) ? Match.matched : Match.notMatched;
                }
                Match etagNonematch = Match.notInHeader;
                String[] h = this.getIfNoneMatch();
                if (h != null) {
                    etagNonematch = Match.matched;
                    String[] stringArray = h;
                    int n = h.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String et = stringArray[n2];
                        if ("*".equals(et) || et.equals(etag)) {
                            etagNonematch = Match.notMatched;
                            break;
                        }
                        ++n2;
                    }
                }
                switch (etagNonematch) {
                    case matched: {
                        return ContentStatus.matched;
                    }
                    case notMatched: {
                        switch (modsince) {
                            case matched: {
                                return ContentStatus.matched;
                            }
                        }
                        return this.isGetOrHead() ? ContentStatus.contentNotModified : ContentStatus.matchFailed;
                    }
                }
                switch (modsince) {
                    default: {
                        return ContentStatus.matched;
                    }
                    case notMatched: 
                }
                return this.isGetOrHead() ? ContentStatus.contentNotModified : ContentStatus.matchFailed;
            }
            if (this.getIfUnmodifiedSince() != -1L || this.getIfMatch() != null) {
                Match unmodsince = Match.notInHeader;
                if (lastmodified != NO_MODIFIED_SINCE_TIMESTAMP && this.getIfUnmodifiedSince() != -1L) {
                    long lastmod;
                    long ifunmodsince = this.getIfUnmodifiedSince() / 1000L;
                    unmodsince = ifunmodsince < (lastmod = lastmodified.getTime() / 1000L) ? Match.notMatched : Match.matched;
                }
                Match etagMatch = Match.notInHeader;
                String[] h = this.getIfMatch();
                if (h != null) {
                    etagMatch = Match.notMatched;
                    String[] stringArray = h;
                    int n = h.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String et = stringArray[n3];
                        if ("*".equals(et) || et.equals(etag)) {
                            etagMatch = Match.matched;
                            break;
                        }
                        ++n3;
                    }
                }
                switch (etagMatch) {
                    default: {
                        switch (unmodsince) {
                            case notMatched: {
                                return ContentStatus.matchFailed;
                            }
                        }
                        return ContentStatus.matched;
                    }
                    case notMatched: 
                }
                return ContentStatus.matchFailed;
            }
            return ContentStatus.matched;
        }

        @Override
        public boolean isInfoOnly() {
            return this.infoOnly;
        }

        @Override
        public void throwStatus(String contentIdentification) throws ResourceCollisionException, NotModifiedException, PreconditionFailedException {
            switch (this.contentStatus) {
                case conflict: {
                    throw new ResourceCollisionException(null, null, MessageFormat.format(CommonMessages.getString("rest_conflict"), contentIdentification));
                }
                case contentNotModified: {
                    throw new NotModifiedException();
                }
                case matchFailed: {
                    throw new PreconditionFailedException(MessageFormat.format(CommonMessages.getString("rest_precondition"), contentIdentification));
                }
            }
        }

        private static enum Match {
            notInHeader,
            matched,
            notMatched;

        }
    }

    public static enum ContentStatus {
        matched,
        contentNotModified,
        conflict,
        matchFailed;

    }

    public static class ETagRequestStatus
    extends BasicRequestStatus {
        private final String[] etags;
        private ContentStatus status = ContentStatus.matched;

        public ETagRequestStatus(String etag) {
            this.etags = new String[]{etag};
        }

        @Override
        public ContentStatus getContentStatus() {
            return this.status;
        }

        @Override
        public void setContentStatus(ContentStatus contentStatus) {
            this.status = contentStatus;
        }

        @Override
        public HTTPMethod getMethod() {
            return HTTPMethod.GET;
        }

        @Override
        public boolean isHead() {
            return false;
        }

        @Override
        public boolean isGetOrHead() {
            return true;
        }

        @Override
        protected long getIfModifiedSince() {
            return -1L;
        }

        @Override
        public long getIfUnmodifiedSince() {
            return -1L;
        }

        @Override
        protected String[] getIfNoneMatch() {
            return this.etags;
        }

        @Override
        public String[] getIfMatch() {
            return null;
        }
    }

    public static enum HTTPMethod {
        GET,
        HEAD,
        PUT,
        DELETE,
        POST;

    }
}

