/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.io.File;

public class FileCheckinCommand
extends OutputCleartoolCommand {
    private File[] viewFiles = null;
    private String comment = null;

    public FileCheckinCommand(File[] viewFiles, String comment) {
        this.viewFiles = viewFiles;
        this.comment = comment;
    }

    @Override
    protected String[] getArguments() {
        String[] args = new String[4 + this.viewFiles.length];
        args[0] = "checkin";
        args[1] = "-c";
        args[2] = this.comment;
        args[3] = "-identical";
        int fc = 0;
        while (fc < this.viewFiles.length) {
            args[fc + 4] = this.viewFiles[fc].getAbsolutePath();
            ++fc;
        }
        return args;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(final String output, String error) {
        return new CheckinCommandOutput(){

            @Override
            public String[] getVersions() {
                String[] versions = new String[FileCheckinCommand.this.viewFiles.length];
                int fc = 0;
                while (fc < FileCheckinCommand.this.viewFiles.length) {
                    String path = FileCheckinCommand.this.viewFiles[fc].getAbsolutePath();
                    String inOutput = "\"" + path + "\"";
                    int inOutputIndex = output.indexOf(inOutput);
                    if (inOutputIndex < 0) {
                        versions[fc] = null;
                    } else {
                        int versionStartQuoteIndex = output.indexOf(34, inOutputIndex + inOutput.length() + 1);
                        int versionEndQuoteIndex = output.indexOf(34, versionStartQuoteIndex + 1);
                        if (versionStartQuoteIndex > -1 && versionEndQuoteIndex > -1 && versionStartQuoteIndex < versionEndQuoteIndex) {
                            versions[fc] = output.substring(versionStartQuoteIndex + 1, versionEndQuoteIndex);
                        }
                    }
                    ++fc;
                }
                return versions;
            }
        };
    }

    public static interface CheckinCommandOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public String[] getVersions();
    }
}

