/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractEventList<E>
implements List<E> {
    protected final List<E> list;

    public AbstractEventList(List<E> list) {
        this.list = list;
    }

    protected abstract void applyChanged(boolean var1);

    @Override
    public void add(int index, E element) {
        this.list.add(index, element);
        this.applyChanged(true);
    }

    @Override
    public boolean add(E o) {
        return this.returnIt(this.list.add(o));
    }

    protected boolean returnIt(boolean changed) {
        this.applyChanged(changed);
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.returnIt(this.list.addAll(c));
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.returnIt(this.list.addAll(index, c));
    }

    @Override
    public void clear() {
        this.list.clear();
        this.applyChanged(true);
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.list.equals(o);
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new EventIterator(this.list.listIterator());
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new EventIterator(this.list.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new EventIterator(this.list.listIterator());
    }

    @Override
    public E remove(int index) {
        this.applyChanged(true);
        return this.list.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.returnIt(this.list.remove(o));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.returnIt(this.list.removeAll(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.returnIt(this.list.retainAll(c));
    }

    @Override
    public E set(int index, E element) {
        this.applyChanged(true);
        return this.list.set(index, element);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new EventSublist(this.list.subList(fromIndex, toIndex));
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    private class EventIterator
    implements ListIterator<E> {
        private final ListIterator<E> li;

        public EventIterator(ListIterator<E> li) {
            this.li = li;
        }

        @Override
        public void add(E o) {
            this.li.add(o);
            AbstractEventList.this.applyChanged(true);
        }

        @Override
        public boolean hasNext() {
            return this.li.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.li.hasPrevious();
        }

        @Override
        public E next() {
            return this.li.next();
        }

        @Override
        public int nextIndex() {
            return this.li.nextIndex();
        }

        @Override
        public E previous() {
            return this.li.previous();
        }

        @Override
        public int previousIndex() {
            return this.li.previousIndex();
        }

        @Override
        public void remove() {
            this.li.remove();
            AbstractEventList.this.applyChanged(true);
        }

        @Override
        public void set(E o) {
            this.li.set(o);
            AbstractEventList.this.applyChanged(true);
        }
    }

    private class EventSublist
    extends AbstractEventList<E> {
        public EventSublist(List<E> sublist) {
            super(sublist);
        }

        @Override
        protected void applyChanged(boolean changed) {
            AbstractEventList.this.applyChanged(changed);
        }
    }
}

