/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client;

import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.common.data.UserInformation;
import com.ibm.ram.common.util.RAMURLEncoder;
import com.ibm.ram.internal.client.AbstractRAMClient;
import com.ibm.ram.internal.client.IRESTCacheManager;
import com.ibm.ram.internal.client.RAMServiceException;
import com.ibm.ram.internal.client.util.StringUtils;
import com.ibm.ram.internal.common.bundles.StoredMessage;
import com.ibm.ram.internal.jaxb.Action;
import com.ibm.ram.internal.jaxb.Asset;
import com.ibm.ram.internal.jaxb.AssetID;
import com.ibm.ram.internal.jaxb.Comment;
import com.ibm.ram.internal.jaxb.Community;
import com.ibm.ram.internal.jaxb.ExitCondition;
import com.ibm.ram.internal.jaxb.Lifecycle;
import com.ibm.ram.internal.jaxb.Link;
import com.ibm.ram.internal.jaxb.ObjectFactory;
import com.ibm.ram.internal.jaxb.Permissions;
import com.ibm.ram.internal.jaxb.Repository;
import com.ibm.ram.internal.jaxb.Reviewer;
import com.ibm.ram.internal.jaxb.StateConfiguration;
import com.ibm.ram.internal.jaxb.StateHistory;
import com.ibm.ram.internal.jaxb.User;
import com.ibm.ram.internal.jaxb.UserGroup;
import com.ibm.ram.internal.jaxb.Vote;
import com.ibm.ram.internal.jaxb.Workflow;
import com.ibm.ram.internal.jaxb.atom.FeedType;
import com.ibm.ram.internal.jaxb.util.FeedIterator;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import com.ibm.ram.internal.jaxb.util.JAXButil;
import com.ibm.ram.internal.rest.AbstractRestService;
import com.ibm.ram.internal.rest.RAMRestException;
import com.ibm.ram.internal.rest.Request;
import com.ibm.ram.internal.rest.Response;
import com.ibm.ram.internal.rest.RestDispatcher;
import com.ibm.ram.internal.rest.RestService;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import org.oslc.asset.internal.CompactRendering;
import org.oslc.asset.internal.Preview;
import org.oslc.asset.internal.ResourceRef;

public abstract class AbstractRESTClient
extends RestDispatcher {
    public static final String LOCK_ACTION = "lockAsset";
    public static final String UNLOCK_ACTION = "unlockAsset";
    private final AbstractRAMClient client;
    private String serverPath;
    private IRESTCacheManager cacheManager = this.getRestCacheManager();
    private User fUser;

    protected AbstractRESTClient(AbstractRAMClient client) {
        this.client = client;
        if (client.isAnonymous) {
            this.serverPath = client.getWebServerPath();
            if (this.serverPath == null) {
                this.serverPath = client.getWebServicesPath();
            }
        } else {
            this.serverPath = client.getWebServicesPath();
        }
        if (this.serverPath.endsWith("/")) {
            this.serverPath = this.serverPath.substring(0, this.serverPath.length() - 1);
        }
    }

    public void clearStateHistoriesCache(Link<Asset> assetRef) {
        if (assetRef != null) {
            Link<StateHistory> currentStateHistory;
            Link<List<StateHistory>> reviewHistoriesLink = JAXBLinksUtil.getStateHistoriesLink(assetRef);
            if (!StringUtils.isBlank(reviewHistoriesLink.getHref())) {
                this.cacheManager.clearCache(reviewHistoriesLink.getHref());
            }
            if (!StringUtils.isBlank((currentStateHistory = JAXBLinksUtil.getStateHistoryLink(assetRef, "current")).getHref())) {
                this.cacheManager.clearCache(currentStateHistory.getHref());
            }
        }
    }

    public User getUser() throws RAMServiceException {
        if (this.fUser == null) {
            try {
                UserInformation remoteUser = this.getRAMClient().getRAM1Webservice().getUser();
                this.fUser = JAXButil.getUser(remoteUser);
                Link<User> userLink = JAXBLinksUtil.getLink(this.fUser);
                User jaxUser = (User)this.getRestService(userLink, User.class).doGet().getValue();
                this.fUser.getUserGroups().clear();
                if (jaxUser != null) {
                    this.fUser.getUserGroups().addAll(jaxUser.getUserGroups());
                }
            }
            catch (RAMServiceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
            }
        }
        return this.fUser;
    }

    public Permissions getAssetPermission(AssetIdentification asset) throws RAMServiceException {
        try {
            Link<Asset> link = JAXBLinksUtil.getOSLCAssetLink(asset);
            link.setHref(String.valueOf(link.getHref()) + ".perm");
            return (Permissions)this.getRestService(link, Permissions.class).doGet().getValue();
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public Asset getAsset(AssetIdentification asset) throws RAMServiceException {
        try {
            Link<Asset> link = JAXBLinksUtil.getAssetLink(asset);
            return (Asset)this.getRestService(link, Asset.class).doGet().getValue();
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public InputStream getArtifactContent(AssetIdentification asset, String artifactPath) throws RAMServiceException {
        try {
            AssetID id = new AssetID();
            id.setGUID(asset.getGUID());
            id.setVersion(asset.getVersion());
            String artifactContentURL = JAXBLinksUtil.getOSLCArtifactContentURL(id, artifactPath);
            JAXBLinksUtil.getLink(artifactPath, artifactPath);
            Request request = new Request(artifactContentURL);
            return this.getRestService(request).doGetContent();
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public CompactRendering getUserCompactRendering(UserInformation userInfo) throws RAMServiceException {
        try {
            User user = JAXButil.getUser(userInfo);
            Link<User> link = JAXBLinksUtil.getLink(user);
            link.setHref(String.valueOf(link.getHref()) + ".jcr");
            return (CompactRendering)this.getRestService(link, User.class).doGet().getValue();
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public String getUserPreviewURL(UserInformation userInfo, String previewType) throws RAMServiceException {
        String previewURL = null;
        CompactRendering cr = this.getUserCompactRendering(userInfo);
        if (cr != null && previewType != null) {
            if (previewType.equals("smallPreview")) {
                previewURL = cr.getSmallPreview().getResource();
            }
            if (previewType.equals("largePreview")) {
                previewURL = cr.getLargePreview().getResource();
            }
        }
        return previewURL;
    }

    public CompactRendering getAssetCompactRendering(AssetIdentification asset) throws RAMServiceException {
        try {
            Link<Asset> link = JAXBLinksUtil.getOSLCAssetLink(asset);
            link.setHref(String.valueOf(link.getHref()) + ".jcr");
            return (CompactRendering)this.getRestService(link, Asset.class).doGet().getValue();
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public String getAssetPreviewURL(AssetIdentification asset, String previewType) throws RAMServiceException {
        String previewURL = null;
        CompactRendering cr = this.getAssetCompactRendering(asset);
        if (cr != null && previewType != null) {
            Preview p = null;
            if (previewType.equals("smallPreview") && (p = cr.getSmallPreview()) == null) {
                p = cr.getLargePreview();
            }
            if (previewType.equals("largePreview") && (p = cr.getLargePreview()) == null) {
                p = cr.getSmallPreview();
            }
            if (p != null) {
                previewURL = p.getResource();
            }
        }
        return previewURL;
    }

    public String getAssetPreviewIconURL(AssetIdentification asset) throws RAMServiceException {
        String iconURL = null;
        CompactRendering cr = this.getAssetCompactRendering(asset);
        if (cr != null) {
            iconURL = cr.getIcon().getResource();
        }
        return iconURL;
    }

    public FeedIterator<Action> getAvailableActions(AssetIdentification assetId) throws RAMServiceException {
        return this.getAvailableActions(assetId, false);
    }

    public FeedIterator<Action> getAvailableActions(AssetIdentification assetId, boolean bypassCache) throws RAMServiceException {
        Link<List<Action>> actionsLink = JAXBLinksUtil.getAvailableActionsLink(assetId);
        Request request = new Request(this.getContext());
        request.setLink(actionsLink);
        request.setRequestingClass(FeedType.class);
        if (bypassCache) {
            request.getHeadersMap().put("Cache-Control", "no-store");
        }
        try {
            FeedType feed = (FeedType)this.getRestService(request).doGet().getValue();
            return new FeedIterator<Action>(feed);
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public Asset createAsset(Asset asset) throws RAMServiceException, RAMRestException {
        Link<List<Asset>> assetsLink = JAXBLinksUtil.getDraftAssetsLink();
        JAXBElement<Asset> element = new ObjectFactory().createAsset(asset);
        assetsLink.setValue((List<Asset>)element);
        Request request = new Request(this.getContext());
        request.setLink(assetsLink);
        request.setRequestingClass(Asset.class);
        asset = (Asset)this.getRestService(request).doPost().getValue();
        Action save = new Action();
        save.setIdentifier("submit");
        save.setName("Submit");
        Workflow workflow = new Workflow();
        workflow.setIdentifier("com.ibm.ram.legacy");
        workflow.setName("Legacy Workflow");
        asset.setAction(JAXBLinksUtil.getLink(save));
        Link<JAXBElement<Asset>> draftAssetLink = JAXBLinksUtil.getLink("Draft Asset", asset.getHref(), new ObjectFactory().createAsset(asset));
        request.setLink(draftAssetLink);
        asset = (Asset)this.getRestService(request).doPut().getValue();
        return asset;
    }

    public Response<Lifecycle> getLifecycle(AssetIdentification asset) throws RAMServiceException {
        return this.getLifecycle(asset, false);
    }

    public Response<Lifecycle> getLifecycle(AssetIdentification asset, boolean bypassCache) throws RAMServiceException {
        Response<Lifecycle> lifecycle = null;
        if (asset != null) {
            String resourcePath = JAXBLinksUtil.getLifecyleLink(asset).getHref();
            Request request = new Request(resourcePath);
            if (bypassCache) {
                request.getHeadersMap().put("Cache-Control", "no-store");
            }
            if ((lifecycle = this.cacheManager.getResource(this, request, Lifecycle.class, true)) != null) {
                this.populateLifecycle(lifecycle.getValue());
            }
        }
        return lifecycle;
    }

    public User getUser(Link<User> userLink) throws RAMServiceException {
        Response<User> resource;
        User user = null;
        if (userLink != null && (resource = this.cacheManager.getResource(this, new Request(userLink.getHref()), User.class, true)) != null) {
            user = resource.getValue();
        }
        return user;
    }

    public FeedIterator<UserGroup> getUserGroups(int communityID, String query) throws RAMServiceException {
        FeedIterator user = null;
        if (communityID > -1) {
            try {
                String path = "internal/userGroups.xml?tid=" + communityID + "&q=" + query.trim();
                Link<Object> ugLink = JAXBLinksUtil.getLink("UserGroup Search", path, null);
                Request request = new Request(this.getContext());
                request.setLink(ugLink);
                request.setRequestingClass(FeedType.class);
                FeedType feed = (FeedType)this.getRestService(request).doGet().getValue();
                if (feed != null) {
                    user = new FeedIterator(feed);
                }
            }
            catch (RAMRestException e) {
                throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
            }
        }
        return user;
    }

    public Lifecycle getLifecycle(Link<Community> communityRef, String identifier) throws RAMServiceException {
        try {
            Link<Lifecycle> link = JAXBLinksUtil.getLifecycleLink(communityRef, identifier);
            return (Lifecycle)this.getRestService(link, Lifecycle.class).doGet().getValue();
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public FeedIterator<Lifecycle> getMasterLifecycles() throws RAMServiceException {
        Link masterLifecyclesLink = JAXBLinksUtil.getMasterLifecycles();
        Request request = new Request(this.getContext());
        request.setLink(masterLifecyclesLink);
        request.setRequestingClass(FeedType.class);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("oslc.properties", "atom:content");
        request.setParameterMap(paramMap);
        try {
            FeedType feed = (FeedType)this.getRestService(request).doGet().getValue();
            return new FeedIterator<Lifecycle>(feed);
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public Lifecycle createMasterLifecycle(String name, String description, Link<Workflow> workflow) throws RAMServiceException {
        Link masterLifecyclesLink = JAXBLinksUtil.getMasterLifecycles();
        Lifecycle lifecycle = new Lifecycle();
        lifecycle.setDescription(description);
        lifecycle.setName(name);
        lifecycle.setWorkflow(workflow);
        JAXBElement<Lifecycle> element = new ObjectFactory().createLifecyle(lifecycle);
        masterLifecyclesLink.setValue(element);
        Request request = new Request(this.getContext());
        request.setLink(masterLifecyclesLink);
        request.setRequestingClass(Lifecycle.class);
        try {
            lifecycle = (Lifecycle)this.getRestService(request).doPost().getValue();
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
        if (lifecycle != null) {
            this.populateLifecycle(lifecycle);
        }
        return lifecycle;
    }

    public Lifecycle createLifecycle(String name, String description, Link<Community> communityRef, ResourceRef masterLifecycleLink) throws RAMServiceException {
        Link<List<Lifecycle>> communityLifecyclesLink = JAXBLinksUtil.getLifecylesLink(communityRef);
        Lifecycle lifecycle = new Lifecycle();
        lifecycle.setCommunity(communityRef);
        lifecycle.setDescription(description);
        lifecycle.setName(name);
        lifecycle.setMaster(masterLifecycleLink);
        JAXBElement<Lifecycle> element = new ObjectFactory().createLifecyle(lifecycle);
        communityLifecyclesLink.setValue((List<Lifecycle>)element);
        Request request = new Request(this.getContext());
        request.setLink(communityLifecyclesLink);
        request.setRequestingClass(Lifecycle.class);
        try {
            lifecycle = (Lifecycle)this.getRestService(request).doPost().getValue();
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
        if (lifecycle != null) {
            this.populateLifecycle(lifecycle);
        }
        return lifecycle;
    }

    public Lifecycle updateLifecycle(Lifecycle lifecycle) throws RAMServiceException {
        Link<Lifecycle> communityLifecyclesLink = JAXBLinksUtil.getCommunityLifecycleLink(lifecycle);
        JAXBElement<Lifecycle> element = new ObjectFactory().createLifecyle(lifecycle);
        communityLifecyclesLink.setValue((Lifecycle)element);
        Request request = new Request(this.getContext());
        request.setLink(communityLifecyclesLink);
        request.setRequestingClass(Lifecycle.class);
        try {
            lifecycle = (Lifecycle)this.getRestService(request).doPut().getValue();
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
        if (lifecycle != null) {
            this.populateLifecycle(lifecycle);
        }
        return lifecycle;
    }

    public void deleteLifecycle(Lifecycle lifecycle) throws RAMServiceException {
        try {
            Link<Lifecycle> lifecycleLink = JAXBLinksUtil.getLifecycleLink(lifecycle.getCommunity(), lifecycle.getIdentifier());
            this.getRestService(lifecycleLink, Lifecycle.class).doDelete();
        }
        catch (RAMRestException e) {
            e.printStackTrace();
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public Lifecycle getLifecycle(Asset asset) throws RAMServiceException {
        Link link = JAXBLinksUtil.getAssetLifecycles();
        JAXBElement<Asset> jaxAsset = new ObjectFactory().createAsset(asset);
        Lifecycle ret = this.cacheManager.postResource(this, link.getHref(), jaxAsset, Lifecycle.class).getValue();
        if (ret != null) {
            this.populateLifecycle(ret);
        }
        return ret;
    }

    private void populateLifecycle(Lifecycle ret) throws RAMServiceException {
        HashMap<String, Action> idToActionMap = new HashMap<String, Action>();
        if (ret != null) {
            List<StateConfiguration> stateConfigurations;
            List<Action> actions;
            if (ret.getWorkflow() != null && ret.getWorkflow().getValue() == null) {
                ret.getWorkflow().setValue(this.getWorkflow(ret));
            }
            if ((actions = ret.getWorkflow().getValue().getActions()) != null) {
                for (Action action : actions) {
                    idToActionMap.put(action.getIdentifier(), action);
                }
            }
            if ((stateConfigurations = ret.getStateConfigurations()) != null) {
                for (StateConfiguration stateConfiguration : stateConfigurations) {
                    Set<Reviewer> reviewers;
                    List<ExitCondition> exitConditions = stateConfiguration.getExitConditions();
                    if (exitConditions != null) {
                        for (ExitCondition exitCondition : exitConditions) {
                            if (exitCondition.getAction() == null || exitCondition.getAction().getValue() != null) continue;
                            String id = JAXBLinksUtil.getActionIdentifier(exitCondition.getAction());
                            exitCondition.getAction().setValue((Action)idToActionMap.get(id));
                        }
                    }
                    if ((reviewers = stateConfiguration.getReviewers()) == null) continue;
                    for (Reviewer reviewer : reviewers) {
                        if (reviewer == null || reviewer.getUser() == null || reviewer.getUser().getValue() != null) continue;
                        User user = this.getUser(reviewer.getUser());
                        reviewer.getUser().setValue(user);
                    }
                }
            }
        }
    }

    public void putAssetAction(Asset asset, String actionID) throws RAMServiceException {
        Link<Action> createAction;
        boolean create;
        String resourcePath = JAXBLinksUtil.getLink(asset).getHref();
        if (!StringUtils.isBlank(actionID)) {
            resourcePath = String.valueOf(resourcePath) + "?action=" + actionID;
        }
        boolean bl = create = (createAction = asset.getAction()) == null || !actionID.equals(JAXBLinksUtil.getActionIdentifier(createAction));
        if (create) {
            Action action = new Action();
            action.setIdentifier(actionID);
            action.setWorkflow(asset.getLifecycle().getValue().getWorkflow());
            createAction = JAXBLinksUtil.getLink(action);
            asset.setAction(createAction);
        }
        JAXBElement<Asset> createAsset = new ObjectFactory().createAsset(asset);
        this.cacheManager.putResource(this, resourcePath, createAsset, Asset.class);
    }

    public boolean checkAsset(String guid, String version) throws RAMServiceException, RAMRestException {
        String internalAssetUri = JAXBLinksUtil.getAssetHref(new AssetID(guid, version));
        Link link = JAXBLinksUtil.getLink(internalAssetUri);
        Request request = new Request(this.getContext());
        request.setLink(link);
        request.getHeadersMap().put("If-Asset-Exist", "true");
        int status = this.getRestService(request).doHead().getStatus();
        return status != 404 && status != 400;
    }

    public void changeAssetLockStatus(Asset asset, boolean lock, StoredMessage updateComment) throws RAMServiceException {
        StringBuilder resourcePath = new StringBuilder(JAXBLinksUtil.getLink(asset).getHref());
        resourcePath.append('?').append("action").append('=').append(lock ? LOCK_ACTION : UNLOCK_ACTION);
        if (updateComment != null) {
            resourcePath.append('&').append("comment").append('=').append(RAMURLEncoder.encode(updateComment.toString()));
        }
        JAXBElement<Asset> createAsset = new ObjectFactory().createAsset(asset);
        this.cacheManager.putResource(this, resourcePath.toString(), createAsset, Asset.class);
    }

    public Lifecycle putAssetLifecycle(AssetIdentification asset, Lifecycle lifecycle) throws RAMServiceException, RAMRestException {
        Link<Lifecycle> link = JAXBLinksUtil.getLifecyleLink(asset);
        link.setValue((Lifecycle)new ObjectFactory().createLifecyle(lifecycle));
        Request request = new Request(this.getContext());
        request.setLink(link);
        request.setRequestingClass(Lifecycle.class);
        lifecycle = (Lifecycle)this.getRestService(request).doPut().getValue();
        return lifecycle;
    }

    public Workflow getWorkflow(Lifecycle lifecycle) throws RAMServiceException {
        Workflow workflow = null;
        if (lifecycle != null) {
            String resourcePath = lifecycle.getWorkflow().getHref();
            Response<Workflow> resource = this.cacheManager.getResource(this, new Request(resourcePath), Workflow.class, true);
            workflow = resource == null ? null : resource.getValue();
        }
        return workflow;
    }

    public Response<FeedIterator<StateHistory>> getStateHistories(Link<Asset> assetRef) throws RAMServiceException {
        Link<List<StateHistory>> reviewHistoriesLink = JAXBLinksUtil.getStateHistoriesLink(assetRef);
        Request request = new Request(this.getContext());
        request.setLink(reviewHistoriesLink);
        request.setRequestingClass(FeedType.class);
        try {
            Response doGet = this.getRestService(request).doGet();
            FeedType feed = (FeedType)doGet.getValue();
            Response<FeedIterator<StateHistory>> response = new Response<FeedIterator<StateHistory>>(null);
            response.setLastModified(doGet.getLastModified());
            response.setValue(new FeedIterator(feed));
            return response;
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public Response<StateHistory> getStateHistory(Link<Asset> assetRef, String identifier) throws RAMServiceException {
        Link<StateHistory> reviewHistoryLink = JAXBLinksUtil.getStateHistoryLink(assetRef, identifier);
        try {
            Response history = this.getRestService(reviewHistoryLink, StateHistory.class).doGet();
            return history;
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public Response<StateHistory> getCurrentStateHistory(Link<Asset> assetRef) throws RAMServiceException {
        return this.getStateHistory(assetRef, "current");
    }

    public FeedIterator<Lifecycle> getLifecycles(Link<Community> communityRef) throws RAMServiceException {
        Link<List<Lifecycle>> lifecyclesLink = JAXBLinksUtil.getLifecylesLink(communityRef);
        Request request = new Request(this.getContext());
        request.getHeadersMap().put("Cache-Control", "no-store");
        request.getParameterMap().put("oslc.properties", "atom:content");
        request.setLink(lifecyclesLink);
        request.setRequestingClass(FeedType.class);
        try {
            FeedType feed = (FeedType)this.getRestService(request).doGet().getValue();
            return new FeedIterator<Lifecycle>(feed);
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public FeedIterator<Workflow> getWorkflows() throws RAMServiceException {
        Link<List<Workflow>> workflowsLink = JAXBLinksUtil.getWorkflowsLink();
        Request request = new Request(this.getContext());
        request.setLink(workflowsLink);
        request.setRequestingClass(FeedType.class);
        try {
            FeedType feed = (FeedType)this.getRestService(request).doGet().getValue();
            return new FeedIterator<Workflow>(feed);
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public Community getCommunity(String identifier) throws RAMServiceException {
        Community community = new Community();
        community.setIdentifier(identifier);
        Link<Community> communityLink = JAXBLinksUtil.getLink(community);
        Request request = new Request(this.getContext());
        request.setLink(communityLink);
        request.setRequestingClass(Community.class);
        try {
            community = (Community)this.getRestService(request).doGet().getValue();
            return community;
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public Comment getComment(Link<StateHistory> stateHistoryRef, String commentId) throws RAMServiceException {
        Comment comment = new Comment();
        comment.setIdentifier(commentId);
        Link<Comment> commentLink = JAXBLinksUtil.getLink(stateHistoryRef, comment);
        Request request = new Request(this.getContext());
        request.setLink(commentLink);
        request.setRequestingClass(Comment.class);
        try {
            comment = (Comment)this.getRestService(request).doGet().getValue();
            return comment;
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public FeedIterator<Comment> getComments(Link<StateHistory> stateHistoryRef) throws RAMServiceException {
        Link<List<Comment>> commentsLink = JAXBLinksUtil.getCommentsLink(stateHistoryRef);
        Request request = new Request(this.getContext());
        request.setLink(commentsLink);
        request.setRequestingClass(FeedType.class);
        try {
            FeedType feed = (FeedType)this.getRestService(request).doGet().getValue();
            return new FeedIterator<Comment>(feed);
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public Comment postComment(Link<StateHistory> stateHistoryRef, Comment comment) throws RAMServiceException {
        Link<List<Comment>> commentsLink = JAXBLinksUtil.getCommentsLink(stateHistoryRef);
        commentsLink.setValue((List<Comment>)new ObjectFactory().createComment(comment));
        Request request = new Request(this.getContext());
        request.setLink(commentsLink);
        request.setRequestingClass(Comment.class);
        try {
            comment = (Comment)this.getRestService(request).doPost().getValue();
            return comment;
        }
        catch (RAMRestException e) {
            e.printStackTrace();
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public void putVote(Link<Asset> asset, String stateHistoryID, Vote vote) throws RAMServiceException {
        StateHistory createStateHistory = new ObjectFactory().createStateHistory();
        createStateHistory.getVotes().add(vote);
        Link<StateHistory> shLink = JAXBLinksUtil.getStateHistoryLink(asset, stateHistoryID);
        shLink.setValue((StateHistory)new ObjectFactory().createStateHistory(createStateHistory));
        Request request = new Request(this.getContext());
        request.setLink(shLink);
        request.setRequestingClass(StateHistory.class);
        try {
            this.getRestService(request).doPut().getValue();
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public Workflow getWorkflow(String identifier) throws RAMServiceException {
        Workflow workflow = new Workflow();
        workflow.setIdentifier(identifier);
        Link<Workflow> workflowLink = JAXBLinksUtil.getLink(workflow);
        Request request = new Request(this.getContext());
        request.setLink(workflowLink);
        request.setRequestingClass(Workflow.class);
        try {
            workflow = (Workflow)this.getRestService(request).doGet().getValue();
            return workflow;
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public String getServerPath() {
        return this.serverPath;
    }

    public AbstractRAMClient getRAMClient() {
        return this.client;
    }

    public Repository getRepository() throws RAMServiceException {
        Link<Repository> link = JAXBLinksUtil.getRepositoryLink();
        Request request = new Request(this.getContext());
        request.setLink(link);
        request.setRequestingClass(Repository.class);
        try {
            return (Repository)this.getRestService(request).doGet().getValue();
        }
        catch (RAMRestException e) {
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    protected void setServerPath(String serverPath) {
        this.serverPath = serverPath;
    }

    public void deleteAssetRating(AssetIdentification assetId) throws RAMServiceException {
        try {
            Link assetRatingLink = JAXBLinksUtil.getAssetRatingLink(assetId);
            this.getRestService(assetRatingLink, null).doDelete();
        }
        catch (RAMRestException e) {
            e.printStackTrace();
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public String[] getAssetVersionsQuery(AssetIdentification assetId) throws RAMServiceException {
        try {
            Link assetRatingLink = JAXBLinksUtil.getAssetVersionsQuery(this.client.getUserName(), assetId);
            Response response = this.getRestService(assetRatingLink, null).doGet();
            return (String[])response.getValue();
        }
        catch (RAMRestException e) {
            e.printStackTrace();
            throw new RAMServiceException(10006, e.getLocalizedMessage(), e);
        }
    }

    public abstract RestService getRestService(String var1, Class var2);

    @Override
    public abstract RestService getRestService(Link var1, Class var2);

    @Override
    public abstract AbstractRestService getRestService(Request var1);

    protected abstract IRESTCacheManager getRestCacheManager();
}

