/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm;

import com.ibm.ram.common.data.AssetInformation;
import com.ibm.ram.defaultprofile.Artifact;
import com.ibm.ram.defaultprofile.Asset;
import com.ibm.ram.defaultprofile.Reference;
import com.ibm.ram.internal.common.bundles.CommonMessages;
import com.ibm.ram.internal.scm.ListProperties;
import com.ibm.ram.internal.scm.ccvs.CVSReference;
import com.ibm.ram.internal.scm.clearcase.BaseClearCaseReference;
import com.ibm.ram.scm.SCMException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Properties;

public class Utilities {
    public static String serializeProperties(Properties properties) throws IOException {
        String serialized = null;
        if (properties != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            properties.store(bos, null);
            StringBuilder sb = new StringBuilder(bos.toString());
            while (sb.length() > 0 && sb.charAt(0) == '#') {
                int nextLine = 0;
                boolean endStarted = false;
                int i = 1;
                while (i < sb.length()) {
                    nextLine = i;
                    char c = sb.charAt(i);
                    if (c == '\n' || c == '\r') {
                        endStarted = true;
                    } else if (endStarted) break;
                    ++i;
                }
                sb.delete(0, nextLine);
            }
            serialized = sb.toString();
        }
        return serialized;
    }

    public static Properties deSerializeProperties(String serializedProperties) throws IOException {
        ListProperties properties = null;
        if (serializedProperties != null) {
            properties = new ListProperties();
            properties.load(new ByteArrayInputStream(serializedProperties.getBytes()));
        }
        return properties;
    }

    public static String getAssetLabel(Asset asset) {
        String id = asset.getId();
        String version = asset.getVersion();
        String newID = Utilities.getOnlyLettersOrDigits(id);
        String newVersion = Utilities.getOnlyLettersOrDigits(version);
        String label = "RAM_" + newID + "_" + newVersion;
        return label;
    }

    public static String getAssetLabel(AssetInformation asset) {
        String id = asset.getIdentification().getGUID();
        String version = asset.getIdentification().getVersion();
        String newID = Utilities.getOnlyLettersOrDigits(id);
        String newVersion = Utilities.getOnlyLettersOrDigits(version);
        String label = "RAM_" + newID + "_" + newVersion;
        return label;
    }

    public static String getOnlyLettersOrDigits(String input) {
        StringBuffer lettersOrDigits = new StringBuffer();
        if (input != null) {
            StringCharacterIterator cItr = new StringCharacterIterator(input);
            char c = cItr.current();
            while (c != '\uffff') {
                if (Character.isLetterOrDigit(c)) {
                    lettersOrDigits.append(c);
                }
                c = cItr.next();
            }
        }
        return lettersOrDigits.toString();
    }

    public static String processCRLF(String string) {
        String processed = null;
        if (string != null) {
            StringBuffer s = new StringBuffer(string);
            String RETURN = "\\r";
            String LINEFEED = "\\n";
            int rIndex = s.indexOf(RETURN);
            while (rIndex > -1) {
                s.replace(rIndex, rIndex + RETURN.length(), "\r");
                rIndex = s.indexOf(RETURN, rIndex + 1);
            }
            int nIndex = s.indexOf(LINEFEED);
            while (nIndex > -1) {
                s.replace(nIndex, nIndex + LINEFEED.length(), "\n");
                nIndex = s.indexOf(LINEFEED, nIndex + 1);
            }
            processed = s.toString();
        }
        return processed;
    }

    public static SCMInformation getSCMInformation(Artifact ramArtifact) {
        SCMInformation scmInfo = new SCMInformation();
        try {
            Reference artifactReference = ramArtifact.getReference();
            if (artifactReference != null && artifactReference.getReferenceKind() != null) {
                scmInfo.scmReference = artifactReference;
            }
        }
        catch (Throwable throwable) {
            scmInfo.scmReference = null;
        }
        boolean bl = scmInfo.scmFile = scmInfo.scmReference != null;
        if (scmInfo.scmFile) {
            boolean bl2 = scmInfo.scmDescriptionPresent = scmInfo.scmReference.getDescription() != null;
            if (scmInfo.scmDescriptionPresent) {
                try {
                    scmInfo.scmProperties = Utilities.getDisplayProperties(scmInfo.scmReference);
                }
                catch (IOException iOException) {
                    scmInfo.scmProperties = new Properties();
                }
                scmInfo.scmDescriptionValue = scmInfo.scmReference.getDescription().getValue();
            }
        }
        return scmInfo;
    }

    private static Properties getDisplayProperties(Reference ref) throws IOException {
        Properties p = Utilities.deSerializeProperties(ref.getDescription().getValue());
        if ("cvs".equals(ref.getReferenceKind().getName()) && (p == null || p.size() < 1)) {
            try {
                CVSReference cvsRef = CVSReference.parseReferenceValue(ref);
                p = cvsRef.getDisplayProperties();
            }
            catch (SCMException sCMException) {}
        } else if ("clearcase".equals(ref.getReferenceKind().getName()) && p != null && !p.containsKey("LABEL")) {
            try {
                BaseClearCaseReference ccRef = BaseClearCaseReference.parseReferenceValue(ref, false);
                p = ccRef.getDisplayProperties();
            }
            catch (SCMException sCMException) {}
        }
        return p;
    }

    public static void appendSCMInformation(StringBuffer content, boolean isSCMFile, boolean isSCMDescriptionPresent, Properties scmProperties) {
        if (isSCMFile) {
            content.append("<span>" + CommonMessages.getString("Artifacts_InfopopSpanSCMProps") + "</span>");
            try {
                Properties p = null;
                if (isSCMDescriptionPresent) {
                    p = scmProperties;
                    if (p == null) {
                        p = new Properties();
                    }
                    content.append("<table border=\"0\" style=\"overflow:hidden\">");
                    Enumeration<Object> keys = p.keys();
                    while (keys.hasMoreElements()) {
                        String prop = (String)keys.nextElement();
                        String value = p.getProperty(prop);
                        value = value.replaceAll("\\\\", "\\\\\\\\");
                        content.append("<tr>");
                        content.append("<td><b>" + prop.replace('_', ' ') + "</b>:</td>");
                        if (!value.startsWith("<a ")) {
                            content.append("<td><div title=\"" + value + "\">" + com.ibm.ram.internal.common.util.Utilities.addWordBreakTags(value) + "</div></td>");
                        } else {
                            content.append("<td><b>" + value + "</b></td>");
                        }
                        content.append("</tr>");
                    }
                    content.append("</table>");
                }
            }
            catch (Throwable throwable) {
                content.append("<br><i>" + CommonMessages.getString("Artifacts_InfopopSCMCurrentlyUnavailable") + "</i>");
            }
        }
    }

    public static class SCMInformation {
        public boolean scmFile = false;
        public boolean scmDescriptionPresent = false;
        public String scmDescriptionValue = "";
        public Properties scmProperties = new Properties();
        public Reference scmReference = null;
    }
}

