/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.types;

import com.ibm.ram.client.LocalFileArtifact;
import com.ibm.ram.client.LocalFolderArtifact;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAssetType;
import com.ibm.ram.client.RAMCommunity;
import com.ibm.ram.client.RAMFolderArtifact;
import com.ibm.ram.client.RAMUser;
import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.data.RelationshipType;
import com.ibm.ram.common.data.SubCategory;
import com.ibm.ram.common.data.UserInformation;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.types.Artifact;
import com.ibm.ram.internal.client.ant.types.ArtifactSet;
import com.ibm.ram.internal.client.ant.types.Artifacts;
import com.ibm.ram.internal.client.ant.types.AssetType;
import com.ibm.ram.internal.client.ant.types.Attribute;
import com.ibm.ram.internal.client.ant.types.Categories;
import com.ibm.ram.internal.client.ant.types.Category;
import com.ibm.ram.internal.client.ant.types.Community;
import com.ibm.ram.internal.client.ant.types.Description;
import com.ibm.ram.internal.client.ant.types.Guid;
import com.ibm.ram.internal.client.ant.types.Name;
import com.ibm.ram.internal.client.ant.types.Owner;
import com.ibm.ram.internal.client.ant.types.RAMDataType;
import com.ibm.ram.internal.client.ant.types.Reference;
import com.ibm.ram.internal.client.ant.types.RelatedAsset;
import com.ibm.ram.internal.client.ant.types.RelatedAssets;
import com.ibm.ram.internal.client.ant.types.Server;
import com.ibm.ram.internal.client.ant.types.ShortDescription;
import com.ibm.ram.internal.client.ant.types.Tag;
import com.ibm.ram.internal.client.ant.types.Version;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.ArchiveScanner;
import org.apache.tools.ant.types.Resource;

public class Asset
extends RAMDataType {
    private String guid;
    private String version;
    private RAMAsset asset;
    private AssetType assetType;
    private Community community;
    private Description description;
    private Name name;
    private ShortDescription shortDescription;
    private Version newVersion;
    private Guid newGuid;
    private List owners = new ArrayList();
    private List tags = new ArrayList();
    private List attributes = new ArrayList();
    private List artifacts = new ArrayList();
    private List categories = new ArrayList();
    private List relatedAssets = new ArrayList();
    private List artifactSets = new ArrayList();
    private Artifacts artifactsList;
    private RelatedAssets relatedAssetsList;
    private Categories categoryList;
    private File tmpFolder;

    public void add(Community community) {
        if (this.community != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)community);
        } else {
            community.setParent(this);
            this.community = community;
        }
    }

    public void add(Attribute attribute) {
        attribute.setParent(this);
        this.attributes.add(attribute);
    }

    public void add(Version version) {
        if (this.newVersion != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)version);
        } else {
            this.newVersion = version;
        }
    }

    public void add(Guid guid) {
        if (this.newGuid != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)guid);
        } else {
            this.newGuid = guid;
        }
    }

    public void add(Name name) {
        if (this.name != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)name);
        } else {
            this.name = name;
        }
    }

    public void add(Description description) {
        if (this.description != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)description);
        } else {
            this.description = description;
        }
    }

    public void add(ShortDescription shortDescription) {
        if (this.shortDescription != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)shortDescription);
        } else {
            this.shortDescription = shortDescription;
        }
    }

    public void add(AssetType assetType) {
        if (this.assetType != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)assetType);
        } else {
            assetType.setParent(this);
            this.assetType = assetType;
        }
    }

    public void add(Tag tag) {
        this.tags.add(tag);
    }

    public void add(Owner owner) {
        owner.setParent(this);
        this.owners.add(owner);
    }

    public void add(Artifact artifact) {
        artifact.setParent(this);
        this.artifacts.add(artifact);
    }

    public void add(Artifacts artifactsList) {
        artifactsList.setParent(this);
        this.artifactsList = artifactsList;
    }

    public void add(ArtifactSet set) {
        this.artifactSets.add(set);
    }

    public void add(Category category) {
        category.setParent(this);
        this.categories.add(category);
    }

    public void add(Categories categories) {
        categories.setParent(this);
        this.categoryList = categories;
    }

    public void add(RelatedAsset relatedAsset) {
        relatedAsset.setParent(this);
        this.relatedAssets.add(relatedAsset);
    }

    public void add(RelatedAssets relatedAssets) {
        relatedAssets.setParent(this);
        this.relatedAssetsList = relatedAssets;
    }

    protected void commitRelatedAssets() {
        if (this.relatedAssetsList != null) {
            this.relatedAssetsList.commitModel();
        }
        if (!this.relatedAssets.isEmpty()) {
            for (RelatedAsset rel : this.relatedAssets) {
                RAMAsset[] assets = rel.getAssets();
                int i = 0;
                while (i < assets.length) {
                    this.getAsset().addRelatedAsset((com.ibm.ram.common.data.Asset)assets[i], (RelationshipType)rel.getRelationshipType());
                    ++i;
                }
            }
        }
    }

    protected void commitAttributes() {
        if (!this.attributes.isEmpty()) {
            for (Attribute attribute : this.attributes) {
                attribute.setAsset(this.getAsset());
                attribute.commitModel();
            }
        }
    }

    protected void commitArtifacts() {
        if (this.artifactsList != null) {
            this.artifactsList.setAsset(this.getAsset());
            this.artifactsList.commitModel();
        }
        if (!this.artifactSets.isEmpty()) {
            for (ArtifactSet set : this.artifactSets) {
                DirectoryScanner scanner = set.getDirectoryScanner(this.getProject());
                boolean createTempFile = scanner instanceof ArchiveScanner;
                String[] files = scanner.getIncludedFiles();
                File basedir = set.getDir(this.getProject());
                String basepath = this.normalize(set.getPath(), null);
                int i = 0;
                while (i < files.length) {
                    String path = this.normalize(basepath, files[i]);
                    if (!"/manifest.rmd".equals(path)) {
                        File file;
                        if (createTempFile) {
                            Resource resource = scanner.getResource(files[i]);
                            file = new File(this.getTempFolder(), this.normalize(files[i], null));
                            file.getParentFile().mkdirs();
                            try {
                                UtilitiesCommon.copyStreams((InputStream)resource.getInputStream(), (OutputStream)new FileOutputStream(file), null, (boolean)true, (boolean)true);
                            }
                            catch (FileNotFoundException e) {
                                LoggingUtil.error((ProjectComponent)this, (Throwable)e);
                            }
                            catch (IOException e) {
                                LoggingUtil.error((ProjectComponent)this, (Throwable)e);
                            }
                        } else {
                            file = new File(basedir, this.normalize(files[i], null));
                        }
                        if (!file.isDirectory()) {
                            int index = path.lastIndexOf(47);
                            if (index != -1) {
                                path = path.substring(0, index);
                            }
                            if (path.startsWith("/")) {
                                path = path.substring(1);
                            }
                        }
                        this.createFileArtifact(path, file, set.getReference());
                        if (createTempFile) {
                            file.deleteOnExit();
                        }
                    }
                    ++i;
                }
            }
        }
        if (!this.artifacts.isEmpty()) {
            for (Artifact artifact : this.artifacts) {
                artifact.setAsset(this.getAsset());
                artifact.commitModel();
            }
        }
    }

    protected void createFileArtifact(String path, File file, Reference ref) {
        Object artifact = null;
        artifact = file.isDirectory() ? new LocalFolderArtifact(file) : new LocalFileArtifact(file);
        if (ref != null) {
            ref.setArtifact((com.ibm.ram.common.data.Artifact)artifact);
            ref.commitModel();
        }
        try {
            ((RAMFolderArtifact)this.getAsset().getArtifactsRoot()).addArtifact(path, (com.ibm.ram.common.data.Artifact)artifact);
        }
        catch (RAMRuntimeException e) {
            LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ErrorAddingArtifact"), String.valueOf(artifact.getPath()) + '/' + artifact.getName()), (Throwable)e);
        }
    }

    private File getTempFolder() {
        if (this.tmpFolder == null) {
            this.tmpFolder = new File(System.getProperty("java.io.tmpdir"), "com.ibm.ram.ant");
            this.tmpFolder.mkdirs();
        }
        return this.tmpFolder;
    }

    protected String normalize(String basepath, String subpath) {
        if (basepath == null) {
            basepath = "";
        }
        if ((basepath = basepath.replace('\\', '/')).length() == 0 || basepath.charAt(0) != '/') {
            basepath = String.valueOf('/') + basepath;
        }
        if (basepath.charAt(basepath.length() - 1) == '/') {
            basepath = basepath.substring(0, basepath.length() - 1);
        }
        if (subpath == null || subpath.length() == 0) {
            return basepath;
        }
        if ((subpath = subpath.replace('\\', '/')).length() == 0 || subpath.charAt(0) != '/') {
            subpath = String.valueOf('/') + subpath;
        }
        if (subpath.charAt(subpath.length() - 1) == '/') {
            subpath = subpath.substring(0, subpath.length() - 1);
        }
        return String.valueOf(basepath) + subpath;
    }

    @Override
    public Object getModel() {
        return this.getAsset();
    }

    protected Asset getRef() {
        return (Asset)((Object)this.getCheckedRef(Asset.class, Asset.class.getName()));
    }

    protected void commitTags() {
        if (!this.tags.isEmpty()) {
            for (Tag tag : this.tags) {
                this.getAsset().addTags(tag.getValue());
            }
        }
    }

    protected void commitOwners() {
        if (!this.owners.isEmpty()) {
            Iterator iter = this.owners.iterator();
            ArrayList<RAMUser> newUsers = new ArrayList<RAMUser>();
            while (iter.hasNext()) {
                Owner owner = (Owner)((Object)iter.next());
                newUsers.add(owner.getUser());
            }
            this.getAsset().setOwners((UserInformation[])newUsers.toArray(new RAMUser[newUsers.size()]));
        }
    }

    @Override
    public void commitModel() {
        if (this.community != null) {
            this.getAsset().setCommunity((CommunityInformation)this.getCommunity());
        }
        if (this.assetType != null) {
            this.getAsset().setAssetType((com.ibm.ram.common.data.AssetType)this.getType());
        }
        if (this.description != null) {
            this.getAsset().setDescription(this.description.getValue());
        }
        if (this.name != null) {
            this.getAsset().setName(this.name.getValue());
        }
        if (this.shortDescription != null) {
            this.getAsset().setShortDescription(this.shortDescription.getValue());
        }
        this.commitArtifacts();
        this.commitAttributes();
        this.commitRelatedAssets();
        this.commitCategories();
        this.commitTags();
        this.commitOwners();
    }

    protected void commitCategories() {
        if (this.categoryList != null) {
            this.categoryList.commitModel();
        }
        if (!this.categories.isEmpty()) {
            for (Category category : this.categories) {
                SubCategory subCategory = category.getSubCategory();
                if (subCategory == null) {
                    LoggingUtil.warn((ProjectComponent)category, MessageFormat.format(ClientMessages.getString((String)"Ant.CategoryNotDefined"), category.getFullPath()));
                    continue;
                }
                this.getAsset().categorize(subCategory);
            }
        }
    }

    public RAMAsset getAsset() {
        if (this.isReference()) {
            return this.getRef().getAsset();
        }
        if (this.asset != null) {
            return this.asset;
        }
        if (this.guid != null && this.version != null) {
            try {
                this.asset = this.getSession().getAsset(new AssetIdentification(this.guid, this.version));
            }
            catch (RAMRuntimeException e) {
                LoggingUtil.error(this.getProject(), MessageFormat.format("Ant.ErrorGettingAsset", String.valueOf(this.guid) + " [" + this.version + "]"), (Throwable)e);
            }
        } else if (this.guid != null) {
            try {
                this.asset = this.getSession().getAsset(new AssetIdentification(this.guid, "*"));
            }
            catch (RAMRuntimeException e) {
                LoggingUtil.error(this.getProject(), MessageFormat.format("Ant.ErrorGettingAsset", this.guid), (Throwable)e);
            }
        }
        return this.asset;
    }

    public String getGuid() {
        if (this.isReference()) {
            return this.getRef().getGuid();
        }
        if (this.guid != null) {
            return this.guid;
        }
        try {
            return this.getAsset().getIdentification().getGUID();
        }
        catch (RAMRuntimeException e) {
            LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ErrorGettingGuid"), String.valueOf(this.getAsset().getName()) + " [" + this.getAsset().getIdentification().getVersion() + "]"), (Throwable)e);
            return null;
        }
    }

    public void setGuid(String guid) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.guid = guid;
    }

    public String getVersion() {
        if (this.isReference()) {
            return this.getRef().getVersion();
        }
        if (this.version != null) {
            return this.version;
        }
        if (this.getAsset() != null) {
            return this.getAsset().getIdentification().getVersion();
        }
        return null;
    }

    public String getNewVersion() {
        if (this.isReference()) {
            return this.getRef().getNewVersion();
        }
        if (this.newVersion != null) {
            return this.newVersion.getValue();
        }
        return null;
    }

    public String getNewGuid() {
        if (this.isReference()) {
            return this.getRef().getNewGuid();
        }
        if (this.newGuid != null) {
            return this.newGuid.getValue();
        }
        return null;
    }

    public void setVersion(String version) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.version = version;
    }

    public void setServer(String serverId) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        Object ref = this.getProject().getReference(serverId);
        if (ref == null || !(ref instanceof Server)) {
            LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ServerNotDefined"), serverId));
        }
        this.setSession(((Server)((Object)ref)).getSession());
    }

    public void setAsset(RAMAsset asset) {
        this.asset = asset;
    }

    @Override
    public List getChildren() {
        ArrayList<RAMDataType> children = new ArrayList<RAMDataType>();
        children.addAll(this.artifacts);
        children.add(this.artifactsList);
        children.addAll(this.artifactSets);
        children.add(this.assetType);
        children.addAll(this.attributes);
        children.add(this.categoryList);
        children.addAll(this.categories);
        children.add(this.community);
        children.addAll(this.relatedAssets);
        children.add(this.relatedAssetsList);
        return children;
    }

    public String getName() {
        if (this.isReference()) {
            return this.getRef().getName();
        }
        if (this.name != null) {
            return this.name.getValue();
        }
        RAMAsset asset = this.getAsset();
        if (asset != null) {
            return asset.getName();
        }
        return null;
    }

    public String getDescription() {
        if (this.isReference()) {
            return this.getRef().getDescription();
        }
        if (this.description != null) {
            return this.description.getValue();
        }
        return this.getAsset().getDescription();
    }

    public RAMCommunity getCommunity() {
        if (this.isReference()) {
            return this.getRef().getCommunity();
        }
        if (this.community != null) {
            this.community.setParent(this);
            return this.community.getCommunity();
        }
        return (RAMCommunity)this.getAsset().getCommunity();
    }

    public RAMAssetType getType() {
        if (this.isReference()) {
            return this.getRef().getType();
        }
        if (this.assetType != null) {
            this.assetType.setParent(this);
            return this.assetType.getAssetType();
        }
        return (RAMAssetType)this.getAsset().getAssetType();
    }

    public String getShortDescription() {
        if (this.isReference()) {
            return this.getRef().getShortDescription();
        }
        if (this.shortDescription != null) {
            return this.shortDescription.getValue();
        }
        return this.getAsset().getShortDescription();
    }
}

