/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.types;

import com.ibm.ram.client.RAMAssetType;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.types.Description;
import com.ibm.ram.internal.client.ant.types.Name;
import com.ibm.ram.internal.client.ant.types.RAMDataType;
import com.ibm.ram.internal.client.ant.types.Server;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.text.MessageFormat;
import java.util.List;
import org.apache.tools.ant.ProjectComponent;

public class AssetType
extends RAMDataType {
    private String name;
    private Description description;
    private Name newName;
    private Description newDescription;
    private RAMAssetType assetType;

    public void addText(String text) {
        this.setName(this.getProject().replaceProperties(text));
    }

    public void add(Description description) {
        if (this.newDescription != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)description);
        } else {
            this.newDescription = description;
        }
    }

    public void add(Name name) {
        if (this.newName != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)name);
        } else {
            this.newName = name;
        }
    }

    public String getNewName() {
        if (this.newName != null) {
            return this.newName.getValue();
        }
        return null;
    }

    @Override
    public Object getModel() {
        return this.getAssetType();
    }

    public RAMAssetType getAssetType() {
        if (this.isReference()) {
            return this.getRef().getAssetType();
        }
        if (this.assetType != null) {
            return this.assetType;
        }
        if (this.name != null) {
            try {
                this.assetType = this.getSession().getAssetType(this.name);
            }
            catch (RAMRuntimeException e) {
                LoggingUtil.errorGettingObject((ProjectComponent)this, this.name, e);
            }
        }
        return this.assetType;
    }

    @Override
    public List getChildren() {
        return null;
    }

    public void setAssetType(RAMAssetType type) {
        this.assetType = type;
    }

    public String getDescription() {
        if (this.isReference()) {
            return this.getRef().getDescription();
        }
        if (this.description != null) {
            return this.description.getValue();
        }
        try {
            if (this.getAssetType() != null) {
                return this.getAssetType().getDescription();
            }
        }
        catch (RAMRuntimeException e) {
            LoggingUtil.error((ProjectComponent)this, (Throwable)e);
        }
        return null;
    }

    protected AssetType getRef() {
        return (AssetType)((Object)this.getCheckedRef(AssetType.class, AssetType.class.getName()));
    }

    public String getName() {
        if (this.isReference()) {
            return this.getRef().getName();
        }
        if (this.name != null) {
            return this.name;
        }
        try {
            return this.getAssetType().getName();
        }
        catch (RAMRuntimeException e) {
            LoggingUtil.error((ProjectComponent)this, (Throwable)e);
            return null;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setServer(String serverId) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        Object ref = this.getProject().getReference(serverId);
        if (ref == null || !(ref instanceof Server)) {
            LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ServerNotDefined"), serverId));
        }
        this.setSession(((Server)((Object)ref)).getSession());
    }
}

