/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.types;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMRelationshipType;
import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.common.data.Relationship;
import com.ibm.ram.common.data.RelationshipType;
import com.ibm.ram.internal.client.ant.ArtifactEntry;
import com.ibm.ram.internal.client.ant.DownloadUtil;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.types.Asset;
import com.ibm.ram.internal.client.ant.types.RAMDataType;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.tools.ant.ProjectComponent;

public class RelatedAssets
extends RAMDataType {
    private static final String REPLACE_ALL = "All";
    private static final String REPLACE_BY_RELATIONSHIP_TYPE = "ByRelationshipType";
    private static final String REPLACE_BY_GUID = "ByGUID";
    private String relationshipString;
    private RAMAsset asset;
    private File eclipseproject;
    private String replace;

    public void addText(String text) {
        this.relationshipString = this.getProject().replaceProperties(text);
    }

    @Override
    public void commitModel() {
        if (this.eclipseproject != null) {
            if (!this.eclipseproject.exists()) {
                LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.FileDoesNotExist"), this.eclipseproject));
                return;
            }
            if (!this.eclipseproject.isDirectory()) {
                LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.FileIsNotADirectory"), this.eclipseproject));
                return;
            }
            File controlFile = new File(this.eclipseproject, ".settings/rambuildercontrol.xml");
            if (!controlFile.exists()) {
                LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ControlFileDoesNotExist"), this.eclipseproject));
                return;
            }
            StringBuilder buffer = new StringBuilder("dependency:");
            HashMap<String, ArtifactEntry> assets = new HashMap<String, ArtifactEntry>();
            List<ArtifactEntry> entries = DownloadUtil.getArtifactsFromControlFile(controlFile);
            for (ArtifactEntry entry : entries) {
                String key = String.valueOf(entry.getGuid()) + "/" + entry.getVersion();
                ArtifactEntry oldEntry = assets.put(key, entry);
                if (oldEntry != null) continue;
                buffer.append(key);
                buffer.append(",");
            }
            if (this.relationshipString == null) {
                this.relationshipString = buffer.toString();
            } else {
                if (!this.relationshipString.endsWith(";")) {
                    this.relationshipString = String.valueOf(this.relationshipString) + ";";
                }
                this.relationshipString = String.valueOf(this.relationshipString) + buffer.toString();
            }
        }
        if (this.relationshipString == null || this.relationshipString.length() == 0) {
            LoggingUtil.warnNoValueSpecified((ProjectComponent)this);
            return;
        }
        if (REPLACE_ALL.equalsIgnoreCase(this.replace)) {
            while (this.getAsset().getRelationships().length > 0) {
                this.getAsset().removeRelationship(this.getAsset().getRelationships()[0]);
            }
        }
        String[] types = this.relationshipString.split(";");
        int i = 0;
        while (i < types.length) {
            int index = types[i].indexOf(58);
            if (index == -1) {
                LoggingUtil.warn((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.InvalidRelationshipList"), types[i], "relationshipTypeName:commaSeparatedListOfGuid/Version"));
            } else {
                String typeString = types[i].substring(0, index);
                RAMRelationshipType relationshipType = this.getSession().getRelationshipType(typeString);
                if (REPLACE_BY_RELATIONSHIP_TYPE.equalsIgnoreCase(this.replace)) {
                    ArrayList<Relationship> relationships = new ArrayList<Relationship>(Arrays.asList(this.getAsset().getRelationships()));
                    for (Relationship relationship : relationships) {
                        if (!relationship.getRelationshipTypeName().equals(typeString)) continue;
                        this.getAsset().removeRelationship(relationship);
                    }
                }
                String relString = types[i].substring(index + 1);
                String[] rels = relString.split(",");
                int j = 0;
                while (j < rels.length) {
                    index = rels[j].indexOf(47);
                    if (index == -1) {
                        LoggingUtil.warn((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.InvalidGuidVersion"), rels[j]));
                    } else {
                        String guid = rels[j].substring(0, index);
                        String version = rels[j].substring(index + 1);
                        if (guid.length() != 0 && version.length() != 0) {
                            if (REPLACE_BY_GUID.equalsIgnoreCase(this.replace)) {
                                ArrayList<Relationship> relationships = new ArrayList<Relationship>(Arrays.asList(this.getAsset().getRelationships()));
                                for (Relationship relationship : relationships) {
                                    if (!relationship.getRelationshipTypeName().equals(typeString) || !relationship.getChildAssetGUID().equals(guid)) continue;
                                    this.getAsset().removeRelationship(relationship);
                                }
                            }
                            RAMAsset relatedAsset = this.getSession().getAsset(new AssetIdentification(guid, version));
                            this.getAsset().addRelatedAsset((com.ibm.ram.common.data.Asset)relatedAsset, (RelationshipType)relationshipType);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public List getChildren() {
        return null;
    }

    public RAMAsset getAsset() {
        if (this.isReference()) {
            return this.getRef().getAsset();
        }
        if (this.asset != null) {
            return this.asset;
        }
        if (this.getParent() != null && this.getParent() instanceof Asset) {
            this.asset = ((Asset)this.getParent()).getAsset();
        }
        return this.asset;
    }

    @Override
    public Object getModel() {
        return null;
    }

    protected RelatedAssets getRef() {
        return (RelatedAssets)((Object)this.getCheckedRef(RelatedAssets.class, RelatedAssets.class.getName()));
    }

    public String getReplace() {
        return this.replace;
    }

    public void setAsset(RAMAsset asset) {
        this.asset = asset;
    }

    public void setEclipseproject(File eclipseproject) {
        this.eclipseproject = eclipseproject;
    }

    public void setProject(File project) {
        this.eclipseproject = project;
    }

    public void setReplace(String replace) {
        this.replace = replace;
    }
}

