/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.cli.command;

import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RCAssetNotFoundException;
import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.internal.cli.bundles.Messages;
import com.ibm.ram.internal.cli.command.Command;
import com.ibm.ram.internal.cli.command.SearchCommand;
import com.ibm.ram.internal.cli.commandline.CommandLine;
import com.ibm.ram.internal.cli.commandline.Option;
import com.ibm.ram.internal.cli.util.AttributeHelper;
import com.ibm.ram.internal.cli.util.CategoryHelper;
import com.ibm.ram.internal.cli.util.RelationshipHelper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class SetCommand
extends Command {
    public static final String NAME = "set";
    public static final String OPTION_CATEGORY = "-c";
    public static final String OPTION_CATEGORY_FORCE = "-f";
    public static final String OPTION_ATTRIBUTE = "-a";
    public static final String OPTION_RELATED = "-r";
    private List<String> categories;
    private List<String> forcedCategories;
    private List<String> attributes;
    private List<String> related;

    public SetCommand(String[] args) {
        super(args);
    }

    @Override
    public IStatus execute() {
        boolean assetUpdated;
        String message;
        ArrayList<Object> okStatus;
        ArrayList<Object> errorStatus;
        Status status;
        block25: {
            CategoryHelper categoryHelper;
            IStatus setStatus;
            String message2;
            status = this.getRAMSession();
            if (!status.isOK()) {
                return status;
            }
            errorStatus = new ArrayList<Object>();
            okStatus = new ArrayList<Object>();
            RAMAsset asset = null;
            AssetIdentification assetId = SearchCommand.getAssetIdentification(this.ramSession, this.packageId, this.packageVersion, this.queryString);
            if (assetId != null) {
                try {
                    this.packageVersion = assetId.getVersion();
                    asset = this.ramSession.getAsset(assetId);
                }
                catch (RCAssetNotFoundException rCAssetNotFoundException) {
                    message2 = MessageFormat.format(Messages.getString("GetCommand.3"), assetId.getGUID(), assetId.getVersion());
                    errorStatus.add(new Status(4, this.getClass().getName(), message2));
                }
                catch (Exception e) {
                    message = MessageFormat.format(Messages.getString("GetCommand.4"), assetId.getGUID(), assetId.getVersion());
                    errorStatus.add(new Status(4, this.getClass().getName(), message));
                    message = e.getLocalizedMessage();
                    if (message != null) {
                        errorStatus.add(new Status(4, this.getClass().getName(), message));
                    }
                }
            } else {
                message2 = this.packageVersion != null && !this.packageVersion.isEmpty() ? MessageFormat.format(Messages.getString("GetCommand.3"), this.packageId, this.packageVersion) : MessageFormat.format(Messages.getString("GetCommand.9"), this.packageId);
                errorStatus.add(new Status(4, this.getClass().getName(), message2));
            }
            assetUpdated = false;
            if (errorStatus.isEmpty() && asset != null && this.related != null && !this.related.isEmpty()) {
                for (String aRelationship : this.related) {
                    RelationshipHelper relationshipHelper = new RelationshipHelper(aRelationship);
                    setStatus = relationshipHelper.setRelated(this.ramSession, asset);
                    if (setStatus.isOK()) {
                        okStatus.add(setStatus);
                        assetUpdated = true;
                        continue;
                    }
                    errorStatus.add(setStatus);
                }
            }
            if (errorStatus.isEmpty() && asset != null && this.categories != null && !this.categories.isEmpty()) {
                for (String aCategory : this.categories) {
                    categoryHelper = new CategoryHelper(aCategory);
                    setStatus = categoryHelper.setCategory(this.ramSession, asset);
                    if (setStatus.isOK()) {
                        okStatus.add(setStatus);
                        assetUpdated = true;
                        continue;
                    }
                    errorStatus.add(setStatus);
                }
            }
            if (errorStatus.isEmpty() && asset != null && this.forcedCategories != null && !this.forcedCategories.isEmpty()) {
                for (String aCategory : this.forcedCategories) {
                    categoryHelper = new CategoryHelper(aCategory);
                    setStatus = categoryHelper.setCategory(this.ramSession, asset, Boolean.TRUE);
                    if (setStatus.isOK()) {
                        okStatus.add(setStatus);
                        assetUpdated = true;
                        continue;
                    }
                    errorStatus.add(setStatus);
                }
            }
            if (errorStatus.isEmpty() && asset != null && this.attributes != null && !this.attributes.isEmpty()) {
                for (String anAttribute : this.attributes) {
                    AttributeHelper attributeHelper = new AttributeHelper(anAttribute);
                    setStatus = attributeHelper.setAttribute(asset);
                    if (setStatus.isOK()) {
                        okStatus.add(setStatus);
                        assetUpdated = true;
                        continue;
                    }
                    errorStatus.add(setStatus);
                }
            }
            if (errorStatus.isEmpty() && assetUpdated) {
                try {
                    this.ramSession.put((IRAMSessionObject)asset, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    String exceptionMessage = e.getLocalizedMessage();
                    if (exceptionMessage == null) break block25;
                    errorStatus.add(new Status(4, this.getClass().getName(), e.getLocalizedMessage()));
                }
            }
        }
        this.releaseRAMSession();
        if (errorStatus.isEmpty()) {
            if (assetUpdated) {
                message = MessageFormat.format(Messages.getString("SetCommand.1"), this.packageId, this.packageVersion);
                okStatus.add(new Status(0, this.getClass().getName(), message));
            }
            status = new MultiStatus(this.getClass().getName(), 0, (IStatus[])okStatus.toArray(new Status[okStatus.size()]), null, null);
        } else {
            status = new MultiStatus(this.getClass().getName(), 4, (IStatus[])errorStatus.toArray(new Status[errorStatus.size()]), null, null);
        }
        return status;
    }

    @Override
    public IStatus validate() {
        CommandLine commandLine = new CommandLine(this.cmdArgs);
        Option optionCategory = new Option(OPTION_CATEGORY, true, true);
        Option optionCategoryForce = new Option(OPTION_CATEGORY_FORCE, true, true);
        Option optionAttribute = new Option(OPTION_ATTRIBUTE, true, true);
        Option optionRelated = new Option(OPTION_RELATED, true, true);
        commandLine.addOption(optionCategory);
        commandLine.addOption(optionCategoryForce);
        commandLine.addOption(optionAttribute);
        commandLine.addOption(optionRelated);
        commandLine.addOption(new Option("-config", true));
        commandLine.addOption(new Option("-q", true));
        IStatus status = super.validate(commandLine);
        if (!status.isOK()) {
            return status;
        }
        if (this.packageId == null || this.packageId.isEmpty()) {
            return new Status(4, this.getClass().getName(), Messages.getString("CommandLine.6"));
        }
        if (!(optionCategory.isSet() || optionAttribute.isSet() || optionRelated.isSet() || optionCategoryForce.isSet())) {
            return new Status(4, this.getClass().getName(), Messages.getString("SetCommand.2"));
        }
        this.categories = commandLine.getOption(OPTION_CATEGORY).getValues();
        this.forcedCategories = commandLine.getOption(OPTION_CATEGORY_FORCE).getValues();
        this.attributes = commandLine.getOption(OPTION_ATTRIBUTE).getValues();
        this.related = commandLine.getOption(OPTION_RELATED).getValues();
        this.queryString = commandLine.getOption("-q").getValue();
        this.createConfiguration(commandLine.getOption("-config").getValue());
        return this.config.validate();
    }
}

