/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.cli.rampackage;

import com.ibm.ram.internal.cli.bundles.Messages;
import com.ibm.ram.internal.cli.rampackage.Dependency;
import com.ibm.ram.internal.cli.rampackage.DescriptorParser;
import com.ibm.ram.internal.cli.rampackage.Person;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class PackageDescriptor {
    private String packageDescriptorName;
    private String id;
    private String version;
    private String groupId;
    private String description;
    private List<String> keywords;
    private Person author;
    private List<Person> owners;
    private String community;
    private String type;
    private List<Dependency> dependencies;
    public static final String PACKAGE_JSON = "package.json";
    public static final String POM_XML = "pom.xml";
    public static final String POM_EXT = ".pom";

    public PackageDescriptor(String fileName) {
        this.packageDescriptorName = fileName;
    }

    public IStatus read() {
        DescriptorParser parser = new DescriptorParser(this.packageDescriptorName);
        IStatus status = parser.parse();
        if (status.isOK()) {
            try {
                this.id = parser.getId();
                this.version = parser.getVersion();
                this.groupId = parser.getGroupId();
                this.description = parser.getDescription();
                this.keywords = parser.getKeywords();
                this.author = parser.getAuthor();
                this.owners = parser.getOwners();
                this.community = parser.getCommunity();
                this.type = parser.getType();
                this.dependencies = parser.getDependencies();
                if (this.id == null || this.version == null) {
                    String message;
                    status = new MultiStatus(this.getClass().getName(), 4, "", (Throwable)new Exception());
                    if (this.id == null) {
                        message = MessageFormat.format(Messages.getString("PackageDescriptor.4"), "id");
                        ((MultiStatus)status).add((IStatus)new Status(4, this.getClass().getName(), message));
                    }
                    if (this.version == null) {
                        message = MessageFormat.format(Messages.getString("PackageDescriptor.4"), "version");
                        ((MultiStatus)status).add((IStatus)new Status(4, this.getClass().getName(), message));
                    }
                }
            }
            catch (Exception e) {
                status = new Status(4, this.getClass().getName(), e.getLocalizedMessage());
            }
        }
        return status;
    }

    public String getPackageDescriptorName() {
        return this.packageDescriptorName;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public String getId() {
        return this.id;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCommunity() {
        return this.community;
    }

    public List getOwners() {
        return this.owners;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Package Descriptor Contents\n");
        sbuf.append("id:            " + this.id + "\n");
        sbuf.append("version:       " + this.version + "\n");
        sbuf.append("description:   " + this.description + "\n");
        sbuf.append("keywords:      " + this.keywords + "\n");
        if (this.author != null) {
            sbuf.append("author:        " + this.author.toString() + "\n");
        }
        sbuf.append("owners:\n");
        if (this.owners != null) {
            Iterator<Person> i = this.owners.iterator();
            while (i.hasNext()) {
                sbuf.append(String.valueOf(i.next().toString()) + "\n");
            }
        }
        sbuf.append("community:     " + this.community + "\n");
        sbuf.append("type:          " + this.type + "\n");
        sbuf.append("dependencies:\n");
        if (this.dependencies != null) {
            for (Dependency entry : this.dependencies) {
                sbuf.append(String.valueOf(entry.toString()) + "\n");
            }
        }
        return sbuf.toString();
    }
}

