/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.GenericArrayTypeImpl;
import com.google.gson.ParameterizedTypeImpl;
import com.google.gson.Preconditions;
import com.google.gson.TypeInfo;
import com.google.gson.TypeInfoArray;
import com.google.gson.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

final class TypeInfoFactory {
    private TypeInfoFactory() {
    }

    public static TypeInfoArray getTypeInfoForArray(Type type) {
        Preconditions.checkArgument(TypeUtils.isArray(type));
        return new TypeInfoArray(type);
    }

    public static TypeInfo getTypeInfoForField(Field f, Type typeDefiningF) {
        Class<?> classDefiningF = TypeUtils.toRawClass(typeDefiningF);
        Type type = f.getGenericType();
        Type actualType = TypeInfoFactory.getActualType(type, typeDefiningF, classDefiningF);
        return new TypeInfo(actualType);
    }

    private static Type getActualType(Type typeToEvaluate, Type parentType, Class<?> rawParentClass) {
        if (typeToEvaluate instanceof Class) {
            return typeToEvaluate;
        }
        if (typeToEvaluate instanceof ParameterizedType) {
            ParameterizedType castedType = (ParameterizedType)typeToEvaluate;
            Type owner = castedType.getOwnerType();
            Type[] actualTypeParameters = TypeInfoFactory.extractRealTypes(castedType.getActualTypeArguments(), parentType, rawParentClass);
            Type rawType = castedType.getRawType();
            return new ParameterizedTypeImpl(rawType, actualTypeParameters, owner);
        }
        if (typeToEvaluate instanceof GenericArrayType) {
            Type actualType;
            GenericArrayType castedType = (GenericArrayType)typeToEvaluate;
            Type componentType = castedType.getGenericComponentType();
            if (componentType.equals(actualType = TypeInfoFactory.getActualType(componentType, parentType, rawParentClass))) {
                return castedType;
            }
            if (actualType instanceof Class) {
                return TypeUtils.wrapWithArray(TypeUtils.toRawClass(actualType));
            }
            return new GenericArrayTypeImpl(actualType);
        }
        if (typeToEvaluate instanceof TypeVariable) {
            if (parentType instanceof ParameterizedType) {
                TypeVariable fieldTypeVariable = (TypeVariable)typeToEvaluate;
                TypeVariable<Class<?>>[] classTypeVariables = rawParentClass.getTypeParameters();
                ParameterizedType objParameterizedType = (ParameterizedType)parentType;
                int indexOfActualTypeArgument = TypeInfoFactory.getIndex(classTypeVariables, fieldTypeVariable);
                Type[] actualTypeArguments = objParameterizedType.getActualTypeArguments();
                return actualTypeArguments[indexOfActualTypeArgument];
            }
            throw new UnsupportedOperationException("Expecting parameterized type, got " + parentType + ".\n Are you missing the use of TypeToken idiom?\n See " + "http://sites.google.com/site/gson/gson-user-guide#TOC-Serializing-and-Deserializing-Gener");
        }
        if (typeToEvaluate instanceof WildcardType) {
            WildcardType castedType = (WildcardType)typeToEvaluate;
            return TypeInfoFactory.getActualType(castedType.getUpperBounds()[0], parentType, rawParentClass);
        }
        throw new IllegalArgumentException("Type '" + typeToEvaluate + "' is not a Class, " + "ParameterizedType, GenericArrayType or TypeVariable. Can't extract type.");
    }

    private static Type[] extractRealTypes(Type[] actualTypeArguments, Type parentType, Class<?> rawParentClass) {
        Preconditions.checkNotNull(actualTypeArguments);
        Type[] retTypes = new Type[actualTypeArguments.length];
        int i = 0;
        while (i < actualTypeArguments.length) {
            retTypes[i] = TypeInfoFactory.getActualType(actualTypeArguments[i], parentType, rawParentClass);
            ++i;
        }
        return retTypes;
    }

    private static int getIndex(TypeVariable<?>[] types, TypeVariable<?> type) {
        int i = 0;
        while (i < types.length) {
            if (type.equals(types[i])) {
                return i;
            }
            ++i;
        }
        throw new IllegalStateException("How can the type variable not be present in the class declaration!");
    }
}

