/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMTopic;
import com.ibm.ram.client.RAMUser;
import com.ibm.ram.common.data.Forum;
import com.ibm.ram.common.data.Topic;
import com.ibm.ram.common.data.UserInformation;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class RAMForum
extends Forum {
    private static final Logger logger = Logger.getLogger((String)RAMForum.class.getName());
    private RAMTopic[] fTopics;
    private Forum fForum;
    private boolean fUpdate = false;
    private boolean fDirty = false;
    private boolean fDelete = false;
    private RAMUser fSubmitter;
    private RAMAsset fAsset;

    RAMForum(RAMAsset asset, Forum forum) {
        this.fAsset = asset;
        this.fForum = forum;
        this.fForum = forum;
        this.fUpdate = true;
    }

    RAMForum(RAMAsset asset, RAMUser submitter, String title, String description) {
        this.fAsset = asset;
        this.fForum = new Forum();
        this.fForum.setId(-1);
        this.fForum.setTitle(title != null ? title : "");
        this.fForum.setDescription(description != null ? description : "");
        this.setSubmitter(submitter);
        this.fForum.setSubmissionDate(-1L);
        this.fForum.setLastUpdatedDate(-1L);
        this.fUpdate = false;
        this.fDirty = true;
    }

    void updateForum(Forum forum, IProgressMonitor monitor) {
        if (!this.fDirty) {
            monitor.beginTask(ClientMessages.getString("RAMForum.0"), 1);
            this.fTopics = null;
            this.fSubmitter = null;
            this.fForum = forum;
            monitor.worked(1);
        } else {
            RAMTopic[] topics = (RAMTopic[])this.getTopics();
            monitor.beginTask(ClientMessages.getString("RAMForum.1"), topics.length * 10 + 1);
            this.fSubmitter = null;
            this.fForum.setDescription(forum.getDescription());
            this.fForum.setId(forum.getId());
            this.fForum.setLastUpdatedDate(forum.getLastUpdatedDate());
            this.fForum.setState(forum.getState());
            this.fForum.setTitle(forum.getTitle());
            monitor.worked(1);
            int i = 0;
            while (!monitor.isCanceled() && i < topics.length) {
                if (topics[i].isDirty()) {
                    try {
                        Topic newTopic = topics[i];
                        if (!topics[i].isUpdate()) {
                            monitor.subTask(MessageFormat.format(ClientMessages.getString("RAMForum.2"), this.getAsset().getName(), this.getTitle(), topics[i].getTitle()));
                            newTopic = this.getAsset().getSession().getRAMClient().getRAM1Webservice().createDiscussionTopic(this.getAsset().getIdentification().getGUID(), this.getAsset().getIdentification().getVersion(), topics[i].getTitle(), topics[i].getDescription(), this.getId(), topics[i].getSubmitter().getUid(), topics[i].getSubmissionDate());
                        }
                        monitor.worked(2);
                        if (!monitor.isCanceled()) {
                            topics[i].updateTopic(newTopic, (IProgressMonitor)new SubProgressMonitor(monitor, 8));
                        }
                    }
                    catch (Exception e) {
                        String message = MessageFormat.format(ClientMessages.getString("RAMForum.FAILED_TO_CREATE_TOPIC"), topics[i]);
                        logger.error((Object)message, (Throwable)e);
                    }
                } else {
                    monitor.worked(10);
                }
                ++i;
            }
        }
        this.fDirty = false;
        this.fUpdate = true;
    }

    @Override
    public int getId() {
        return this.fForum.getId();
    }

    @Override
    public void setId(int id) {
        this.fForum.setId(id);
    }

    public RAMTopic createTopic(String title, String description) {
        RAMTopic ret = new RAMTopic(this, this.getAsset().getSession().getUser(), title, description);
        RAMTopic[] topics = (RAMTopic[])this.getTopics();
        RAMTopic[] newTopics = new RAMTopic[topics.length + 1];
        System.arraycopy(topics, 0, newTopics, 0, topics.length);
        newTopics[topics.length] = ret;
        this.fTopics = newTopics;
        this.setDirty(true);
        return ret;
    }

    void setDirty(boolean dirty) {
        this.fDirty = dirty;
        if (dirty) {
            this.getAsset().setForumDirty(true);
        }
    }

    @Override
    public Topic[] getTopics() {
        if (this.fTopics == null) {
            if (this.fForum.getTopics() == null) {
                this.fTopics = new RAMTopic[0];
            } else {
                Topic[] wsTopics = this.fForum.getTopics();
                RAMTopic[] topics = new RAMTopic[wsTopics.length];
                int i = 0;
                while (i < wsTopics.length) {
                    topics[i] = new RAMTopic(this, wsTopics[i]);
                    ++i;
                }
                this.fTopics = topics;
            }
        }
        return this.fTopics;
    }

    boolean isUpdate() {
        return this.fUpdate;
    }

    boolean isDelete() {
        return this.fDelete;
    }

    boolean isDirty() {
        return this.fDirty;
    }

    @Override
    public String getDescription() {
        return this.fForum.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.fForum.setDescription(description);
    }

    @Override
    public long getLastUpdatedDate() {
        return this.fForum.getLastUpdatedDate();
    }

    @Override
    public String getState() {
        return this.fForum.getState();
    }

    @Override
    public long getSubmissionDate() {
        return this.fForum.getSubmissionDate();
    }

    @Override
    public UserInformation getSubmitter() {
        if (this.fSubmitter == null) {
            if (this.fForum.getSubmitter() == null) {
                this.fForum.setSubmitter(this.getAsset().getSession().getUser());
            } else {
                RAMUser newUser;
                this.fSubmitter = newUser = this.getAsset().getSession().fetchUser(this.fForum.getSubmitter());
            }
        }
        return this.fSubmitter;
    }

    public void setSubmitter(RAMUser submitter) {
        this.fForum.setSubmitter(submitter.getInternalUser());
        this.fSubmitter = submitter;
    }

    @Override
    public String getTitle() {
        return this.fForum.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.fForum.setTitle(title);
    }

    public RAMAsset getAsset() {
        return this.fAsset;
    }

    @Override
    public void setTopics(Topic[] topics) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMForum.METHOD_NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setLastUpdatedDate(long lastUpdatedDate) {
        this.fForum.setLastUpdatedDate(lastUpdatedDate);
    }

    @Override
    public void setState(String state) {
        this.fForum.setState(state);
    }

    @Override
    public void setSubmissionDate(long submissionDate) {
        this.fForum.setSubmissionDate(submissionDate);
    }

    @Override
    public void setSubmitter(UserInformation submitter) {
        this.fForum.setSubmitter(submitter);
    }

    public String toString() {
        if (this.fForum == null && this.fForum.getTitle() == null) {
            return super.toString();
        }
        return this.getAsset() + "/" + this.getTitle();
    }
}

