/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.LoadEclipseClass;
import com.ibm.ram.client.LocalArchiveFolderArtifact;
import com.ibm.ram.client.LocalFileArtifact;
import com.ibm.ram.client.LocalFolderArtifact;
import com.ibm.ram.client.RAMAction;
import com.ibm.ram.client.RAMArtifact;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAssetAttribute;
import com.ibm.ram.client.RAMAssetQueryBuilder;
import com.ibm.ram.client.RAMAssetTag;
import com.ibm.ram.client.RAMAssetType;
import com.ibm.ram.client.RAMCategorySchema;
import com.ibm.ram.client.RAMCommunity;
import com.ibm.ram.client.RAMCommunityAssetType;
import com.ibm.ram.client.RAMFolderArtifact;
import com.ibm.ram.client.RAMLibrary;
import com.ibm.ram.client.RAMPassword;
import com.ibm.ram.client.RAMRelationship;
import com.ibm.ram.client.RAMRelationshipType;
import com.ibm.ram.client.RAMSearchResult;
import com.ibm.ram.client.RAMState;
import com.ibm.ram.client.RAMURLArtifact;
import com.ibm.ram.client.RAMUser;
import com.ibm.ram.client.RCAssetNotFoundException;
import com.ibm.ram.client.copy.CopyOption;
import com.ibm.ram.client.status.RAMStatus;
import com.ibm.ram.client.status.RAMStatusMonitor;
import com.ibm.ram.common.data.Artifact;
import com.ibm.ram.common.data.ArtifactReference;
import com.ibm.ram.common.data.Asset;
import com.ibm.ram.common.data.AssetAttribute;
import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.common.data.AssetInformation;
import com.ibm.ram.common.data.AssetType;
import com.ibm.ram.common.data.Category;
import com.ibm.ram.common.data.CategorySchema;
import com.ibm.ram.common.data.CommunityAssetType;
import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.data.FolderArtifact;
import com.ibm.ram.common.data.Relationship;
import com.ibm.ram.common.data.RelationshipInfo;
import com.ibm.ram.common.data.RelationshipType;
import com.ibm.ram.common.data.RepositoryIdentification;
import com.ibm.ram.common.data.SearchQuery;
import com.ibm.ram.common.data.SearchResult;
import com.ibm.ram.common.data.State;
import com.ibm.ram.common.data.SubCategory;
import com.ibm.ram.common.data.URLArtifact;
import com.ibm.ram.common.data.UserInformation;
import com.ibm.ram.common.data.exception.AssetNotFoundException;
import com.ibm.ram.common.data.exception.EntitlementException;
import com.ibm.ram.common.data.exception.RAMException;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.emf.ConstraintGrouping;
import com.ibm.ram.common.emf.EMFPackage;
import com.ibm.ram.common.emf.RelationshipConstraint;
import com.ibm.ram.common.emf.RelationshipGrouping;
import com.ibm.ram.common.util.CachedRAMURIConverter;
import com.ibm.ram.common.util.ManifestAccessor;
import com.ibm.ram.common.util.UniqueIDGenerator;
import com.ibm.ram.common.util.ValidationManager;
import com.ibm.ram.defaultprofile.ClassificationSchema;
import com.ibm.ram.defaultprofile.DefaultprofilePackage;
import com.ibm.ram.defaultprofile.RelatedAsset;
import com.ibm.ram.defaultprofile.util.Utilities;
import com.ibm.ram.internal.access.ws.Constants;
import com.ibm.ram.internal.client.AbstractRAMClient;
import com.ibm.ram.internal.client.AbstractRESTClient;
import com.ibm.ram.internal.client.InvalidQueryException;
import com.ibm.ram.internal.client.RAMMappings;
import com.ibm.ram.internal.client.RAMServiceException;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import com.ibm.ram.internal.client.util.AssetUtil;
import com.ibm.ram.internal.client.util.RAMSessionModificationEvent;
import com.ibm.ram.internal.client.util.SessionManager;
import com.ibm.ram.internal.client.util.SessionStore;
import com.ibm.ram.internal.common.bundles.StoredMessage;
import com.ibm.ram.internal.common.data.AssetAttributeSO;
import com.ibm.ram.internal.common.data.AssetSO;
import com.ibm.ram.internal.common.data.AssetTypeCommunityRelationshipSO;
import com.ibm.ram.internal.common.data.AssetTypeSO;
import com.ibm.ram.internal.common.data.CommunitySO;
import com.ibm.ram.internal.common.data.FacetSelectionSO;
import com.ibm.ram.internal.common.data.LibraryInformationSO;
import com.ibm.ram.internal.common.data.SearchNode;
import com.ibm.ram.internal.common.data.SearchResultSO;
import com.ibm.ram.internal.common.util.RelationshipRangeUtility;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import com.ibm.ram.internal.rest.RAMRestException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class RAMSession {
    private static final String RAM_CLIENT_CLASS_NAME = "com.ibm.ram.internal.client.RAMClient";
    public static final String RAM_7_1_0_0_SERVICES_VERSION = AbstractRAMClient.RICH_CLIENT_VERSION_71;
    public static final String RAM_7_1_0_1_SERVICES_VERSION = AbstractRAMClient.RICH_CLIENT_VERSION_7101;
    public static final String RAM_7_1_1_0_SERVICES_VERSION = AbstractRAMClient.RICH_CLIENT_VERSION_711;
    public static final String RAM_7_1_1_1_SERVICES_VERSION = AbstractRAMClient.RICH_CLIENT_VERSION_7111;
    public static final String RAM_7_2_0_0_SERVICES_VERSION = AbstractRAMClient.RICH_CLIENT_VERSION_72;
    public static final String RAM_7_2_0_1_SERVICES_VERSION = AbstractRAMClient.RICH_CLIENT_VERSION_7201;
    public static final String RAM_7_2_0_2_SERVICES_VERSION = AbstractRAMClient.RICH_CLIENT_VERSION_7202;
    public static final String RAM_7_5_0_0_SERVICES_VERSION = AbstractRAMClient.RICH_CLIENT_VERSION_7500;
    public static final String RAM_7_5_0_1_SERVICES_VERSION = AbstractRAMClient.RICH_CLIENT_VERSION_7501;
    public static final String RAM_7_5_0_2_SERVICES_VERSION = AbstractRAMClient.RICH_CLIENT_VERSION_7502;
    public static final String RAM_7_5_1_0_SERVICES_VERSION = AbstractRAMClient.RICH_CLIENT_VERSION_751;
    public static final String RAM_7_5_1_1_SERVICES_VERSION = AbstractRAMClient.RICH_CLIENT_VERSION_7511;
    public static final String RAM_7_5_2_0_SERVICES_VERSION = AbstractRAMClient.RICH_CLIENT_VERSION_752;
    public static final String RAM_7_5_2_4_SERVICES_VERSION = AbstractRAMClient.RICH_CLIENT_VERSION_7524;
    public static String REST_CACHE_FOLDER_PROPERTY_KEY = "com.ibm.ram.client.rest.cacheFolder";
    private static final String CLIENT_ASSET_UPLOAD_FLAG_AS_DRAFT = "saveAsDraft";
    private static final String CLIENT_ASSET_UPLOAD_FLAG_AS_IS = "saveAsIs";
    private static final String CLIENT_ASSET_UPLOAD_FLAG_SAVE_NORMAL = "saveAsNormal";
    private static final int ID_CONSOLE_GROUP = 0;
    private static final int ID_REPOSITORY_RESOURCES_GROUP = 1;
    private static final Logger logger;
    private AbstractRAMClient fRAMClient;
    private RAMUser fUser;
    private String fLocalStorageLocation;
    private Locale fLocale = Locale.getDefault();
    private Constants fConstants;
    private Map fAssets = new HashMap();
    private List fAssetQueue = new ArrayList();
    private List fModified = new ArrayList();
    private Map fAssetTypesByName;
    private Map fAssetTypesByURI;
    private Map fCommunitiesByName;
    private Map fCommunitiesById;
    private Map fRelationshipTypeByName;
    private Map fRelationshipTypeByDisplayName;
    private Map fCategorySchemasByURI;
    private Map fCategorySchemasByName;
    private Map fAttributesByName;
    private Map fAttributesByURI;
    private Map<String, RAMState> fStatesByName;
    private Map<Integer, RAMState> fStatesById;
    private Map fUsersByUid;
    private Map<String, RAMLibrary> fLibraries;
    private static final String TAG_DELIM = ",";
    private static int MAX_UPLOAD_THREADS;
    private Map<URI, URI> fServerToLocalEMFURIResourceMap = new HashMap<URI, URI>();
    private Map<String, RAMAsset> fWhoIsInTheAssetPipeline = new ConcurrentHashMap<String, RAMAsset>();
    private ResourceSet fResourceSet;
    private RepositoryIdentification fRepositoryIdentification;
    private File fLocalStorageFolder;
    private RAMUser fOnBehalfOfUser;
    private boolean fOverrideValidation;
    boolean server = false;
    private static final String ASSET_TYPE_SCHEMA_URI = "classif/assetTypesSchema.xmi#/";
    private final String LIBRARIES_MUTEX = "LIBRARIES_MUTEX";

    static {
        DefaultprofilePackage.eINSTANCE.getActivity();
        EMFPackage.eINSTANCE.getArtifactConstraint();
        logger = Logger.getLogger((String)RAMSession.class.getName());
        MAX_UPLOAD_THREADS = 8;
    }

    protected RAMSession() {
        this.server = true;
    }

    public RAMSession(String ramLocation, String userName, String password) throws RAMRuntimeException {
        this(ramLocation, userName, password, null);
    }

    public RAMSession(String ramLocation, String userName, String password, String onBehalfOfUserId) throws RAMRuntimeException {
        try {
            if (logger.isDebugEnabled()) {
                RAMSession.printJAXBLocations();
            }
            this.createClient(ramLocation, userName, password, onBehalfOfUserId);
        }
        catch (Exception e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
        this.fOnBehalfOfUser = this.getUser(onBehalfOfUserId);
    }

    public RAMSession(String ramLocation, String userName, RAMPassword ramPassword, String onBehalfOfUserId) throws RAMRuntimeException {
        this(ramLocation, userName, ramPassword.getPassword(), onBehalfOfUserId);
    }

    private void createClient(String ramLocation, String userName, String password, String onBehalfOfUserId) throws MalformedURLException, RAMServiceException, RemoteException, RAMException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.fRAMClient = this.primCreateClient(new URL(ramLocation), userName, password, onBehalfOfUserId);
        this.fRAMClient.ERROR_LOG_LEVEL = Level.DEBUG;
        try {
            this.fRAMClient.initialize();
        }
        finally {
            this.fRAMClient.ERROR_LOG_LEVEL = AbstractRAMClient.ERROR_LOG_LEVEL_DEFAULT;
        }
    }

    private LoadEclipseClass getEclipseLoader() {
        try {
            Class<?> loadClass = Class.forName("com.ibm.ram.client.LoadEclipseClassImpl");
            return (LoadEclipseClass)loadClass.getDeclaredField("INSTANCE").get(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (LinkageError linkageError) {}
        return null;
    }

    protected AbstractRAMClient primCreateClient(URL ramLocation, String userName, String password, String onBehalfOfUserId) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<Object> ramClientClass = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading the 'com.ibm.ram.internal.client.RAMClient' using context class loader");
        }
        try {
            ramClientClass = Class.forName(RAM_CLIENT_CLASS_NAME, true, classLoader);
            Constructor<?> constructor = ramClientClass.getConstructor(URL.class, String.class, String.class, String.class);
            return (AbstractRAMClient)constructor.newInstance(ramLocation, userName, password, onBehalfOfUserId);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Loading the 'com.ibm.ram.internal.client.RAMClient' using current class loader");
            }
            try {
                ramClientClass = Class.forName(RAM_CLIENT_CLASS_NAME);
                Constructor<?> constructor = ramClientClass.getConstructor(URL.class, String.class, String.class, String.class);
                return (AbstractRAMClient)constructor.newInstance(ramLocation, userName, password, onBehalfOfUserId);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                LoadEclipseClass eclipseLoader = this.getEclipseLoader();
                if (eclipseLoader != null && eclipseLoader.isEclipseRunning()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Loading the 'com.ibm.ram.internal.client.RAMClient' using Eclipse class loader");
                    }
                    ramClientClass = eclipseLoader.loadClass(RAM_CLIENT_CLASS_NAME, "com.ibm.ram.client", "[7.5.11,7.5.20)");
                    Constructor<Object> constructor = ramClientClass.getConstructor(URL.class, String.class, String.class, String.class);
                    return (AbstractRAMClient)constructor.newInstance(ramLocation, userName, password, onBehalfOfUserId);
                }
                return null;
            }
        }
    }

    private RAMAsset getAsset(AssetIdentification id, boolean includeForums, boolean includeRatings, boolean clearCache) throws RAMRuntimeException, RCAssetNotFoundException {
        if (clearCache == Boolean.FALSE) {
            return this.getAsset(id, includeForums, includeRatings);
        }
        RAMAsset ret = null;
        try {
            AssetSO wsAsset = this.fetchAssetFromServer(id, includeForums, includeRatings);
            if (wsAsset != null) {
                ret = new RAMAsset(this, wsAsset);
                this.fAssets.put(ret.getSessionKey(), ret);
            }
        }
        catch (AssetNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            throw new RCAssetNotFoundException(String.valueOf(ClientMessages.getString("RAMSession.AssetNotFound")) + " : " + id, e, true);
        }
        catch (EntitlementException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            throw new RAMRuntimeException("User " + this.getUser() + " is not authorized to view the asset " + id, e);
        }
        catch (RAMRuntimeException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
        return ret;
    }

    private RAMAsset getAsset(AssetIdentification id, boolean includeForums, boolean includeRatings) throws RAMRuntimeException, RCAssetNotFoundException {
        RAMAsset ret = null;
        try {
            AssetSO wsAsset;
            String key = RAMAsset.createSessionKey(id);
            if (this.fAssets.containsKey(key)) {
                ret = (RAMAsset)this.fAssets.get(key);
            }
            if (ret == null && (wsAsset = this.fetchAssetFromServer(id, includeForums, includeRatings)) != null) {
                ret = new RAMAsset(this, wsAsset);
                this.fAssets.put(ret.getSessionKey(), ret);
            }
        }
        catch (AssetNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            throw new RCAssetNotFoundException(String.valueOf(ClientMessages.getString("RAMSession.AssetNotFound")) + " : " + id, e, true);
        }
        catch (EntitlementException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            throw new RAMRuntimeException("User " + this.getUser() + " is not authorized to view the asset " + id, e);
        }
        catch (RAMRuntimeException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
        return ret;
    }

    public RAMAsset getAsset(AssetIdentification id) {
        return this.getAsset(id, false, false);
    }

    public RAMAsset getAsset(AssetIdentification id, boolean clearCache) {
        return this.getAsset(id, false, false, clearCache);
    }

    public RAMAsset getAsset(String GUID, String version) throws RAMRuntimeException {
        AssetIdentification id = new AssetIdentification(GUID, version);
        return this.getAsset(id, false, false);
    }

    public RAMCommunity[] getCommunitiesUserCanSubmitTo() throws RAMRuntimeException {
        RAMCommunity[] ret = new RAMCommunity[]{};
        try {
            CommunityInformation[] communities = this.getRAMClient().getRAM1Webservice().getCreateGroups();
            if (communities == null) {
                return new RAMCommunity[0];
            }
            ArrayList<RAMCommunity> coms = new ArrayList<RAMCommunity>();
            int i = 0;
            while (i < communities.length) {
                RAMCommunity community = this.getCommunity(communities[i].getId());
                if (community != null) {
                    coms.add(community);
                }
                ++i;
            }
            ret = coms.toArray(new RAMCommunity[coms.size()]);
        }
        catch (Throwable e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
        return ret;
    }

    public RAMAsset getAsset(String GUID) throws RAMRuntimeException {
        AssetIdentification id = new AssetIdentification(GUID, "*");
        return this.getAsset(id, false, false);
    }

    public SearchQuery createAssetQuery(String queryText) {
        RAMAssetQueryBuilder query = new RAMAssetQueryBuilder(this, this.getConstants());
        if (queryText != null && queryText.length() > 0 && queryText.startsWith("ramSearch:(") && queryText.endsWith(")")) {
            SearchNode searchNode = new SearchNode(queryText);
            List<String> textQueries = searchNode.getTextQueries();
            int i = 0;
            while (i < textQueries.size()) {
                query.addQueryTextField(textQueries.get(i));
                ++i;
            }
            List<FacetSelectionSO> facetSelections = searchNode.getFacetSelections();
            int i2 = 0;
            while (i2 < facetSelections.size()) {
                FacetSelectionSO selection = facetSelections.get(i2);
                query.addSearchFilter(selection.getFacetName(), selection.getItem());
                ++i2;
            }
        } else if (queryText != null && !"".equals(queryText)) {
            query.addQueryTextField(queryText);
        }
        return query;
    }

    public SearchResult getAssets(SearchQuery query) throws RAMRuntimeException {
        RAMSearchResult ret = null;
        try {
            SearchNode node = new SearchNode(query.getQueryString());
            String[] queryArray = node.getTextQueries().toArray(new String[node.getTextQueries().size()]);
            FacetSelectionSO[] facets = node.getAllSelections().toArray(new FacetSelectionSO[node.getAllSelections().size()]);
            SearchResultSO results = this.getRAMClient().getRAM1Webservice().search(queryArray, facets, query.isSortAscending(), query.getSortByField(), query.getResultsStartIndex(), query.getMaxResults(), query.getSearchModes(), query.isThisSearchRecorded(), this.getLocale().getLanguage());
            ret = new RAMSearchResult(this, results);
        }
        catch (Exception e) {
            if (e instanceof InvalidQueryException) {
                String mesage = MessageFormat.format(ClientMessages.getString("RAMSession.INVALID_SEARCH_QUERY"), query);
                throw new RAMRuntimeException(mesage, e);
            }
            throw new RAMRuntimeException(e.getMessage(), e);
        }
        return ret;
    }

    AssetSO fetchAssetFromServer(AssetIdentification id, boolean includeForums, boolean includeRatings) throws RemoteException, RAMRuntimeException, RAMServiceException, AssetNotFoundException, EntitlementException, RAMException {
        AssetSO wsAsset = this.fRAMClient.getRAM1Webservice().getAssetByID(id, true, true, includeForums, includeRatings, false, false, false, true, false, false, this.getLocale().getLanguage());
        return wsAsset;
    }

    CommunitySO fetchCommunityFromServer(int id) throws RAMException, RemoteException, RAMServiceException {
        CommunitySO[] wsCommunities = this.getRAMClient().getRAM1Webservice().getCommunities(new int[]{id}, false, false);
        if (wsCommunities != null && wsCommunities.length > 0) {
            return wsCommunities[0];
        }
        return null;
    }

    RAMAsset getAssetFromLocalCache(AssetInformation wsAsset) throws RAMRuntimeException {
        String key = RAMAsset.createSessionKey(wsAsset.getIdentification());
        RAMAsset ret = null;
        if (this.fAssets.containsKey(key)) {
            ret = (RAMAsset)this.fAssets.get(key);
        }
        if (ret == null) {
            ret = new RAMAsset(this, wsAsset);
            this.fAssets.put(ret.getSessionKey(), ret);
        }
        return ret;
    }

    public RAMAsset[] getModifiedAssets() {
        ArrayList<RAMAsset> ret = new ArrayList<RAMAsset>();
        int i = 0;
        while (i < this.fModified.size()) {
            RAMAsset asset;
            Object workItem = this.fModified.get(i);
            if (workItem instanceof RAMAsset && (asset = (RAMAsset)workItem).isDirty()) {
                ret.add(asset);
            }
            ++i;
        }
        return ret.toArray(new RAMAsset[ret.size()]);
    }

    public RAMAsset[] getQueuedAssets() {
        return this.fAssetQueue.toArray(new RAMAsset[this.fAssetQueue.size()]);
    }

    public RAMAsset getModifiedAsset(AssetIdentification id) {
        RAMAsset tmp;
        String key = RAMAsset.createSessionKey(id);
        RAMAsset ret = null;
        if (this.fAssets.containsKey(key) && (tmp = (RAMAsset)this.fAssets.get(key)).isDirty()) {
            ret = tmp;
        }
        return ret;
    }

    public RAMAsset getModifiedAsset(String GUID, String version) {
        RAMAsset tmp;
        AssetIdentification id = new AssetIdentification(GUID, version);
        String key = RAMAsset.createSessionKey(id);
        RAMAsset ret = null;
        if (this.fAssets.containsKey(key) && (tmp = (RAMAsset)this.fAssets.get(key)).isDirty()) {
            ret = tmp;
        }
        return ret;
    }

    public RAMAsset createAsset(String version) {
        RAMAsset ret = new RAMAsset(this, null, version, 0);
        this.fAssets.put(ret.getSessionKey(), ret);
        this.cache(ret);
        return ret;
    }

    public RAMAsset createAsset(String GUID, String version) {
        RAMAsset ret = new RAMAsset(this, GUID, version, 0);
        this.fAssets.put(ret.getSessionKey(), ret);
        this.cache(ret);
        return ret;
    }

    protected RAMAsset primCreateAsset(String GUID, String version, int managementStyle) {
        RAMAsset ret = new RAMAsset(this, GUID, version, managementStyle);
        this.fAssets.put(ret.getSessionKey(), ret);
        this.cache(ret);
        return ret;
    }

    public RAMAsset createAsset(Asset asset) {
        return this.createAsset(asset, new RAMStatusMonitor());
    }

    public RAMAsset createAsset(Asset asset, RAMStatusMonitor monitor) {
        if (asset == null) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMSession.NULL_ASSET_EXCEPTION"));
        }
        return this.createAsset(asset, null, asset.getIdentification().getVersion(), monitor);
    }

    public RAMAsset createAsset(Asset asset, String GUID) {
        return this.createAsset(asset, GUID, new RAMStatusMonitor());
    }

    public RAMAsset createAsset(Asset asset, String GUID, RAMStatusMonitor monitor) {
        if (asset == null) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMSession.NULL_ASSET_EXCEPTION"));
        }
        return this.createAsset(asset, GUID, asset.getIdentification().getVersion(), monitor);
    }

    public RAMAsset createAsset(Asset asset, String GUID, String version) {
        return this.createAsset(asset, GUID, version, new RAMStatusMonitor());
    }

    public RAMAsset createAsset(Asset asset, String GUID, String version, RAMStatusMonitor monitor) {
        RAMAsset ret = this.clone(asset, GUID, version, monitor);
        this.copyRelationship(ret);
        this.fAssets.put(ret.getSessionKey(), ret);
        this.cache(ret);
        return ret;
    }

    public RAMAsset createAsset(RAMAsset asset, String GUID, String version, CopyOption co, boolean checkDuplicate, RAMStatusMonitor monitor) {
        if (co == null) {
            logger.warn((Object)"parameter CopyOption could not be null, a valid Copy Option need to be offered. CopyAsset will return null.");
            return null;
        }
        if (monitor == null) {
            monitor = new RAMStatusMonitor();
        }
        long start = 0L;
        if (logger.isDebugEnabled()) {
            start = System.currentTimeMillis();
            logger.debug((Object)("Copy asset with copy option: " + co.toString()));
        }
        if (!monitor.isCanceled()) {
            String message = MessageFormat.format(ClientMessages.getString("RAMSession.COPY_ASSET"), asset.getName());
            int workRemaining = 100;
            monitor.beginTask(message, workRemaining);
        }
        monitor.subTask("copy asset meta data");
        RAMAsset ret = this.clone(asset, GUID, version, co, checkDuplicate, new RAMStatusMonitor((IProgressMonitor)monitor, 90));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("copy asset took: " + (System.currentTimeMillis() - start) + " ms to finish copying metadata of asset: " + asset.getIdentification().toString()));
            start = System.currentTimeMillis();
        }
        if (co.isSet(256L)) {
            monitor.subTask("copy asset relationship");
            this.copyRelationship(asset, ret);
        }
        monitor.worked(10);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("copy asset took: " + (System.currentTimeMillis() - start) + " ms to finish copying relationships of asset: " + asset.getIdentification().toString()));
        }
        monitor.subTask("cache asset");
        this.fAssets.put(ret.getSessionKey(), ret);
        this.cache(ret);
        monitor.done();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("copy asset finshed for asset: " + asset.getIdentification().toString()));
        }
        return ret;
    }

    private void copyRelationship(RAMAsset sourceAsset, RAMAsset ret) {
        RAMRelationship[] rAMRelationshipArray = (RAMRelationship[])sourceAsset.getRelationships();
        int n = rAMRelationshipArray.length;
        int n2 = 0;
        while (n2 < n) {
            RAMRelationship rel = rAMRelationshipArray[n2];
            ret.addRelatedAsset(rel.getChildAsset(), rel.getRelationshipType());
            ++n2;
        }
    }

    private void copyRelationship(RAMAsset ret) {
        Relationship[] rels = ret.getRelationships();
        String name = "Unknown Name";
        String version = "Unknown Version";
        int j = 0;
        while (j < rels.length) {
            try {
                RAMRelationship rel = (RAMRelationship)rels[j];
                name = rel.getChildAssetGUID();
                version = rel.getChildAssetVersion();
                RAMRelationshipType type = (RAMRelationshipType)rel.getRelationshipType();
                if (type == null) {
                    AssetInformation asset = new AssetInformation();
                    asset.getIdentification().setGUID(rel.getChildAssetGUID());
                    asset.getIdentification().setVersion(version);
                    logger.warn((Object)MessageFormat.format(ClientMessages.getString("BatchTarget.MISSING_RELATIONSHIP"), ret, asset));
                } else {
                    RAMAsset child = (RAMAsset)rel.getChildAsset();
                    if (child == null) {
                        AssetInformation asset = new AssetInformation();
                        asset.getIdentification().setGUID(rel.getChildAssetGUID());
                        asset.getIdentification().setVersion(version);
                        logger.warn((Object)MessageFormat.format(ClientMessages.getString("AssetUtil.COULD_NOT_FETCH_RELAEDTED_ASSET"), name, version, ret));
                    } else {
                        RelatedAsset relatedAsset = rel.getInternalRelatedAsset();
                        RelationshipInfo info = RelationshipRangeUtility.getInfo(relatedAsset);
                        if (info == null || !info.isReverseRange()) {
                            if (info != null && info.isSource()) {
                                relatedAsset.setDescription(null);
                            }
                            child.addReverseRelationship(ret, type.getReverseType(), info != null && info.getRange() != null);
                        } else {
                            ret.removeRelationship(rel, false);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)MessageFormat.format(ClientMessages.getString("BatchTarget.FETCH_RELATED"), ret, name, version), (Throwable)e);
            }
            ++j;
        }
    }

    public RAMAsset createAssetNewVersion(Asset asset, String version) {
        return this.createAssetNewVersion(asset, version, new RAMStatusMonitor());
    }

    public RAMAsset createAssetNewVersion(Asset asset, String version, RAMStatusMonitor monitor) {
        if (asset == null) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMSession.NULL_ASSET_EXCEPTION"));
        }
        AssetIdentification originalID = asset.getIdentification();
        RAMAsset ret = this.clone(asset, originalID.getGUID(), version, monitor);
        ret.setAsCreateNewVersion(originalID.getGUID(), originalID.getVersion());
        this.copyRelationship(ret);
        this.fAssets.put(ret.getSessionKey(), ret);
        this.cache(ret);
        return ret;
    }

    public RAMAsset replaceAssetNewVersion(Asset asset, String version) {
        String oldVersion;
        String GUID;
        if (!(asset instanceof RAMAsset && this.equals(((RAMAsset)asset).getSession()) || (asset = this.getAsset(GUID = asset.getIdentification().getGUID(), oldVersion = asset.getIdentification().getVersion())) != null)) {
            throw new RAMRuntimeException(MessageFormat.format(ClientMessages.getString("RAMSession.ASSET_NOT_FOUND"), asset), true);
        }
        RAMAsset ramAsset = (RAMAsset)asset;
        ramAsset.internalSetVersion(version);
        ramAsset.setUpdateAction();
        return ramAsset;
    }

    private RAMAsset clone(Asset sourceAsset, String GUID, String version, RAMStatusMonitor monitor) throws RAMRuntimeException {
        RAMAsset targetAsset = null;
        if (GUID == null) {
            GUID = UniqueIDGenerator.getUniqueID();
        }
        if (!monitor.isCanceled()) {
            String message = MessageFormat.format(ClientMessages.getString("AssetUtil.PORT_ASSET_INFO"), sourceAsset.getName());
            int workRemaining = 200;
            monitor.beginTask(message, workRemaining);
            boolean validManifest = true;
            try {
                targetAsset = this.getAsset(new AssetIdentification(GUID, version));
            }
            catch (RAMRuntimeException rAMRuntimeException) {
                if (sourceAsset instanceof RAMAsset) {
                    try {
                        targetAsset = this.portAssetManifest((RAMAsset)sourceAsset, GUID, version);
                    }
                    catch (Exception e1) {
                        logger.error((Object)(String.valueOf(ClientMessages.getString("AssetUtil.FAILED_TO_PORT_MANIFEST")) + " - " + sourceAsset), (Throwable)e1);
                        validManifest = false;
                    }
                }
                if (targetAsset == null) {
                    targetAsset = this.createAsset(GUID, version);
                }
                targetAsset.setName(sourceAsset.getName());
            }
            SessionStore store = SessionManager.getSessionManager().getSessionStore(this);
            RAMMappings mappings = store.getMappings();
            AssetUtil.portAssetInfo(targetAsset, sourceAsset, mappings, false, false, false, false, (IProgressMonitor)new RAMStatusMonitor((IProgressMonitor)monitor, 100));
            workRemaining -= 100;
            if (validManifest) {
                if (sourceAsset instanceof RAMAsset) {
                    try {
                        new LocalArchiveFolderArtifact(targetAsset, sourceAsset, (IProgressMonitor)new RAMStatusMonitor((IProgressMonitor)monitor, 100));
                        ((RAMFolderArtifact)targetAsset.getArtifactsRoot()).setAsRoot(targetAsset, targetAsset.getManifestBuilder().getSolution(), true);
                        workRemaining -= 100;
                    }
                    catch (Exception ex) {
                        logger.error((Object)(String.valueOf(ClientMessages.getString("AssetUtil.FAILED_TO_PORT_MANIFEST")) + " - " + sourceAsset), (Throwable)ex);
                    }
                } else {
                    try {
                        FolderArtifact sourceRoot = sourceAsset.getArtifactsRoot();
                        RAMFolderArtifact targetRoot = (RAMFolderArtifact)targetAsset.getArtifactsRoot();
                        this.portArtifacts(sourceRoot, targetRoot);
                    }
                    catch (Exception ex) {
                        logger.error((Object)(String.valueOf(ClientMessages.getString("AssetUtil.FAILED_TO_PORT_MANIFEST")) + " - " + sourceAsset), (Throwable)ex);
                    }
                }
            }
            if (workRemaining > 0) {
                monitor.worked(workRemaining);
            }
            monitor.done();
        }
        return targetAsset;
    }

    protected boolean checkAsset(String guid, String version) throws RAMServiceException, RAMRestException {
        if (this.compareServicesVersion(RAM_7_5_2_4_SERVICES_VERSION) >= 0) {
            return this.getRESTClient().checkAsset(guid, version);
        }
        throw new RAMRuntimeException("Associated service for check asset is not implemented in RAM repository. Need a RAM repository with version: " + this.getRAMClient().getServerVersion().toString() + " or above.");
    }

    private RAMAsset clone(RAMAsset sourceAsset, String GUID, String version, CopyOption co, boolean checkDuplicate, RAMStatusMonitor monitor) throws RAMRuntimeException {
        RAMAsset targetAsset = null;
        if (GUID == null) {
            GUID = UniqueIDGenerator.getUniqueID();
        }
        if (version == null) {
            version = sourceAsset.getIdentification().getVersion();
        }
        if (!monitor.isCanceled()) {
            if (checkDuplicate) {
                monitor.subTask("check existing asset");
                boolean exist = false;
                try {
                    exist = this.checkAsset(GUID, version);
                    if (exist) {
                        RAMRuntimeException ex = new RAMRuntimeException("Duplicated asset identification detected. There is a asset existing in repository with identification: " + GUID + "/" + version);
                        monitor.appendStatus(targetAsset, 4, 1019, ex.getMessage(), ex);
                        monitor.done();
                        throw ex;
                    }
                }
                catch (RAMServiceException e) {
                    e.printStackTrace();
                }
                catch (RAMRestException e) {
                    e.printStackTrace();
                }
            }
            monitor.subTask("create target asset with identification");
            if (targetAsset == null) {
                targetAsset = this.createAsset(GUID, version);
            }
            monitor.worked(10);
        }
        if (!monitor.isCanceled()) {
            monitor.subTask("copy asset name");
            if (co.isSet(2048L)) {
                targetAsset.setName(sourceAsset.getName());
            }
            monitor.worked(10);
        }
        if (!monitor.isCanceled()) {
            monitor.subTask("copy asset community");
            if (co.isSet(8L)) {
                targetAsset.setCommunity(sourceAsset.getCommunity());
            }
            monitor.worked(10);
        }
        if (!monitor.isCanceled()) {
            monitor.subTask("copy asset type");
            if (co.isSet(16L)) {
                targetAsset.setAssetType(sourceAsset.getAssetType());
            }
            monitor.worked(10);
        }
        if (!monitor.isCanceled()) {
            monitor.subTask("copy asset short description");
            if (co.isSet(1024L)) {
                targetAsset.setShortDescription(sourceAsset.getShortDescription());
            }
            monitor.worked(10);
        }
        if (!monitor.isCanceled()) {
            monitor.subTask("copy asset description");
            if (co.isSet(512L)) {
                targetAsset.setDescription(sourceAsset.getDescription());
            }
            monitor.worked(10);
        }
        if (!monitor.isCanceled()) {
            monitor.subTask("copy asset attributes");
            if (co.isSet(64L)) {
                AssetAttribute[] assetAttributes;
                AssetAttribute[] assetAttributeArray = assetAttributes = sourceAsset.getAssetAttributes();
                int n = assetAttributes.length;
                int n2 = 0;
                while (n2 < n) {
                    AssetAttribute attr = assetAttributeArray[n2];
                    AssetAttribute targetAttr = targetAsset.getAssetAttribute(attr.getName());
                    if (targetAttr != null) {
                        targetAttr.setValues(attr.getValues());
                    } else {
                        logger.warn((Object)("Asset attribute: " + attr.getName() + " from source is not found in target. copy for this attribute will be skipped"));
                    }
                    ++n2;
                }
            }
            monitor.worked(10);
        }
        if (!monitor.isCanceled()) {
            long start;
            monitor.subTask("copy asset artifacts");
            if (co.isSet(4L)) {
                start = System.currentTimeMillis();
                this.processArtifact(sourceAsset, targetAsset, new RAMStatusMonitor((IProgressMonitor)monitor, 100));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Function takes: " + (System.currentTimeMillis() - start) + " ms to finish artifact copying"));
                }
            }
            monitor.worked(10);
            monitor.subTask("copy category");
            if (co.isSet(32L)) {
                start = System.currentTimeMillis();
                RAMSession.portAssetCategories(sourceAsset, targetAsset);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Function takes: " + (System.currentTimeMillis() - start) + " ms to finish category copying"));
                }
            }
            monitor.worked(10);
        }
        monitor.appendStatus(targetAsset, 0, 2, "Finish copying asset.", null);
        monitor.done();
        return targetAsset;
    }

    private void processArtifact(RAMAsset sourceAsset, RAMAsset targetAsset, RAMStatusMonitor monitor) {
        try {
            String msg;
            InputStream is = null;
            try {
                is = sourceAsset.getContents();
            }
            catch (RAMRuntimeException e) {
                logger.warn((Object)"Error happens while get artifact stream from repository.", (Throwable)e);
                monitor.appendStatus(targetAsset, 4, 1020, "Error happens while get artifact stream from repository.", e);
            }
            catch (IOException e) {
                logger.warn((Object)"IOException happens while get artifact stream from repository.", (Throwable)e);
                monitor.appendStatus(targetAsset, 4, 1020, "IOException happens while get artifact stream from repository.", e);
            }
            if (is != null) {
                try {
                    monitor.subTask("load artifacts existing in repository.");
                    new LocalArchiveFolderArtifact(targetAsset, sourceAsset, (IProgressMonitor)new RAMStatusMonitor((IProgressMonitor)monitor, 100));
                    ((RAMFolderArtifact)targetAsset.getArtifactsRoot()).setAsRoot(targetAsset, targetAsset.getManifestBuilder().getSolution(), true);
                    monitor.worked(40);
                }
                catch (Exception ex) {
                    msg = String.valueOf(ClientMessages.getString("AssetUtil.FAILED_TO_PORT_MANIFEST")) + " - " + sourceAsset;
                    logger.error((Object)msg, (Throwable)ex);
                    monitor.appendStatus(targetAsset, 4, 1020, msg, ex);
                }
            }
            if (sourceAsset.isAssetDirty()) {
                if (!sourceAsset.isArtifactsRootNull()) {
                    monitor.subTask("load local artifact.");
                    try {
                        FolderArtifact sourceRoot = sourceAsset.getArtifactsRoot();
                        RAMFolderArtifact targetRoot = (RAMFolderArtifact)targetAsset.getArtifactsRoot();
                        this.portArtifacts(sourceRoot, targetRoot);
                        monitor.worked(40);
                    }
                    catch (Exception ex) {
                        msg = String.valueOf(ClientMessages.getString("AssetUtil.FAILED_TO_PORT_MANIFEST")) + " - " + sourceAsset;
                        logger.error((Object)msg, (Throwable)ex);
                        monitor.appendStatus(targetAsset, 4, 1020, msg, ex);
                    }
                } else {
                    logger.warn((Object)"artifacts root of source asset is not specified. User needs to invoke RAMAsset.setArtifactsRoot(FolderArtifact root) to specify the artifact root for local artifacts. Copy artifact process will skip copy local artifacts untill root artifact of source asset is specified.");
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private static void findSetSubCategories(SubCategory[] children, List setList) {
        int i = 0;
        while (i < children.length) {
            SubCategory[] grandChildren;
            if (children[i].isSet()) {
                setList.add(children[i]);
            }
            if ((grandChildren = children[i].getSubCategories()) != null && grandChildren.length > 0) {
                RAMSession.findSetSubCategories(grandChildren, setList);
            }
            ++i;
        }
    }

    private static void portAssetCategories(Asset sourceAsset, RAMAsset targetAsset) {
        RAMSession targetSession = targetAsset.getSession();
        CategorySchema[] schemas = sourceAsset.getCategorySchemas();
        if (schemas != null) {
            int i = 0;
            while (i < schemas.length) {
                Category[] categories = schemas[i].getCategories();
                int j = 0;
                while (j < categories.length) {
                    ArrayList categorizationsList = new ArrayList();
                    SubCategory[] children = categories[j].getSubCategories();
                    RAMSession.findSetSubCategories(children, categorizationsList);
                    SubCategory[] categorizations = categorizationsList.toArray(new SubCategory[categorizationsList.size()]);
                    int k = 0;
                    while (k < categorizations.length) {
                        try {
                            SubCategory subCategory = categorizations[k];
                            String fullPath = subCategory.getFullPath();
                            SubCategory targetSubCategory = AssetUtil.fetchSubCategory(targetSession, fullPath);
                            if (targetSubCategory == null) {
                                String message = MessageFormat.format(ClientMessages.getString("AssetUtil.CATEGORY_NOT_FOUND"), categorizations[k]);
                                logger.error((Object)message);
                            } else {
                                targetAsset.categorize(targetSubCategory);
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void portArtifacts(FolderArtifact sourceRoot, RAMFolderArtifact targetRoot) {
        if (sourceRoot == null) {
            return;
        }
        Artifact[] sourceChildren = sourceRoot.getChildren();
        int i = 0;
        while (i < sourceChildren.length) {
            Artifact sourceArtifact;
            Artifact replaceArtifact = null;
            boolean isFolder = false;
            if (sourceChildren[i] instanceof LocalFileArtifact) {
                sourceArtifact = (LocalFileArtifact)sourceChildren[i];
                replaceArtifact = new LocalFileArtifact(((LocalFileArtifact)sourceArtifact).getFile());
            } else if (sourceChildren[i] instanceof LocalArchiveFolderArtifact) {
                sourceArtifact = (LocalArchiveFolderArtifact)sourceChildren[i];
                replaceArtifact = new LocalArchiveFolderArtifact(((LocalArchiveFolderArtifact)sourceArtifact).getArchiveFile());
            } else if (sourceChildren[i] instanceof LocalFolderArtifact) {
                sourceArtifact = (LocalFolderArtifact)sourceChildren[i];
                replaceArtifact = new LocalFolderArtifact(((LocalFolderArtifact)sourceArtifact).getFolder());
                isFolder = true;
            } else if (sourceChildren[i] instanceof FolderArtifact) {
                sourceArtifact = (FolderArtifact)sourceChildren[i];
                replaceArtifact = new RAMFolderArtifact(sourceArtifact.getPath(), sourceArtifact.getName());
                isFolder = true;
            } else if (sourceChildren[i] instanceof URLArtifact) {
                sourceArtifact = (URLArtifact)sourceChildren[i];
                replaceArtifact = new RAMURLArtifact(((URLArtifact)sourceArtifact).getURL());
            } else {
                replaceArtifact = new RAMArtifact(targetRoot.getAsset());
            }
            if (replaceArtifact != null) {
                ((Artifact)replaceArtifact).setLabel(sourceChildren[i].getLabel());
                ((Artifact)replaceArtifact).setMimeType(sourceChildren[i].getMimeType());
                if (sourceChildren[i].getReference() != null) {
                    ArtifactReference sourceRef = sourceChildren[i].getReference();
                    ArtifactReference targetRef = ((Artifact)replaceArtifact).getReference();
                    targetRef.setDescription(sourceRef.getDescription());
                    targetRef.setKind(sourceRef.getKind());
                    targetRef.setValue(sourceRef.getValue());
                }
                ((Artifact)replaceArtifact).setName(sourceChildren[i].getName());
                ((Artifact)replaceArtifact).setPath(sourceChildren[i].getPath());
                targetRoot.addArtifact(replaceArtifact);
            }
            if (isFolder) {
                this.portArtifacts((FolderArtifact)sourceChildren[i], (RAMFolderArtifact)replaceArtifact);
            }
            ++i;
        }
    }

    private RAMAsset portAssetManifest(RAMAsset sourceAsset, String GUID, String version) throws IOException {
        RAMAsset ret = null;
        if (sourceAsset != null) {
            ResourceSet sourceRS = sourceAsset.getManifestBuilder().getManifestResourceSet();
            Resource sourceNewResource = sourceRS.createResource(URI.createURI((String)"tmp://manifest"));
            sourceNewResource.getContents().add((Object)EcoreUtil.copy((EObject)sourceAsset.getManifestBuilder().getManifest()));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            sourceNewResource.save((OutputStream)bos, null);
            String sourceManifest = bos.toString("UTF-8");
            sourceRS.getResources().remove((Object)sourceNewResource);
            String manifestString = sourceManifest;
            ret = this.createAsset(GUID, version);
            ret.setName(sourceAsset.getName());
            ret.setManifest(manifestString);
        }
        return ret;
    }

    public RAMAssetType createAssetType(String name) {
        if (this.fAssetTypesByName == null) {
            this.initAssetTypeCache();
        }
        RAMAssetType ret = new RAMAssetType(this, name);
        this.fAssetTypesByName.put(name, ret);
        this.cache(ret);
        return ret;
    }

    public RAMCategorySchema createCategorySchema(String name) {
        if (this.fCategorySchemasByName == null) {
            this.initCategorySchemaCache();
        }
        RAMCategorySchema ret = new RAMCategorySchema(this, name);
        this.fCategorySchemasByName.put(name, ret);
        this.cache(ret);
        return ret;
    }

    public RAMCommunity createCommunity(String name) {
        RAMCommunity ret = new RAMCommunity(this, name);
        if (this.fCommunitiesByName == null) {
            this.initCommunitiesCache();
        }
        this.fCommunitiesByName.put(name, ret);
        this.cache(ret);
        return ret;
    }

    public RAMCommunityAssetType createCommunityAssetType(String name, CommunityInformation community) {
        RAMAssetType master = this.getAssetType(name);
        if (master == null) {
            master = this.createAssetType(name);
            master.setRestricted(true);
        }
        return (RAMCommunityAssetType)master.createCommunityAssetType(community);
    }

    public RAMCommunityAssetType getCommunityAssetType(AssetType master, CommunityInformation community) {
        RAMAssetType ramMaster = null;
        if (master == null) {
            String message = MessageFormat.format(ClientMessages.getString("RAMSession.MASTER_ASSET_TYPE_NOT_FOUND"), master);
            throw new RAMRuntimeException(message, true);
        }
        ramMaster = !(master instanceof RAMAssetType) || ((RAMAssetType)master).getSession() != this ? this.getAssetType(master.getName()) : (RAMAssetType)master;
        if (ramMaster == null) {
            String message = MessageFormat.format(ClientMessages.getString("RAMSession.MASTER_ASSET_TYPE_NOT_FOUND"), master);
            throw new RAMRuntimeException(message, true);
        }
        return (RAMCommunityAssetType)ramMaster.getCommunityAssetType(community);
    }

    public int getWebServiceTimeout() {
        AbstractRAMClient client = this.getRAMClient();
        int wsTimeOut = client.getWebServicesTimeout();
        int inSeconds = wsTimeOut <= 0 ? -1 : (wsTimeOut <= 1000 ? 1 : wsTimeOut / 1000);
        return inSeconds;
    }

    public void setWebServiceTimeout(int seconds) {
        int milliseconds = seconds * 1000;
        AbstractRAMClient client = this.getRAMClient();
        client.setWebServicesTimeout(milliseconds);
    }

    public int getUploadTimeout() {
        AbstractRAMClient client = this.getRAMClient();
        int wsTimeOut = client.getUploadDownloadTimeout();
        int inSeconds = wsTimeOut <= 0 ? -1 : (wsTimeOut <= 1000 ? 1 : wsTimeOut / 1000);
        return inSeconds;
    }

    public void setUploadTimeout(int seconds) {
        int milliseconds = seconds * 1000;
        AbstractRAMClient client = this.getRAMClient();
        client.setUploadDownloadTimeout(milliseconds);
    }

    public RAMAssetAttribute createAssetAttribute(String name) {
        if (this.fAttributesByName == null) {
            this.initAttributeCache();
        }
        RAMAssetAttribute ret = new RAMAssetAttribute(this, name);
        this.fAttributesByName.put(name, ret);
        this.cache(ret);
        return ret;
    }

    public RAMRelationshipType createRelationshipType(String name, String reverseName) {
        if (this.fRelationshipTypeByName == null) {
            this.initRelationshipType();
        }
        RAMRelationshipType ret = new RAMRelationshipType(this, name, reverseName, true);
        RAMRelationshipType reverse = new RAMRelationshipType(this, reverseName, name, false);
        this.fRelationshipTypeByName.put(name, ret);
        this.fRelationshipTypeByDisplayName.put(name, ret);
        this.fRelationshipTypeByName.put(reverseName, reverse);
        this.fRelationshipTypeByDisplayName.put(reverseName, reverse);
        this.cache(ret);
        return ret;
    }

    public void clear() {
        this.clear(false);
    }

    protected void clear(boolean includeMetaModel) {
        if (!includeMetaModel) {
            RAMAsset[] assets = this.fAssets.values().toArray(new RAMAsset[this.fAssets.size()]);
            int i = 0;
            while (i < assets.length) {
                RAMAsset asset = assets[i];
                this.remove(asset);
                ++i;
            }
            this.fResourceSet = null;
        } else {
            this.clearStorageFolder();
            if (this.fAssets != null) {
                this.fAssets.clear();
            }
            if (this.fAssetQueue != null) {
                this.fAssetQueue.clear();
            }
            if (this.fModified != null) {
                this.fModified.clear();
            }
            this.fAssetTypesByName = null;
            this.fAssetTypesByURI = null;
            this.fCommunitiesByName = null;
            this.fCommunitiesById = null;
            this.fRelationshipTypeByName = null;
            this.fRelationshipTypeByDisplayName = null;
            this.fCategorySchemasByURI = null;
            this.fCategorySchemasByName = null;
            this.fAttributesByName = null;
            this.fAttributesByURI = null;
            this.fStatesByName = null;
            this.fStatesById = null;
            this.fUsersByUid = null;
            this.fLibraries = null;
            this.fServerToLocalEMFURIResourceMap = null;
            this.fWhoIsInTheAssetPipeline = null;
            this.fResourceSet = null;
        }
    }

    synchronized ResourceSet getResourceSet() {
        if (this.fResourceSet == null) {
            SessionManager initializer = SessionManager.getSessionManager();
            this.fResourceSet = initializer.createCachedResourceSet(this.getRAMClient(), this.getServerToLocalEMFURIResourceMap(), this.getLocalStorageFolder());
        }
        return this.fResourceSet;
    }

    Map<URI, URI> getServerToLocalEMFURIResourceMap() {
        if (this.fServerToLocalEMFURIResourceMap == null) {
            this.fServerToLocalEMFURIResourceMap = new HashMap<URI, URI>();
        }
        return this.fServerToLocalEMFURIResourceMap;
    }

    void deleteAsset(RAMAsset asset, RAMStatusMonitor monitor) throws RAMRuntimeException {
        if (!monitor.isCanceled()) {
            String message = MessageFormat.format(ClientMessages.getString("RAMSession.DELETE_ASSET"), asset.toLocalizedString());
            monitor.beginTask(message, 1);
            monitor.subTask(message);
            try {
                this.getRAMClient().getRAM1Webservice().deleteAssetByID(asset.getIdentification());
                monitor.worked(1);
            }
            catch (Exception e) {
                throw new RAMRuntimeException(e.getLocalizedMessage(), e);
            }
        }
    }

    public RAMCommunity getCommunity(String name) throws RAMRuntimeException {
        if (this.fCommunitiesByName == null) {
            this.initCommunitiesCache();
        }
        return (RAMCommunity)this.fCommunitiesByName.get(name);
    }

    public RAMCategorySchema getCategorySchema(String name) {
        if (this.fCategorySchemasByName == null) {
            this.initCategorySchemaCache();
        }
        return (RAMCategorySchema)this.fCategorySchemasByName.get(name);
    }

    public RAMAssetAttribute[] getAllAssetAttributes() throws RAMRuntimeException {
        if (this.fAttributesByName == null) {
            this.initAttributeCache();
        }
        Collection attributes = this.fAttributesByName.values();
        return attributes.toArray(new RAMAssetAttribute[attributes.size()]);
    }

    public RAMAssetAttribute getAssetAttribute(String name) {
        if (this.fAttributesByName == null) {
            this.initAttributeCache();
        }
        return (RAMAssetAttribute)this.fAttributesByName.get(name);
    }

    public RAMAssetAttribute getAssetAttributeByURI(String uri) {
        if (this.fAttributesByURI == null) {
            this.initAttributeCache();
        }
        return (RAMAssetAttribute)this.fAttributesByURI.get(uri);
    }

    public RAMCategorySchema getCategorySchemaByURI(String uri) {
        if (this.fCategorySchemasByURI == null) {
            this.initCategorySchemaCache();
        }
        return (RAMCategorySchema)this.fCategorySchemasByURI.get(uri);
    }

    public RAMCommunity getCommunity(int id) throws RAMRuntimeException {
        if (this.fCommunitiesById == null) {
            this.initCommunitiesCache();
        }
        return (RAMCommunity)this.fCommunitiesById.get(new Integer(id));
    }

    public RAMCommunity[] getAllCommunities() throws RAMRuntimeException {
        if (this.fCommunitiesByName == null) {
            this.initCommunitiesCache();
        }
        Collection assetTypes = this.fCommunitiesByName.values();
        return assetTypes.toArray(new RAMCommunity[assetTypes.size()]);
    }

    public RAMCommunity[] getCommunitiesUserAdministers() {
        RAMCommunity[] ret = null;
        try {
            CommunityInformation[] communities = this.getRAMClient().getRAM1Webservice().getAdminGroups();
            if (communities == null) {
                return new RAMCommunity[0];
            }
            ret = new RAMCommunity[communities.length];
            int i = 0;
            while (i < communities.length) {
                ret[i] = this.getCommunity(communities[i].getId());
                ++i;
            }
        }
        catch (Throwable e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
        return ret;
    }

    public RAMCategorySchema[] getAllCategorySchemas() throws RAMRuntimeException {
        if (this.fCategorySchemasByURI == null) {
            this.initCategorySchemaCache();
        }
        Collection assetTypes = this.fCategorySchemasByURI.values();
        return assetTypes.toArray(new RAMCategorySchema[assetTypes.size()]);
    }

    public RAMAssetType[] getAllAssetTypes() throws RAMRuntimeException {
        if (this.fAssetTypesByName == null) {
            this.initAssetTypeCache();
        }
        Collection assetTypes = this.fAssetTypesByName.values();
        return assetTypes.toArray(new RAMAssetType[assetTypes.size()]);
    }

    public RAMAssetType getAssetType(String name) throws RAMRuntimeException {
        if (this.fAssetTypesByName == null) {
            this.initAssetTypeCache();
        }
        return (RAMAssetType)this.fAssetTypesByName.get(name);
    }

    public RAMAssetType getAssetTypeByURI(String uri) throws RAMRuntimeException {
        if (this.fAssetTypesByURI == null) {
            this.initAssetTypeCache();
        }
        return (RAMAssetType)this.fAssetTypesByURI.get(uri);
    }

    public String getServicesVersion() throws RAMRuntimeException {
        try {
            return this.getRAMClient().getRAM1Webservice().getVersion();
        }
        catch (RAMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public String getClientVersion() {
        return AbstractRAMClient.RICH_CLIENT_VERSION_CURRENT;
    }

    public RAMState getState(String name) {
        if (this.fStatesByName == null) {
            this.initStates();
        }
        return this.fStatesByName.get(name);
    }

    public RAMState getStateById(int id) {
        if (this.fStatesById == null) {
            this.initStates();
        }
        return this.fStatesById.get(new Integer(id));
    }

    private synchronized void initStates() throws RAMRuntimeException {
        if (this.fStatesById == null || this.fStatesByName == null) {
            try {
                this.fStatesById = new HashMap<Integer, RAMState>();
                this.fStatesByName = new HashMap<String, RAMState>();
                State[] assetStates = this.getRAMClient().getRAM1Webservice().getAllStates();
                int i = 0;
                while (i < assetStates.length) {
                    RAMState state = new RAMState(this, assetStates[i]);
                    Integer id = new Integer(state.getId());
                    this.fStatesById.put(id, state);
                    this.fStatesByName.put(state.getName(), state);
                    ++i;
                }
            }
            catch (Throwable e) {
                throw new RAMRuntimeException(e.getLocalizedMessage(), e);
            }
        }
    }

    public int compareServicesVersion(String version) throws RAMRuntimeException {
        int ret = 0;
        String thisVersion = this.getServicesVersion();
        if (thisVersion == null || version == null) {
            throw new RAMRuntimeException("Null is incomparable");
        }
        StringTokenizer passedInToker = new StringTokenizer(version, ".");
        StringTokenizer thisToker = new StringTokenizer(thisVersion, ".");
        while (thisToker.hasMoreTokens() && passedInToker.hasMoreTokens()) {
            String thisToken = thisToker.nextToken();
            String passedInToken = passedInToker.nextToken();
            int thisPart = Integer.parseInt(thisToken);
            int passedInPart = Integer.parseInt(passedInToken);
            if (passedInPart < thisPart) {
                ret = 1;
                break;
            }
            if (thisPart >= passedInPart) continue;
            ret = -1;
            break;
        }
        return ret;
    }

    private void initAssetTypeCache() throws RAMRuntimeException {
        try {
            SessionManager initializer = SessionManager.getSessionManager();
            AssetTypeSO[] allAssetTypes = initializer.getAssetTypeCache(this.getRAMClient());
            this.fAssetTypesByName = new HashMap();
            this.fAssetTypesByURI = new HashMap();
            int i = 0;
            while (allAssetTypes != null && i < allAssetTypes.length) {
                AssetTypeSO assetType = allAssetTypes[i];
                RAMAssetType ramAssetType = new RAMAssetType(this, assetType);
                this.fAssetTypesByURI.put(assetType.getURI(), ramAssetType);
                this.fAssetTypesByName.put(assetType.getName(), ramAssetType);
                ++i;
            }
        }
        catch (Exception e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
    }

    private void initCommunitiesCache() throws RAMRuntimeException {
        try {
            SessionManager initializer = SessionManager.getSessionManager();
            CommunityInformation[] allCommunities = initializer.getCommunitiesCache(this.getRAMClient());
            this.fCommunitiesByName = new HashMap();
            this.fCommunitiesById = new HashMap();
            if (allCommunities != null) {
                int i = 0;
                while (i < allCommunities.length) {
                    if (!this.isInternalCommunity(allCommunities[i])) {
                        CommunityInformation community = allCommunities[i];
                        RAMCommunity ramCommunity = new RAMCommunity(this, allCommunities[i]);
                        this.fCommunitiesById.put(new Integer(community.getId()), ramCommunity);
                        this.fCommunitiesByName.put(community.getName(), ramCommunity);
                    }
                    ++i;
                }
            } else {
                logger.warn((Object)"No Communities were found on the server");
            }
        }
        catch (Exception e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
    }

    private boolean isInternalCommunity(CommunityInformation community) {
        return community == null || community.getId() == 0 || community.getId() == 1;
    }

    private void initRelationshipType() throws RAMRuntimeException {
        try {
            SessionManager initializer = SessionManager.getSessionManager();
            RelationshipType[] assetRelationTypes = initializer.getRelationshipTypeCache(this.getRAMClient());
            this.fRelationshipTypeByDisplayName = new HashMap();
            this.fRelationshipTypeByName = new HashMap();
            int i = 0;
            while (i < assetRelationTypes.length) {
                RAMRelationshipType ramRelationshipType = new RAMRelationshipType(this, assetRelationTypes[i]);
                this.fRelationshipTypeByName.put(assetRelationTypes[i].getName(), ramRelationshipType);
                this.fRelationshipTypeByDisplayName.put(assetRelationTypes[i].getDisplayName(), ramRelationshipType);
                ++i;
            }
        }
        catch (Throwable e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
    }

    private void initAttributeCache() throws RAMRuntimeException {
        try {
            SessionManager initializer = SessionManager.getSessionManager();
            AssetAttribute[] attributes = initializer.getAssetAttributeCache(this.getRAMClient());
            this.fAttributesByName = new HashMap();
            this.fAttributesByURI = new HashMap();
            int i = 0;
            while (i < attributes.length) {
                RAMAssetAttribute attribute = new RAMAssetAttribute(this, attributes[i]);
                this.fAttributesByName.put(attribute.getName(), attribute);
                this.fAttributesByURI.put(attribute.getURI(), attribute);
                ++i;
            }
        }
        catch (Exception ex) {
            logger.warn((Object)ClientMessages.getString("RAMSession.8"), (Throwable)ex);
        }
    }

    private void initCategorySchemaCache() throws RAMRuntimeException {
        try {
            SessionManager initializer = SessionManager.getSessionManager();
            String[] schemauris = initializer.getAllCatgeorySchemaURIs(this.getRAMClient());
            this.fCategorySchemasByName = new HashMap();
            this.fCategorySchemasByURI = new HashMap();
            ResourceSet resSet = this.getResourceSet();
            int i = 0;
            while (i < schemauris.length) {
                try {
                    if (!schemauris[i].endsWith(ASSET_TYPE_SCHEMA_URI)) {
                        ClassificationSchema categorySchema = (ClassificationSchema)resSet.getEObject(URI.createURI((String)schemauris[i]), true);
                        RAMCategorySchema schema = new RAMCategorySchema(this, categorySchema);
                        this.fCategorySchemasByName.put(categorySchema.getName(), schema);
                        this.fCategorySchemasByURI.put(schema.getURI(), schema);
                    }
                }
                catch (Exception e) {
                    String message = MessageFormat.format(ClientMessages.getString("RAMSession.FAILED_TO_LOAD_CATEGORY_SCHEMA"), schemauris[i]);
                    logger.warn((Object)message, (Throwable)e);
                }
                ++i;
            }
        }
        catch (Throwable e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
    }

    private String[] copySchemasToLocalOS(String[] schemauris) throws IOException, RAMRuntimeException {
        SessionManager initializer = SessionManager.getSessionManager();
        return initializer.copySchemasToLocalOS(this.getRAMClient(), schemauris, this.getLocalStorageFolder());
    }

    public RAMUser getUser(String userid) throws RAMRuntimeException {
        UserInformation remoteUser;
        RAMUser user = null;
        if (this.fUsersByUid == null) {
            this.fUsersByUid = new HashMap();
        }
        if (this.fUsersByUid.containsKey(userid)) {
            user = (RAMUser)this.fUsersByUid.get(userid);
        }
        if (user == null && (remoteUser = this.fetchUserFromServer(userid)) != null) {
            user = new RAMUser(this, remoteUser);
            this.fUsersByUid.put(user.getUid(), user);
        }
        return user;
    }

    RAMUser fetchUser(UserInformation remoteUser) throws RAMRuntimeException {
        RAMUser user = null;
        if (remoteUser == null) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMSession.USER_CANNOT_BE_NULL"), true);
        }
        if (this.fUsersByUid == null) {
            this.fUsersByUid = new HashMap();
        }
        if (this.fUsersByUid.containsKey(remoteUser.getUid())) {
            user = (RAMUser)this.fUsersByUid.get(remoteUser.getUid());
        }
        if (user == null) {
            user = new RAMUser(this, remoteUser);
            this.fUsersByUid.put(remoteUser.getUid(), user);
        }
        return user;
    }

    private UserInformation fetchUserFromServer(String userid) throws RAMRuntimeException {
        UserInformation userInfo;
        block14: {
            userInfo = null;
            try {
                if (userid == null) break block14;
                UserInformation[] users = this.getRAMClient().getRAM1Webservice().getUsers(new String[]{userid});
                if (users != null) {
                    int i = 0;
                    while (i < users.length) {
                        if (users[i] != null && users[i].getUid() != null && users[i].getUid().equals(userid)) {
                            userInfo = users[i];
                            break;
                        }
                        ++i;
                    }
                }
                if (userInfo == null) {
                    try {
                        users = this.getRAMClient().getRAM1Webservice().searchUsers(userid, false, this.getLocale().getLanguage());
                        if (users != null && users.length >= 1) {
                            userInfo = users[0];
                        }
                    }
                    catch (Exception exception) {}
                    if (userInfo == null) {
                        try {
                            users = this.getRAMClient().getRAM1Webservice().searchUsers(userid, true, this.getLocale().getLanguage());
                            if (users != null && users.length >= 1) {
                                userInfo = users[0];
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                if (userInfo == null) {
                    userInfo = new UserInformation();
                    userInfo.setName(userid);
                    userInfo.setRegistered(false);
                    userInfo.setUid(userid);
                    userInfo.setRepositoryUser(false);
                }
            }
            catch (Throwable e) {
                throw new RAMRuntimeException(e.getLocalizedMessage(), e);
            }
        }
        return userInfo;
    }

    public RAMRelationshipType[] getAllRelationshipTypes() throws RAMRuntimeException {
        if (this.fRelationshipTypeByName == null) {
            this.initRelationshipType();
        }
        Collection relationshipTypes = this.fRelationshipTypeByName.values();
        return relationshipTypes.toArray(new RAMRelationshipType[relationshipTypes.size()]);
    }

    public RAMRelationshipType getRelationshipType(String name) throws RAMRuntimeException {
        RAMRelationshipType ret;
        if (this.fRelationshipTypeByName == null) {
            this.initRelationshipType();
        }
        if ((ret = (RAMRelationshipType)this.fRelationshipTypeByName.get(name)) == null) {
            ret = (RAMRelationshipType)this.fRelationshipTypeByDisplayName.get(name);
        }
        return ret;
    }

    public RepositoryIdentification getIdentification() {
        if (this.fRepositoryIdentification == null) {
            this.fRepositoryIdentification = SessionManager.getSessionManager().getIdentification(this.getRAMClient());
        }
        RepositoryIdentification id = new RepositoryIdentification(this.fRepositoryIdentification.getId(), this.fRepositoryIdentification.getServerURL(), this.fRepositoryIdentification.getLoginId());
        return id;
    }

    Constants getConstants() throws RAMRuntimeException {
        try {
            if (this.fConstants == null) {
                this.fConstants = this.getRAMClient().getWebServiceConstants();
            }
        }
        catch (Exception e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
        return this.fConstants;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RAMStatus putAssets(IProgressMonitor monitor) throws RAMRuntimeException, IOException {
        block41: {
            block42: {
                block40: {
                    block39: {
                        if (monitor == null) {
                            monitor = new NullProgressMonitor();
                        }
                        TICKS = 10;
                        workItems = this.fAssetQueue.toArray(new IRAMSessionObject[this.fAssetQueue.size()]);
                        count = workItems.length;
                        UPLOAD_TICKS = count * TICKS;
                        monitor.beginTask(ClientMessages.getString("RAMSession.7"), UPLOAD_TICKS);
                        ramStatusMonitor = this.wrapInRAMStatusIfNeeded(monitor, UPLOAD_TICKS);
                        status = ramStatusMonitor.getStatus();
                        assets = new ArrayList<IRAMSessionObject>();
                        hasRelConsttaints = false;
                        group = new ThreadGroup("Upload Assets Threads");
                        pool = new Thread[RAMSession.MAX_UPLOAD_THREADS];
                        theadPointer = 0;
                        if (RAMSession.logger.isDebugEnabled()) {
                            RAMSession.logger.debug((Object)"Create an upload plan");
                        }
                        i = 0;
                        while (!ramStatusMonitor.isCanceled() && i < count) {
                            block35: {
                                block34: {
                                    block33: {
                                        workItem = workItems[i];
                                        if (!(workItem instanceof RAMAsset)) break block33;
                                        asset = (RAMAsset)workItem;
                                        if (RAMSession.logger.isDebugEnabled()) {
                                            RAMSession.logger.debug((Object)("Check position of " + asset));
                                        }
                                        keep = true;
                                        curAsset = asset;
                                        if (!asset.isUpdate() && !asset.isCreate()) break block34;
                                        keep = this.keepAtCurrentPosition(assets, asset);
                                        if (hasRelConsttaints || (constatintGroupings = this.getRelationshipConstaints(asset)) == null || constatintGroupings.size() <= 0) break block34;
                                        if (RAMSession.logger.isDebugEnabled()) {
                                            RAMSession.logger.debug((Object)"Has constraints");
                                        }
                                        j = 0;
                                        if (true) ** GOTO lbl49
                                    }
                                    message = MessageFormat.format(ClientMessages.getString("RAMSession.UNKNOW_OBJECT"), new Object[]{workItem});
                                    RAMSession.logger.warn((Object)message);
                                    status.appendStatus(workItem, 2, 1000, message, null);
                                    this.fAssetQueue.remove(workItem);
                                    ramStatusMonitor.worked(TICKS);
                                    break block35;
                                    do {
                                        if ((grouping = (ConstraintGrouping)constatintGroupings.get(j)) instanceof RelationshipGrouping) {
                                            hasRelConsttaints = true;
                                            if (!RAMSession.logger.isDebugEnabled()) break;
                                            RAMSession.logger.debug((Object)"Has relationship constraints");
                                            break;
                                        }
                                        ++j;
lbl49:
                                        // 2 sources

                                    } while (j < constatintGroupings.size());
                                }
                                if (i != count - 1) {
                                    while (!keep) {
                                        tmp = workItems;
                                        workItems = new IRAMSessionObject[tmp.length];
                                        System.arraycopy(tmp, 0, workItems, 0, i);
                                        System.arraycopy(tmp, i + 1, workItems, i, count - i - 1);
                                        workItems[count - 1] = curAsset;
                                        curAsset = (RAMAsset)workItems[i];
                                        if (curAsset == asset) break;
                                        keep = this.keepAtCurrentPosition(assets, curAsset);
                                    }
                                }
                                assets.add(workItems[i]);
                            }
                            ++i;
                        }
                        if (RAMSession.logger.isDebugEnabled()) {
                            RAMSession.logger.debug((Object)"Upload the assets ");
                        }
                        i = 0;
                        while (!ramStatusMonitor.isCanceled() && i < assets.size()) {
                            block32: {
                                asset = (RAMAsset)assets.get(i);
                                delegatedWork = false;
                                try {
                                    block36: {
                                        message = MessageFormat.format(ClientMessages.getString("RAMSession.CHECK_ASSET"), new Object[]{asset.toLocalizedString()});
                                        ramStatusMonitor.subTask(message);
                                        if (!asset.isDirty()) break block32;
                                        subMon = new RAMStatusMonitor((IProgressMonitor)ramStatusMonitor, TICKS);
                                        if (!hasRelConsttaints && !this.isServerMode() && asset.getAction() != RAMAction.DELETE && this.compareServicesVersion(RAMSession.RAM_7_1_0_1_SERVICES_VERSION) >= 0) break block36;
                                        delegatedWork = true;
                                        start = 0L;
                                        if (RAMSession.logger.isDebugEnabled()) {
                                            start = System.currentTimeMillis();
                                            RAMSession.logger.debug((Object)("Start Serial Upload for " + asset));
                                        }
                                        this.put(asset, (IProgressMonitor)subMon);
                                        if (RAMSession.logger.isDebugEnabled()) {
                                            RAMSession.logger.debug((Object)("Upload " + asset + " complete in: " + (System.currentTimeMillis() - start)));
                                        }
                                        ** GOTO lbl103
                                    }
                                    relationships = asset.getRelationships();
                                    v0 = goodToGo = relationships == null || relationships.length == 0;
lbl92:
                                    // 2 sources

                                    while (true) {
                                        block38: {
                                            block37: {
                                                if (!goodToGo) break block37;
                                                delegatedWork = true;
                                                this.uploadAssetOnThread(subMon, group, pool, theadPointer, asset);
                                                break block38;
                                            }
                                            if (RAMSession.logger.isDebugEnabled()) {
                                                RAMSession.logger.debug((Object)("Checking rels for " + asset));
                                            }
                                            goodToGo = true;
                                            j = 0;
                                            if (true) ** GOTO lbl140
                                        }
                                        delegatedWork = true;
                                        break;
                                    }
                                }
                                catch (Exception e) {
                                    RAMSession.logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                    status.appendStatus(asset, 4, 1000, e.getLocalizedMessage(), e);
                                }
                            }
                            if (!delegatedWork) {
                                ramStatusMonitor.worked(TICKS);
                            }
                            ++i;
                        }
                        break block39;
                        finally {
                            status.setCode(2);
                        }
                    }
                    try {
                        i = 0;
                        while (i < pool.length) {
                            if (pool[i] != null) {
                                pool[i].join();
                            }
                            ++i;
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RAMRuntimeException(e);
                    }
                    monitor.done();
                    return status;
                    do {
                        if (this.fWhoIsInTheAssetPipeline.containsKey(key = RAMAsset.createSessionKey(id = new AssetIdentification((rel = relationships[j]).getChildAssetGUID(), rel.getChildAssetVersion())))) {
                            if (RAMSession.logger.isDebugEnabled()) {
                                RAMSession.logger.debug((Object)("Rel " + ((RAMRelationship)rel).getChildAsset() + " is in the pipeline skip for now"));
                            }
                            if (RAMSession.logger.isDebugEnabled()) {
                                RAMSession.logger.debug((Object)("Queue = " + this.fWhoIsInTheAssetPipeline));
                            }
                            goodToGo = false;
                            break;
                        }
                        ++j;
lbl140:
                        // 2 sources

                    } while (j < relationships.length);
                    if (!goodToGo) break block40;
                    this.fWhoIsInTheAssetPipeline.put(asset.getSessionKey(), asset);
                    if (RAMSession.logger.isDebugEnabled()) {
                        RAMSession.logger.debug((Object)("Asset " + asset + " entering the pipeline"));
                    }
                    break block41;
                }
                if (goodToGo || i == assets.size() - 1) break block42;
                j = i;
                if (true) ** GOTO lbl160
            }
            if (RAMSession.logger.isDebugEnabled()) {
                RAMSession.logger.debug((Object)"Check last item again");
            }
            goodToGo = false;
            break block41;
            do {
                assets.set(j, (IRAMSessionObject)assets.get(j + 1));
                ++j;
lbl160:
                // 2 sources

            } while (j < assets.size() - 1);
            assets.set(assets.size() - 1, asset);
            asset = (RAMAsset)assets.get(i);
            relationships = asset.getRelationships();
            goodToGo = relationships == null || relationships.length == 0;
        }
        Thread.yield();
        ** continue;
    }

    private void uploadAssetOnThread(final RAMStatusMonitor subMon, ThreadGroup group, Thread[] pool, int theadPointer, final RAMAsset asset) {
        Thread uploadThread = null;
        while (uploadThread == null) {
            if (pool[theadPointer] == null || !pool[theadPointer].isAlive()) {
                Runnable uploader = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            try {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Upload " + asset + " on a new thread"));
                                }
                                RAMSession.this.putAsset(asset, subMon);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Upload " + asset + " complete"));
                                }
                            }
                            catch (RAMRuntimeException re) {
                                subMon.appendStatus(asset, 4, 1012, "Upload of asset on thread failed.", re);
                                RAMSession.this.fWhoIsInTheAssetPipeline.remove(asset.getSessionKey());
                            }
                            catch (Exception e) {
                                subMon.appendStatus(asset, 4, 1012, "Upload of asset on thread failed.", e);
                                RAMSession.this.fWhoIsInTheAssetPipeline.remove(asset.getSessionKey());
                            }
                        }
                        finally {
                            RAMSession.this.fWhoIsInTheAssetPipeline.remove(asset.getSessionKey());
                        }
                    }
                };
                uploadThread = pool[theadPointer] = new Thread(group, uploader, "Upload " + asset);
            } else {
                Thread.yield();
            }
            ++theadPointer;
            theadPointer %= MAX_UPLOAD_THREADS;
        }
        uploadThread.start();
    }

    private RAMStatusMonitor wrapInRAMStatusIfNeeded(IProgressMonitor monitor, int UPLOAD_TICKS) {
        RAMStatusMonitor ramStatusMonitor;
        if (!(monitor instanceof RAMStatusMonitor)) {
            ramStatusMonitor = new RAMStatusMonitor(monitor, UPLOAD_TICKS);
            ramStatusMonitor.beginTask(ClientMessages.getString("RAMSession.7"), UPLOAD_TICKS);
        } else {
            ramStatusMonitor = (RAMStatusMonitor)monitor;
        }
        return ramStatusMonitor;
    }

    private boolean keepAtCurrentPosition(List assets, RAMAsset asset) throws RAMRuntimeException {
        List constatintGroupings;
        boolean keepPosition = true;
        if (asset.getAssetType() != null && asset.getCommunity() != null && (constatintGroupings = this.getRelationshipConstaints(asset)) != null) {
            List relationshipConstraints = null;
            int j = 0;
            while (j < constatintGroupings.size()) {
                ConstraintGrouping grouping = (ConstraintGrouping)constatintGroupings.get(j);
                if (grouping instanceof RelationshipGrouping) {
                    relationshipConstraints = ((RelationshipGrouping)grouping).getConstraints();
                }
                ++j;
            }
            if (relationshipConstraints != null) {
                for (RelationshipConstraint constraint : relationshipConstraints) {
                    Relationship[] relatedAssets;
                    String relName = constraint.getRelationship();
                    String requiredType = constraint.getRequiredAssetType();
                    int constaintType = constraint.getCountType().getValue();
                    int constaintCount = constraint.getCount();
                    if (relName == null || (relatedAssets = asset.getRelationships()).length <= 0) continue;
                    int matchedCount = 0;
                    boolean madeQuota = false;
                    int j2 = 0;
                    while (j2 < relatedAssets.length) {
                        RAMRelationship ra = (RAMRelationship)relatedAssets[j2];
                        if (relName.equals(ra.getRelationshipTypeName())) {
                            try {
                                RAMAsset child = (RAMAsset)ra.getChildAsset();
                                if ((requiredType == null || child.getAssetType() != null && child.getAssetType().getURI() != null && child.getAssetType().getURI().endsWith(requiredType)) && (child.isUpdate() || assets.contains(child))) {
                                    ++matchedCount;
                                    if (constaintType == 0) {
                                        if (matchedCount > constaintCount) break;
                                        if (matchedCount == constaintCount) {
                                            madeQuota = true;
                                        }
                                    } else if (constaintType == 2) {
                                        if (matchedCount > constaintCount) break;
                                        madeQuota = true;
                                    } else if (constaintType == 1 && matchedCount == constaintCount) {
                                        madeQuota = true;
                                    }
                                }
                            }
                            catch (RAMRuntimeException rAMRuntimeException) {
                                asset.removeRelationship(ra);
                            }
                        }
                        ++j2;
                    }
                    if (madeQuota) continue;
                    keepPosition = false;
                }
            }
        }
        return keepPosition;
    }

    private List getRelationshipConstaints(RAMAsset asset) {
        RAMCommunityAssetType communityAssetType;
        boolean useMaster = true;
        List<ConstraintGrouping> constraintGroupings = null;
        if (asset == null || asset.getAssetType() == null) {
            return Collections.EMPTY_LIST;
        }
        if (asset.getCommunity() != null && (communityAssetType = this.getCommunityAssetType(asset.getAssetType(), asset.getCommunity())) != null) {
            useMaster = !communityAssetType.isLocal() && communityAssetType.isMasterUsedForConstraints();
            constraintGroupings = communityAssetType.getConstatintGroupings();
        }
        if (useMaster && asset.getAssetType() != null) {
            constraintGroupings = ((RAMAssetType)asset.getAssetType()).getConstatintGroupings();
        }
        return constraintGroupings;
    }

    static String readAssetManifest(InputStream streamedManifest) throws IOException {
        InputStreamReader reader = new InputStreamReader(streamedManifest, "UTF-8");
        StringBuffer buff = new StringBuffer();
        char[] content = new char[4096];
        int read = reader.read(content);
        while (read > -1) {
            buff.append(content, 0, read);
            read = reader.read(content);
        }
        streamedManifest.close();
        return buff.toString();
    }

    /*
     * Unable to fully structure code
     */
    private void putAsset(RAMAsset asset, RAMStatusMonitor monitor) throws RAMRuntimeException {
        block63: {
            if (monitor.isCanceled()) break block63;
            TOTAL_WORK = 50;
            workDone = 0;
            monitor.beginTask(ClientMessages.getString("RAMSession.23"), TOTAL_WORK);
            if (RAMSession.logger.isDebugEnabled()) {
                message = new StringBuffer("Put Asset ");
                message.append(asset);
                message.append(" - Action is ");
                message.append(asset.getAction());
                RAMSession.logger.debug((Object)message);
            }
            artifacts = null;
            try {
                block68: {
                    block67: {
                        block66: {
                            oldKey = asset.getSessionKey();
                            if (monitor.isCanceled()) break block63;
                            this.isInALifecycleAndUseRetireActionsSwitchFromConsts(asset, monitor);
                            if (RAMAction.DELETE != asset.getAction()) break block66;
                            if (asset.isChangeLockStatusDirty() && asset.getChangeLockStatus() == Boolean.FALSE) {
                                this.getRESTClient().changeAssetLockStatus(asset.getRestAssetRef().getValue(), asset.getChangeLockStatus(), new StoredMessage().addMessageString(asset.getChangeLockStatusComment()).getStoredMessage());
                            }
                            this.deleteAsset(asset, new RAMStatusMonitor((IProgressMonitor)monitor, 40));
                            workDone += 40;
                            message = MessageFormat.format(ClientMessages.getString("RAMSession.ASSET_DELETED"), new Object[]{asset.toLocalizedString()});
                            monitor.appendStatus(asset, 1, 13, message, null);
                            this.fAssets.remove(asset.getSessionKey());
                            ** GOTO lbl244
                        }
                        if (RAMAction.RETIRE != asset.getAction()) break block67;
                        message = MessageFormat.format(ClientMessages.getString("RAMSession.RETIRE_ASSET"), new Object[]{asset.toLocalizedString()});
                        monitor.subTask(message);
                        messages = this.getRAMClient().getRAM1Webservice().changeAssetStateByID(asset.getIdentification(), State.ASSET_RETIRED_NAME, asset.isForce());
                        if (messages != null && messages.length > 0) {
                            message = MessageFormat.format(ClientMessages.getString("RAMSession.PROBLEMS_RETIRING_ASSET"), new Object[]{asset.toLocalizedString()});
                            buf = new StringBuffer(message);
                            i = 0;
                            while (i < messages.length) {
                                buf.append("\n" + messages[i]);
                                ++i;
                            }
                            monitor.appendStatus(asset, 4, 1014, buf.toString(), null);
                        } else {
                            message = MessageFormat.format(ClientMessages.getString("RAMSession.ASSET_WAS_SUCCESSFULLY_RETIRED"), new Object[]{asset.toLocalizedString()});
                            monitor.appendStatus(asset, 1, 14, message, null);
                        }
                        ** GOTO lbl244
                    }
                    if (RAMAction.ARCHIVE != asset.getAction()) break block68;
                    message = MessageFormat.format(ClientMessages.getString("RAMSession.ARCHIVE_ASSET"), new Object[]{asset.toLocalizedString()});
                    monitor.subTask(message);
                    messages = this.getRAMClient().getRAM1Webservice().changeAssetStateByID(asset.getIdentification(), State.ASSET_ARCHIVED_NAME, asset.isForce());
                    if (messages != null && messages.length > 0) {
                        message = MessageFormat.format(ClientMessages.getString("RAMSession.PROBLEMS_ARCHIVING_ASSET"), new Object[]{asset.toLocalizedString()});
                        buf = new StringBuffer(message);
                        i = 0;
                        while (i < messages.length) {
                            buf.append("\n" + messages[i]);
                            ++i;
                        }
                        monitor.appendStatus(asset, 4, 1015, buf.toString(), null);
                    } else {
                        message = MessageFormat.format(ClientMessages.getString("RAMSession.ASSET_WAS_SUCCESSFULLY_ARCHIVED"), new Object[]{asset.toLocalizedString()});
                        monitor.appendStatus(asset, 1, 15, message, null);
                    }
                    ** GOTO lbl244
                }
                isUpdate = asset.isUpdate();
                if (asset.isChangeLockStatusDirty() && asset.getChangeLockStatus() == Boolean.FALSE) {
                    this.getRESTClient().changeAssetLockStatus(asset.getRestAssetRef().getValue(), asset.getChangeLockStatus(), new StoredMessage().addMessageString(asset.getChangeLockStatusComment()).getStoredMessage());
                }
                if (asset.isAssetDirty() || asset.isTagDirty()) {
                    block64: {
                        block65: {
                            isTagOnly = isUpdate != false && asset.isAssetDirty() == false && asset.isTagDirty() != false;
                            workDone += 3;
                            artifacts = asset.getLocalArtifactArchiveFile(new RAMStatusMonitor((IProgressMonitor)monitor, 3));
                            v0 = isHomePageAsset = asset.getManagementStyle() == 3;
                            if (!(isHomePageAsset || asset.getAction() != RAMAction.CREATE && asset.getAction() != RAMAction.UPDATE && asset.getAction() != RAMAction.CREATE_DRAFT && asset.getAction() != RAMAction.UPDATE_DRAFT && asset.getAction() != RAMAction.CREATE_AS_IS && asset.getAction() != RAMAction.UPDATE_AS_IS)) {
                                monitor.subTask(ClientMessages.getString("RAMSession.VALIDATE_ASSET"));
                                asset.getManifestBuilder().addForcedNodeToManifestBuilder();
                                validatorMap = asset.getManifestBuilder().getValidationManager().validate();
                                saveAsIsOrDraft = false;
                                if (asset.getAction() == RAMAction.CREATE_DRAFT || asset.getAction() == RAMAction.UPDATE_DRAFT || asset.getAction() == RAMAction.CREATE_AS_IS || asset.getAction() == RAMAction.UPDATE_AS_IS) {
                                    saveAsIsOrDraft = true;
                                }
                                if ((saveAsIsOrDraft || this.isOverrideValidation()) && ValidationManager.isAnyBlockers(validatorMap) || !this.isOverrideValidation() && ValidationManager.isAnyErrors(validatorMap)) {
                                    problems = asset.validate();
                                    mainMessage = new StringBuffer(MessageFormat.format(ClientMessages.getString("RAMSession.ASSET_VALIDATION_FAILED"), new Object[]{asset.toLocalizedString()}));
                                    RAMSession.logger.error((Object)mainMessage);
                                    i = 0;
                                    while (i < problems.length) {
                                        RAMSession.logger.error((Object)problems[i].getMessage());
                                        mainMessage.append(String.valueOf(System.getProperty("line.separator")) + problems[i].getMessage());
                                        ++i;
                                    }
                                    ex = new RAMRuntimeException(mainMessage.toString(), true);
                                    monitor.appendStatus(asset, 4, 1019, mainMessage.toString(), ex);
                                    workDone = TOTAL_WORK;
                                    monitor.worked(TOTAL_WORK - workDone);
                                    monitor.done();
                                    throw ex;
                                }
                                workDone += 5;
                                monitor.worked(5);
                            } else {
                                workDone += 5;
                                monitor.worked(5);
                            }
                            owners = null;
                            if (asset.getOwnersHaveBeenModified()) {
                                owners = new String[asset.getOwners().length];
                                i = 0;
                                while (i < owners.length) {
                                    owners[i] = asset.getOwners()[i].getUid();
                                    ++i;
                                }
                            }
                            if (asset.getCommunity() == null) {
                                throw new RAMRuntimeException(MessageFormat.format(ClientMessages.getString("RAMAssetType.COMMUNITY_NOT_FOUND"), new Object[1]));
                            }
                            ACTION = "saveAsNormal";
                            if (asset.getAction().getWorkflowId() != null && !JAXBLinksUtil.LEGACY_WORKFLOW_ID.equals(asset.getAction().getWorkflowId())) {
                                ACTION = asset.getAction().getIdentifier();
                            } else if (asset.getAction() == RAMAction.CREATE_DRAFT || asset.getAction() == RAMAction.UPDATE_DRAFT) {
                                ACTION = "saveAsDraft";
                            } else if (asset.getAction() == RAMAction.CREATE_AS_IS || asset.getAction() == RAMAction.UPDATE_AS_IS) {
                                ACTION = "saveAsIs";
                            }
                            ++workDone;
                            tagsString = this.prepareTags(asset, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1));
                            message = MessageFormat.format(ClientMessages.getString("RAMSession.UPLOAD_TO_SERVER"), new Object[]{asset.toLocalizedString()});
                            monitor.subTask(message);
                            iProgress = this.createUploadMonitor(message, (IProgressMonitor)new RAMStatusMonitor((IProgressMonitor)monitor, 20));
                            if (!isUpdate || asset.isKeepOldVersion()) {
                                mb = asset.getManifestBuilder();
                                relatedAssets = mb.getRelatedAssets();
                                relItr = relatedAssets.iterator();
                                while (relItr.hasNext()) {
                                    ra = relItr.next();
                                    info = RelationshipRangeUtility.getInfo(ra);
                                    if (info == null || !info.isSource()) continue;
                                    relItr.remove();
                                }
                            }
                            manifest = asset.getManifestAsString();
                            revCount = -1;
                            try {
                                workDone += 20;
                                response = this.fRAMClient.uploadAsset(manifest, artifacts, asset.getCommunity().getId(), ACTION, tagsString, asset.isDelta(), isUpdate, asset.getUpdateComments(), asset.getOriginalGUID(), asset.getOriginalVersion(), asset.isKeepOldVersion(), asset.getMainAssetId() != null, this.isOverrideValidation(), owners, asset.getManagementStyle(), isTagOnly, iProgress);
                                revCount = response.newRevisionCount;
                                break block64;
                            }
                            catch (RAMServiceException e) {
                                statusCode = e.getStatusCode();
                                if (statusCode != 409) break block65;
                                if (!asset.isForce()) {
                                    RAMSession.logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                    monitor.appendStatus(asset, 4, isUpdate != false ? 1012 : 1011, e.getLocalizedMessage(), e);
                                    throw new RAMRuntimeException(e.getLocalizedMessage(), e);
                                }
                                errorMessage = e.getMessage();
                                cur = 0;
                                ** while (errorMessage.length() > cur && Character.isDigit((char)errorMessage.charAt((int)cur)))
                            }
lbl-1000:
                            // 1 sources

                            {
                                ++cur;
                                continue;
                            }
lbl159:
                            // 1 sources

                            if (cur > 0) {
                                revCount = Integer.parseInt(errorMessage.substring(0, cur));
                            } else {
                                RAMSession.logger.warn((Object)("Failed to parse for revision code : " + errorMessage), (Throwable)e);
                                remoteAsset = this.fetchAssetFromServer(asset.getIdentification(), false, false);
                                parsedAsset = RAMAsset.loadManifestFromStream(this, "ram://create" + remoteAsset.getIdentification().getGUID() + remoteAsset.getIdentification().getVersion(), new ByteArrayInputStream(remoteAsset.getManifest().getBytes("UTF-8")));
                                revCount = ManifestAccessor.getRevisionCount(parsedAsset);
                            }
                            asset.getManifestBuilder().setRevisionCount(revCount);
                            manifest = RAMSession.readAssetManifest(asset.getManifestAsStream());
                            try {
                                iProgress = this.createUploadMonitor(message, (IProgressMonitor)new RAMStatusMonitor((IProgressMonitor)monitor, 10));
                                workDone += 10;
                                response = this.fRAMClient.uploadAsset(manifest, artifacts, asset.getCommunity().getId(), ACTION, tagsString, asset.isDelta(), true, null, asset.getOriginalGUID(), asset.getOriginalVersion(), asset.isKeepOldVersion(), false, this.isOverrideValidation(), owners, asset.getManagementStyle(), isTagOnly, iProgress);
                                revCount = response.newRevisionCount;
                            }
                            catch (RAMServiceException e1) {
                                RAMSession.logger.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
                                throw new RAMRuntimeException(e1.getLocalizedMessage(), e1);
                            }
                        }
                        lineSep = System.getProperty("line.separator");
                        error = new StringBuffer(String.valueOf(ClientMessages.getString("RAMSession.ERROR_UPLOADING_ASSET")) + asset + lineSep);
                        error.append("Manifest = ");
                        error.append(String.valueOf(manifest) + lineSep);
                        error.append("Archive = ");
                        error.append(artifacts != null ? artifacts.getAbsolutePath() : "[no file]");
                        RAMSession.logger.error((Object)error);
                        throw e;
                    }
                    asset.getManifestBuilder().setRevisionCount(revCount);
                }
                if (monitor.isCanceled()) {
                    return;
                }
                try {
                    if (asset.isChangeLockStatusDirty() && asset.getChangeLockStatus() == Boolean.TRUE) {
                        this.getRESTClient().changeAssetLockStatus(asset.getRestAssetRef().getValue(), asset.getChangeLockStatus(), new StoredMessage().addMessageString(asset.getChangeLockStatusComment()).getStoredMessage());
                    }
                    if (!monitor.isCanceled() && asset.isForumDirty()) {
                        try {
                            workDone += 2;
                            asset.updateForums((IProgressMonitor)new RAMStatusMonitor((IProgressMonitor)monitor, 2));
                        }
                        catch (RAMRuntimeException e) {
                            monitor.appendStatus(asset, 2, 1000, ClientMessages.getString("RAMSession.36"), e);
                            RAMSession.logger.warn((Object)ClientMessages.getString("RAMSession.36"), (Throwable)e);
                        }
                    }
                    if (!monitor.isCanceled() && asset.isSubscriptionsDirty()) {
                        try {
                            workDone += 2;
                            asset.updateSubscriptions(new RAMStatusMonitor((IProgressMonitor)monitor, 2));
                        }
                        catch (RAMRuntimeException e) {
                            monitor.appendStatus(asset, 2, 1000, ClientMessages.getString("RAMSession.36"), e);
                            RAMSession.logger.warn((Object)ClientMessages.getString("RAMSession.36"), (Throwable)e);
                        }
                    }
                    if (!monitor.isCanceled() && asset.isRatingDirty()) {
                        try {
                            ++workDone;
                            asset.updateRatings(new RAMStatusMonitor((IProgressMonitor)monitor, 1));
                        }
                        catch (RAMRuntimeException e) {
                            monitor.appendStatus(asset, 2, 1000, ClientMessages.getString("RAMSession.36"), e);
                            RAMSession.logger.warn((Object)ClientMessages.getString("RAMSession.36"), (Throwable)e);
                        }
                    }
                    if (!monitor.isCanceled() && asset.isActivityDirty()) {
                        try {
                            workDone += 3;
                            asset.uploadActivities((IProgressMonitor)new RAMStatusMonitor((IProgressMonitor)monitor, 3));
                        }
                        catch (RAMRuntimeException e) {
                            monitor.appendStatus(asset, 2, 1000, ClientMessages.getString("RAMSession.37"), e);
                            RAMSession.logger.warn((Object)ClientMessages.getString("RAMSession.37"), (Throwable)e);
                        }
                    }
                    if (isUpdate) {
                        message1 = MessageFormat.format(ClientMessages.getString("RAMSession.ASSET_WAS_SUCCESSFULLY_UPLOADED"), new Object[]{asset.toLocalizedString()});
                        monitor.appendStatus(asset, 1, 12, message1, null);
                    } else {
                        message1 = MessageFormat.format(ClientMessages.getString("RAMSession.ASSET_CREATED_SUCCESSFULLY"), new Object[]{asset.toLocalizedString()});
                        monitor.appendStatus(asset, 1, 11, message1, null);
                    }
                    if (asset.isAssetDirty()) {
                        asset.assetCommited();
                    } else {
                        asset.metadataCommited();
                    }
                    if (!asset.getSessionKey().equals(oldKey)) {
                        this.fAssets.remove(oldKey);
                        this.fAssets.put(asset.getSessionKey(), asset);
                    }
lbl244:
                    // 8 sources

                    me = new RAMSessionModificationEvent(this);
                    me.setAssetsModified(true);
                    SessionManager.getSessionManager().handleSessionModificationEvent(me);
                    workDone = TOTAL_WORK;
                    monitor.worked(TOTAL_WORK - workDone);
                }
                catch (Exception e) {
                    if (asset.getAction() == RAMAction.DELETE) {
                        message1 = MessageFormat.format(ClientMessages.getString("RAMSession.FAILED_TO_DELETE_THE_ASSET"), new Object[]{asset.toLocalizedString()});
                        monitor.appendStatus(asset, 4, 1013, message1, e);
                        RAMSession.logger.error((Object)message1);
                    } else if (asset.isUpdate()) {
                        message1 = MessageFormat.format(ClientMessages.getString("RAMSession.FAILED_TO_UPDATE_THE_ASSET"), new Object[]{asset.toLocalizedString()});
                        monitor.appendStatus(asset, 4, 1012, message1, e);
                        RAMSession.logger.error((Object)message1);
                    } else {
                        message1 = MessageFormat.format(ClientMessages.getString("RAMSession.FAILED_TO_CREATE_THE_ASSET"), new Object[]{asset.toLocalizedString()});
                        monitor.appendStatus(asset, 4, 1011, message1, e);
                        RAMSession.logger.error((Object)message1);
                    }
                    if (e instanceof RAMRuntimeException) {
                        workDone = TOTAL_WORK;
                        monitor.worked(TOTAL_WORK - workDone);
                        throw (RAMRuntimeException)e;
                    }
                    workDone = TOTAL_WORK;
                    monitor.worked(TOTAL_WORK - workDone);
                    throw new RAMRuntimeException(e.getLocalizedMessage(), e);
                }
            }
            finally {
                this.dequeueAssetForPut(asset);
                monitor.done();
            }
        }
    }

    private boolean isInALifecycleAndUseRetireActionsSwitchFromConsts(RAMAsset asset, RAMStatusMonitor monitor) {
        if ((RAMAction.RETIRE == asset.getAction() || RAMAction.ARCHIVE == asset.getAction()) && asset.isInLifecycle()) {
            RAMAction[] actions = asset.getAvailableActions();
            if (actions == null) {
                monitor.appendStatus(asset, 4, 1014, "There are no available actions for " + asset, null);
                return false;
            }
            if (RAMAction.RETIRE == asset.getAction()) {
                RAMAction phaseOutAction = null;
                RAMAction[] rAMActionArray = actions;
                int n = actions.length;
                int n2 = 0;
                while (n2 < n) {
                    RAMAction action = rAMActionArray[n2];
                    if ("com.ibm.ram.internal.retire.action.phaseOut".equals(action.getIdentifier())) {
                        phaseOutAction = action;
                        break;
                    }
                    ++n2;
                }
                if (phaseOutAction == null) {
                    monitor.appendStatus(asset, 4, 1014, "There are no available actions for " + asset, null);
                    return false;
                }
                asset.setAction(phaseOutAction);
            } else if (RAMAction.ARCHIVE == asset.getAction()) {
                RAMAction retireAction = null;
                RAMAction[] rAMActionArray = actions;
                int n = actions.length;
                int n3 = 0;
                while (n3 < n) {
                    RAMAction action = rAMActionArray[n3];
                    if ("com.ibm.ram.internal.retire.action.retire".equals(action.getIdentifier())) {
                        retireAction = action;
                        break;
                    }
                    ++n3;
                }
                if (retireAction == null) {
                    monitor.appendStatus(asset, 4, 1015, "Retire action not found", null);
                    return false;
                }
                asset.setAction(retireAction);
            }
        }
        return true;
    }

    private AbstractRAMClient.IUploadProgress createUploadMonitor(String message, final IProgressMonitor uploadMonitor) {
        final String subTaskName = message;
        uploadMonitor.beginTask(ClientMessages.getString("RAMSession.30"), 100);
        AbstractRAMClient.IUploadProgress iProgress = new AbstractRAMClient.IUploadProgress(){
            private int fReported = 0;

            @Override
            public boolean isCanceled() {
                return uploadMonitor.isCanceled();
            }

            @Override
            public void setProgress(int progress) {
                if (this.fReported < progress) {
                    int ticks = progress - this.fReported;
                    if (this.fReported <= 100) {
                        uploadMonitor.worked(ticks);
                        uploadMonitor.subTask(String.valueOf(subTaskName) + " (" + progress + "%)");
                    } else {
                        uploadMonitor.subTask(String.valueOf(subTaskName) + " (" + progress + "%)");
                    }
                    this.fReported = progress;
                }
            }
        };
        return iProgress;
    }

    private void putCategorySchema(RAMCategorySchema categorySchema, RAMStatusMonitor monitor) throws RAMRuntimeException {
        if (!monitor.isCanceled()) {
            monitor.beginTask(ClientMessages.getString("RAMSession.38"), 10);
            try {
                try {
                    String message;
                    if (categorySchema.getAction() == RAMAction.DELETE) {
                        if (this.fCategorySchemasByName == null) {
                            this.initCategorySchemaCache();
                        }
                        message = MessageFormat.format(ClientMessages.getString("RAMSession.DELETE_CATEGORY_SCHEMA"), categorySchema.getName());
                        monitor.subTask(message);
                        String name = categorySchema.getName();
                        String uri = categorySchema.getURI();
                        this.getRAMClient().getRAM1Webservice().deleteCategorySchemas(new String[]{uri}, new int[0], false);
                        if (name != null) {
                            this.fCategorySchemasByName.remove(name);
                        }
                        if (uri != null) {
                            this.fCategorySchemasByURI.remove(uri);
                        }
                        String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.CATEGORY_SCHEMA_WAS_DELETED"), categorySchema);
                        monitor.appendStatus(categorySchema, 1, 13, message1, null);
                    } else if (categorySchema.getAction() == RAMAction.UPDATE) {
                        String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.UPDATE_CATEGORY_SCHEMA"), categorySchema.getName());
                        monitor.subTask(message1);
                        int[] communityIds = null;
                        int[] accessKind = null;
                        if (categorySchema.isRestricted() || !this.getUser().isRepositoryAdministrator()) {
                            RAMCommunity[] adminCommunities = categorySchema.getRestrictedCommunities();
                            communityIds = new int[adminCommunities.length];
                            accessKind = new int[adminCommunities.length];
                            int i = 0;
                            while (i < adminCommunities.length) {
                                communityIds[i] = ((CommunityInformation)adminCommunities[i]).getId();
                                accessKind[i] = 1;
                                ++i;
                            }
                        }
                        int shareType = categorySchema.isRestricted() ? this.getConstants().getSHARING_TYPE_RESTRICTED() : this.getConstants().getSHARING_TYPE_GLOBAL();
                        String uri = this.getRAMClient().getRAM1Webservice().updateCategorySchema(categorySchema.getURI(), categorySchema.getConfiguration(), false, communityIds != null ? communityIds : new int[]{}, accessKind != null ? accessKind : new int[]{}, this.getUser().isRepositoryAdministrator(), shareType);
                        ResourceSet resSet = this.getResourceSet();
                        URI schemaURI = URI.createURI((String)uri);
                        Resource existingResource = resSet.getResource(schemaURI.trimFragment(), false);
                        while (existingResource != null) {
                            existingResource.unload();
                            resSet.getResources().remove((Object)existingResource);
                            existingResource = resSet.getResource(schemaURI.trimFragment(), false);
                        }
                        this.copySchemasToLocalOS(new String[]{uri});
                        ClassificationSchema newSchema = (ClassificationSchema)resSet.getEObject(schemaURI, true);
                        categorySchema.setInternalClassificationSchema(newSchema);
                        this.fCategorySchemasByURI.put(categorySchema.getURI(), categorySchema);
                        this.fCategorySchemasByName.put(categorySchema.getName(), categorySchema);
                        String message2 = MessageFormat.format(ClientMessages.getString("RAMSession.CATEGORY_SCHEMA_UPDATED"), categorySchema);
                        monitor.appendStatus(categorySchema, 1, 12, message2, null);
                    } else {
                        RAMCommunity[] adminCommunities;
                        message = MessageFormat.format(ClientMessages.getString("RAMSession.CREATE_CAT_SCHEMA"), categorySchema.getName());
                        monitor.subTask(message);
                        int[] communityIds = null;
                        int[] accessKind = null;
                        if ((categorySchema.isRestricted() || !this.getUser().isRepositoryAdministrator()) && (adminCommunities = categorySchema.getRestrictedCommunities()) != null) {
                            communityIds = new int[adminCommunities.length];
                            accessKind = new int[adminCommunities.length];
                            int i = 0;
                            while (i < adminCommunities.length) {
                                communityIds[i] = ((CommunityInformation)adminCommunities[i]).getId();
                                accessKind[i] = 1;
                                ++i;
                            }
                        }
                        String uri = this.getRAMClient().getRAM1Webservice().createCategorySchema(categorySchema.getURI(), categorySchema.getConfiguration(), communityIds != null ? communityIds : new int[]{}, accessKind != null ? accessKind : new int[]{}, this.getUser().isRepositoryAdministrator(), categorySchema.isRestricted() ? this.getConstants().getSHARING_TYPE_RESTRICTED() : this.getConstants().getSHARING_TYPE_GLOBAL());
                        ResourceSet resSet = this.getResourceSet();
                        ClassificationSchema newSchema = (ClassificationSchema)resSet.getEObject(URI.createURI((String)uri), true);
                        categorySchema.setInternalClassificationSchema(newSchema);
                        this.fCategorySchemasByURI.put(categorySchema.getURI(), categorySchema);
                        String[] localFileNames = this.copySchemasToLocalOS(new String[]{uri});
                        if (localFileNames == null || localFileNames.length < 1) {
                            logger.error((Object)("Failed to create a local file for uri " + uri));
                        } else {
                            try {
                                String localURI = localFileNames[0];
                                URIConverter converter = this.getResourceSet().getURIConverter();
                                if (converter instanceof CachedRAMURIConverter) {
                                    CachedRAMURIConverter cachedConverter = (CachedRAMURIConverter)converter;
                                    URI serverURI = URI.createURI((String)uri);
                                    URI localFileURI = URI.createFileURI((String)localURI);
                                    if (serverURI != null && localFileURI != null) {
                                        cachedConverter.addCacheMapping(serverURI, localFileURI);
                                    }
                                } else {
                                    logger.error((Object)"Resource set was not a CachedRAMURIConverter");
                                }
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                        String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.CAT_SCHEMA_CREATED"), categorySchema);
                        monitor.appendStatus(categorySchema, 1, 11, message1, null);
                    }
                    categorySchema.categorySchemaCommited();
                    RAMSessionModificationEvent me = new RAMSessionModificationEvent(this);
                    me.setCategorizationsModified(true);
                    SessionManager.getSessionManager().handleSessionModificationEvent(me);
                }
                catch (Exception e) {
                    if (categorySchema.getAction() == RAMAction.UPDATE) {
                        monitor.appendStatus(categorySchema, 4, 1012, e.getLocalizedMessage(), e);
                    } else {
                        monitor.appendStatus(categorySchema, 4, 1011, e.getLocalizedMessage(), e);
                    }
                    throw new RAMRuntimeException(e.getLocalizedMessage(), e);
                }
            }
            finally {
                monitor.worked(10);
            }
        }
    }

    private void putCommunity(RAMCommunity community, RAMStatusMonitor monitor) throws RAMRuntimeException {
        if (!monitor.isCanceled()) {
            monitor.beginTask(ClientMessages.getString("RAMSession.42"), 10);
            int delegatedWork = 0;
            try {
                try {
                    String message;
                    if (community.getAction() == RAMAction.DELETE) {
                        if (this.fCommunitiesByName == null) {
                            this.initCommunitiesCache();
                        }
                        message = MessageFormat.format(ClientMessages.getString("RAMSession.DELETE_COMMUNITY"), community.getName());
                        monitor.subTask(message);
                        String name = community.getName();
                        int id = community.getId();
                        this.getRAMClient().getRAM1Webservice().deleteCommunities(new int[]{id}, -1);
                        if (name != null) {
                            this.fCommunitiesByName.remove(name);
                        }
                        if (id != -1) {
                            this.fCommunitiesById.remove(new Integer(id));
                        }
                        String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.COMMUNITY_DELETED"), community);
                        monitor.appendStatus(community, 1, 13, message1, null);
                    } else if (community.getAction() == RAMAction.UPDATE) {
                        String[] adminids;
                        message = MessageFormat.format(ClientMessages.getString("RAMSession.UPDATE_COMMUNITY"), community.getName());
                        monitor.subTask(message);
                        RAMUser[] admins = community.getAdministrators();
                        if (admins.length == 0) {
                            adminids = new String[]{this.getUser().getUid()};
                        } else {
                            adminids = new String[admins.length];
                            int i = 0;
                            while (i < admins.length) {
                                adminids[i] = admins[i].getUid();
                                ++i;
                            }
                        }
                        if (community.isHomepageAssetDirty()) {
                            delegatedWork = 5;
                            community.commitHomepageAsset((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, delegatedWork));
                        }
                        this.getRAMClient().getRAM1Webservice().updateCommunity(community.getId(), community.getName(), community.getDescription(), adminids);
                        String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.COMMUNITY_UPDATED"), community);
                        monitor.appendStatus(community, 1, 12, message1, null);
                    } else {
                        String[] adminids;
                        message = MessageFormat.format(ClientMessages.getString("RAMSession.CREATE_COMMUNITY"), community.getName());
                        monitor.subTask(message);
                        RAMUser[] admins = community.getAdministrators();
                        if (admins.length == 0) {
                            adminids = new String[]{this.getUser().getUid()};
                        } else {
                            adminids = new String[admins.length];
                            int i = 0;
                            while (i < admins.length) {
                                adminids[i] = admins[i].getUid();
                                ++i;
                            }
                        }
                        CommunitySO impl = this.getRAMClient().getRAM1Webservice().createCommunity(community.getName(), community.getDescription(), adminids);
                        community.setId(impl.getId());
                        this.fCommunitiesById.put(new Integer(impl.getId()), community);
                        String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.COMMUNITY_CREATED"), community);
                        monitor.appendStatus(community, 1, 12, message1, null);
                    }
                    community.communityCommited();
                    RAMSessionModificationEvent me = new RAMSessionModificationEvent(this);
                    me.setCommunitiesModified(true);
                    SessionManager.getSessionManager().handleSessionModificationEvent(me);
                }
                catch (Exception e) {
                    if (community.getAction() == RAMAction.UPDATE) {
                        monitor.appendStatus(community, 4, 1012, e.getLocalizedMessage(), e);
                    } else {
                        monitor.appendStatus(community, 4, 1011, e.getLocalizedMessage(), e);
                    }
                    throw new RAMRuntimeException(e.getLocalizedMessage(), e);
                }
            }
            finally {
                monitor.worked(10 - delegatedWork);
            }
        }
    }

    private void putAssetAttribute(RAMAssetAttribute assetAttribute, RAMStatusMonitor monitor) throws RAMRuntimeException {
        if (!monitor.isCanceled()) {
            monitor.beginTask(ClientMessages.getString("RAMSession.46"), 10);
            try {
                try {
                    String message;
                    if (assetAttribute.getAction() == RAMAction.DELETE) {
                        message = MessageFormat.format(ClientMessages.getString("RAMSession.DELETE_ASSET_ATTRIBUTE"), assetAttribute.getName());
                        monitor.subTask(message);
                        String name = assetAttribute.getName();
                        String uri = assetAttribute.getURI();
                        this.getRAMClient().getRAM1Webservice().deleteAttributes(new String[]{assetAttribute.getURI()});
                        if (this.fAttributesByName != null && name != null) {
                            this.fAttributesByName.remove(name);
                        }
                        if (this.fAttributesByURI != null && uri != null) {
                            this.fAttributesByURI.remove(uri);
                        }
                        String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.ASSET_ATTRIBUT_DELETED"), assetAttribute);
                        monitor.appendStatus(assetAttribute, 1, 13, message1, null);
                    } else if (assetAttribute.getAction() == RAMAction.UPDATE) {
                        int i;
                        message = MessageFormat.format(ClientMessages.getString("RAMSession.UPDATE_ASSET_ATTRIBUTE"), assetAttribute.getName());
                        monitor.subTask(message);
                        String[] originalValues = assetAttribute.getOriginalValues();
                        String[] currentValues = assetAttribute.getValidValues();
                        ArrayList<String> newValues = new ArrayList<String>();
                        ArrayList<String> valuesToRemove = new ArrayList<String>();
                        if (originalValues != null) {
                            int j;
                            i = 0;
                            while (i < originalValues.length) {
                                String originalValue = originalValues[i];
                                if (currentValues != null) {
                                    boolean removeMatch = true;
                                    j = 0;
                                    while (j < currentValues.length) {
                                        String newValue = currentValues[j];
                                        if (newValue.equals(originalValue)) {
                                            removeMatch = false;
                                            break;
                                        }
                                        ++j;
                                    }
                                    if (removeMatch) {
                                        valuesToRemove.add(originalValue);
                                    }
                                } else {
                                    valuesToRemove.add(originalValue);
                                }
                                ++i;
                            }
                            if (currentValues != null) {
                                i = 0;
                                while (i < currentValues.length) {
                                    String newValue = currentValues[i];
                                    boolean addMatch = true;
                                    j = 0;
                                    while (j < currentValues.length) {
                                        String originalValue = originalValues[j];
                                        if (newValue.equals(originalValue)) {
                                            addMatch = false;
                                            break;
                                        }
                                        ++j;
                                    }
                                    if (addMatch) {
                                        newValues.add(newValue);
                                    }
                                    ++i;
                                }
                            }
                        } else if (currentValues != null) {
                            i = 0;
                            while (i < currentValues.length) {
                                newValues.add(currentValues[i]);
                                ++i;
                            }
                        }
                        String[] adds = newValues.toArray(new String[newValues.size()]);
                        String[] removes = valuesToRemove.toArray(new String[valuesToRemove.size()]);
                        this.getRAMClient().getRAM1Webservice().updateAttribute(assetAttribute.getURI(), assetAttribute.getName(), assetAttribute.getDescription(), assetAttribute.getType(), assetAttribute.getConfiguration(), assetAttribute.isSingleSetting(), removes, adds, null);
                        String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.ASSET_ATTRIBUTE_UPDATED"), assetAttribute);
                        monitor.appendStatus(assetAttribute, 1, 12, message1, null);
                    } else {
                        message = MessageFormat.format(ClientMessages.getString("RAMSession.CREATE_NEW_ATTRIBUTE"), assetAttribute.getName());
                        monitor.subTask(message);
                        AssetAttributeSO attribute = this.getRAMClient().getRAM1Webservice().createAttribute(assetAttribute.getURI(), assetAttribute.getName(), assetAttribute.getDescription(), assetAttribute.getType(), assetAttribute.getConfiguration(), assetAttribute.isRestrictedSetting(), assetAttribute.isSingleSetting(), assetAttribute.getValidValues(), assetAttribute.getValidValues());
                        assetAttribute.getInternalWebServiceAssetAttribute().setURI(attribute.getURI());
                        this.fAttributesByURI.put(attribute.getURI(), assetAttribute);
                        String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.ATTRIBUTE_CREATED"), assetAttribute.getName());
                        monitor.appendStatus(assetAttribute, 1, 11, message1, null);
                    }
                    assetAttribute.assetAttributeCommited();
                    RAMSessionModificationEvent me = new RAMSessionModificationEvent(this);
                    me.setAttributesModified(true);
                    SessionManager.getSessionManager().handleSessionModificationEvent(me);
                }
                catch (Throwable e) {
                    throw new RAMRuntimeException(e.getLocalizedMessage(), e);
                }
            }
            finally {
                monitor.worked(10);
            }
        }
    }

    private void putAssetType(RAMAssetType assetType, RAMStatusMonitor monitor) throws RAMRuntimeException {
        if (!monitor.isCanceled()) {
            monitor.beginTask(ClientMessages.getString("RAMSession.50"), 10);
            try {
                String message;
                if (assetType.getAction() == RAMAction.DELETE) {
                    if (this.fAssetTypesByName == null) {
                        this.initAssetTypeCache();
                    }
                    message = MessageFormat.format(ClientMessages.getString("RAMSession.DELETE_ASSET_TYPE"), assetType.getName());
                    monitor.subTask(message);
                    String name = assetType.getName();
                    String uri = assetType.getURI();
                    this.getRAMClient().getRAM1Webservice().deleteAssetTypes(new String[]{uri}, false);
                    if (name != null) {
                        this.fAssetTypesByName.remove(name);
                    }
                    if (uri != null) {
                        this.fAssetTypesByName.remove(uri);
                    }
                    String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.ASSET_TYPE_DELETED_SUCCESSFULLY"), assetType);
                    monitor.appendStatus(assetType, 1, 13, message1, null);
                } else if (assetType.getAction() == RAMAction.UPDATE) {
                    message = MessageFormat.format(ClientMessages.getString("RAMSession.UPDATE_ASSET_TYPE"), assetType.getName());
                    monitor.subTask(message);
                    this.getRAMClient().getRAM1Webservice().updateAssetType(assetType.getURI(), assetType.getName(), assetType.getDescription(), assetType.getConfiguration(), assetType.isRestricted(), assetType.isPrivate(), assetType.getInternalAssetType().getCollisionCount(), assetType.getCommunityAssetTypeSOs());
                    String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.ASSET_TYPE_WAS_UPDATED"), assetType);
                    monitor.appendStatus(assetType, 1, 12, message1, null);
                } else {
                    message = MessageFormat.format(ClientMessages.getString("RAMSession.CREATE_NEW_ASSET_TYPE"), assetType.getName());
                    monitor.subTask(message);
                    AssetTypeSO internalAssetType = assetType.getInternalAssetType();
                    AssetTypeSO impl = this.getRAMClient().getRAM1Webservice().createAssetType(assetType.getURI(), assetType.getName(), assetType.getDescription(), assetType.getConfiguration(), assetType.isRestricted(), assetType.isPrivate(), assetType.getCommunityAssetTypeSOs());
                    internalAssetType.setConfiguration(impl.getConfiguration());
                    assetType.setId(impl.getId());
                    assetType.setURI(impl.getURI());
                    this.fAssetTypesByURI.put(assetType.getURI(), assetType);
                    String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.ASSET_TYPE_CREATE"), assetType);
                    monitor.appendStatus(assetType, 1, 11, message1, null);
                }
                String assetTypeSchemaURI = ASSET_TYPE_SCHEMA_URI;
                URI absoluteURI = Utilities.createClassificationSchemaURI(assetTypeSchemaURI, this.getResourceSet());
                this.copySchemasToLocalOS(new String[]{absoluteURI.toString()});
                assetType.assetTypeCommited();
                RAMSessionModificationEvent me = new RAMSessionModificationEvent(this);
                me.setAssetTypesModified(true);
                SessionManager.getSessionManager().handleSessionModificationEvent(me);
                monitor.worked(10);
            }
            catch (Exception e) {
                if (assetType.getAction() == RAMAction.UPDATE) {
                    monitor.appendStatus(assetType, 4, 1012, e.getLocalizedMessage(), e);
                } else {
                    monitor.appendStatus(assetType, 4, 1011, e.getLocalizedMessage(), e);
                }
                throw new RAMRuntimeException(e.getLocalizedMessage(), e);
            }
        }
    }

    private void putCommunityAssetType(RAMCommunityAssetType communityAssetType, RAMStatusMonitor monitor) throws RAMRuntimeException {
        if (!monitor.isCanceled()) {
            monitor.beginTask(ClientMessages.getString("RAMSession.50"), 10);
            try {
                try {
                    RAMAssetType assetType;
                    String message;
                    if (communityAssetType.getAction() == RAMAction.DELETE) {
                        if (this.fAssetTypesByName == null) {
                            this.initAssetTypeCache();
                        }
                        message = MessageFormat.format(ClientMessages.getString("RAMSession.DELETE_ASSET_TYPE"), communityAssetType);
                        monitor.subTask(message);
                        assetType = (RAMAssetType)communityAssetType.getMasterAssetType();
                        AssetTypeCommunityRelationshipSO internalAssetType = communityAssetType.getInternalCommunityAssetType();
                        this.getRAMClient().getRAM1Webservice().deleteCommunityAssetType(internalAssetType);
                        if (assetType.isPrivate()) {
                            if (assetType.getName() != null) {
                                this.fAssetTypesByName.remove(assetType.getName());
                            }
                            if (assetType.getURI() != null) {
                                this.fAssetTypesByName.remove(assetType.getURI());
                            }
                        }
                        String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.ASSET_TYPE_DELETED_SUCCESSFULLY"), assetType);
                        monitor.appendStatus(communityAssetType, 1, 13, message1, null);
                    } else if (communityAssetType.getAction() == RAMAction.UPDATE) {
                        message = MessageFormat.format(ClientMessages.getString("RAMSession.UPDATE_ASSET_TYPE"), communityAssetType.getName());
                        monitor.subTask(message);
                        AssetTypeCommunityRelationshipSO internalAssetType = communityAssetType.getInternalCommunityAssetType();
                        this.getRAMClient().getRAM1Webservice().updateCommunityAssetTypes(internalAssetType);
                        String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.ASSET_TYPE_WAS_UPDATED"), communityAssetType);
                        monitor.appendStatus(communityAssetType, 1, 12, message1, null);
                    } else {
                        message = MessageFormat.format(ClientMessages.getString("RAMSession.CREATE_NEW_ASSET_TYPE"), communityAssetType);
                        monitor.subTask(message);
                        assetType = (RAMAssetType)communityAssetType.getMasterAssetType();
                        CommunityAssetType communityType = this.getRAMClient().getRAM1Webservice().createCommunityAssetType(assetType.getURI(), assetType.getName(), communityAssetType);
                        AssetType impl = communityType.getMasterAssetType();
                        assetType.setId(impl.getId());
                        assetType.setURI(impl.getURI());
                        this.fAssetTypesByURI.put(assetType.getURI(), assetType);
                        String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.ASSET_TYPE_CREATE"), assetType);
                        monitor.appendStatus(communityAssetType, 1, 11, message1, null);
                    }
                    String assetTypeSchemaURI = ASSET_TYPE_SCHEMA_URI;
                    URI absoluteURI = Utilities.createClassificationSchemaURI(assetTypeSchemaURI, this.getResourceSet());
                    this.copySchemasToLocalOS(new String[]{absoluteURI.toString()});
                    ((RAMAssetType)communityAssetType.getMasterAssetType()).assetTypeCommited();
                    RAMSessionModificationEvent me = new RAMSessionModificationEvent(this);
                    me.setAssetTypesModified(true);
                    SessionManager.getSessionManager().handleSessionModificationEvent(me);
                }
                catch (Exception e) {
                    if (communityAssetType.getAction() == RAMAction.UPDATE) {
                        monitor.appendStatus(communityAssetType, 4, 1012, e.getLocalizedMessage(), e);
                    } else if (communityAssetType.getAction() == RAMAction.DELETE) {
                        monitor.appendStatus(communityAssetType, 4, 1013, e.getLocalizedMessage(), e);
                    } else {
                        monitor.appendStatus(communityAssetType, 4, 1011, e.getLocalizedMessage(), e);
                    }
                    throw new RAMRuntimeException(e.getLocalizedMessage(), e);
                }
            }
            finally {
                monitor.worked(10);
            }
        }
    }

    private void putRelationshipType(RAMRelationshipType relationshipType, RAMStatusMonitor monitor) throws RAMRuntimeException {
        if (!monitor.isCanceled()) {
            monitor.beginTask(ClientMessages.getString("RAMSession.54"), 10);
            if (!relationshipType.isPreferredEnd()) {
                relationshipType = (RAMRelationshipType)relationshipType.getReverseType();
            }
            try {
                try {
                    String message;
                    if (relationshipType.getAction() == RAMAction.DELETE) {
                        message = MessageFormat.format(ClientMessages.getString("RAMSession.DELETE_REL_TYPE"), relationshipType.getName());
                        monitor.subTask(message);
                        String name = relationshipType.getName();
                        String displayName = relationshipType.getDisplayName();
                        String revName = relationshipType.getReverseType().getName();
                        String revDisplayName = relationshipType.getReverseType().getDisplayName();
                        this.getRAMClient().getRAM1Webservice().deleteAssetRelationType(name);
                        if (name != null) {
                            this.fRelationshipTypeByName.remove(name);
                        }
                        if (displayName != null) {
                            this.fRelationshipTypeByDisplayName.remove(displayName);
                        }
                        if (revName != null) {
                            this.fRelationshipTypeByName.remove(revName);
                        }
                        if (revDisplayName != null) {
                            this.fRelationshipTypeByDisplayName.remove(revDisplayName);
                        }
                        String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.REL_TYPE_DELETED"), relationshipType);
                        monitor.appendStatus(relationshipType, 1, 13, message1, null);
                    } else if (relationshipType.getAction() == RAMAction.UPDATE) {
                        monitor.appendStatus(relationshipType, 4, 1012, ClientMessages.getString("RAMRelationshipType.not_updateable"), null);
                    } else {
                        message = MessageFormat.format(ClientMessages.getString("RAMSession.CREATE_REL_TYPE"), relationshipType.getName());
                        monitor.subTask(message);
                        if (relationshipType.getReverseType() != null) {
                            this.getRAMClient().getRAM1Webservice().createAssetRelationType(relationshipType.getName(), relationshipType.getDisplayName(), relationshipType.getReverseType().getName(), relationshipType.getReverseType().getDisplayName());
                        } else {
                            this.getRAMClient().getRAM1Webservice().createAssetRelationType(relationshipType.getName(), relationshipType.getDisplayName(), relationshipType.getReverseName(), relationshipType.getReverseName());
                        }
                        String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.REL_TYPE_CREATED"), relationshipType);
                        monitor.appendStatus(relationshipType, 1, 11, message1, null);
                    }
                    relationshipType.relationshipTypeCommited();
                    RAMSessionModificationEvent me = new RAMSessionModificationEvent(this);
                    me.setRelationshipTypesModified(true);
                    SessionManager.getSessionManager().handleSessionModificationEvent(me);
                }
                catch (Exception e) {
                    if (relationshipType.getAction() == RAMAction.UPDATE) {
                        monitor.appendStatus(relationshipType, 4, 1012, e.getLocalizedMessage(), e);
                    } else {
                        monitor.appendStatus(relationshipType, 4, 1011, e.getLocalizedMessage(), e);
                    }
                    throw new RAMRuntimeException(e.getLocalizedMessage(), e);
                }
            }
            finally {
                monitor.worked(10);
            }
        }
    }

    private String prepareTags(RAMAsset asset, IProgressMonitor monitor) throws RAMRuntimeException {
        StringBuffer tagsString = new StringBuffer();
        if (asset.getTags().length == 0) {
            monitor.beginTask(ClientMessages.getString("RAMSession.57"), 1);
            monitor.worked(1);
            monitor.done();
        } else {
            RAMAssetTag[] tags = (RAMAssetTag[])asset.getTags();
            monitor.beginTask(ClientMessages.getString("RAMSession.58"), tags.length);
            String message = MessageFormat.format(ClientMessages.getString("RAMSession.PREPARE_ASSET_TAGS"), asset.toLocalizedString());
            monitor.subTask(message);
            int i = 0;
            while (i < tags.length) {
                tagsString.append(tags[i].getLabel());
                if (i < tags.length - 1) {
                    tagsString.append(TAG_DELIM);
                }
                monitor.worked(1);
                ++i;
            }
            monitor.done();
        }
        return tagsString.toString();
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public RAMLibrary[] getLibraries() {
        this.initLibraries();
        Collection<RAMLibrary> libraries = this.fLibraries.values();
        return libraries.toArray(new RAMLibrary[this.fLibraries.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLibraries() throws RAMRuntimeException {
        if (this.fLibraries == null) {
            try {
                String string = "LIBRARIES_MUTEX";
                synchronized ("LIBRARIES_MUTEX") {
                    if (this.fLibraries == null) {
                        LibraryInformationSO[] libararies = this.getRAMClient().getRAM1Webservice().getLibraryInformations(null, null);
                        HashMap<String, RAMLibrary> libs = new HashMap<String, RAMLibrary>();
                        int i = 0;
                        while (i < libararies.length) {
                            RAMLibrary lib = new RAMLibrary(this, libararies[i]);
                            libs.put(lib.getSessionKey(), lib);
                            ++i;
                        }
                        this.fLibraries = libs;
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (RAMRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RAMRuntimeException("Failed to fetch the Libraries", e);
            }
        }
        {
            return;
        }
    }

    public RAMLibrary getLibrary(AssetIdentification id) {
        this.initLibraries();
        return this.fLibraries.get(RAMAsset.createSessionKey(id));
    }

    boolean isRightToLeftLocale() {
        String lang;
        boolean isBidi = false;
        if (this.fLocale != null && ("iw".equals(lang = this.fLocale.getLanguage()) || "he".equals(lang) || "ar".equals(lang) || "fa".equals(lang) || "ur".equals(lang))) {
            isBidi = true;
        }
        return isBidi;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public String getLocalStorageLocation() {
        if (this.fLocalStorageLocation == null) {
            this.fLocalStorageLocation = this.getSessionTempDir();
            if (!this.fLocalStorageLocation.endsWith(System.getProperty("file.separator"))) {
                this.fLocalStorageLocation = String.valueOf(this.fLocalStorageLocation) + System.getProperty("file.separator");
            }
            this.fLocalStorageLocation = String.valueOf(this.fLocalStorageLocation) + "local_ram_store";
        }
        return this.fLocalStorageLocation;
    }

    public void setLocalStorageLocation(String localStorageLocation) {
        this.fLocalStorageLocation = localStorageLocation;
    }

    File getLocalStorageFolder() {
        if (this.fLocalStorageFolder == null) {
            File file = new File(this.getLocalStorageLocation());
            if (!file.exists()) {
                file.mkdir();
            }
            this.fLocalStorageFolder = new File(file, RAMSession.cleanFromUnsuitableFilechars(String.valueOf(this.toString()) + "_" + System.currentTimeMillis()));
            if (!this.fLocalStorageFolder.exists()) {
                this.fLocalStorageFolder.mkdir();
            }
        }
        return this.fLocalStorageFolder;
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    private static String cleanFromUnsuitableFilechars(String s) {
        if (RAMSession.isBlank(s)) {
            return "";
        }
        char[] chars = s.toCharArray();
        boolean mod = false;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] != '-' && !Character.isJavaIdentifierPart(chars[i])) {
                chars[i] = 95;
                mod = true;
            }
            ++i;
        }
        return mod ? new String(chars) : s;
    }

    public String getWebServerURL() {
        return this.getRAMClient().getWebServerPath();
    }

    public String getWebServicesURL() {
        return this.getRAMClient().getWebServicesPath();
    }

    public String getRAMServerURL() {
        return this.getIdentification().getServerURL();
    }

    public String getRAMServerLoginid() {
        return this.getIdentification().getLoginId();
    }

    public RAMUser getUser() throws RAMRuntimeException {
        if (this.fUser == null) {
            try {
                UserInformation remoteUser = this.getRAMClient().getRAM1Webservice().getUser();
                this.fUser = this.fetchUser(remoteUser);
            }
            catch (Exception e) {
                throw new RAMRuntimeException(e.getLocalizedMessage(), e);
            }
        }
        return this.fUser;
    }

    String rehashIfNeeded(RAMAsset asset, String oldKey) {
        String newKey;
        String ret = oldKey;
        if (asset.getOriginalGUID() == null && asset.getOriginalVersion() == null && !(newKey = asset.getSessionKey()).equals(oldKey)) {
            this.fAssets.put(newKey, asset);
            this.fAssets.remove(oldKey);
            ret = newKey;
        }
        return ret;
    }

    boolean rehashIfNeeded(RAMRelationshipType relationshipType, String oldName, String oldDisplayName) {
        boolean modified = false;
        String newKey = relationshipType.getName();
        String newDisplayName = relationshipType.getDisplayName();
        if (!newKey.equals(oldName)) {
            this.fRelationshipTypeByName.put(newKey, relationshipType);
            this.fRelationshipTypeByName.remove(oldName);
            modified = true;
        }
        if (!newDisplayName.equals(oldDisplayName)) {
            this.fRelationshipTypeByDisplayName.put(newKey, relationshipType);
            this.fRelationshipTypeByDisplayName.remove(oldName);
            modified = true;
        }
        return modified;
    }

    String rehashIfNeeded(RAMCommunity community, String oldName) {
        String ret = oldName;
        String newKey = community.getName();
        if (!newKey.equals(oldName)) {
            this.fCommunitiesByName.put(newKey, community);
            this.fCommunitiesByName.remove(oldName);
            ret = newKey;
        }
        return ret;
    }

    String getSessionKey(IRAMSessionObject cachedObject) {
        String ret = null;
        if (cachedObject instanceof RAMAsset) {
            RAMAsset asset = (RAMAsset)cachedObject;
            ret = asset.getSessionKey();
        } else if (cachedObject instanceof RAMAssetType) {
            RAMAssetType assetType = (RAMAssetType)cachedObject;
            ret = assetType.getSessionKey();
        } else if (cachedObject instanceof RAMAssetAttribute) {
            RAMAssetAttribute assetAttribute = (RAMAssetAttribute)cachedObject;
            ret = assetAttribute.getSessionKey();
        } else if (cachedObject instanceof RAMCategorySchema) {
            RAMCategorySchema categorySchema = (RAMCategorySchema)cachedObject;
            ret = categorySchema.getSessionKey();
        } else if (cachedObject instanceof RAMCommunity) {
            RAMCommunity ramCommunity = (RAMCommunity)cachedObject;
            ret = ramCommunity.getSessionKey();
        } else if (cachedObject instanceof RAMRelationshipType) {
            RAMRelationshipType ramRelationshipTYpe = (RAMRelationshipType)cachedObject;
            ret = ramRelationshipTYpe.getSessionKey();
        } else if (cachedObject instanceof RAMUser) {
            RAMUser ramUser = (RAMUser)cachedObject;
            ret = ramUser.getSessionKey();
        } else if (cachedObject instanceof RAMCommunityAssetType) {
            RAMCommunityAssetType ramCommunityAssetType = (RAMCommunityAssetType)cachedObject;
            ret = ramCommunityAssetType.getSessionKey();
        }
        return ret;
    }

    public void remove(IRAMSessionObject cachedObject) {
        String key = this.getSessionKey(cachedObject);
        if (key == null) {
            return;
        }
        if (cachedObject instanceof RAMAsset) {
            RAMAsset asset = (RAMAsset)cachedObject;
            if (asset.isFullAsset()) {
                XMLResource resource = asset.getManifestBuilder().getManifestResource();
                this.getResourceSet().getResources().remove((Object)resource);
            }
            this.fAssetQueue.remove(asset);
            this.fModified.remove(asset);
            this.fAssets.remove(key);
        } else if (cachedObject instanceof RAMCommunity) {
            RAMCommunity community = (RAMCommunity)cachedObject;
            this.fCommunitiesById.remove(new Integer(community.getId()));
            this.fCommunitiesByName.remove(community.getName());
        } else if (cachedObject instanceof RAMCategorySchema) {
            RAMCategorySchema schema = (RAMCategorySchema)cachedObject;
            this.fCategorySchemasByName.remove(schema.getName());
            this.fCategorySchemasByURI.remove(schema.getURI());
        } else if (cachedObject instanceof RAMAssetType) {
            RAMAssetType type = (RAMAssetType)cachedObject;
            this.fAssetTypesByName.remove(type.getName());
            this.fAssetTypesByURI.remove(type.getURI());
        } else if (cachedObject instanceof RAMAssetAttribute) {
            RAMAssetAttribute attribute = (RAMAssetAttribute)cachedObject;
            this.fAttributesByName.remove(attribute.getName());
        } else if (cachedObject instanceof RAMCommunity) {
            RAMCommunity ramCommunity = (RAMCommunity)cachedObject;
            this.fCommunitiesById.remove(new Integer(ramCommunity.getId()));
            this.fCommunitiesByName.remove(ramCommunity.getName());
        } else if (cachedObject instanceof RAMRelationshipType) {
            RAMRelationshipType ramRelationshipType = (RAMRelationshipType)cachedObject;
            this.fRelationshipTypeByDisplayName.remove(ramRelationshipType.getDisplayName());
            this.fRelationshipTypeByName.remove(ramRelationshipType.getName());
        }
    }

    public RAMStatus put(IRAMSessionObject cachedObject, IProgressMonitor monitor) {
        RAMStatus status;
        block21: {
            String key = this.getSessionKey(cachedObject);
            if (!(monitor instanceof RAMStatusMonitor)) {
                monitor.beginTask(ClientMessages.getString("RAMSession.23"), 100);
                monitor = new RAMStatusMonitor((IProgressMonitor)monitor, 100);
            }
            RAMStatusMonitor ramStatusMonitor = (RAMStatusMonitor)((Object)monitor);
            status = ramStatusMonitor.getStatus();
            try {
                if (key == null || !cachedObject.isDirty()) {
                    monitor.beginTask(ClientMessages.getString("RAMSession.23"), 100);
                    monitor.worked(100);
                    break block21;
                }
                if (cachedObject instanceof RAMAsset) {
                    RAMAsset asset = (RAMAsset)cachedObject;
                    this.assertAssetUpdatable(asset);
                    this.putAsset(asset, ramStatusMonitor);
                    break block21;
                }
                if (cachedObject instanceof RAMCommunity) {
                    RAMCommunity community = (RAMCommunity)cachedObject;
                    this.putCommunity(community, ramStatusMonitor);
                } else if (cachedObject instanceof RAMCategorySchema) {
                    RAMCategorySchema schema = (RAMCategorySchema)cachedObject;
                    this.putCategorySchema(schema, ramStatusMonitor);
                } else if (cachedObject instanceof RAMAssetType) {
                    RAMAssetType type = (RAMAssetType)cachedObject;
                    this.putAssetType(type, ramStatusMonitor);
                } else if (cachedObject instanceof RAMAssetAttribute) {
                    RAMAssetAttribute attribute = (RAMAssetAttribute)cachedObject;
                    this.putAssetAttribute(attribute, ramStatusMonitor);
                } else if (cachedObject instanceof RAMRelationshipType) {
                    RAMRelationshipType relationshipType = (RAMRelationshipType)cachedObject;
                    this.putRelationshipType(relationshipType, ramStatusMonitor);
                } else if (cachedObject instanceof RAMUser) {
                    RAMUser ramUser = (RAMUser)cachedObject;
                    this.putUser(ramUser, ramStatusMonitor);
                } else if (cachedObject instanceof RAMCommunityAssetType) {
                    RAMCommunityAssetType ramCommunityAssetType = (RAMCommunityAssetType)cachedObject;
                    this.putCommunityAssetType(ramCommunityAssetType, ramStatusMonitor);
                }
            }
            finally {
                ramStatusMonitor.getStatus().setCode(2);
            }
        }
        return status;
    }

    private void putUser(RAMUser user, RAMStatusMonitor monitor) {
        block13: {
            String message = MessageFormat.format(ClientMessages.getString("RAMSession.UPDATE_USER"), user);
            monitor.beginTask(message, 10);
            try {
                UserInformation info;
                if (user.isRegistered()) {
                    UserInformation info2;
                    try {
                        info2 = this.getRAMClient().getRAM1Webservice().updateUser(user.getUid(), user.getName(), user.getPhone(), user.getEmail(), 0, 0, new int[0], new int[0][0]);
                    }
                    catch (RAMRuntimeException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new RAMRuntimeException(e.getLocalizedMessage(), e);
                    }
                    if (info2 != null) {
                        user.setInternalUser(info2);
                        String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.USER_UPDATED_SUCCESSFULLY"), user);
                        monitor.appendStatus(user, 1, 12, message1, null);
                    } else {
                        String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.USER_NOT_UPDATED"), user);
                        monitor.appendStatus(user, 4, 1012, message1, null);
                        logger.error((Object)message1);
                    }
                    break block13;
                }
                String message1 = MessageFormat.format(ClientMessages.getString("RAMSession.REGISTER_USER"), user);
                monitor.beginTask(message1, 10);
                try {
                    info = this.getRAMClient().getRAM1Webservice().registerUser(user.getUid(), user.getName(), user.getPhone(), user.getEmail(), 0, 0);
                }
                catch (RAMRuntimeException e) {
                    String message2 = MessageFormat.format(ClientMessages.getString("RAMSession.USER_NOT_CREATED"), user);
                    monitor.appendStatus(user, 4, 1016, message2, null);
                    logger.error((Object)message2);
                    throw e;
                }
                catch (Throwable e) {
                    String message2 = MessageFormat.format(ClientMessages.getString("RAMSession.USER_NOT_CREATED"), user);
                    monitor.appendStatus(user, 4, 1016, message2, null);
                    logger.error((Object)message2);
                    throw new RAMRuntimeException(message2, e);
                }
                if (info != null) {
                    user.setInternalUser(info);
                    String message2 = MessageFormat.format(ClientMessages.getString("RAMSession.USER_CREATED"), user);
                    monitor.appendStatus(user, 1, 16, message2, null);
                }
                RAMSessionModificationEvent me = new RAMSessionModificationEvent(this);
                me.setUsersModified(true);
                SessionManager.getSessionManager().handleSessionModificationEvent(me);
            }
            finally {
                monitor.worked(10);
            }
        }
    }

    synchronized void cache(IRAMSessionObject cachedObject) {
        String key = this.getSessionKey(cachedObject);
        if (key != null && !this.fModified.contains(cachedObject)) {
            this.fModified.add(cachedObject);
        }
    }

    public void queueAssetForPut(RAMAsset asset) {
        this.queueAssetForPut(asset, false);
    }

    public void queueAssetForPut(RAMAsset asset, boolean force) {
        this.assertAssetUpdatable(asset);
        String key = this.getSessionKey(asset);
        if (key != null) {
            asset.setForce(force);
            if (!this.fAssetQueue.contains(asset)) {
                this.fAssetQueue.add(asset);
            }
        }
    }

    private void assertAssetUpdatable(RAMAsset asset) {
        if (asset.isLocked()) {
            throw new IllegalStateException("The asset is locked. It cannot be updated.");
        }
    }

    synchronized void uncache(IRAMSessionObject cachedObject) {
        String key = this.getSessionKey(cachedObject);
        if (key != null) {
            this.fModified.remove(cachedObject);
            this.fAssetQueue.remove(cachedObject);
        }
    }

    public void dequeueAssetForPut(RAMAsset asset) {
        String key = this.getSessionKey(asset);
        if (key != null) {
            this.fAssetQueue.remove(asset);
        }
    }

    public void setUser(RAMUser user) {
        this.fUser = user;
    }

    AbstractRAMClient getRAMClient() {
        return this.fRAMClient;
    }

    AbstractRESTClient getRESTClient() throws RAMServiceException {
        return this.fRAMClient.getRestClient();
    }

    public void release() {
        SessionManager.getSessionManager().releaseSession(this);
        if (this.fResourceSet != null) {
            this.fRAMClient.cleanResourceSet(this.getResourceSet());
        }
        this.fRAMClient.disconnect(new Runnable(){

            @Override
            public void run() {
                RAMSession.this.clearStorageFolder();
                RAMSession.this.clear(true);
            }
        });
    }

    private void clearStorageFolder() {
        try {
            if (this.fLocalStorageFolder != null && this.fLocalStorageFolder.exists()) {
                RAMSession.deleteDir(this.fLocalStorageFolder);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to delete the cache diectory " + this.fLocalStorageLocation), (Throwable)e);
        }
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = RAMSession.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public RAMUser getOnBehalfOfUser() {
        return this.fOnBehalfOfUser;
    }

    private static void printJAXBLocations() {
        URL url = null;
        try {
            CodeSource cs;
            ProtectionDomain pd;
            Class<Marshaller> clazz = Marshaller.class;
            if (clazz != null && (pd = clazz.getProtectionDomain()) != null && (cs = pd.getCodeSource()) != null) {
                url = cs.getLocation();
            }
            if (url != null) {
                logger.debug((Object)("Class Marshaller was found in JAR " + url + "."));
            } else if (clazz != null && clazz.getClassLoader() != null) {
                logger.debug((Object)"Unable to locate JAR for class Marshaller.  It is not the JVM");
            }
        }
        catch (Throwable throwable) {
            logger.debug((Object)"Error locating JAR for class Marshaller.  Will attempt to start job server without class.");
        }
    }

    protected void setRAMClient(AbstractRAMClient ramClient) {
        this.fRAMClient = ramClient;
    }

    protected boolean isServerMode() {
        return this.server;
    }

    protected String getSessionTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public void setOverrideValidation(boolean overrideValidation) {
        this.fOverrideValidation = overrideValidation;
    }

    public boolean isOverrideValidation() {
        return this.fOverrideValidation;
    }

    protected AbstractRAMClient.Response getURL(URL url, boolean followRedirects, int timeout) throws IOException, RAMServiceException {
        return this.getRAMClient().getURL(url, followRedirects, timeout);
    }

    boolean isServerSupportLocking() {
        return this.getRAMClient().isServerVersionCompatible(AbstractRAMClient.ServerVersion.VERSION_752);
    }

    boolean isServerSupportGetVersionDB() {
        return this.getRAMClient().isServerVersionCompatible(AbstractRAMClient.ServerVersion.VERSION_7522);
    }

    boolean isServierSupportCategorizeForce() {
        return this.getRAMClient().isServerVersionCompatible(AbstractRAMClient.ServerVersion.VERSION_7521);
    }
}

